/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Html;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.common.address.AddressUtils;
import kd.taxc.common.org.BaseDataUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.common.util.RegisterAddressUtil;
import kd.taxc.tctb.business.taxcmain.TaxcMainBusiness;

public class TaxCalendarPlugin
extends AbstractFormPlugin {
    private static final int ROW = 7;
    private static final int COL = 8;
    private static final String TIME_KEY = "datefield";
    private static final String entity = "tctb_tax_main";
    private static final String REGISTER_ADDR = "registeraddress";
    private static final String ENTITY_CATEGORY = "categoryentryentity";
    private static final String ENABLE_FIELD = "enable";
    private static final String ENTITY_CALENDAR = "tpo_tax_calendar";
    private static final String KEY_ORG = "org";
    private static final String KEY_METHOD = "datefield";
    private static final String TAX_TYPE = "taxtype";
    private static final String PAYMENT_PERIOD = "deadline";
    private static final String COLLECT_PERIOD = "levytype";
    private static Map<String, String> CATEGORY_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("zzs", "1");
            this.put("qysds", "2");
            this.put("yhs", "3");
            this.put("fjsf", "5");
        }
    };
    private static Map<String, String> CATEGORY_NAME_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("zzs-2", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u6708\u62a5", (String)"TaxCalendarPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.put("fjsf-2", ResManager.loadKDString((String)"\u9644\u52a0\u7a0e\u8d39", (String)"TaxCalendarPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.put("qysds-2", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u6708\u62a5", (String)"TaxCalendarPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.put("zzs-1", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u5b63\u62a5", (String)"TaxCalendarPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.put("fjsf-1", ResManager.loadKDString((String)"\u9644\u52a0\u7a0e\u8d39", (String)"TaxCalendarPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.put("qysds-1", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5b63\u62a5", (String)"TaxCalendarPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.put("qysds-3", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u62a5", (String)"TaxCalendarPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.put("yhs-4", ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u6838\u5b9a\u7533\u62a5", (String)"TaxCalendarPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.put("yhs-5", ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u6c47\u603b\u7533\u62a5", (String)"TaxCalendarPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
    };
    private static Map<String, String> METHOD_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ajsb", "1");
            this.put("aysb", "2");
            this.put("ansb", "3");
            this.put("hdzs", "4");
            this.put("aqhz", "5");
        }
    };

    private static String getMsgConfigInfo() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u914d\u7f6e\u76f8\u5173\u4fe1\u606f\u3002", (String)"TaxCalendarPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
    }

    private static String getMsgConfigAddr() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5730\u5740\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\u3002", (String)"TaxCalendarPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
    }

    private static String getMsgConfigNoChina() {
        return ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u8be2\u6d77\u5916\u7ec4\u7ec7\u7684\u7a0e\u52a1\u65e5\u5386\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxCalendarPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    public void registerListener(EventObject e) {
        OrgEdit org = (OrgEdit)this.getView().getControl(KEY_ORG);
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        List<Long> orgIds = this.getDefaultOrgIds();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    public List<Long> getDefaultOrgIds() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            return hasPermOrgResult.getHasPermOrgs();
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date datefield;
        if (("datefield".equals(e.getProperty().getName()) || KEY_ORG.equals(e.getProperty().getName())) && (datefield = (Date)this.getModel().getValue("datefield")) != null) {
            this.setCalendar(datefield);
        }
    }

    public void init() {
        this.getModel().setValue(KEY_ORG, (Object)BaseDataUtil.getDefaultOrg((IFormView)this.getView()));
        this.setCalendar(new Date());
    }

    private void setCalendar(Date date) {
        Calendar current = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        int maxday = calendar.getActualMaximum(5);
        calendar.add(5, 0 - weekday);
        SimpleDateFormat dfdd = new SimpleDateFormat("dd");
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, String> infoMap = this.getTaxInfos();
        if (infoMap == null) {
            infoMap = new HashMap<String, String>();
        }
        StringBuilder sBuilders = new StringBuilder();
        if (infoMap.size() != 0) {
            for (Map.Entry<String, String> entry : infoMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!value.equals(dfnyr.format(calendar.getTime()))) continue;
                sBuilders.append(CATEGORY_NAME_MAP.get(key));
                sBuilders.append("&#10;");
            }
        }
        String infoMapString = sBuilders.toString();
        ArrayList<String> detailList = new ArrayList<String>();
        int index = 0;
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                calendar.add(5, 1);
                Html html = (Html)this.getControl("htmlap_" + i + "_" + j);
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("<div title=\"").append(infoMapString).append("\"><div style=\"text-align:right;\">").append("<span ").append("style=\"width:28px;").append("font-size:16px;").append("height:28px;").append("color:#333333;").append("border-radius:50%;").append("display:inline-block;").append("line-height:28px;").append("text-align:center;");
                sBuilder.append(infoMapString);
                if (index < weekday - 1 || index - weekday - maxday + 2 > 0) {
                    sBuilder.append("color:#999999;");
                }
                if (dfnyr.format(current.getTime()).equals(dfnyr.format(calendar.getTime()))) {
                    sBuilder.append("background:rgba(95,137,243,1);");
                    sBuilder.append("color:#ffffff;");
                } else if (infoMap.size() != 0) {
                    for (Map.Entry<String, String> entry : infoMap.entrySet()) {
                        String value = entry.getValue();
                        if (!value.equals(dfnyr.format(calendar.getTime()))) continue;
                        sBuilder.append("background:rgba(252,133,85,1);");
                        sBuilder.append("color:#ffffff;");
                    }
                }
                sBuilder.append("\">").append(dfnyr.format(current.getTime()).equals(dfnyr.format(calendar.getTime())) ? ResManager.loadKDString((String)"\u4eca", (String)"TaxCalendarPlugin_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0]) : dfdd.format(calendar.getTime())).append("</span>").append("</div>");
                int k = 0;
                ArrayList<String> strList = new ArrayList<String>();
                StringBuilder firstStr = new StringBuilder();
                if (infoMap.size() != 0) {
                    for (Map.Entry<String, String> entry : infoMap.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (!value.equals(dfnyr.format(calendar.getTime()))) continue;
                        sBuilder.append("<div style=\"text-align:left\" id=\"item_").append(i).append('_').append(j).append('_').append(k).append("\">");
                        sBuilder.append("<span style=\"background:#FC8555;width:4px;height:4px;display:inline-block\"></span>");
                        sBuilder.append("<span style=\"color:rgba(51,51,51,1);margin-left:4px;\">").append(CATEGORY_NAME_MAP.get(key)).append("</span>");
                        sBuilder.append("</div>");
                        ++k;
                        if (key.contains("zzs") || key.contains("fjsf")) {
                            firstStr.append(CATEGORY_NAME_MAP.get(key));
                            firstStr.append('\u3001');
                            continue;
                        }
                        strList.add(CATEGORY_NAME_MAP.get(key));
                    }
                }
                String start = DateUtils.getFirstDateOfMonthStr((Date)calendar.getTime(), (String)DateUtils.MMDD_CHINESE);
                String end = DateUtils.format((Date)calendar.getTime(), (String)DateUtils.DD_CHINESE);
                if (firstStr != null && firstStr.length() != 0) {
                    firstStr.replace(firstStr.length() - 1, firstStr.length(), "");
                    detailList.add(this.getCalendarDetail(firstStr.toString(), start, end));
                }
                if (!strList.isEmpty()) {
                    for (String str : strList) {
                        detailList.add(this.getCalendarDetail(str, start, end));
                    }
                }
                sBuilder.append("</div></div>");
                html.setConent(sBuilder.toString());
                ++index;
            }
        }
        ArrayList<Map> listitem = new ArrayList<Map>();
        Container flexpanelap = (Container)this.getView().getControl("detailflex");
        String items = this.getPageCache().get("items");
        if (items != null && !items.isEmpty()) {
            String[] arr = items.split(",");
            for (int i = 0; i < arr.length; ++i) {
                flexpanelap.deleteControls(new String[]{arr[i]});
            }
        }
        if (!detailList.isEmpty()) {
            int titleIndex = 0;
            ArrayList<String> listId = new ArrayList<String>(detailList.size());
            for (String s : detailList) {
                LabelAp title = new LabelAp();
                listId.add("title" + titleIndex);
                title.setKey("title" + titleIndex);
                title.setId("title" + titleIndex);
                title.setName(new LocaleString(s));
                title.setTextAlign("center");
                title.setFontSize(12);
                title.setForeColor("#333333");
                Style style = new Style();
                Margin margin = new Margin();
                margin.setBottom("20px");
                style.setMargin(margin);
                title.setStyle(style);
                listitem.add(title.createControl());
                ++titleIndex;
            }
            this.getPageCache().put("items", String.join((CharSequence)",", listId));
        }
        flexpanelap.addControls(listitem);
    }

    private String getCalendarDetail(String taxDetail, String start, String end) {
        StringBuilder detailStr = new StringBuilder();
        detailStr.append(String.format(ResManager.loadKDString((String)"%1$s-%2$s\u7533\u62a5%3$s\u3002", (String)"TaxCalendarPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), start, end, taxDetail));
        return detailStr.toString();
    }

    private Map<String, String> getTaxInfos() {
        IFormView view = this.getView();
        Object orgid = this.getModel().getValue(KEY_ORG);
        if (orgid == null) {
            return null;
        }
        Long org = ((DynamicObject)orgid).getLong("id");
        Date taxmethod = (Date)this.getModel().getValue("datefield");
        QFilter q1 = new QFilter("orgid", "=", (Object)org);
        DynamicObject dynamic = null;
        try {
            dynamic = TaxcMainBusiness.loadTaxcMainByOrgId((Long)org, (Long)TaxationsysMappingEnum.CHN.getId());
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return null;
        }
        if (dynamic == null) {
            this.getView().showTipNotification(TaxCalendarPlugin.getMsgConfigInfo());
            return null;
        }
        DynamicObject dobj = BusinessDataServiceHelper.loadSingle((Object)dynamic.getLong("id"), (String)entity);
        if (dobj == null) {
            view.showTipNotification(TaxCalendarPlugin.getMsgConfigAddr());
            return null;
        }
        DynamicObject datedobj = AddressUtils.getAdmindivision((Long)dynamic.getLong(REGISTER_ADDR));
        if (datedobj == null) {
            view.showTipNotification(TaxCalendarPlugin.getMsgConfigAddr());
            return null;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)datedobj.getString("country.name"), (CharSequence)ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"TaxCalendarPlugin_13", (String)"taxc-tctb-formplugin", (Object[])new Object[0]))) {
            view.showTipNotification(TaxCalendarPlugin.getMsgConfigNoChina());
            return null;
        }
        long level = datedobj.getLong("basedatafield.level");
        long provinceid = 0L;
        long cityid = -1L;
        if (level == 1L) {
            provinceid = datedobj.getLong("id");
        } else if (level == 2L) {
            cityid = datedobj.getLong("id");
            provinceid = datedobj.getLong("parent");
        } else if (level == 3L) {
            cityid = datedobj.getLong("parent");
            DynamicObject city = AddressUtils.getAdmindivision((Long)cityid);
            provinceid = city.getLong("parent");
        } else if (level > 3L) {
            long streetid = 0L;
            streetid = datedobj.getLong("parent");
            DynamicObject area = AddressUtils.getAdmindivision((Long)streetid);
            cityid = area.getLong("parent");
            DynamicObject city = AddressUtils.getAdmindivision((Long)cityid);
            provinceid = city.getLong("parent");
        }
        QFilter provinceFilter = new QFilter("entryentity.provinces", "=", (Object)provinceid);
        QFilter cityFilter = new QFilter("entryentity.city", "=", (Object)cityid);
        TreeMap<String, String> targetMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.contains("zzs") && o2.contains("fjsf")) {
                    return -1;
                }
                if (!o1.contains("zzs") || !o2.contains("fjsf")) {
                    return 1;
                }
                return 0;
            }
        });
        DynamicObjectCollection cateColl = dobj.getDynamicObjectCollection(ENTITY_CATEGORY);
        if (cateColl != null && !cateColl.isEmpty()) {
            for (DynamicObject d : cateColl) {
                Date methodDate;
                if (!"1".equals(d.getString(ENABLE_FIELD))) continue;
                QFilter taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)CATEGORY_MAP.get(d.getString(TAX_TYPE)));
                QFilter methodsFilter = null;
                if ("zzs".equals(d.getString(TAX_TYPE)) || "qysds".equals(d.getString(TAX_TYPE)) || "fjsf".equals(d.getString(TAX_TYPE))) {
                    QFilter qq;
                    Date methodDates;
                    if ("fjsf".equals(d.getString(TAX_TYPE))) {
                        boolean flag = false;
                        for (DynamicObject dd : cateColl) {
                            if (!"zzs".equals(dd.getString(TAX_TYPE))) continue;
                            methodsFilter = new QFilter("entryentity.methods", "=", (Object)METHOD_MAP.get(dd.getString(PAYMENT_PERIOD)));
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u52a0\u7a0e\u8d39\u5904\u4e8e\u5f00\u542f\u72b6\u6001\u65f6\uff0c\u8bf7\u786e\u4fdd\u589e\u503c\u7a0e\u4e5f\u5904\u4e8e\u5f00\u542f\u72b6\u6001\u3002", (String)"TaxCalendarPlugin_14", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                            return null;
                        }
                    } else {
                        methodsFilter = new QFilter("entryentity.methods", "=", (Object)METHOD_MAP.get(d.getString(PAYMENT_PERIOD)));
                    }
                    if ("qysds".equals(d.getString(TAX_TYPE)) && !"3".equals(METHOD_MAP.get(d.getString(PAYMENT_PERIOD))) && (methodDates = this.getInfoFromCalendar(provinceFilter, cityFilter, taxtypeFilter, qq = new QFilter("entryentity.methods", "=", (Object)"3"), taxmethod)) != null) {
                        targetMap.put("qysds-3", DateUtils.format((Date)methodDates));
                    }
                } else if ("yhs".equals(d.getString(TAX_TYPE))) {
                    methodsFilter = new QFilter("entryentity.methods", "=", (Object)METHOD_MAP.get(d.getString(COLLECT_PERIOD)));
                } else if ("fcscztdsys".equals(d.getString(TAX_TYPE)) || "xfs".equals(d.getString(TAX_TYPE)) || "hjbhs".equals(d.getString(TAX_TYPE))) {
                    // empty if block
                }
                if ((methodDate = this.getInfoFromCalendar(provinceFilter, cityFilter, taxtypeFilter, methodsFilter, taxmethod)) == null || methodsFilter == null) continue;
                targetMap.put(d.getString(TAX_TYPE) + "-" + methodsFilter.getValue(), DateUtils.format((Date)methodDate));
            }
        }
        return targetMap;
    }

    private Date getInfoFromCalendar(QFilter provinceFilter, QFilter cityFilter, QFilter taxtypeFilter, QFilter methodsFilter, Date taxmethod) {
        int year = DateUtils.getYearOfDate((Date)taxmethod);
        int month = DateUtils.getMonthOfDate((Date)taxmethod);
        QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
        DynamicObjectCollection dynamicObjects = RegisterAddressUtil.queryCalender((QFilter)provinceFilter, (QFilter)cityFilter, (QFilter)taxtypeFilter, (QFilter)methodsFilter, (QFilter)yearFilter, (int)month);
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            dynamicObjects = RegisterAddressUtil.queryCalender((QFilter)provinceFilter, null, (QFilter)taxtypeFilter, (QFilter)methodsFilter, (QFilter)yearFilter, (int)month);
        }
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            dynamicObjects = RegisterAddressUtil.queryCalendarByName((Long)((Long)provinceFilter.getValue()), (Long)((Long)cityFilter.getValue()), (QFilter)taxtypeFilter, (QFilter)methodsFilter, (QFilter)yearFilter, (int)month);
        }
        return RegisterAddressUtil.getCalendarDate((int)year, (DynamicObjectCollection)dynamicObjects);
    }
}

