/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.common.constant.TaxConstant;
import kd.taxc.common.db.table.YbnsrService;
import kd.taxc.common.util.DateUtils;
import kd.taxc.tctb.business.util.UpgradeUtil;

public class TaxCategoryChoosePeriodPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TaxCategoryChoosePeriodPlugin.class);
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            String taxPayerType;
            Date endDate;
            Date startDate;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String org = StringUtils.isNotBlank(customParams.get("orgid")) ? customParams.get("orgid").toString() : "";
            String type = StringUtils.isNotBlank(customParams.get("type")) ? customParams.get("type").toString() : "";
            Date period = (Date)this.getModel().getValue("period");
            if (null == period) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d77\u59cb\u6708\u4efd\u3002", (String)"TaxCategoryChoosePeriodPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            Date now = new Date();
            if (period.getTime() >= now.getTime()) {
                startDate = now;
                endDate = period;
            } else {
                startDate = period;
                endDate = now;
            }
            HashMap<String, String> extraParams = new HashMap<String, String>(16);
            extraParams.put("declarestatus", "declared");
            DynamicObject object = YbnsrService.queryYbnsrDateRange((String)org, (String)type, (String)DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)startDate)), (String)DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)endDate)), (int)0, extraParams);
            if (null != object) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5c5e\u671f\u5b58\u5728\u5df2\u7533\u62a5\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxCategoryChoosePeriodPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            Map sorted = UpgradeUtil.getSortedDynamicObject((Map)customParams);
            DynamicObject category = (DynamicObject)sorted.get("sorted");
            if (period.before(category.getDate("taxstartdate"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u4e00\u6b21\u53d8\u66f4\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxCategoryChoosePeriodPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            List sortedDateList = (List)sorted.get("sortedTime");
            Date lastDeadLine = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)period, (int)-1));
            period = DateUtils.getFirstDateOfMonth((Date)period);
            boolean flag = false;
            for (Date date : sortedDateList) {
                int month = DateUtils.getMonthOfDate((Date)date);
                int temp = DateUtils.getMonthDiff((Date)period, (Date)date);
                if (temp == 0) {
                    flag = true;
                    break;
                }
                if (!(1 != month && 4 != month && 7 != month && 10 != month || temp != 1 && temp != 2)) {
                    flag = true;
                    break;
                }
                if (2 != month && 5 != month && 8 != month && 11 != month || temp != 1) continue;
                flag = true;
                break;
            }
            if (flag) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b63\u5ea6\u5185\u5df2\u5b58\u5728\u53d8\u66f4\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxCategoryChoosePeriodPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            String deadLine = Objects.isNull(customParams.get("deadline")) ? null : (String)customParams.get("deadline");
            String string = taxPayerType = Objects.isNull(customParams.get("taxpayertype")) ? null : (String)customParams.get("taxpayertype");
            if ("ybnsr".equalsIgnoreCase(taxPayerType) && "ajsb".equalsIgnoreCase(deadLine)) {
                boolean firstMonthFlag = true;
                int firstMonth = DateUtils.getMonthOfDate((Date)period);
                if (1 == firstMonth || 4 == firstMonth || 7 == firstMonth || 10 == firstMonth) {
                    firstMonthFlag = false;
                }
                if (firstMonthFlag) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u822c\u7eb3\u7a0e\u4eba\u6309\u5b63\u7533\u62a5\u7684\u53d8\u66f4\u8d77\u59cb\u6708\u4efd\u5e94\u4e3a\u5b63\u5ea6\u7684\u7b2c\u4e00\u4e2a\u6708\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxCategoryChoosePeriodPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            customParams.put("lastDeadLine", lastDeadLine);
            customParams.put("period", period);
            StringBuilder message = new StringBuilder();
            if (!StringUtils.equals((CharSequence)customParams.get("originalFarmDeductValue").toString(), (CharSequence)customParams.get("farmdeducttype").toString())) {
                String periodStr = DateUtils.format((Date)period, (String)"yyyy-MM");
                String origTxpyType = this.getFieldStringByParam(customParams, "originalTaxpayerTypeValue");
                String origDdl = this.getFieldStringByParam(customParams, "originalDeadlineValue");
                String origFaDeType = this.getFieldStringByParam(customParams, "originalFarmDeductValue");
                String txpyType = this.getFieldStringByParam(customParams, "taxpayertype");
                String ddl = this.getFieldStringByParam(customParams, "deadline");
                String FaDeType = this.getFieldStringByParam(customParams, "farmdeducttype");
                message.append(String.format(ResManager.loadKDString((String)"\u4ece[%1$s]\u8d77\uff0c[%2$s] [%3$s] [%4$s]  \u53d8\u66f4\u4e3a  [%5$s] [%6$s] [%7$s]\uff1f \u82e5\u786e\u8ba4\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u53d6\u6570\u89c4\u5219", (String)"TaxCategoryChoosePeriodPlugin_14", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), periodStr, origTxpyType, origDdl, origFaDeType, txpyType, ddl, FaDeType));
            } else if (StringUtils.equals((CharSequence)customParams.get("originalTaxpayerTypeValue").toString(), (CharSequence)customParams.get("taxpayertype").toString())) {
                message.append(String.format(ResManager.loadKDString((String)"\u4ece[%1$s]\u8d77\uff0c[%2$s] [%3$s]\u53d8\u66f4\u4e3a[%4$s]\uff1f", (String)"TaxCategoryChoosePeriodPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), DateUtils.format((Date)period, (String)"yyyy-MM"), TaxConstant.getTaxTypeCardMap().get(customParams.get("taxpayertype")), TaxConstant.getTaxTypeCardMap().get(customParams.get("originalDeadlineValue")), TaxConstant.getTaxTypeCardMap().get(customParams.get("deadline"))));
            } else {
                message.append(String.format(ResManager.loadKDString((String)"\u4ece[%1$s]\u8d77\uff0c[%2$s] [%3$s]\u53d8\u66f4\u4e3a[%4$s] [%5$s]\uff1f \u82e5\u786e\u8ba4\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u53d6\u6570\u89c4\u5219", (String)"TaxCategoryChoosePeriodPlugin_13", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), DateUtils.format((Date)period, (String)"yyyy-MM"), TaxConstant.getTaxTypeCardMap().get(customParams.get("originalTaxpayerTypeValue")), TaxConstant.getTaxTypeCardMap().get(customParams.get("originalDeadlineValue")), TaxConstant.getTaxTypeCardMap().get(customParams.get("taxpayertype")), TaxConstant.getTaxTypeCardMap().get(customParams.get("deadline"))));
            }
            this.showConfirmTips(BTNOK, message.toString(), SerializationUtils.toJsonString((Object)customParams));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BTNOK.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            Map customs = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
            IDataModel mainModel = this.getView().getParentView().getParentView().getModel();
            mainModel.setValue("levytype", customs.get("levytype"), 0);
            mainModel.setValue("deadline", customs.get("deadline"), 0);
            mainModel.setValue("taxpayertype", customs.get("taxpayertype"), 0);
            mainModel.setValue("enable", customs.get("enable"), 0);
            mainModel.setValue("farmdeducttype", customs.get("farmdeducttype"), 0);
            mainModel.setValue("qsyfdate", (Object)DateUtils.format((Date)DateUtils.stringToDate((String)customs.get("period").toString(), (String)"yyyy-MM-dd HH:mm:ss")));
            this.getView().close();
            this.getView().getParentView().close();
            mainModel.setDataChanged(true);
            this.getView().getParentView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().sendFormAction(this.getView().getParentView().getParentView());
        }
    }

    private void showConfirmTips(String itemKey, String message, String customValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(itemKey, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxCategoryChoosePeriodPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxCategoryChoosePeriodPlugin_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(message, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, customValue);
    }

    private String getFieldStringByParam(Map<String, Object> customParams, String key) {
        Map taxTypeCardMap = TaxConstant.getTaxTypeCardMap();
        return (String)taxTypeCardMap.get(customParams.get(key));
    }
}

