/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.common.showpage.PageShowCommon;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.enums.TaxTypeComboEnum;
import kd.taxc.tctb.business.taxcmain.TaxInfoHomeBusiness;
import kd.taxc.tctb.business.util.UpgradeUtil;

public class TaxCategoryDialogPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TaxCategoryDialogPlugin.class);
    private static final String TCTB_CHOOSE_PERIOD = "tctb_choose_period";

    public void afterCreateNewData(EventObject e) {
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        if (index != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxpayertypeflex"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"deadline"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"levytype"});
            IDataModel parentModel = this.getView().getParentView().getModel();
            String taxType = (String)parentModel.getValue("taxtype", index.intValue());
            this.getModel().setValue("taxtype", parentModel.getValue("taxtype", index.intValue()));
            this.getModel().setValue("levytype", parentModel.getValue("levytype", index.intValue()));
            this.getModel().setValue("deadline", parentModel.getValue("deadline", index.intValue()));
            this.getModel().setValue("taxpayertype", parentModel.getValue("taxpayertype", index.intValue()));
            this.getModel().setValue("enable", parentModel.getValue("enable", index.intValue()));
            this.getModel().setValue("farmdeducttype", parentModel.getValue("farmdeducttype", index.intValue()));
            this.getModel().setValue("approvedcollectionmethod", parentModel.getValue("approvedcollectionmethod", index.intValue()));
            this.getModel().setValue("taxableincometaxrate", parentModel.getValue("taxableincometaxrate", index.intValue()));
            switch (taxType) {
                case "zzs": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"deadlineflex"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"taxpayertypeflex"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"acsb"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"aqhz"});
                    if ("ybnsr".equals(parentModel.getValue("taxpayertype", index.intValue()))) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"levytype"});
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"residenttypeflex"});
                    break;
                }
                case "qysds": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"deadlineflex"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"acsb"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"aqhz"});
                    this.getModel().setValue("residenttype", parentModel.getValue("residenttype"));
                    if (this.isRateApprovedCollectionMethod(this.getModel().getDataEntity().getString("approvedcollectionmethod"))) {
                        this.setMustInput(Boolean.TRUE, new String[]{"taxableincometaxrate"});
                        break;
                    }
                    this.setMustInput(Boolean.FALSE, new String[]{"taxableincometaxrate"});
                    break;
                }
                case "yhs": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"deadlineflex"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"levytypeflex"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"aqhz"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"ajsb"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"czzs"});
                    break;
                }
                case "tdzzs": 
                case "zys": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"deadlineflex"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"levytypeflex"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"residenttypeflex"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"aqhz"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"ajsb"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"czzs"});
                    break;
                }
                default: {
                    logger.error("no such a taxType!");
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        if (index != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"deadline"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"levytype"});
            IDataModel parentModel = this.getView().getParentView().getModel();
            String taxType = (String)parentModel.getValue("taxtype", index.intValue());
            if ("zzs".equals(taxType)) {
                if ("taxpayertype".equals(e.getProperty().getName())) {
                    if ("ybnsr".equals(e.getChangeSet()[0].getNewValue())) {
                        this.getModel().setValue("deadline", (Object)"aysb");
                        this.getModel().setValue("levytype", (Object)"czzs");
                        this.getView().setEnable(Boolean.FALSE, new String[]{"levytype"});
                    } else if ("xgmnsr".equals(e.getChangeSet()[0].getNewValue())) {
                        this.getModel().setValue("deadline", (Object)"ajsb");
                        this.getModel().setValue("levytype", (Object)"czzs");
                    }
                }
            } else if ("qysds".equals(taxType)) {
                BigDecimal taxRate;
                if ("approvedcollectionmethod".equals(e.getProperty().getName())) {
                    if (this.isRateApprovedCollectionMethod((String)e.getChangeSet()[0].getNewValue())) {
                        this.setMustInput(Boolean.TRUE, new String[]{"taxableincometaxrate"});
                    } else {
                        this.setMustInput(Boolean.FALSE, new String[]{"taxableincometaxrate"});
                        this.getModel().setValue("taxableincometaxrate", null);
                    }
                } else if ("taxableincometaxrate".equals(e.getProperty().getName()) && (BigDecimal.ZERO.compareTo(taxRate = (BigDecimal)e.getChangeSet()[0].getNewValue()) >= 0 || BigDecimal.ONE.compareTo(taxRate) <= 0)) {
                    this.getModel().setValue("taxableincometaxrate", null);
                }
            }
        }
    }

    private boolean isRateApprovedCollectionMethod(String approvedCollectionMethod) {
        IDataModel parentModel = this.getView().getParentView().getModel();
        if (!("qysds".equals(parentModel.getValue("taxtype")) && "jmqy".equals(this.getModel().getValue("residenttype")) && "hdzs".equals(this.getModel().getValue("levytype")))) {
            return false;
        }
        return "rate-income".equals(approvedCollectionMethod) || "rate-cost".equals(approvedCollectionMethod);
    }

    private void setMustInput(Boolean mustInput, String[] fields) {
        for (String field : fields) {
            FieldEdit control = (FieldEdit)this.getControl(field);
            if (null == control) continue;
            control.setMustInput(mustInput.booleanValue());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
            if (index != null) {
                if ("zzs".equals(parentModel.getValue("taxtype"))) {
                    Object originalDeadlineValue = parentModel.getValue("deadline", index.intValue());
                    Object originalTaxpayerTypeValue = parentModel.getValue("taxpayertype", index.intValue());
                    Object originalEnableValue = parentModel.getValue("enable", index.intValue());
                    Object originalLevyTypeValue = parentModel.getValue("levytype", index.intValue());
                    Object originalFarmDeductValue = parentModel.getValue("farmdeducttype", index.intValue());
                    Iterable changeProperties = this.getModel().getDataEntity(true).getDataEntityState().getBizChangedProperties();
                    boolean flag = false;
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    if (null != changeProperties) {
                        DynamicObject main = parentModel.getDataEntity(true);
                        DynamicObjectCollection sub = main.getDynamicObjectCollection("categoryentryentity");
                        for (IDataEntityProperty property : changeProperties) {
                            if (!StringUtils.equals((CharSequence)"deadline", (CharSequence)property.getName()) && !StringUtils.equals((CharSequence)"taxpayertype", (CharSequence)property.getName()) && !StringUtils.equals((CharSequence)"farmdeducttype", (CharSequence)property.getName())) continue;
                            customParams.put(property.getName(), this.getModel().getValue(property.getName()));
                            flag = true;
                        }
                        if (flag) {
                            this.setCustomValue(parentModel, index, originalDeadlineValue, originalTaxpayerTypeValue, originalFarmDeductValue, originalEnableValue, originalLevyTypeValue, customParams, main, sub);
                            List executeOriginalData = UpgradeUtil.getExecuteOriginalData((String)customParams.get("taxtype").toString(), (String)main.getPkValue().toString());
                            if (CollectionUtils.isEmpty((Collection)executeOriginalData)) {
                                this.setModelValue(parentModel, index);
                                this.getView().close();
                            } else {
                                Long maxVer = TaxInfoHomeBusiness.getMaxVer((TaxTypeComboEnum)TaxTypeComboEnum.getEnumByCode((String)"zzs"), (Long)main.getDynamicObject("orgid").getLong("id"));
                                if (EmptyCheckUtils.isNotEmpty((Object)maxVer) && maxVer != 0L) {
                                    PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCTB_CHOOSE_PERIOD, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                                } else {
                                    this.setModelValue(parentModel, index);
                                    this.getView().close();
                                }
                            }
                        } else {
                            this.setModelValue(parentModel, index);
                            this.getView().close();
                        }
                    }
                } else if ("qysds".equals(parentModel.getValue("taxtype"))) {
                    BigDecimal taxableIncomeTaxRate;
                    if (this.isRateApprovedCollectionMethod(this.getModel().getDataEntity().getString("approvedcollectionmethod")) && BigDecimal.ZERO.compareTo(taxableIncomeTaxRate = this.getModel().getDataEntity().getBigDecimal("taxableincometaxrate")) == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536\u65b9\u5f0f\u4e3a\u6838\u5b9a\u5e94\u7a0e\u6240\u5f97\u7387\u65f6\uff0c\u5fc5\u987b\u5f55\u5165\u5e94\u7a0e\u6240\u5f97\u7387\u3002", (String)"TaxCategoryDialogPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.setModelValue(parentModel, index);
                    this.getView().close();
                } else {
                    this.setModelValue(parentModel, index);
                    this.getView().close();
                }
            }
        }
    }

    private void setModelValue(IDataModel parentModel, Integer index) {
        parentModel.setValue("levytype", this.getModel().getValue("levytype"), index.intValue());
        parentModel.setValue("deadline", this.getModel().getValue("deadline"), index.intValue());
        parentModel.setValue("taxpayertype", this.getModel().getValue("taxpayertype"), index.intValue());
        parentModel.setValue("enable", this.getModel().getValue("enable"), index.intValue());
        parentModel.setValue("residenttype", this.getModel().getValue("residenttype"), index.intValue());
        parentModel.setValue("farmdeducttype", this.getModel().getValue("farmdeducttype"), index.intValue());
        parentModel.setValue("approvedcollectionmethod", this.getModel().getValue("approvedcollectionmethod"), index.intValue());
        parentModel.setValue("taxableincometaxrate", this.getModel().getValue("taxableincometaxrate"), index.intValue());
    }

    private void setCustomValue(IDataModel parentModel, Integer index, Object originalDeadlineValue, Object originalTaxpayerTypeValue, Object originalFarmDeductValue, Object originalEnableValue, Object originalLevyTypeValue, Map<String, Object> customParams, DynamicObject main, DynamicObjectCollection sub) {
        customParams.put("orgid", main.getDynamicObject("orgid").getString("id"));
        customParams.put("originalDeadlineValue", originalDeadlineValue);
        customParams.put("originalTaxpayerTypeValue", originalTaxpayerTypeValue);
        customParams.put("originalEnableValue", originalEnableValue);
        customParams.put("originalLevyTypeValue", originalLevyTypeValue);
        customParams.put("originalFarmDeductValue", originalFarmDeductValue);
        customParams.put("taxtype", parentModel.getValue("taxtype"));
        if (StringUtils.isBlank((Object)customParams.get("deadline"))) {
            customParams.put("deadline", originalDeadlineValue);
        }
        if (StringUtils.isBlank((Object)customParams.get("taxpayertype"))) {
            customParams.put("taxpayertype", originalTaxpayerTypeValue);
        }
        if (StringUtils.isBlank((Object)customParams.get("farmdeducttype"))) {
            customParams.put("farmdeducttype", originalFarmDeductValue);
        }
        customParams.put("type", customParams.get("taxtype").toString() + originalTaxpayerTypeValue);
        if ("ajsb".equals(originalDeadlineValue) && "xgmnsr".equals(originalTaxpayerTypeValue)) {
            customParams.put("type", customParams.get("taxtype").toString() + originalTaxpayerTypeValue + "jidu");
        }
        customParams.put("seq", sub.size() + 1);
        customParams.put("mainId", main.getLong("id"));
        customParams.put("levytype", this.getModel().getValue("levytype"));
        customParams.put("enable", this.getModel().getValue("enable"));
        List list = sub.stream().filter(v -> "zzs".equals(v.getString("taxtype"))).collect(Collectors.toSet()).stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        customParams.put("originalEntryId", list.get(0));
        customParams.put("index", index);
    }
}

