/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;

public class TaxCategoryHjbhsDialogPlugin
extends AbstractFormPlugin {
    private static final String CLOSE = "close";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        Integer index;
        String isForbidden = (String)this.getView().getFormShowParameter().getCustomParam("isForbidden");
        if ("true".equals(isForbidden)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap2", "advconbaritemap3", "advconbaritemap", "advconbaritemap1"});
        }
        if ((index = (Integer)this.getView().getFormShowParameter().getCustomParam("index")) != null) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            this.getModel().setValue("taxtype", parentModel.getValue("taxtype", index.intValue()));
            this.getModel().setValue("enablegroup", parentModel.getValue("enable", index.intValue()));
            DynamicObjectCollection entryEntity = parentModel.getEntryEntity("hjbhsentity");
            if (entryEntity.size() > 0) {
                this.getModel().setValue("acsb", ((DynamicObject)entryEntity.get(0)).get("hjbhs_acsb"));
                this.getModel().setValue("cshygc", ((DynamicObject)entryEntity.get(0)).get("hjbhs_cshygc"));
                this.getModel().setValue("cxwsjzclcs", ((DynamicObject)entryEntity.get(0)).get("hjbhs_cxwsjzclcs"));
                this.getModel().setValue("shljjzclcs", ((DynamicObject)entryEntity.get(0)).get("hjbhs_shljjzclcs"));
                String pollutanttype = (String)((DynamicObject)entryEntity.get(0)).get("hjbhs_pollutanttype");
                this.getModel().setValue("swrw", (Object)(pollutanttype.contains("101") ? 1 : 0));
                this.getModel().setValue("dqwrw", (Object)(pollutanttype.contains("102") ? 1 : 0));
                this.getModel().setValue("zs", (Object)(pollutanttype.contains("103") ? 1 : 0));
                this.getModel().setValue("gtfw", (Object)(pollutanttype.contains("104") ? 1 : 0));
                if (!(entryEntity.size() != 1 || ObjectUtils.isEmpty((Object)((DynamicObject)entryEntity.get(0)).get("hjbhs_number")) && ObjectUtils.isEmpty((Object)((DynamicObject)entryEntity.get(0)).get("hjbhs_startdate")) && ObjectUtils.isEmpty((Object)((DynamicObject)entryEntity.get(0)).get("hjbhs_enddate")) && ObjectUtils.isEmpty((Object)((DynamicObject)entryEntity.get(0)).get("hjbhs_remark")))) {
                    this.getModel().batchCreateNewEntryRow("entryentity", 1);
                    this.getModel().setValue("tempid", ((DynamicObject)entryEntity.get(0)).get("id"), 0);
                    this.getModel().setValue("number", ((DynamicObject)entryEntity.get(0)).get("hjbhs_number"), 0);
                    this.getModel().setValue("startdate", ((DynamicObject)entryEntity.get(0)).get("hjbhs_startdate"), 0);
                    this.getModel().setValue("enddate", ((DynamicObject)entryEntity.get(0)).get("hjbhs_enddate"), 0);
                    this.getModel().setValue("remark", ((DynamicObject)entryEntity.get(0)).get("hjbhs_remark"), 0);
                } else if (entryEntity.size() > 1) {
                    int[] rows;
                    for (int row : rows = this.getModel().batchCreateNewEntryRow("entryentity", entryEntity.size())) {
                        this.getModel().setValue("tempid", ((DynamicObject)entryEntity.get(row)).get("id"), row);
                        this.getModel().setValue("number", ((DynamicObject)entryEntity.get(row)).get("hjbhs_number"), row);
                        this.getModel().setValue("startdate", ((DynamicObject)entryEntity.get(row)).get("hjbhs_startdate"), row);
                        this.getModel().setValue("enddate", ((DynamicObject)entryEntity.get(row)).get("hjbhs_enddate"), row);
                        this.getModel().setValue("remark", ((DynamicObject)entryEntity.get(row)).get("hjbhs_remark"), row);
                    }
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof DeleteEntry) {
            args.setCancel(true);
            int[] selectRows = ((EntryGrid)this.getControl("entryentity")).getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"TaxCategoryHjbhsDialogPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int rowIndex : selectRows) {
                OperationResult delete;
                DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                Long rowId = rowObj != null && rowObj.get("tempid") != null ? rowObj.getLong("tempid") : 0L;
                if (rowId == 0L || (delete = OperationServiceHelper.executeOperate((String)"delete", (String)"tctb_hjbhs_entry", (Object[])new Object[]{rowId}, (OperateOption)OperateOption.create())).isSuccess()) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"TaxCategoryHjbhsDialogPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRows("entryentity", selectRows);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperateKey().equals("submit") && args.getOperationResult().isSuccess()) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
            if (index != null) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                parentModel.setValue("taxtype", this.getModel().getValue("taxtype"), index.intValue());
                parentModel.setValue("enable", this.getModel().getValue("enablegroup"), index.intValue());
                Object acsb = this.getModel().getValue("acsb");
                Object cshygc = this.getModel().getValue("cshygc");
                Object cxwsjzclcs = this.getModel().getValue("cxwsjzclcs");
                Object shljjzclcs = this.getModel().getValue("shljjzclcs");
                String swrw = (Boolean)this.getModel().getValue("swrw") != false ? "101" : null;
                String dqwrw = (Boolean)this.getModel().getValue("dqwrw") != false ? "102" : null;
                String zs = (Boolean)this.getModel().getValue("zs") != false ? "103" : null;
                String gtfw = (Boolean)this.getModel().getValue("gtfw") != false ? "104" : null;
                String[] pollutant = new String[]{dqwrw, swrw, zs, gtfw};
                String pollutanttype = null;
                StringBuilder type = new StringBuilder();
                Arrays.stream(pollutant).forEach(o -> {
                    if (StringUtil.isNotBlank((CharSequence)o)) {
                        type.append((String)o).append(",");
                    }
                });
                if (type.toString().endsWith(",")) {
                    pollutanttype = type.toString().substring(0, type.toString().lastIndexOf(","));
                }
                if (entryEntity.size() > 0) {
                    HashSet<String> set = new HashSet<String>(16);
                    for (DynamicObject dynamicObject : entryEntity) {
                        String number = dynamicObject.getString("number");
                        String seq = dynamicObject.getString("seq");
                        if (StringUtil.isBlank((CharSequence)number)) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6392\u6c61\u8bb8\u53ef\u8bc1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryHjbhsDialogPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), seq));
                            return;
                        }
                        if (set.add(number)) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5df2\u5b58\u5728\u76f8\u540c\u6392\u6c61\u8bb8\u53ef\u8bc1\u7f16\u53f7\u3002", (String)"TaxCategoryHjbhsDialogPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), seq));
                        return;
                    }
                    Object pkid = parentModel.getDataEntity(true).get("id");
                    if (Objects.nonNull(pkid)) {
                        DynamicObjectCollection hjbhsEntityDbList = parentModel.getEntryEntity("hjbhsentity");
                        List dbEntryIdList = hjbhsEntityDbList.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
                        List tempIdList = entryEntity.stream().filter(item -> Objects.nonNull(item.get("tempid"))).map(item -> item.getLong("tempid")).collect(Collectors.toList());
                        ArrayList<Integer> deleteRows = new ArrayList<Integer>(hjbhsEntityDbList.size());
                        for (int i = 0; i < hjbhsEntityDbList.size(); ++i) {
                            long tempId = ((DynamicObject)hjbhsEntityDbList.get(i)).getLong("id");
                            if (tempIdList.contains(tempId)) continue;
                            deleteRows.add(i);
                        }
                        parentModel.deleteEntryRows("hjbhsentity", deleteRows.stream().mapToInt(Integer::intValue).toArray());
                        for (int row = 0; row < entryEntity.size(); ++row) {
                            Object tempId = ((DynamicObject)entryEntity.get(row)).get("tempid");
                            if (dbEntryIdList.contains(tempId)) {
                                this.setParentEntryEntity(parentModel, entryEntity, acsb, cshygc, cxwsjzclcs, shljjzclcs, pollutanttype, row);
                            }
                            if (!Objects.isNull(tempId)) continue;
                            int newEntry = parentModel.createNewEntryRow("hjbhsentity");
                            this.setParentEntryEntity(parentModel, entryEntity, acsb, cshygc, cxwsjzclcs, shljjzclcs, pollutanttype, newEntry);
                        }
                    } else {
                        int[] rows;
                        parentModel.deleteEntryData("hjbhsentity");
                        for (int row : rows = parentModel.batchCreateNewEntryRow("hjbhsentity", entryEntity.size())) {
                            this.setParentEntryEntity(parentModel, entryEntity, acsb, cshygc, cxwsjzclcs, shljjzclcs, pollutanttype, row);
                        }
                    }
                } else {
                    int[] rows;
                    parentModel.deleteEntryData("hjbhsentity");
                    for (int row : rows = parentModel.batchCreateNewEntryRow("hjbhsentity", 1)) {
                        parentModel.setValue("hjbhs_acsb", acsb, row);
                        parentModel.setValue("hjbhs_cshygc", cshygc, row);
                        parentModel.setValue("hjbhs_cxwsjzclcs", cxwsjzclcs, row);
                        parentModel.setValue("hjbhs_shljjzclcs", shljjzclcs, row);
                        parentModel.setValue("hjbhs_pollutanttype", (Object)pollutanttype, row);
                    }
                }
            }
            if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("taxtypechange"))) {
                IPageCache parentPageCahce = this.getView().getParentView().getPageCache();
                String taxtypechange = parentPageCahce.get("taxtypechange");
                if (EmptyCheckUtils.isEmpty((Object)taxtypechange)) {
                    taxtypechange = "hjbhs";
                } else if (taxtypechange.indexOf("hjbhs") < 0) {
                    taxtypechange = taxtypechange + ',' + "hjbhs";
                }
                parentPageCahce.put("taxtypechange", taxtypechange);
            }
            this.getView().close();
        }
    }

    private void setParentEntryEntity(IDataModel parentModel, DynamicObjectCollection entryEntity, Object acsb, Object cshygc, Object cxwsjzclcs, Object shljjzclcs, String pollutanttype, int row) {
        parentModel.setValue("hjbhs_number", ((DynamicObject)entryEntity.get(row)).get("number"), row);
        parentModel.setValue("hjbhs_remark", ((DynamicObject)entryEntity.get(row)).get("remark"), row);
        parentModel.setValue("hjbhs_startdate", ((DynamicObject)entryEntity.get(row)).get("startdate"), row);
        parentModel.setValue("hjbhs_enddate", ((DynamicObject)entryEntity.get(row)).get("enddate"), row);
        parentModel.setValue("hjbhs_acsb", acsb, row);
        parentModel.setValue("hjbhs_cshygc", cshygc, row);
        parentModel.setValue("hjbhs_cxwsjzclcs", cxwsjzclcs, row);
        parentModel.setValue("hjbhs_shljjzclcs", shljjzclcs, row);
        parentModel.setValue("hjbhs_pollutanttype", (Object)pollutanttype, row);
    }

    public void beforeClick(BeforeClickEvent evt) {
        Boolean change;
        if (evt.getSource() instanceof Button && StringUtil.equalsIgnoreCase((CharSequence)((Button)evt.getSource()).getOperationKey(), (CharSequence)CLOSE) && (change = Boolean.valueOf(this.getModel().getDataChanged())).booleanValue()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TaxCategoryHjbhsDialogPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"TaxCategoryHjbhsDialogPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TaxCategoryHjbhsDialogPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (CLOSE.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().put("taxtypechange", "hjbhs");
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        this.getPageCache().put("taxtypechange", "hjbhs");
    }
}

