/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.utils.DynamicObjectUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.enums.CollectRateEnum;
import kd.taxc.enums.TaxPeriodEnum;
import kd.taxc.tctb.formplugin.util.TaxCategoryCommonUtil;

public class TaxCategoryQtsfDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Map<String, String> qtsfFieldInfos = new HashMap<String, String>();

    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit1 = (BasedataEdit)this.getControl("collectitem");
        if (basedataEdit1 != null) {
            basedataEdit1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Integer index;
        String isFprbidden = (String)this.getView().getFormShowParameter().getCustomParam("isForbidden");
        if (Objects.equals("true", isFprbidden)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap2", "advconbaritemap3", "advconbaritemap", "advconbaritemap1"});
        }
        if (Objects.nonNull(index = (Integer)this.getView().getFormShowParameter().getCustomParam("index"))) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            this.getModel().setValue("enablegroup", parentModel.getValue("enable", index.intValue()));
            DynamicObjectCollection entryEntity = parentModel.getEntryEntity("qtsfentity");
            if (entryEntity.size() > 0) {
                int[] rows;
                for (int row : rows = this.getModel().batchCreateNewEntryRow("entryentity", entryEntity.size())) {
                    this.getModel().setValue("collectrate", ((DynamicObject)entryEntity.get(row)).get("collectrate"), row);
                    this.getModel().setValue("collectsubrate", ((DynamicObject)entryEntity.get(row)).get("collectsubrate"), row);
                    this.getModel().setValue("taxperiod", ((DynamicObject)entryEntity.get(row)).get("taxperiod"), row);
                    this.getModel().setValue("amountrate", ((DynamicObject)entryEntity.get(row)).get("amountrate"), row);
                    this.getModel().setValue("effectivestart", ((DynamicObject)entryEntity.get(row)).get("effectivestart"), row);
                    this.getModel().setValue("effectiveend", ((DynamicObject)entryEntity.get(row)).get("effectiveend"), row);
                    this.getModel().setValue("collectitem", ((DynamicObject)entryEntity.get(row)).get("collectitem"), row);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (Objects.equals("submit", args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
            if (index != null) {
                parentModel.setValue("enable", this.getModel().getValue("enablegroup"));
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (entryEntity.size() > 0) {
                    int[] rows;
                    DynamicObject dynamicObject = null;
                    for (int row = 0; row < entryEntity.size(); ++row) {
                        Date expired;
                        Date validfrom;
                        Date endTime;
                        Date startTime;
                        boolean include;
                        dynamicObject = (DynamicObject)entryEntity.get(row);
                        String seq = dynamicObject.getString("seq");
                        DynamicObject collectrate = dynamicObject.getDynamicObject("collectrate");
                        DynamicObject collectitem = dynamicObject.getDynamicObject("collectitem");
                        Date effectivestart = dynamicObject.getDate("effectivestart");
                        Date effectiveend = dynamicObject.getDate("effectiveend");
                        if (Objects.nonNull(effectiveend) && effectivestart.after(effectiveend)) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6709\u6548\u671f\u6b62\u4e0d\u80fd\u65e9\u4e8e\u6709\u6548\u671f\u8d77\u3002", (String)"TaxCategoryQtsfDialogPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
                            return;
                        }
                        if (Objects.nonNull(collectrate) && !(include = DateUtils.isDateRangeWithin((Date)effectivestart, (Date)effectiveend, (Date)(startTime = collectrate.getDate("starttime")), (Date)(endTime = collectrate.getDate("endtime"))))) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u6709\u6548\u671f\u8d77\u6b62\u4e0d\u5728\u201c\u7a0e\u52a1\u653f\u7b56\u8fd0\u7ef4>\u5f81\u6536\u54c1\u76ee\u201d\u6709\u6548\u671f\u8d77\u6b62\u7684\u8303\u56f4\u5185\u3002", (String)"TaxCategoryQtsfDialogPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
                            return;
                        }
                        if (!TaxCategoryCommonUtil.checkIsDataRangeMatchPeriod(this.getView(), effectivestart, effectiveend, dynamicObject.getString("taxperiod"), row + 1)) {
                            return;
                        }
                        if (Objects.nonNull(collectitem) && Objects.nonNull(collectrate) && !(include = DateUtils.isDateRangeWithin((Date)effectivestart, (Date)effectiveend, (Date)(validfrom = collectitem.getDate("validfrom")), (Date)(expired = collectitem.getDate("expired"))))) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u6709\u6548\u671f\u8d77\u6b62\u4e0d\u5728\u5f81\u6536\u5b50\u76ee\u7684\u6709\u6548\u671f\u8d77\u6b62\u8303\u56f4\u5185\u3002", (String)"TaxCategoryQtsfDialogPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
                            return;
                        }
                        for (Map.Entry<String, String> entry : qtsfFieldInfos.entrySet()) {
                            if (null != dynamicObject.get(entry.getKey()) && !"".equals(dynamicObject.get(entry.getKey()))) continue;
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%1$s\u884c\uff1a%2$s\u3002", (String)"TaxCategoryQtsfDialogPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), seq, entry.getValue()));
                            return;
                        }
                    }
                    if (this.checkUniqueGroupVoild(entryEntity)) {
                        return;
                    }
                    parentModel.deleteEntryData("qtsfentity");
                    for (int row : rows = parentModel.batchCreateNewEntryRow("qtsfentity", entryEntity.size())) {
                        parentModel.setValue("collectrate", ((DynamicObject)entryEntity.get(row)).get("collectrate"), row);
                        parentModel.setValue("collectsubrate", ((DynamicObject)entryEntity.get(row)).get("collectsubrate"), row);
                        parentModel.setValue("taxperiod", ((DynamicObject)entryEntity.get(row)).get("taxperiod"), row);
                        parentModel.setValue("amountrate", ((DynamicObject)entryEntity.get(row)).get("amountrate"), row);
                        parentModel.setValue("effectivestart", ((DynamicObject)entryEntity.get(row)).get("effectivestart"), row);
                        parentModel.setValue("effectiveend", ((DynamicObject)entryEntity.get(row)).get("effectiveend"), row);
                        parentModel.setValue("collectitem", ((DynamicObject)entryEntity.get(row)).get("collectitem"), row);
                    }
                } else {
                    parentModel.deleteEntryData("qtsfentity");
                }
            }
            if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("taxtypechange"))) {
                IPageCache parentPageCahce = this.getView().getParentView().getPageCache();
                String taxtypechange = parentPageCahce.get("taxtypechange");
                if (EmptyCheckUtils.isEmpty((Object)taxtypechange)) {
                    taxtypechange = "qtsf";
                } else if (taxtypechange.indexOf("qtsf") < 0) {
                    taxtypechange = taxtypechange + ',' + "qtsf";
                }
                parentPageCahce.put("taxtypechange", taxtypechange);
            }
            this.getView().close();
        }
    }

    private boolean checkUniqueGroupVoild(DynamicObjectCollection entryEntity) {
        DynamicObject dyn1 = null;
        DynamicObject dyn2 = null;
        for (int i = 0; i < entryEntity.size(); ++i) {
            dyn1 = (DynamicObject)entryEntity.get(i);
            for (int j = 0; j < entryEntity.size(); ++j) {
                boolean duplicate;
                dyn2 = (DynamicObject)entryEntity.get(j);
                if (i == j || !(duplicate = this.matchDimension(dyn1, dyn2))) continue;
                this.getView().showErrorNotification(this.getDuplicateErrorMsg(dyn1, dyn2));
                return true;
            }
        }
        return false;
    }

    private String getDuplicateErrorMsg(DynamicObject dyn1, DynamicObject dyn2) {
        DynamicObject collectrate = dyn1.getDynamicObject("collectrate");
        DynamicObject collectitem = dyn1.getDynamicObject("collectitem");
        String errorMsg = "";
        errorMsg = collectitem == null || this.getCheckKey(dyn1).size() == 1 ? String.format(ResManager.loadKDString((String)"\u5728\u540c\u4e00\u6709\u6548\u671f\u8d77\u6b62\u8303\u56f4\u5185\uff0c\u5b58\u5728\u4e24\u4e2a\u6216\u4ee5\u4e0a\u76f8\u540c\u5f81\u6536\u54c1\u76ee\u3002", (String)"TaxCategoryQtsfDialogPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), collectrate.getString("name")) : String.format(ResManager.loadKDString((String)"\u5728\u540c\u4e00\u6709\u6548\u671f\u8d77\u6b62\u8303\u56f4\u5185\uff0c\u5b58\u5728\u4e24\u4e2a\u6216\u4ee5\u4e0a\u76f8\u540c\u7684\u201c%s\u201d\u4e0e\u5b50\u76ee\u7684\u7ec4\u5408\u8bb0\u5f55\u3002", (String)"TaxCategoryQtsfDialogPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), collectrate.getString("name"));
        return errorMsg;
    }

    public List<String> getCheckKey(DynamicObject dyn1) {
        CollectRateEnum collectRateEnum;
        DynamicObject collectrate = dyn1.getDynamicObject("collectrate");
        if (collectrate != null && (collectRateEnum = CollectRateEnum.getEnumByNumber((String)collectrate.getString("number"))) != null) {
            return collectRateEnum.getCheckKey();
        }
        return Lists.newArrayList((Object[])new String[]{"collectrate"});
    }

    public boolean matchDimension(DynamicObject dyn1, DynamicObject dyn2) {
        List<String> checkKey = this.getCheckKey(dyn1);
        for (String k : checkKey) {
            if (DynamicObjectUtils.matchFiled((DynamicObject)dyn1, (DynamicObject)dyn2, (String)k)) continue;
            return false;
        }
        return this.matchTimeCover(dyn1.getDate("effectivestart"), dyn1.getDate("effectiveend"), dyn2.getDate("effectivestart"), dyn2.getDate("effectiveend"));
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        this.getPageCache().put("taxtypechange", "qtsf");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("collectitem".equals(key)) {
            int index = e.getRow();
            ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
            DynamicObject collectRate = (DynamicObject)this.getModel().getValue("collectrate", index);
            if (collectRate == null) {
                return;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("parent.id", "=", (Object)collectRate.getLong("id")));
            filters.add(new QFilter("projectname", "is not null", null));
            f7List.getListFilterParameter().setQFilters(filters);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().put("taxtypechange", "qtsf");
        String key = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if ("taxperiod".equals(key)) {
            DynamicObject collectRate = (DynamicObject)this.getModel().getValue("collectrate", index);
            if (collectRate == null || newValue == null) {
                return;
            }
            CollectRateEnum collectRateEnum = CollectRateEnum.getEnumByNumber((String)collectRate.getString("number"));
            if (collectRateEnum != null && !collectRateEnum.getTaxPeriods().contains(newValue.toString())) {
                TaxPeriodEnum taxPeriodEnum = TaxPeriodEnum.getEnumByNumber((String)newValue.toString());
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6b64\u5f81\u6536\u54c1\u76ee\u4e0d\u80fd\u9009\u62e9\u6309%s\u7533\u62a5\u3002", (String)"TaxCategoryQtsfDialogPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), taxPeriodEnum.getName()));
                this.getModel().setValue("taxperiod", oldValue, index);
            }
        } else if ("collectrate".equals(key)) {
            CollectRateEnum collectRateEnum;
            this.getModel().setValue("collectitem", null, index);
            this.getModel().setValue("taxperiod", null, index);
            DynamicObject collectRate = (DynamicObject)this.getModel().getValue("collectrate", index);
            if (collectRate != null && (collectRateEnum = CollectRateEnum.getEnumByNumber((String)collectRate.getString("number"))) != null) {
                this.getModel().setValue("taxperiod", collectRateEnum.getTaxPeriods().get(0));
            }
        } else if ("effectivestart".equals(key)) {
            if (newValue == null) {
                return;
            }
            Date effectivestart = (Date)newValue;
            this.getModel().setValue(key, (Object)DateUtils.getFirstDateOfMonth((Date)effectivestart));
        } else if ("effectiveend".equals(key)) {
            if (newValue == null) {
                return;
            }
            Date effectiveend = (Date)newValue;
            this.getModel().setValue(key, (Object)DateUtils.getLastDateOfMonth((Date)effectiveend));
        }
    }

    private boolean matchTimeCover(Date effectivestart, Date effectiveend, Date validfrom, Date expired) {
        Date s1 = effectivestart;
        Date e1 = effectiveend;
        s1 = DateUtils.getDayFirst((Date)s1);
        if (e1 != null) {
            e1 = DateUtils.getDayLast((Date)e1);
        }
        Date s2 = validfrom;
        Date e2 = expired;
        s2 = DateUtils.getDayFirst((Date)s2);
        if (e2 != null) {
            e2 = DateUtils.getDayLast((Date)e2);
        }
        return kd.taxc.bdtaxr.common.utils.date.DateUtils.getIntersectionDate((Date)s1, (Date)e1, (Date)s2, (Date)e2) != null;
    }

    static {
        qtsfFieldInfos.put("collectrate", ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee", (String)"TaxCategoryQtsfDialogPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        qtsfFieldInfos.put("taxperiod", ResManager.loadKDString((String)"\u7f34\u7eb3\u671f\u9650", (String)"TaxCategoryQtsfDialogPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        qtsfFieldInfos.put("amountrate", ResManager.loadKDString((String)"\u8d39\u7387", (String)"TaxCategoryQtsfDialogPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        qtsfFieldInfos.put("effectivestart", ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77", (String)"TaxCategoryQtsfDialogPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
    }
}

