/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxCategoryXfsDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit1 = (BasedataEdit)this.getControl("taxpoint");
        basedataEdit1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Integer index;
        String isForbidden = (String)this.getView().getFormShowParameter().getCustomParam("isForbidden");
        if ("true".equals(isForbidden)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap2", "advconbaritemap3", "advconbaritemap", "advconbaritemap1"});
        }
        if ((index = (Integer)this.getView().getFormShowParameter().getCustomParam("index")) != null) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            this.getModel().setValue("taxtype", parentModel.getValue("taxtype", index.intValue()));
            this.getModel().setValue("enablegroup", parentModel.getValue("enable", index.intValue()));
            String deadline = String.valueOf(parentModel.getValue("deadline", index.intValue()));
            if (StringUtils.isBlank((CharSequence)deadline)) {
                deadline = "aysb";
            }
            this.getModel().setValue("deadline", (Object)deadline);
            DynamicObjectCollection entryEntity = parentModel.getEntryEntity("xfsentity");
            if (entryEntity.size() > 0) {
                int[] rows;
                for (int row : rows = this.getModel().batchCreateNewEntryRow("entryentity", entryEntity.size())) {
                    this.getModel().setValue("xfstaxitemrate", ((DynamicObject)entryEntity.get(row)).get("xfstaxitemrate"), row);
                    this.getModel().setValue("taxpoint", ((DynamicObject)entryEntity.get(row)).get("taxpoint"), row);
                    this.getModel().setValue("startdate", ((DynamicObject)entryEntity.get(row)).get("xfsstartdate"), row);
                    this.getModel().setValue("enddate", ((DynamicObject)entryEntity.get(row)).get("xfsenddate"), row);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperateKey().equals("submit") && args.getOperationResult().isSuccess()) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
            if (index != null) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                String enable = (String)this.getModel().getValue("enablegroup");
                if ("1".equals(enable) && entryEntity.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u7a0e\u76ee\u4fe1\u606f\u3002", (String)"TaxCategoryXfsDialogPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return;
                }
                parentModel.setValue("taxtype", this.getModel().getValue("taxtype"), index.intValue());
                parentModel.setValue("enable", this.getModel().getValue("enablegroup"), index.intValue());
                parentModel.setValue("deadline", this.getModel().getValue("deadline"), index.intValue());
                if (entryEntity.size() > 0) {
                    int[] rows;
                    HashMap<String, String> xfstaxitemrateMap = new HashMap<String, String>();
                    for (DynamicObject dynamicObject : entryEntity) {
                        String rateId = ((DynamicObject)dynamicObject.get("xfstaxitemrate")).get("id").toString();
                        String rateNumber = ((DynamicObject)dynamicObject.get("xfstaxitemrate")).get("number").toString();
                        if (xfstaxitemrateMap.containsKey(rateId)) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u7a0e\u76ee\u5df2\u5b58\u5728\u3002", (String)"TaxCategoryXfsDialogPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        xfstaxitemrateMap.put(rateId, rateNumber);
                        Date startDate = dynamicObject.getDate("startdate");
                        Date endDate = dynamicObject.getDate("enddate");
                        if (!DateUtils.format((Date)startDate).equalsIgnoreCase(DateUtils.getFirstDateOfMonthStr((Date)startDate, (String)"yyyy-MM-dd"))) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f\u8bf7\u9009\u62e9\u6708\u521d1\u53f7\u3002", (String)"TaxCategoryXfsDialogPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (!Objects.nonNull(endDate) || startDate.compareTo(endDate) <= 0) continue;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5c01\u5b58\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u542f\u7528\u65e5\u671f\u3002", (String)"TaxCategoryXfsDialogPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    parentModel.deleteEntryData("xfsentity");
                    for (int row : rows = parentModel.batchCreateNewEntryRow("xfsentity", entryEntity.size())) {
                        parentModel.setValue("xfstaxitemrate", ((DynamicObject)entryEntity.get(row)).get("xfstaxitemrate"), row);
                        parentModel.setValue("taxpoint", ((DynamicObject)entryEntity.get(row)).get("taxpoint"), row);
                        parentModel.setValue("xfsstartdate", ((DynamicObject)entryEntity.get(row)).get("startdate"), row);
                        parentModel.setValue("xfsenddate", ((DynamicObject)entryEntity.get(row)).get("enddate"), row);
                    }
                }
            }
            if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("taxtypechange"))) {
                IPageCache parentPageCahce = this.getView().getParentView().getPageCache();
                String taxtypechange = parentPageCahce.get("taxtypechange");
                if (EmptyCheckUtils.isEmpty((Object)taxtypechange)) {
                    taxtypechange = "xfs";
                } else if (taxtypechange.indexOf("xfs") < 0) {
                    taxtypechange = taxtypechange + ',' + "xfs";
                }
                parentPageCahce.put("taxtypechange", taxtypechange);
            }
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject dynamicObject;
        QFilter qFilter;
        DynamicObject temp;
        Object obj;
        if (e.getProperty().getName().equals("xfstaxitemrate") && (obj = this.getModel().getValue("xfstaxitemrate")) != null && (temp = BusinessDataServiceHelper.loadSingle((String)"tpo_tcct_taxrateentry", (String)"id,taxpoint", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)(dynamicObject = (DynamicObject)obj).getLong("id"))})) != null) {
            DynamicObjectCollection dynamicObjectCollection = temp.getDynamicObjectCollection("taxpoint");
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                dynamicObjects.add(dynamicObjectCollection.get(0));
                this.getModel().setValue("taxpoint", (Object)dynamicObjects);
            }
        }
        String name = e.getChangeSet()[0].getDataEntity().getDataEntityType().getName();
        if ("enablegroup".equals(e.getProperty().getName()) || "deadline".equalsIgnoreCase(e.getProperty().getName()) || "entryentity".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxtypechange", "xfs");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().equals("taxpoint")) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("xfstaxitemrate");
            if (dynamicObject == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u76ee\u3002", (String)"TaxCategoryXfsDialogPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)dynamicObject.get("taxpoint");
            ArrayList taxPointNumbers = new ArrayList();
            dynamicObjectCollection.stream().forEach(o -> {
                DynamicObject basedata = o.getDynamicObject("fbasedataid");
                taxPointNumbers.add((String)basedata.get("number"));
            });
            QFilter qfilter = new QFilter("number", "in", taxPointNumbers);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(qfilter);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        this.getPageCache().put("taxtypechange", "xfs");
    }
}

