/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.formplugin.util.TaxCategoryCommonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TaxCategoryYhsDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SEASON = "season";
    private static final String HALFYEAR = "halfyear";
    private static final String YEAR = "year";
    private static final String[] NOT_TIME_FIELDS = new String[]{"taxrate", "declaretype", "period", "isverify", "hdrate"};
    private static final String SHOWCONFIRM_EDIT = "showConfirm_edit";
    private static final String SHOWCONFIRM_DEL = "showConfirm_del";
    private static final String DEL_YES = "yesDel";
    private static final String EDIT_YES = "yesEdit";

    public void registerListener(EventObject e) {
        BasedataEdit taxrate = (BasedataEdit)this.getControl("taxrate");
        taxrate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"tipclose"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("tipclose".equalsIgnoreCase(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipflex"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject originalValue = (DynamicObject)evt.getOriginalValue();
        if (originalValue != null) {
            formShowParameter.setSelectedRow(originalValue.get("id"));
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7a0e\u54c1\u76ee", (String)"TaxCategoryYhsDialogPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        Date now = new Date();
        Date date = DateUtils.stringToDate((String)"2022-08-01");
        if (now.compareTo(date) >= 0) {
            QFilter q1 = new QFilter("startdate", "<=", (Object)now);
            QFilter q2 = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)now));
            DynamicObject object = QueryServiceHelper.queryOne((String)"tpo_tcsd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1, q2});
            if (object != null) {
                List<QFilter> treeFilters = Collections.singletonList(new QFilter("taxrange", "=", object.get("id")));
                TreeFilterParameter treeFilterParameter = formShowParameter.getTreeFilterParameter();
                ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
                listFilterParameter.setQFilters(treeFilters);
                treeFilterParameter.setQFilters(treeFilters);
            }
        }
        formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
        formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
    }

    public void afterCreateNewData(EventObject e) {
        Integer index;
        Date date;
        Date now;
        String isForbidden = (String)this.getView().getFormShowParameter().getCustomParam("isForbidden");
        if ("true".equals(isForbidden)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap2", "advconbaritemap3", "advconbaritemap", "advconbaritemap1"});
        }
        if ((now = new Date()).compareTo(date = DateUtils.stringToDate((String)"2022-12-31")) >= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipflex"});
        }
        if ((index = (Integer)this.getView().getFormShowParameter().getCustomParam("index")) != null) {
            Object obj;
            IDataModel parentModel = this.getView().getParentView().getModel();
            this.getModel().setValue("taxtype", parentModel.getValue("taxtype", index.intValue()));
            this.getModel().setValue("enablegroup", parentModel.getValue("enable", index.intValue()));
            DynamicObjectCollection entryEntity = parentModel.getEntryEntity("yhsentity");
            if (entryEntity.size() > 0) {
                int[] rows;
                HashMap<String, Object> dataCache = new HashMap<String, Object>(16);
                HashMap<String, String> dataCacheName = new HashMap<String, String>(16);
                for (int row : rows = this.getModel().batchCreateNewEntryRow("entryentity", entryEntity.size())) {
                    String tempId = String.valueOf(DBUtils.getLongId(null));
                    this.getModel().setValue("tempid", (Object)tempId, row);
                    this.getModel().setValue("taxrate", ((DynamicObject)entryEntity.get(row)).get("taxrate"), row);
                    this.getModel().setValue("declaretype", ((DynamicObject)entryEntity.get(row)).get("declaretype"), row);
                    this.getModel().setValue("period", ((DynamicObject)entryEntity.get(row)).get("period"), row);
                    this.getModel().setValue("effectivedate", ((DynamicObject)entryEntity.get(row)).get("effectivedate"), row);
                    this.getModel().setValue("expirydate", ((DynamicObject)entryEntity.get(row)).get("expirydate"), row);
                    this.getModel().setValue("isverify", ((DynamicObject)entryEntity.get(row)).get("isverify"), row);
                    this.getModel().setValue("hdrate", ((DynamicObject)entryEntity.get(row)).get("hdrate"), row);
                    dataCache.put(tempId, entryEntity.get(row));
                    dataCacheName.put(tempId, ((DynamicObject)entryEntity.get(row)).getString("taxrate.name"));
                }
                this.getView().getPageCache().put(this.getView().getPageId() + "old", SerializationUtils.toJsonString(dataCache));
                this.getView().getPageCache().put(this.getView().getPageId() + "oldTaxrate", SerializationUtils.toJsonString(dataCacheName));
            }
            if ((obj = parentModel.getValue("orgid")) != null) {
                Long orgId = ((DynamicObject)obj).getLong("id");
                this.getView().getPageCache().put("orgid", String.valueOf(orgId));
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] selectRowIndexs = e.getRowIndexs();
        if (StringUtil.isBlank((CharSequence)this.getPageCache().get(DEL_YES))) {
            ArrayList<String> prepareRows = new ArrayList<String>();
            for (int selectRowIndex : selectRowIndexs) {
                DynamicObject[] selectRow = this.getModel().getEntryEntity("entryentity", selectRowIndex, selectRowIndex + 1);
                String tempId = selectRow[0].getString("tempid");
                if (StringUtils.isBlank((CharSequence)tempId)) continue;
                prepareRows.add(String.valueOf(selectRowIndex));
            }
            if (!prepareRows.isEmpty()) {
                this.showConfirmTips(SHOWCONFIRM_DEL, String.join((CharSequence)",", prepareRows), "");
                e.setCancel(true);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.getPageCache().put(DEL_YES, null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        Integer index;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)((Donothing)args.getSource()).getOperateKey(), (CharSequence)"submit") && StringUtil.isBlank((CharSequence)this.getPageCache().get(EDIT_YES)) && (index = (Integer)this.getView().getFormShowParameter().getCustomParam("index")) != null && (entryEntity = this.getModel().getEntryEntity("entryentity")).size() > 0) {
            String editCache = this.getPageCache().get(this.getView().getPageId() + "edit");
            Map editDataCache = null;
            if (StringUtils.isNotBlank((CharSequence)editCache)) {
                editDataCache = (Map)SerializationUtils.fromJsonString((String)editCache, Map.class);
            }
            HashSet<String> rowInfo = new HashSet<String>(16);
            HashSet<String> reductionRow = new HashSet<String>(16);
            for (int row = 0; row < entryEntity.size(); ++row) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
                String tempId = dynamicObject.getString("tempId");
                if (tempId == null || editDataCache == null || !editDataCache.containsKey(tempId)) continue;
                this.validateIsShowConfirm(tempId, rowInfo, dynamicObject, row, editDataCache, reductionRow);
            }
            if (!rowInfo.isEmpty()) {
                this.showConfirmTips(SHOWCONFIRM_EDIT, String.join((CharSequence)",", reductionRow), String.join((CharSequence)"\n", rowInfo));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperateKey().equals("submit") && args.getOperationResult().isSuccess()) {
            this.closeWindowValidate();
        }
    }

    private void closeWindowValidate() {
        IDataModel parentModel = this.getView().getParentView().getModel();
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        if (index != null) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity.size() > 0) {
                StringBuilder errorMessage = new StringBuilder();
                String editCache = this.getPageCache().get(this.getView().getPageId() + "edit");
                Map editDataCache = null;
                if (StringUtils.isNotBlank((CharSequence)editCache)) {
                    editDataCache = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.getView().getPageId() + "edit"), Map.class);
                }
                StringBuilder errors = new StringBuilder();
                for (int row = 0; row < entryEntity.size(); ++row) {
                    boolean betweenOfTime;
                    boolean latestYhs;
                    BigDecimal hdrate;
                    Date expiryDate;
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
                    this.validateEntryData(dynamicObject, row, errors);
                    if (StringUtil.isNotBlank((CharSequence)errors.toString())) {
                        this.getView().showErrorNotification(errors.toString());
                        return;
                    }
                    Date effectiveDate = dynamicObject.getDate("effectivedate");
                    if (effectiveDate.compareTo(expiryDate = dynamicObject.getDate("expirydate")) > 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6709\u6548\u671f\u8d77\u7684\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u671f\u6b62\u7684\u65f6\u95f4\u3002", (String)"TaxCategoryYhsDialogPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
                        return;
                    }
                    if (!TaxCategoryCommonUtil.checkIsDataRangeMatchPeriod(this.getView(), effectiveDate, expiryDate, dynamicObject.getString("period"), row + 1)) {
                        return;
                    }
                    dynamicObject.set("effectivedate", (Object)DateUtils.getFirstDateOfMonth((Date)effectiveDate));
                    dynamicObject.set("expirydate", (Object)DateUtils.getLastDateOfMonth((Date)expiryDate));
                    Boolean isVerify = dynamicObject.getBoolean("isverify");
                    if (isVerify.booleanValue() && BigDecimal.ZERO.compareTo(hdrate = dynamicObject.getBigDecimal("hdrate")) == 0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u5f55\u5165\u7a0e\u6536\u54c1\u76ee%2$s\u7684\u6838\u5b9a\u6bd4\u4f8b\u3002", (String)"TaxCategoryYhsDialogPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1, dynamicObject.getDynamicObject("taxrate").getString("name")));
                        return;
                    }
                    String tempId = dynamicObject.getString("tempId");
                    if (tempId != null) {
                        // empty if block
                    }
                    if (latestYhs = this.isLatestYhs(dynamicObject.getDynamicObject("taxrate").getLong("id")).booleanValue()) {
                        String declaretype = dynamicObject.getString("declaretype");
                        String period = dynamicObject.getString("period");
                        if ("aqsb".equals(declaretype) && !SEASON.equalsIgnoreCase(period) && !YEAR.equalsIgnoreCase(period)) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7a0e\u6536\u54c1\u76ee%2$s\u7684\u7f34\u7eb3\u671f\u9650\u5e94\u4e3a\u5b63\u6216\u4e3a\u5e74\u3002", (String)"TaxCategoryYhsDialogPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1, dynamicObject.getDynamicObject("taxrate").getString("name")));
                            return;
                        }
                    }
                    ImmutablePair<Date, Date> datePeriod = this.getDatePeriod(dynamicObject.getDynamicObject("taxrate").getLong("id"));
                    Date enddate = datePeriod.right == null ? null : DateUtils.getDayFirst((Date)((Date)datePeriod.right));
                    boolean bl = betweenOfTime = enddate == null || enddate.compareTo(DateUtils.getDayFirst((Date)expiryDate)) >= 0;
                    if (betweenOfTime) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7a0e\u6536\u54c1\u76ee%2$s\u6709\u6548\u671f\u8303\u56f4\u4e0d\u5728\u7a0e\u76ee\u8868\u751f\u6548\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u4fee\u6539\u6709\u6548\u8d77\u6b62\u65f6\u95f4\u3002", (String)"TaxCategoryYhsDialogPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1, dynamicObject.getDynamicObject("taxrate").getString("name")));
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)errorMessage.toString())) {
                    OperationResult operationResult = new OperationResult();
                    operationResult.setSuccess(false);
                    operationResult.setMessage(errorMessage.toString());
                    this.getView().showOperationResult(operationResult);
                    return;
                }
                this.validateIsConflict(entryEntity, errorMessage);
                if (StringUtils.isNotBlank((CharSequence)errorMessage.toString())) {
                    OperationResult operationResult = new OperationResult();
                    operationResult.setSuccess(false);
                    operationResult.setMessage(errorMessage.toString());
                    this.getView().showOperationResult(operationResult);
                    return;
                }
            }
            parentModel.setValue("taxtype", this.getModel().getValue("taxtype"), index.intValue());
            parentModel.setValue("enable", this.getModel().getValue("enablegroup"), index.intValue());
            parentModel.deleteEntryData("yhsentity");
            if (entryEntity.size() > 0) {
                int[] rows;
                for (int row : rows = parentModel.batchCreateNewEntryRow("yhsentity", entryEntity.size())) {
                    parentModel.setValue("taxrate", ((DynamicObject)entryEntity.get(row)).get("taxrate"), row);
                    parentModel.setValue("declaretype", ((DynamicObject)entryEntity.get(row)).get("declaretype"), row);
                    parentModel.setValue("period", ((DynamicObject)entryEntity.get(row)).get("period"), row);
                    parentModel.setValue("effectivedate", ((DynamicObject)entryEntity.get(row)).get("effectivedate"), row);
                    parentModel.setValue("expirydate", ((DynamicObject)entryEntity.get(row)).get("expirydate"), row);
                    parentModel.setValue("isverify", ((DynamicObject)entryEntity.get(row)).get("isverify"), row);
                    parentModel.setValue("hdrate", ((DynamicObject)entryEntity.get(row)).get("hdrate"), row);
                }
            }
        }
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("taxtypechange"))) {
            IPageCache parentPageCahce = this.getView().getParentView().getPageCache();
            String taxtypechange = parentPageCahce.get("taxtypechange");
            if (EmptyCheckUtils.isEmpty((Object)taxtypechange)) {
                taxtypechange = "yhs";
            } else if (taxtypechange.indexOf("yhs") < 0) {
                taxtypechange = taxtypechange + ',' + "yhs";
            }
            parentPageCahce.put("taxtypechange", taxtypechange);
        }
        this.getView().close();
    }

    private StringBuilder validateEntryData(DynamicObject dynamicObject, int row, StringBuilder errors) {
        if (Objects.isNull(dynamicObject.get("taxrate"))) {
            errors.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7a0e\u6536\u54c1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryYhsDialogPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
        }
        if (Objects.isNull(dynamicObject.get("declaretype"))) {
            errors.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7533\u62a5\u671f\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryYhsDialogPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
        }
        if (Objects.isNull(dynamicObject.get("period"))) {
            errors.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7f34\u7eb3\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryYhsDialogPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
        }
        if (Objects.isNull(dynamicObject.get("isverify"))) {
            errors.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u662f\u5426\u6838\u5b9a\u5f81\u6536\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryYhsDialogPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
        }
        if (Objects.isNull(dynamicObject.get("effectivedate"))) {
            errors.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryYhsDialogPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
        }
        if (Objects.isNull(dynamicObject.get("expirydate"))) {
            errors.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6709\u6548\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxCategoryYhsDialogPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), row + 1));
        }
        return errors;
    }

    private ImmutablePair<Date, Date> getDatePeriod(Long id) {
        DynamicObject[] tcsdTaxrates;
        for (DynamicObject tcsdTaxrate : tcsdTaxrates = BusinessDataServiceHelper.load((String)"tpo_tcsd_taxrate", (String)"id,entryentity,startdate,enddate", (QFilter[])new QFilter[0])) {
            DynamicObjectCollection entryentity = tcsdTaxrate.getDynamicObjectCollection("entryentity");
            List ids = entryentity.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
            if (!ids.contains(id)) continue;
            Date startdate = tcsdTaxrate.getDate("startdate");
            Date enddate = tcsdTaxrate.getDate("enddate");
            return ImmutablePair.of((Object)startdate, (Object)enddate);
        }
        return ImmutablePair.of(null, null);
    }

    private Boolean isLatestYhs(Long id) {
        Date left = (Date)this.getDatePeriod((Long)id).right;
        if (left == null) {
            return true;
        }
        DynamicObject[] taxRates = BusinessDataServiceHelper.load((String)"tpo_tcsd_taxrate", (String)"id,number,name,startdate,enddate", (QFilter[])new QFilter[0]);
        Date latestEndDate = null;
        for (DynamicObject taxRate : taxRates) {
            if (taxRate.getDate("enddate") == null) {
                latestEndDate = null;
                break;
            }
            if (null != latestEndDate && taxRate.getDate("enddate").compareTo(latestEndDate) <= 0) continue;
            latestEndDate = taxRate.getDate("enddate");
        }
        return latestEndDate != null && left.compareTo(latestEndDate) == 0;
    }

    private void validateIsConflict(DynamicObjectCollection entryEntity, StringBuilder errorMessage) {
        for (int row = 0; row < entryEntity.size(); ++row) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
            Date effectiveDate = dynamicObject.getDate("effectivedate");
            Date expiryDate = dynamicObject.getDate("expirydate");
            for (int i = row + 1; i < entryEntity.size(); ++i) {
                DynamicObject targetObject = (DynamicObject)entryEntity.get(i);
                Date targetEffectiveDate = targetObject.getDate("effectivedate");
                Date targetExpiryDate = targetObject.getDate("expirydate");
                if (effectiveDate.after(targetExpiryDate) || expiryDate.before(targetEffectiveDate) || dynamicObject.getDynamicObject("taxrate").getLong("id") != targetObject.getDynamicObject("taxrate").getLong("id")) continue;
                errorMessage.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5728%3$s\u81f3%4$s\u5185\u540c\u65f6\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"TaxCategoryYhsDialogPlugin_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), i + 1, dynamicObject.getDynamicObject("taxrate").getString("name"), DateUtils.format((Date)effectiveDate, (String)"yyyy-MM-dd"), DateUtils.format((Date)expiryDate, (String)"yyyy-MM-dd"))).append(System.getProperty("line.separator"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        DynamicObject newValue;
        if ("enablegroup".equals(e.getProperty().getName())) {
            this.getPageCache().put("taxtypechange", "yhs");
            return;
        }
        if ("effectivedate".equals(e.getProperty().getName()) && this.getModel().getValue(e.getProperty().getName()) != null) {
            Date effectiveDate = (Date)this.getModel().getValue(e.getProperty().getName());
            this.getModel().setValue(e.getProperty().getName(), (Object)DateUtils.getFirstDateOfMonth((Date)effectiveDate));
        }
        if ("expirydate".equals(e.getProperty().getName()) && this.getModel().getValue(e.getProperty().getName()) != null) {
            Date expiryDate = (Date)this.getModel().getValue(e.getProperty().getName());
            this.getModel().setValue(e.getProperty().getName(), (Object)DateUtils.getLastDateOfMonth((Date)expiryDate));
        }
        if ("taxrate".equals(e.getProperty().getName()) && (newValue = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            ImmutablePair<Date, Date> datePeriod = this.getDatePeriod(newValue.getLong("id"));
            if (datePeriod.right != null) {
                this.getModel().setValue("expirydate", (Object)DateUtils.getLastDateOfMonth((Date)((Date)datePeriod.right)));
            }
        }
        ChangeData[] changeDatas = e.getChangeSet();
        ChangeData changeData = changeDatas[0];
        String tempId = changeData.getDataEntity().getString("tempid");
        if (this.getPageCache().get(this.getView().getPageId() + "edit") == null) {
            this.getPageCache().put(this.getView().getPageId() + "edit", SerializationUtils.toJsonString(new HashMap()));
        }
        Map editDataMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.getView().getPageId() + "edit"), Map.class);
        if (StringUtils.isNotBlank((CharSequence)tempId)) {
            List editProperties;
            if (!editDataMap.containsKey(tempId)) {
                editDataMap.put(tempId, new ArrayList());
            }
            if (!(editProperties = (List)editDataMap.get(tempId)).contains(e.getProperty().getName())) {
                editProperties.add(e.getProperty().getName());
            } else {
                String newValue2;
                String oldValue;
                Map dataCache = (Map)JSONObject.parseObject((String)this.getPageCache().get(this.getView().getPageId() + "old"), Map.class);
                JSONObject dynamicObject = (JSONObject)dataCache.get(tempId);
                if ("taxrate".equals(e.getProperty().getName())) {
                    oldValue = String.valueOf(dynamicObject.getJSONObject(e.getProperty().getName()).get((Object)"id"));
                    newValue2 = changeData.getNewValue() != null ? String.valueOf(((DynamicObject)changeData.getNewValue()).getString("id")) : null;
                } else if ("effectivedate".equals(e.getProperty().getName())) {
                    oldValue = DateUtils.format((Date)dynamicObject.getDate(e.getProperty().getName()), (String)"yyyy-MM-dd");
                    newValue2 = DateUtils.format((Date)((Date)changeData.getNewValue()), (String)"yyyy-MM-dd");
                } else if ("expirydate".equals(e.getProperty().getName())) {
                    oldValue = DateUtils.format((Date)dynamicObject.getDate(e.getProperty().getName()), (String)"yyyy-MM-dd");
                    newValue2 = DateUtils.format((Date)((Date)changeData.getNewValue()), (String)"yyyy-MM-dd");
                } else {
                    oldValue = String.valueOf(dynamicObject.get((Object)e.getProperty().getName()));
                    newValue2 = String.valueOf(changeData.getNewValue());
                }
                if (StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue2)) {
                    Iterator iterator = editProperties.iterator();
                    while (iterator.hasNext()) {
                        String fieldName = (String)iterator.next();
                        if (!fieldName.equals(e.getProperty().getName())) continue;
                        iterator.remove();
                        break;
                    }
                }
            }
            this.getPageCache().put(this.getView().getPageId() + "edit", SerializationUtils.toJsonString((Object)editDataMap));
        }
        if ("entryentity".equalsIgnoreCase(name = e.getChangeSet()[0].getDataEntity().getDataEntityType().getName())) {
            this.getPageCache().put("taxtypechange", "yhs");
        }
    }

    private void validateIsShowConfirm(String tempId, Set<String> rowMessage, DynamicObject dynamicObject, int row, Map<String, List<String>> editDataCache, Set<String> reductionRow) {
        Date statDate = null;
        Date endDate = null;
        Date oldStartDate = null;
        Date oldEndDate = null;
        List<String> fields = Arrays.asList(NOT_TIME_FIELDS);
        Map dataCache = (Map)JSONObject.parseObject((String)this.getPageCache().get(this.getView().getPageId() + "old"), Map.class);
        Map dataCacheName = (Map)JSONObject.parseObject((String)this.getPageCache().get(this.getView().getPageId() + "oldTaxrate"), Map.class);
        String taxrateName = (String)dataCacheName.get(tempId);
        for (String editField : editDataCache.get(tempId)) {
            JSONObject jsonObject = (JSONObject)dataCache.get(tempId);
            if (fields.contains(editField)) {
                String newValue;
                String oldValue = jsonObject.getString(editField);
                if (StringUtil.equalsIgnoreCase((CharSequence)oldValue, (CharSequence)(newValue = dynamicObject.getString(editField)))) continue;
                rowMessage.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5b58\u5728\u4fee\u6539", (String)"TaxCategoryYhsDialogPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), "" + (row + 1), taxrateName));
                reductionRow.add(String.valueOf(row));
                continue;
            }
            oldStartDate = jsonObject.getDate("effectivedate");
            oldEndDate = jsonObject.getDate("expirydate");
            statDate = jsonObject.getDate("effectivedate");
            endDate = jsonObject.getDate("expirydate");
            Date editDate = dynamicObject.getDate(editField);
            if (editDate == null) continue;
            if ("effectivedate".equals(editField)) {
                statDate = DateUtils.getFirstDateOfMonth((Date)editDate);
                endDate = endDate.compareTo(dynamicObject.getDate("expirydate")) == 0 ? endDate : dynamicObject.getDate("expirydate");
                continue;
            }
            if (!"expirydate".equals(editField)) continue;
            statDate = statDate.compareTo(dynamicObject.getDate("effectivedate")) == 0 ? statDate : dynamicObject.getDate("effectivedate");
            endDate = DateUtils.getLastDateOfMonth((Date)editDate);
        }
        if (statDate != null && null != oldStartDate && null != oldEndDate && (statDate.compareTo(oldStartDate) > 0 || oldEndDate.compareTo(endDate) > 0)) {
            rowMessage.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5b58\u5728\u4fee\u6539", (String)"TaxCategoryYhsDialogPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), "" + (row + 1), taxrateName));
            reductionRow.add(String.valueOf(row));
        }
    }

    private void showConfirmTips(String callBackId, String customValue, String message2) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxCategoryYhsDialogPlugin_13", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxCategoryYhsDialogPlugin_14", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)SHOWCONFIRM_DEL)) {
            msg = ResManager.loadKDString((String)"\u6309\u671f\u7533\u62a5\u7684\u5370\u82b1\u7a0e\u4f1a\u6839\u636e\u7a0e\u79cd\u5361\u7247\u4e2d\u751f\u6548\u7684\u7a0e\u76ee\u6570\u636e\u8fdb\u884c\u7a0e\u6e90\u91c7\u96c6\uff0c\u5220\u9664\u9009\u4e2d\u7684\u7a0e\u76ee\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u7a0e\u6e90\u91c7\u96c6\uff0c\u786e\u8ba4\u8981\u5220\u9664\u8be5\u7a0e\u76ee\u5417\uff1f", (String)"TaxCategoryYhsDialogPlugin_15", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)SHOWCONFIRM_EDIT)) {
            msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u4e0b\u5217\u6570\u636e\u5b58\u5728\u4fee\u6539\uff0c\u4fee\u6539\u540e\u53ef\u80fd\u5bfc\u81f4\u65e0\u6cd5\u518d\u6839\u636e\u539f\u7a0e\u76ee\u6570\u636e\u8fdb\u884c\u7a0e\u6e90\u91c7\u96c6\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"TaxCategoryYhsDialogPlugin_16", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        this.getView().showConfirm(msg, message2, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps, customValue);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)SHOWCONFIRM_DEL) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getPageCache().put(DEL_YES, DEL_YES);
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            this.getModel().deleteEntryRows("entryentity", entryGrid.getSelectRows());
            this.getPageCache().put("taxtypechange", "yhs");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)SHOWCONFIRM_EDIT)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(EDIT_YES, EDIT_YES);
                this.closeWindowValidate();
            } else {
                Map dataCache = (Map)JSONObject.parseObject((String)this.getPageCache().get(this.getView().getPageId() + "old"), Map.class);
                String reductionRow = messageBoxClosedEvent.getCustomVaule();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (entryEntity.size() > 0 && StringUtil.isNotBlank((CharSequence)reductionRow)) {
                    String[] rows = reductionRow.split(",");
                    Arrays.stream(rows).forEach(o -> {
                        int row = Integer.parseInt(o);
                        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
                        String tempId = dynamicObject.getString("tempid");
                        JSONObject jsonObject = (JSONObject)dataCache.get(tempId);
                        this.getModel().setValue("taxrate", (Object)jsonObject.getJSONObject("taxrate").getString("id"), row);
                        this.getModel().setValue("declaretype", jsonObject.get((Object)"declaretype"), row);
                        this.getModel().setValue("period", jsonObject.get((Object)"period"), row);
                        this.getModel().setValue("effectivedate", jsonObject.get((Object)"effectivedate"), row);
                        this.getModel().setValue("expirydate", jsonObject.get((Object)"expirydate"), row);
                        this.getModel().setValue("isverify", jsonObject.get((Object)"isverify"), row);
                        this.getModel().setValue("hdrate", jsonObject.get((Object)"hdrate"), row);
                    });
                }
            }
        }
    }
}

