/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Listbox;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.common.util.SearchUtil;
import kd.taxc.common.util.StringUtil;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.tctb.business.taxcmain.TaxInfoHomeBusiness;
import kd.taxc.tctb.business.taxcmain.TaxcMainBusiness;
import kd.taxc.tctb.common.constant.OrgConstant;
import kd.taxc.tctb.common.constant.TaxInfoConstant;
import kd.taxc.tctb.common.util.DevprotalBizAppUtil;
import kd.taxc.tctb.common.vo.OpenTaxMainVo;
import kd.taxc.tctb.formplugin.org.TaxInfoMain;
import kd.taxc.util.SystemParamUtil;

public class TaxInfoHome
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener,
ListboxClickListener,
AfterSearchClickListener,
FilterContainerInitListener,
CreateListColumnsListener,
AfterBindDataListener {
    private static Log LOGGER = LogFactory.getLog(TaxInfoHome.class);
    private static final String KEY_TREEVIEW = "orgtree";
    private static final String KEY_SEARCH = "entitysearchap";
    private static final String MAIN_ENTITY = "tctb_tax_main";
    private static final String KEY_CONTENT = "splitpanelap_right";
    private static final String KEY_TOOLBAR = "toolbarap";
    private static final String TBLNEW = "tblnew";
    private static final String KEY_SAVE = "save";
    private static final String DELETE_KEY = "delete";
    private static final String SUBMIT_KEY = "submit";
    private static final String CANCEL_SUBMIT = "unsubmit";
    private static final String AUDIT_KEY = "audit";
    private static final String UNAUDIT = "unaudit";
    private static final String CURRENT_ORG = "CURRENT_ORG";
    private static final String NEW_ORG = "NEW_ORG";
    private static final String BARITEMAP1 = "baritemap1";
    private static final String IS_ENTITY = "isEntity";
    private static final String FORBIDDEN_STATUS = "3";
    private static final String TRUE = "true";
    private static final String KEY_REFRESH = "refresh";
    private static final String LISTBOXAP = "listboxap";
    private static final String FLEXPANELAP = "flexpanelap";
    private static final String KEY_IMPORT = "importdata";
    private static final String KEY_EXPORT = "exportlist";
    private static final String KEY_EXPORT_NEW = "exportlist_new";
    private static final String IMPORT_DETAILS = "importdetails";
    private static final String EXPORT_DETAILS = "exportdetails";
    private static final String VIEWFLOWCHART = "viewflowchart";
    public static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search sl = (Search)this.getControl(KEY_SEARCH);
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        final TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent searchEnterEvent) {
                if (!StringUtil.isEmpty((CharSequence)searchEnterEvent.getText())) {
                    String oldSearchText = TaxInfoHome.this.getPageCache().get(treeView.getKey() + "searchText");
                    if (StringUtil.isNotBlank((CharSequence)oldSearchText) && !oldSearchText.equals(searchEnterEvent.getText())) {
                        TaxInfoHome.this.getPageCache().put(treeView.getKey() + "_resultlist", null);
                    }
                    ArrayList<String> dataKey = new ArrayList<String>();
                    dataKey.add("number");
                    SearchUtil.searchMemberAndNext((String)searchEnterEvent.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)TaxInfoHome.KEY_TREEVIEW, dataKey);
                    TaxInfoHome.this.getPageCache().put(treeView.getKey() + "searchText", searchEnterEvent.getText());
                } else {
                    TaxInfoHome.this.getPageCache().put(treeView.getKey() + "_resultlist", null);
                    TaxInfoHome.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"TaxInfoHome_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(this::setBillListFilter);
        Listbox box = (Listbox)this.getView().getControl(LISTBOXAP);
        box.addListboxClickListener((ListboxClickListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRightWithNext((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(KEY_TREEVIEW)), (String[])btns, (String)KEY_TREEVIEW);
        }
    }

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setEntityId(MAIN_ENTITY);
            filterContainer.setBillFormId(MAIN_ENTITY);
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
            filterContainer.addAfterSearchClickListener((AfterSearchClickListener)this);
            filterContainer.addAfterBindDataListener((AfterBindDataListener)this);
        }
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{KEY_TOOLBAR});
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String deleteClose;
        DynamicObject org;
        Long id;
        String pageid = this.getPageCache().get("pageid");
        if (pageid == null) {
            return;
        }
        IFormView childView = this.getView().getView(pageid);
        if (null == childView) {
            return;
        }
        boolean change = this.confirmChange(childView);
        if (change) {
            e.setCancel(true);
        }
        if ((id = (Long)childView.getModel().getValue("id")) != null && id > 0L && null != (org = (DynamicObject)childView.getModel().getValue("orgid")) && StringUtil.isEmpty((CharSequence)(deleteClose = this.getPageCache().get("deleteClose")))) {
            this.getView().returnDataToParent((Object)org.getLong("id"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("close".equals(e.getCallBackId())) {
            String newItemid = this.getPageCache().get("new_itemid");
            if (e.getResult() == MessageBoxResult.Yes && StringUtil.isBlank((CharSequence)newItemid)) {
                String pageid = this.getPageCache().get("pageid");
                IFormView childView = this.getView().getView(pageid);
                childView.getModel().setDataChanged(false);
                this.clearZzsPeriodCache(childView);
                this.getPageCache().remove("addNew" + this.getPageCache().get(CURRENT_ORG));
                this.getView().close();
            } else if (e.getResult() == MessageBoxResult.Yes && StringUtil.isNotBlank((CharSequence)newItemid)) {
                String nodeId = this.getPageCache().get(CURRENT_ORG);
                this.getPageCache().put("pkid" + nodeId, newItemid);
                if (StringUtil.isNotBlank((CharSequence)this.getPageCache().get("addNew" + this.getPageCache().get(CURRENT_ORG)))) {
                    this.getPageCache().remove("addNew" + this.getPageCache().get(CURRENT_ORG));
                }
                this.changeNode(nodeId);
                this.getPageCache().remove("new_itemid");
            } else if (e.getResult() == MessageBoxResult.No) {
                boolean flag = this.doOperate(KEY_SAVE);
                if (flag && StringUtil.isBlank((CharSequence)newItemid)) {
                    this.getPageCache().remove("addNew" + this.getPageCache().get(CURRENT_ORG));
                    this.getView().close();
                } else if (!flag && StringUtil.isNotBlank((CharSequence)this.getPageCache().get("addNew" + this.getPageCache().get(CURRENT_ORG)))) {
                    Listbox listbox = (Listbox)this.getControl(LISTBOXAP);
                    listbox.activeItem(this.getPageCache().get(CURRENT_ORG));
                }
            } else if (e.getResult() == MessageBoxResult.Cancel) {
                Listbox listbox = (Listbox)this.getControl(LISTBOXAP);
                IFormView childView = this.getChildView();
                if (Objects.nonNull(childView)) {
                    Object pkId = ((BillShowParameter)childView.getFormShowParameter()).getPkId();
                    if (Objects.nonNull(pkId)) {
                        listbox.activeItem(String.valueOf(pkId));
                    } else {
                        listbox.activeItem(this.getPageCache().get(CURRENT_ORG));
                    }
                }
            }
        } else if ("nodeClick".equals(e.getCallBackId())) {
            if (e.getResult() == MessageBoxResult.No) {
                boolean flag = this.doOperate(KEY_SAVE);
                if (flag) {
                    this.getPageCache().remove("addNew" + this.getPageCache().get(CURRENT_ORG));
                    this.getPageCache().remove("new_itemid");
                } else {
                    TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
                    String nodeId = this.getPageCache().get(CURRENT_ORG);
                    TreeNode node = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeId);
                    treeView.focusNode(node);
                }
            } else if (e.getResult() == MessageBoxResult.Yes) {
                String nodeId = this.getPageCache().get(NEW_ORG);
                String pageid = this.getPageCache().get("pageid");
                IFormView childView = this.getView().getView(pageid);
                this.clearZzsPeriodCache(childView);
                this.getPageCache().remove("addNew" + this.getPageCache().get(CURRENT_ORG));
                this.getPageCache().remove("new_itemid");
                this.changeNode(nodeId);
            } else if (e.getResult() == MessageBoxResult.Cancel) {
                String nodeId = this.getPageCache().get(CURRENT_ORG);
                TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
                TreeNode node = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeId);
                treeView.focusNode(node);
            } else {
                String nodeId = this.getPageCache().get(CURRENT_ORG);
                TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
                TreeNode node = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeId);
                treeView.focusNode(node);
                treeView.treeNodeClick(node.getParentid(), node.getId());
            }
        } else if (e.getCallBackId() != null && e.getCallBackId().contains("SharingScheme")) {
            try {
                ApiResult result = null;
                if ("confirmNewSharingScheme".equals(e.getCallBackId())) {
                    if (e.getResult() == MessageBoxResult.Yes) {
                        result = this.callSharingSchemeService("addToSharingScheme");
                    }
                } else if ("removeOldSharingScheme".equals(e.getCallBackId())) {
                    if (e.getResult() == MessageBoxResult.Yes) {
                        result = this.callSharingSchemeService("removeFromOldSharingScheme");
                    }
                } else if ("confirmNewSharingScheme-removeOldSharingScheme".equals(e.getCallBackId())) {
                    if (e.getResult() == MessageBoxResult.Yes) {
                        result = this.callSharingSchemeService("addToSharingScheme");
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u53d6\u6d88\u6cbf\u7528\u539f\u4e0a\u7ea7\u81ea\u52a8\u5171\u4eab\u65b9\u6848\uff1f", (String)"TaxInfoHome_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("removeOldSharingScheme", (IFormPlugin)this));
                }
                if (result != null) {
                    if (result.getSuccess()) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaxInfoHome_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TaxInfoHome_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TaxInfoHome_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                LOGGER.error("SharingSchemeAutoSharService-" + e.getCallBackId() + "-Error", (Throwable)ex);
            }
        }
    }

    private void clearZzsPeriodCache(IFormView childView) {
        if (Objects.isNull(childView)) {
            return;
        }
        FormShowParameter formShowParameter = childView.getFormShowParameter();
        Object pkId = ((BillShowParameter)formShowParameter).getPkId();
        if (Objects.nonNull(pkId)) {
            childView.getPageCache().remove("zzs,period," + pkId);
        }
    }

    private ApiResult callSharingSchemeService(String method) {
        ApiResult result = null;
        IFormView childView = this.getChildView();
        if (childView != null) {
            DynamicObject taxorg = (DynamicObject)childView.getModel().getValue("taxorg");
            if (taxorg != null) {
                Long orgid = taxorg.getLong("id");
                result = (ApiResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"SharingSchemeAutoSharService", (String)method, (Object[])new Object[]{orgid});
            }
            return result;
        }
        return ApiResult.fail((String)"can't get childView");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("closeImport".equals(evt.getActionId()) || "tctb_tax_info_home".equals(evt.getActionId())) {
            this.changeNode(this.getPageCache().get(CURRENT_ORG));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (KEY_REFRESH.equalsIgnoreCase(key)) {
            this.afterCreateNewData(null);
        }
    }

    private void importData(IFormView view, String entityId, String entityName, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)entityId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Object> plugin = new HashMap<String, Object>();
        plugin.put("Enabled", Boolean.TRUE);
        plugin.put("ClassName", "kd.taxc.tctb.formplugin.org.ver.OrgTaxVerImportPlugin");
        plugins.add(plugin);
        showParameter.setCustomParam("ListName", (Object)entityName);
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    private void viewFlowChart(IFormView view) {
        BillList billlist = (BillList)view.getControl(BILLLISTAP);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"TaxInfoHome_17", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return;
        }
        Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
        if (collect.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u518d\u64cd\u4f5c\u3002", (String)"TaxInfoHome_18", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return;
        }
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        try {
            WorkflowServiceHelper.viewFlowchart((String)view.getPageId(), (Object)list.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"TaxInfoHome_19", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (KEY_IMPORT.equals(key)) {
            String entityName = ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f", (String)"TaxInfoHome_20", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            this.importData(this.getView(), MAIN_ENTITY, entityName, new CloseCallBack((IFormPlugin)this, "closeImport"));
        } else if (KEY_EXPORT.equals(key)) {
            this.openTaxMainListform();
        } else if (KEY_EXPORT_NEW.equals(key)) {
            this.openTaxMainListAndExportList(KEY_EXPORT);
        } else if ("exportlistbyselectfields".equals(key)) {
            this.openTaxMainListAndExportList("exportlistbyselectfields");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)VIEWFLOWCHART)) {
            this.viewFlowChart(this.getView());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)IMPORT_DETAILS)) {
            this.viewImportdetails();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)EXPORT_DETAILS)) {
            this.viewExportdetails();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"donothingadd")) {
            boolean menuFlag = this.getMenuFlag();
            if (menuFlag) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("tctb_tax_info_home");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowTitle(true);
                Object nodeId = this.getCurrentNodeId();
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                customParams.put("listOrgId", nodeId);
                customParams.put("addNew" + nodeId, true);
                showParameter.setCustomParams(customParams);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tctb_tax_info_home");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else {
                String nodeId = this.getPageCache().get(CURRENT_ORG);
                this.getPageCache().put("addNew" + nodeId, TRUE);
                this.changeNode(nodeId);
            }
        }
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        boolean menuFlag = this.getMenuFlag();
        if (menuFlag && EmptyCheckUtils.isEmpty((Object)selectedRows) && this.isOperateKey(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaxInfoHome_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        } else if (menuFlag && EmptyCheckUtils.isNotEmpty((Object)selectedRows) && this.isOperateKey(key)) {
            List pkidList = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(x -> (Long)x).collect(Collectors.toList());
            DynamicObject[] objects = TaxcMainBusiness.getTaxMainInfoByIds(pkidList);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)key, (String)MAIN_ENTITY, (DynamicObject[])objects, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(TaxInfoConstant.getSuccessOperate((String)key));
            } else {
                this.getView().showOperationResult(operationResult, OperateCodeEnum.getByCode((String)key));
            }
            if (operationResult.getSuccessPkIds().size() > 0) {
                if (DELETE_KEY.equals(key)) {
                    billlistap.clearSelection();
                }
                this.refreshView();
            }
        } else if (EmptyCheckUtils.isNotEmpty((Object)key) && key.equals("donothing")) {
            this.doOperate(KEY_SAVE);
        } else if (this.isOperateKey(key)) {
            this.doOperate(key);
        }
    }

    protected void refreshView() {
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        Object nodeId = this.getCurrentNodeId();
        if (nodeId != null) {
            this.changeNode(nodeId.toString());
        } else {
            billlistap.refreshData();
        }
    }

    protected Object getCurrentNodeId() {
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        Object nodeId = null;
        if (treeView != null && treeView.getTreeState() != null && treeView.getTreeState().getFocusNode() != null) {
            nodeId = treeView.getTreeState().getFocusNode().get("id");
        }
        return nodeId;
    }

    private boolean isOperateKey(String key) {
        return DELETE_KEY.equals(key) || SUBMIT_KEY.equals(key) || CANCEL_SUBMIT.equals(key) || AUDIT_KEY.equals(key) || UNAUDIT.equals(key);
    }

    private boolean doOperate(String operateKey) {
        IFormView childView = this.getChildView();
        if (null == childView) {
            return false;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        List pluginList = pluginProxy.getPlugIns();
        TaxInfoMain taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            if (!(plugin instanceof TaxInfoMain)) continue;
            taxDeclarePlugin = (TaxInfoMain)plugin;
        }
        if (taxDeclarePlugin != null) {
            String nodeId;
            OperationResult result = taxDeclarePlugin.doOperate(operateKey);
            if (!result.isSuccess()) {
                this.getView().showOperationResult(result);
                this.saveOperateDialog(childView.getModel().getDataEntity(true).getString("number"), operateKey, false);
                return false;
            }
            childView.getModel().setDataChanged(false);
            String billstatus = childView.getModel().getDataEntity(true).getString("billstatus");
            childView.getModel().setValue("billstatus", (Object)billstatus);
            this.getView().sendFormAction(childView);
            this.setOperateVisable(billstatus, operateKey);
            this.getView().showSuccessNotification(TaxInfoConstant.getSuccessOperate((String)operateKey));
            if (!this.getMenuFlag() && !DELETE_KEY.equals(operateKey)) {
                this.getPageCache().remove("new_itemid");
                nodeId = this.getPageCache().get(CURRENT_ORG);
                this.getPageCache().remove("addNew" + nodeId);
                this.getPageCache().put("pkid" + nodeId, String.valueOf(result.getSuccessPkIds().get(0)));
                this.clearZzsPeriodCache(childView);
                String newNodeId = this.getPageCache().get(NEW_ORG);
                if (StringUtil.isNotBlank((CharSequence)newNodeId)) {
                    nodeId = newNodeId;
                }
                this.changeNode(nodeId);
            }
            if (SUBMIT_KEY.equals(operateKey)) {
                this.postSaveProcess(childView);
            }
            this.saveOperateDialog(childView.getModel().getDataEntity(true).getString("number"), operateKey, true);
            if (DELETE_KEY.equals(operateKey)) {
                nodeId = this.getPageCache().get(CURRENT_ORG);
                this.getPageCache().put("deleteClose", DELETE_KEY);
                this.getView().close();
            }
        }
        return true;
    }

    private void saveOperateDialog(String number, String operateKey, Boolean result) {
        String saveOperateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TaxInfoHome_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        String appid = DevprotalBizAppUtil.getTaxcAppByNumber((String)"tctb");
        if (KEY_SAVE.equals(operateKey) && !result.booleanValue()) {
            OperatorDialogUtils.operateDialogByAppid((String)appid, (String)MAIN_ENTITY, (String)saveOperateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"TaxInfoHome_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), number));
        } else if (KEY_SAVE.equals(operateKey)) {
            OperatorDialogUtils.operateDialogByAppid((String)appid, (String)MAIN_ENTITY, (String)saveOperateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u201c%1$s\u201d\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaxInfoHome_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), number));
        }
    }

    private void setOperateVisable(String billstatus, String operateKey) {
        boolean menuFlag = this.getMenuFlag();
        if (menuFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{TBLNEW, DELETE_KEY, SUBMIT_KEY, CANCEL_SUBMIT, AUDIT_KEY, UNAUDIT, BARITEMAP1});
        } else if ("B".equals(billstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVE, DELETE_KEY, UNAUDIT, BARITEMAP1, VIEWFLOWCHART});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{TBLNEW, SUBMIT_KEY, CANCEL_SUBMIT, AUDIT_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{AUDIT_KEY, CANCEL_SUBMIT});
        } else if ("C".equals(billstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVE, DELETE_KEY, SUBMIT_KEY, CANCEL_SUBMIT, BARITEMAP1, VIEWFLOWCHART});
            this.getView().setEnable(Boolean.FALSE, new String[]{AUDIT_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{TBLNEW, AUDIT_KEY, UNAUDIT});
            this.getView().setEnable(Boolean.TRUE, new String[]{UNAUDIT});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL_SUBMIT, AUDIT_KEY, UNAUDIT, BARITEMAP1, VIEWFLOWCHART});
            this.getView().setVisible(Boolean.TRUE, new String[]{TBLNEW, KEY_SAVE, DELETE_KEY, SUBMIT_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
            IFormView childView = this.getChildView();
            if (null != childView) {
                if (OperationStatus.VIEW.equals((Object)childView.getFormShowParameter().getStatus())) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{KEY_SAVE});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{KEY_SAVE});
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)UNAUDIT) || StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)CANCEL_SUBMIT)) {
                    childView.updateView();
                    this.getView().sendFormAction(childView);
                }
            }
        }
    }

    private void openTaxMainListform() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId(MAIN_ENTITY);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openTaxMainListAndExportList(String action) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId(MAIN_ENTITY);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("innerlist");
        StyleCss inlineCss = showParameter.getOpenStyle().getInlineStyleCss();
        if (inlineCss == null) {
            inlineCss = new StyleCss();
        }
        inlineCss.setHeight("1");
        inlineCss.setWidth("1");
        showParameter.getOpenStyle().setInlineStyleCss(inlineCss);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        showParameter.setCustomParam(action, (Object)TRUE);
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        List pkidList = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(x -> (Long)x).collect(Collectors.toList());
        showParameter.setSelectedRows(pkidList.toArray());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewImportdetails() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("bos_importlog");
        listShowParameter.getListFilterParameter().setFilter(new QFilter("sourceobj.number", "=", (Object)MAIN_ENTITY));
        listShowParameter.getListFilterParameter().setFilter(new QFilter("creator", "=", (Object)Long.parseLong(RequestContext.get().getUserId())));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimportlog"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void viewExportdetails() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("bos_exportlog");
        listShowParameter.getListFilterParameter().setFilter(new QFilter("sourceobj.number", "=", (Object)MAIN_ENTITY));
        listShowParameter.getListFilterParameter().setFilter(new QFilter("creator", "=", (Object)Long.parseLong(RequestContext.get().getUserId())));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeexportlog"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private IFormView getChildView() {
        String pageid = this.getPageCache().get("pageid");
        if (pageid == null) {
            return null;
        }
        IFormView childView = this.getView().getView(pageid);
        return childView;
    }

    private void postSaveProcess(IFormView childView) {
        try {
            Long orgid;
            Map parentConditionMap;
            Long parentOrg;
            DynamicObject taxorg = (DynamicObject)childView.getModel().getValue("taxorg");
            DynamicObject taxationsys = (DynamicObject)childView.getModel().getValue("taxationsys");
            if (taxorg != null && taxationsys != null && TaxationsysMappingEnum.CHN.getId().equals(taxationsys.getLong("id")) && (parentOrg = (Long)(parentConditionMap = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"SharingSchemeAutoSharService", (String)"getJudgeConditions", (Object[])new Object[]{orgid = Long.valueOf(taxorg.getLong("id"))})).get("getCurrentParent")) != null && parentOrg > 0L) {
                Boolean isChangedParent = (Boolean)parentConditionMap.get("isChangedParent");
                Boolean hasOldSharingScheme = (Boolean)parentConditionMap.get("hasOldSharingScheme");
                Boolean hasNewSharingScheme = (Boolean)parentConditionMap.get("hasNewSharingScheme");
                Boolean includedOldSharingScheme = (Boolean)parentConditionMap.get("includedOldSharingScheme");
                Boolean includedNewSharingScheme = (Boolean)parentConditionMap.get("includedNewSharingScheme");
                if (isChangedParent.booleanValue()) {
                    if (hasNewSharingScheme.booleanValue() && !includedNewSharingScheme.booleanValue()) {
                        String callBackId = "confirmNewSharingScheme";
                        if (includedOldSharingScheme.booleanValue()) {
                            callBackId = "confirmNewSharingScheme-removeOldSharingScheme";
                        }
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u52a0\u5165\u4e0a\u7ea7\u81ea\u52a8\u5171\u4eab\u65b9\u6848\uff1f", (String)"TaxInfoHome_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                    } else if (hasOldSharingScheme.booleanValue() && includedOldSharingScheme.booleanValue()) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u53d6\u6d88\u6cbf\u7528\u539f\u4e0a\u7ea7\u81ea\u52a8\u5171\u4eab\u65b9\u6848\uff1f", (String)"TaxInfoHome_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("removeOldSharingScheme", (IFormPlugin)this));
                    }
                } else if (hasNewSharingScheme.booleanValue() && !includedNewSharingScheme.booleanValue()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u52a0\u5165\u4e0a\u7ea7\u81ea\u52a8\u5171\u4eab\u65b9\u6848\uff1f", (String)"TaxInfoHome_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirmNewSharingScheme", (IFormPlugin)this));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("TaxMain-SharingSchemeAutoSharService-Error", (Throwable)e);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        LOGGER.info("treeNodeClick start params nodeId={}", (Object)nodeId);
        String current = this.getPageCache().get(CURRENT_ORG);
        if (nodeId.equals(current)) {
            this.changeNode(nodeId);
            return;
        }
        String pageid = this.getPageCache().get("pageid");
        IFormView childView = this.getView().getView(pageid);
        boolean change = false;
        boolean isRealChange = false;
        String periodCache = "";
        if (childView != null) {
            try {
                change = childView.getModel().getDataChanged();
                String changeDesc = childView.getModel().getChangeDesc();
                isRealChange = change && StringUtils.isNotBlank((CharSequence)changeDesc);
                FormShowParameter formShowParameter = childView.getFormShowParameter();
                Object pkId = ((BillShowParameter)formShowParameter).getPkId();
                if (Objects.nonNull(pkId)) {
                    periodCache = childView.getPageCache().get("zzs,period," + pkId);
                }
            }
            catch (Throwable e) {
                this.changeNode(nodeId);
            }
        }
        String addNewFlag = this.getPageCache().get("addNew" + current);
        if (isRealChange || StringUtils.isNotBlank((CharSequence)periodCache) || StringUtil.isNotBlank((CharSequence)addNewFlag)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("nodeClick", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TaxInfoHome_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58\u9000\u51fa", (String)"TaxInfoHome_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"TaxInfoHome_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TaxInfoHome_13", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            this.getPageCache().put(NEW_ORG, nodeId);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.changeNode(nodeId);
        }
    }

    protected QFilter getOrgFilter(String nodeId) {
        List<Object> orgIds = new ArrayList<Long>(10);
        Boolean containSubFlag = !Objects.isNull(this.getModel().getValue("containsub")) && (Boolean)this.getModel().getValue("containsub") != false;
        if (containSubFlag.booleanValue()) {
            TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
            TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeId);
            if (EmptyCheckUtils.isNotEmpty((Object)treeNode)) {
                List childNodeList = treeNode.getChildren();
                if (EmptyCheckUtils.isNotEmpty((Object)childNodeList)) {
                    List childrens = TreeUtils.getSonChildrens((TreeNode)treeNode, (List)childNodeList);
                    orgIds = childrens.stream().map(x -> Long.parseLong(x.getId())).collect(Collectors.toList());
                    orgIds.add(Long.parseLong(nodeId));
                } else {
                    orgIds.add(Long.parseLong(nodeId));
                }
            }
        } else {
            orgIds.add(Long.parseLong(nodeId));
        }
        HasPermOrgResult hasPermOrgResult = this.getAllPermOrgs();
        List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        Boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List<Object> volidIds = new ArrayList(10);
        if (hasAllOrgPerm != null && hasAllOrgPerm.booleanValue()) {
            volidIds = orgIds;
        } else if (hasPermOrgs != null && hasPermOrgs.size() > 0) {
            volidIds = orgIds.stream().filter(id -> hasPermOrgs.contains(id)).collect(Collectors.toList());
        }
        QFilter orgFilter = null;
        orgFilter = volidIds.size() > 0 ? new QFilter("orgid", "in", volidIds) : new QFilter("orgid", "in", Collections.singletonList(-1L));
        return orgFilter;
    }

    private void changeNode(String nodeId) {
        if (StringUtil.isBlank((CharSequence)nodeId)) {
            return;
        }
        boolean menuFlag = this.getMenuFlag();
        if (menuFlag) {
            this.changeListView(nodeId);
        } else {
            this.changeEditView(nodeId);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String menuFlag = (String)e.getFormShowParameter().getCustomParam("menuFlag");
        if (!TRUE.equals(menuFlag)) {
            OpenTaxMainVo openTaxMainVo;
            Object pkid = e.getFormShowParameter().getCustomParam("pkid");
            String orgStr = (String)e.getFormShowParameter().getCustomParam("listOrgId");
            String taxationsysStr = (String)e.getFormShowParameter().getCustomParam("taxationsys");
            Long pkId = EmptyCheckUtils.isNotEmpty((Object)pkid) ? (Long)pkid : null;
            Long orgId = EmptyCheckUtils.isNotEmpty((Object)orgStr) ? Long.valueOf(Long.parseLong(orgStr)) : null;
            Long taxationSys = EmptyCheckUtils.isNotEmpty((Object)taxationsysStr) ? Long.valueOf(Long.parseLong(taxationsysStr)) : null;
            Long openPkId = null;
            Long openOrgId = orgId;
            Object addNewFlag = e.getFormShowParameter().getCustomParam("addNew" + orgStr);
            if (Objects.isNull(addNewFlag)) {
                DynamicObject taxMain = TaxInfoHomeBusiness.queryTaxMainByIdAndOrgIdAndTaxationSys((Long)pkId, (Long)orgId, (Long)taxationSys);
                if (taxMain != null) {
                    openPkId = taxMain.getLong("id");
                    openOrgId = taxMain.getLong("orgid.id");
                } else if (EmptyCheckUtils.isEmpty((Object)openOrgId)) {
                    openOrgId = this.getDefaultOrg();
                }
            }
            if (!(openTaxMainVo = TaxInfoHomeBusiness.checkOpenTaxMain(openPkId, (Long)openOrgId)).isOpen()) {
                e.setCancel(true);
                e.setCancelMessage(openTaxMainVo.getTipMessage());
            }
        }
    }

    private void changeEditView(String nodeId) {
        String newItemid;
        this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{BILLLISTAP, "flexpanelap2"});
        DynamicObject[] dobj = BusinessDataServiceHelper.load((String)MAIN_ENTITY, (String)"id,isinitial,number,taxorg.istaxpayer,taxationsys", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(nodeId))}, (String)"taxationsys asc");
        String pkid = this.getPageCache().get("pkid" + nodeId);
        LOGGER.info("get pkid from cache pkid={}", (Object)pkid);
        String pkId = null;
        if (EmptyCheckUtils.isNotEmpty((Object)pkid)) {
            pkId = pkid;
        } else if (EmptyCheckUtils.isNotEmpty((Object)dobj)) {
            pkId = String.valueOf(dobj[0].getLong("id"));
        }
        String addNewFlag = this.getPageCache().get("addNew" + nodeId);
        if (Objects.equals(TRUE, addNewFlag)) {
            pkId = null;
        }
        if (StringUtil.isNotBlank((CharSequence)(newItemid = this.getPageCache().get("new_itemid")))) {
            pkId = newItemid;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("orgid", nodeId);
        customParams.put("pkid", pkId);
        String taxAtionsys = (String)this.getView().getFormShowParameter().getCustomParam("taxationsys");
        if (StringUtil.isNotBlank((CharSequence)taxAtionsys)) {
            customParams.put("taxAtionsys", taxAtionsys);
        }
        if (dobj == null || dobj.length == 0) {
            customParams.put(IS_ENTITY, this.isEntityByOrg("id", Long.parseLong(nodeId)));
        } else if (!dobj[0].getBoolean("isinitial")) {
            customParams.put(IS_ENTITY, this.isEntityByOrg("number", dobj[0].getString("number")));
        } else {
            customParams.put(IS_ENTITY, dobj[0].getBoolean("taxorg.istaxpayer"));
        }
        boolean success = this.openTaxMainBillForm(pkId, nodeId, customParams, null);
        if (success) {
            this.loadListboxItem(pkId, nodeId, dobj);
        }
    }

    private void loadListboxItem(String pkId, String nodeId, DynamicObject[] dobj) {
        Listbox box = (Listbox)this.getControl(LISTBOXAP);
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>(10);
        if (EmptyCheckUtils.isNotEmpty((Object)dobj)) {
            for (DynamicObject object : dobj) {
                ListboxItem listboxItem;
                long id = object.getLong("id");
                if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
                    listboxItem = new ListboxItem(String.valueOf(id), object.getString("taxationsys.name"));
                    itemlist.add(listboxItem);
                    continue;
                }
                if (!OrgConstant.TAX_CHINA.equals(object.getLong("taxationsys.id"))) continue;
                listboxItem = new ListboxItem(String.valueOf(id), object.getString("taxationsys.name"));
                itemlist.add(listboxItem);
                break;
            }
            String addNewFlag = this.getPageCache().get("addNew" + nodeId);
            box.addItems(itemlist);
            if (Objects.equals(TRUE, addNewFlag)) {
                ListboxItem listboxItem = new ListboxItem(nodeId, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea61", (String)"TaxInfoHome_14", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                itemlist.add(listboxItem);
                box.activeItem(nodeId);
            } else {
                box.activeItem(pkId);
            }
        } else {
            ListboxItem listboxItem = new ListboxItem(nodeId, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea61", (String)"TaxInfoHome_14", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            itemlist.add(listboxItem);
            box.addItems(itemlist);
            box.activeItem(nodeId);
        }
    }

    private void changeListView(String nodeId) {
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        billlistap.setFilter(this.getOrgFilter(nodeId));
        if (!SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            billlistap.getDataPermQFilters().add(new QFilter("taxationsys", "=", (Object)OrgConstant.TAX_CHINA));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{LISTBOXAP, FLEXPANELAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVE});
        this.getView().setVisible(Boolean.TRUE, new String[]{TBLNEW, DELETE_KEY, SUBMIT_KEY, CANCEL_SUBMIT, AUDIT_KEY, UNAUDIT, BARITEMAP1});
        billlistap.clearSelection();
        billlistap.refresh();
        this.getPageCache().put(CURRENT_ORG, nodeId);
    }

    private boolean isEntityByOrg(String field, Object orgid) {
        DynamicObject pattern;
        DynamicObject[] orgObj = BusinessDataServiceHelper.load((String)"bos_org", (String)"orgpattern", (QFilter[])new QFilter[]{new QFilter(field, "=", orgid)});
        if (orgObj.length > 0 && null != (pattern = orgObj[0].getDynamicObject("orgpattern"))) {
            String name = pattern.getString("patterntype");
            return name.equals("1") || name.equals("2");
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        TreeView treeView;
        IPageCache pageCache = this.getPageCache();
        DynamicObjectCollection dcs = TreeUtils.getOrgListsIncludeDisabled();
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        HasPermOrgResult hasPermOrgResult = this.getAllPermOrgs();
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (DynamicObject obj : dcs) {
            TreeNode leftRoot = new TreeNode();
            String id = obj.getString("id");
            String name = obj.getString("name");
            String parentid = obj.getString("parentid");
            leftRoot.setParentid(parentid);
            leftRoot.setId(id);
            leftRoot.setText(name);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("number", obj.getString("number"));
            leftRoot.setData(data);
            nodeList.add(leftRoot);
        }
        TreeUtils.build((TreeView)tree, nodeList, (IPageCache)pageCache, (boolean)false);
        TreeUtils.expand((TreeView)tree, (IPageCache)pageCache, (int)1);
        String listOrgId = (String)this.getView().getFormShowParameter().getCustomParam("listOrgId");
        Object pkid = this.getView().getFormShowParameter().getCustomParam("pkid");
        if (Objects.nonNull(pkid)) {
            this.getPageCache().put("pkid" + listOrgId, pkid.toString());
        }
        if (hasPermOrgResult.hasAllOrgPerm() || hasPermOrgResult.getHasPermOrgs().size() > 0) {
            Object addNewFlag;
            treeView = (TreeView)this.getControl(KEY_TREEVIEW);
            String orgid = listOrgId;
            if (ObjectUtils.isEmpty((Object)listOrgId)) {
                orgid = String.valueOf(this.getDefaultOrg());
            }
            LOGGER.info("afterCreateNewData params orgid={}", (Object)orgid);
            String taxAtionsys = (String)this.getView().getFormShowParameter().getCustomParam("taxationsys");
            if (StringUtil.isNotBlank((CharSequence)taxAtionsys)) {
                DynamicObject taxationInfo = QueryServiceHelper.queryOne((String)MAIN_ENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter("orgid.id", "=", (Object)Long.parseLong(listOrgId)), new QFilter("taxationsys.id", "=", (Object)Long.parseLong(taxAtionsys))});
                if (EmptyCheckUtils.isNotEmpty((Object)taxationInfo)) {
                    this.getPageCache().put("pkid" + listOrgId, taxationInfo.getString("id"));
                } else {
                    this.getPageCache().put("addNew" + listOrgId, TRUE);
                }
            }
            if (Objects.nonNull(addNewFlag = this.getView().getFormShowParameter().getCustomParam("addNew" + orgid))) {
                this.getPageCache().put("addNew" + listOrgId, TRUE);
            }
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)orgid);
            this.setVisableByOrgid(orgid);
        } else if (!ObjectUtils.isEmpty((Object)listOrgId)) {
            DynamicObject taxationInfo;
            treeView = (TreeView)this.getControl(KEY_TREEVIEW);
            String taxAtionsys = (String)this.getView().getFormShowParameter().getCustomParam("taxationsys");
            LOGGER.info("afterCreateNewData getHasPermOrgs params listOrgId={},taxAtionsys={}", (Object)listOrgId, (Object)taxAtionsys);
            if (StringUtil.isNotBlank((CharSequence)taxAtionsys) && EmptyCheckUtils.isNotEmpty((Object)(taxationInfo = QueryServiceHelper.queryOne((String)MAIN_ENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter("orgid.id", "=", (Object)Long.parseLong(listOrgId)), new QFilter("taxationsys.id", "=", (Object)Long.parseLong(taxAtionsys))})))) {
                this.getPageCache().put("pkid" + listOrgId, taxationInfo.getString("id"));
            }
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)listOrgId);
            this.setVisableByOrgid(listOrgId);
        } else {
            TreeUtils.checkFirstNode((IPageCache)this.getPageCache(), (TreeView)tree);
        }
    }

    protected Long getDefaultOrg() {
        Long orgid = null;
        HasPermOrgResult hasPermOrgResult = this.getAllPermOrgs();
        List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        Boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        if (hasAllOrgPerm.booleanValue() || hasPermOrgs.contains(RequestContext.get().getOrgId())) {
            orgid = RequestContext.get().getOrgId();
        } else if (hasPermOrgs.size() > 0) {
            orgid = (Long)hasPermOrgs.get(0);
        }
        return orgid;
    }

    public void afterBindData(EventObject e) {
        Object pkid = this.getView().getFormShowParameter().getCustomParam("pkid");
        if (Objects.isNull(pkid)) {
            this.selectFirstItem(this.getPageCache().get("pkid" + this.getPageCache().get(CURRENT_ORG)));
        } else {
            this.selectFirstItem(String.valueOf(pkid));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"disable")) {
            evt.setCancel(true);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"enable")) {
            evt.setCancel(true);
        }
    }

    private void setVisableByOrgid(String listOrgId) {
        DynamicObject[] dynamicObjects = TaxInfoHomeBusiness.queryTaxMainInfoByOrgId((Long)Long.parseLong(listOrgId), (String)"id,orgid,number,billstatus");
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            boolean menuFlag = this.getMenuFlag();
            if (menuFlag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVE});
                this.getView().setVisible(Boolean.TRUE, new String[]{TBLNEW, DELETE_KEY, SUBMIT_KEY, CANCEL_SUBMIT, AUDIT_KEY, UNAUDIT, BARITEMAP1});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{DELETE_KEY, AUDIT_KEY, UNAUDIT});
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SAVE, SUBMIT_KEY, CANCEL_SUBMIT});
                this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
                this.getView().setEnable(Boolean.FALSE, new String[]{CANCEL_SUBMIT});
            }
            return;
        }
        IFormView childView = this.getChildView();
        if (Objects.nonNull(childView)) {
            Object pkId = ((BillShowParameter)childView.getFormShowParameter()).getPkId();
            if (Objects.nonNull(pkId)) {
                Map<Long, DynamicObject> taxMainMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
                DynamicObject main = taxMainMap.get((Long)pkId);
                if (main != null) {
                    this.setOperateVisable(main.getString("billstatus"), null);
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{TBLNEW, DELETE_KEY, CANCEL_SUBMIT, AUDIT_KEY, UNAUDIT, BARITEMAP1, VIEWFLOWCHART});
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SAVE, SUBMIT_KEY});
                this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
            }
        } else {
            String billstatus = dynamicObjects[0].getString("billstatus");
            this.setOperateVisable(billstatus, null);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if ("orgid_number".equals(hyperLinkClickEvent.getFieldName())) {
            BillList list = (BillList)hyperLinkClickEvent.getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long pkid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            QFilter idFilter = new QFilter("id", "=", (Object)pkid);
            DynamicObject taxMain = BusinessDataServiceHelper.loadSingle((String)MAIN_ENTITY, (String)"id,orgid.id", (QFilter[])new QFilter[]{idFilter});
            String orgId = ObjectUtils.isEmpty((Object)taxMain) ? String.valueOf(pkid) : taxMain.getString("orgid.id");
            customParams.put("listOrgId", orgId);
            customParams.put("pkid", pkid);
            customParams.put("listFlag", true);
            param.setFormId("tctb_tax_info_home");
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tctb_tax_info_home");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
    }

    private boolean getMenuFlag() {
        String menuFlag = (String)this.getView().getFormShowParameter().getCustomParam("menuFlag");
        return TRUE.equals(menuFlag);
    }

    public void listboxClick(ListboxEvent event) {
        String pageid = this.getPageCache().get("pageid");
        if (pageid == null) {
            return;
        }
        IFormView childView = this.getView().getView(pageid);
        if (null == childView) {
            return;
        }
        boolean change = this.confirmChange(childView);
        String itemId = event.getItemId();
        if (change) {
            this.getPageCache().put("new_itemid", itemId);
            return;
        }
        this.changeListbox(itemId);
    }

    private void changeListbox(String itemId) {
        Listbox listbox = (Listbox)this.getControl(LISTBOXAP);
        listbox.activeItem(itemId);
        this.openTaxMainBillForm(itemId, null, null, new CloseCallBack((IFormPlugin)this, "close"));
    }

    private boolean confirmChange(IFormView childView) {
        OperationStatus operationStatus;
        Boolean change = childView.getModel().getDataChanged();
        FormShowParameter formShowParameter = childView.getFormShowParameter();
        Object pkId = ((BillShowParameter)formShowParameter).getPkId();
        String periodCache = "";
        if (Objects.nonNull(pkId)) {
            periodCache = childView.getPageCache().get("zzs,period," + pkId);
        }
        String nodeId = this.getPageCache().get(CURRENT_ORG);
        String addNewFlag = this.getPageCache().get("addNew" + nodeId);
        String billStatus = "";
        DynamicObject taxMain = childView.getModel().getDataEntity(true);
        if (taxMain != null) {
            billStatus = taxMain.getString("billstatus");
        }
        OperationStatus operationStatus2 = operationStatus = "A".equals(billStatus) ? OperationStatus.EDIT : OperationStatus.VIEW;
        if (OperationStatus.EDIT.equals((Object)operationStatus) && (change.booleanValue() || StringUtils.isNotBlank((CharSequence)periodCache)) || Objects.equals(TRUE, addNewFlag)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TaxInfoHome_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58\u9000\u51fa", (String)"TaxInfoHome_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"TaxInfoHome_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TaxInfoHome_16", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            return true;
        }
        return false;
    }

    private void selectFirstItem(String pkid) {
        Listbox listbox = (Listbox)this.getControl(LISTBOXAP);
        listbox.listboxClick(pkid);
        listbox.activeItem(pkid);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (Objects.equals("containsub", e.getProperty().getName())) {
            TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
            if (Objects.isNull(treeView) || Objects.isNull(treeView.getTreeState().getFocusNode())) {
                return;
            }
            Object id = treeView.getTreeState().getFocusNode().get("id");
            String nodeId = null;
            if (Objects.nonNull(id)) {
                nodeId = (String)id;
            }
            this.changeNode(nodeId);
        }
    }

    public void setBillListFilter(SetFilterEvent setFilterEvent) {
        if (!SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            setFilterEvent.getQFilters().add(new QFilter("taxationsys", "=", (Object)OrgConstant.TAX_CHINA));
        }
        if (this.getCurrentNodeId() != null) {
            setFilterEvent.getQFilters().add(this.getOrgFilter(this.getCurrentNodeId().toString()));
        }
    }

    public void click(SearchClickEvent searchClickEvent) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        ArrayList<QFilter> qFiltersClient = new ArrayList<QFilter>();
        QFilter defaultQFlter = new QFilter("1", "=", (Object)1);
        qFiltersClient.add(defaultQFlter);
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        if (customlist != null && customlist.size() > 0) {
            FilterParameter customFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
            List customQFilterList = customFilterParameter.getQFilters();
            qFiltersClient.addAll(customQFilterList);
        }
        if (schemelist != null && schemelist.size() > 0) {
            FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
            List schemaQFilterList = schemaFilterParameter.getQFilters();
            qFiltersClient.addAll(schemaQFilterList);
        }
        list.setClientQueryFilterParameter(new FilterParameter(qFiltersClient, null));
        list.setQueryFilterParameter(new FilterParameter(searchClickEvent.getFastQFilters(), null));
        this.getView().updateView(BILLLISTAP);
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            ArrayList visibleList = Lists.newArrayList((Object[])TaxInfoConstant.TAXORG_FILEDS);
            filterContainerInitEvent.getSchemeFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
            filterContainerInitEvent.getCommonFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
        } else {
            ArrayList visibleList = Lists.newArrayList((Object[])TaxInfoConstant.TAXORGENTRY_FILEDS);
            filterContainerInitEvent.getSchemeFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
            filterContainerInitEvent.getCommonFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
        }
    }

    public void createListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        List listColumns = beforeCreateListColumnsArgs.getListColumns();
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            ArrayList visibleList = Lists.newArrayList((Object[])TaxInfoConstant.TAXORG_FILEDS);
            listColumns.removeIf(column -> visibleList.contains(column.getListFieldKey()));
        } else {
            ArrayList visibleList = Lists.newArrayList((Object[])TaxInfoConstant.TAXORGENTRY_FILEDS);
            listColumns.removeIf(column -> visibleList.contains(column.getListFieldKey()));
        }
        listColumns.size();
    }

    private boolean openTaxMainBillForm(String pkIdStr, String orgIdStr, Map<String, Object> customParams, CloseCallBack closeCallBack) {
        Long pkId = EmptyCheckUtils.isEmpty((Object)pkIdStr) ? null : Long.valueOf(Long.parseLong(pkIdStr));
        Long orgId = EmptyCheckUtils.isEmpty((Object)orgIdStr) ? null : Long.valueOf(Long.parseLong(orgIdStr));
        OpenTaxMainVo openTaxMainVo = TaxInfoHomeBusiness.checkOpenTaxMain((Long)pkId, (Long)orgId);
        orgIdStr = String.valueOf(openTaxMainVo.getOrgId());
        if (!openTaxMainVo.isOpen()) {
            this.changeOldView(orgIdStr, openTaxMainVo);
            return false;
        }
        if (!EmptyCheckUtils.isEmpty((Object)openTaxMainVo.getTipMessage())) {
            if ("mutex".equals(openTaxMainVo.getTipClassify())) {
                this.getView().showErrorNotification(openTaxMainVo.getTipMessage());
            } else {
                this.getView().showTipNotification(openTaxMainVo.getTipMessage());
            }
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        if (customParams != null) {
            billShowParameter.setCustomParams(customParams);
        }
        billShowParameter.setPkId((Object)openTaxMainVo.getPkId());
        billShowParameter.setBillTypeId(MAIN_ENTITY);
        billShowParameter.setFormId(MAIN_ENTITY);
        billShowParameter.setStatus(openTaxMainVo.getViewStatus());
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.getOpenStyle().setTargetKey(FLEXPANELAP);
        if (closeCallBack != null) {
            billShowParameter.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)billShowParameter);
        this.getPageCache().put("pageid", billShowParameter.getPageId());
        this.setVisableByOrgid(orgIdStr);
        this.getPageCache().put(CURRENT_ORG, orgIdStr);
        this.getPageCache().remove(NEW_ORG);
        return true;
    }

    private IFormView getParentView() {
        IFormView parentView = null;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtil.isNotBlank((CharSequence)parentPageId)) {
            parentView = this.getView().getView(parentPageId);
        }
        return parentView;
    }

    private void changeOldView(String orgId, OpenTaxMainVo openTaxMainVo) {
        String current = this.getPageCache().get(CURRENT_ORG);
        String tipMessage = openTaxMainVo.getTipMessage();
        if (StringUtils.isNotBlank((CharSequence)current)) {
            String addNewFlag = this.getPageCache().get("addNew" + orgId);
            if (Objects.equals(TRUE, addNewFlag) || "mutex".equals(openTaxMainVo.getTipClassify())) {
                this.getPageCache().remove("addNew" + current);
                this.getView().showErrorNotification(tipMessage);
            } else {
                this.getView().showTipNotification(tipMessage);
            }
            if (current.equals(orgId)) {
                return;
            }
            TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
        } else {
            IFormView parentView = this.getParentView();
            if (parentView != null) {
                parentView.showErrorNotification(tipMessage);
                this.getView().sendFormAction(parentView);
                this.getView().close();
            }
        }
    }

    private HasPermOrgResult getAllPermOrgs() {
        HasPermOrgResult hasPermOrgResult = null;
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null || pageCache.get("hasPermOrgs") == null) {
            hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"tctb", (String)MAIN_ENTITY, (String)"47150e89000000ac");
            if (pageCache != null) {
                pageCache.put("hasAllOrgPerm", Objects.toString(hasPermOrgResult.hasAllOrgPerm()));
                pageCache.put("hasPermOrgs", Objects.toString(hasPermOrgResult.getHasPermOrgs()));
            }
        } else {
            final List hasPermOrgs = SerializationUtils.fromJsonStringToList((String)pageCache.get("hasPermOrgs"), Long.class);
            final Boolean hasAllOrgPerm = (Boolean)SerializationUtils.fromJsonString((String)pageCache.get("hasAllOrgPerm"), Boolean.TYPE);
            hasPermOrgResult = new HasPermOrgResult(){

                public boolean hasAllOrgPerm() {
                    return hasAllOrgPerm;
                }

                public List<Long> getHasPermOrgs() {
                    return hasPermOrgs;
                }
            };
        }
        return hasPermOrgResult;
    }

    public void afterBindData(AfterBindDataEvent e) {
        super.afterBindData((EventObject)e);
        FilterContainer fc = (FilterContainer)e.getSource();
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        billlistap.setClientQueryFilterParameter(fc.getContext().getClientQueryFilterParameter());
    }
}

