/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.tctb.common.constant.OrgConstant;
import kd.taxc.tctb.common.constant.TaxInfoConstant;
import kd.taxc.util.SystemParamUtil;

public class TaxInfoListPlugin
extends AbstractListPlugin
implements FilterContainerInitListener {
    private static final String pagekey_addId = "allId";

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        if (ObjectUtils.isEmpty((Object)this.getPageCache().get("orgDefaultViewSchemaId"))) {
            QFilter filter = new QFilter("isdefault", "=", (Object)"1");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_org_default_view", (String)"id", (QFilter[])new QFilter[]{filter});
            if (dynamicObject == null) {
                return;
            }
            Long orgDefaultViewSchemaId = dynamicObject.getLong("id");
            this.getPageCache().put("orgDefaultViewSchemaId", String.valueOf(orgDefaultViewSchemaId));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addAfterBindDataListener(v -> {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String exportlist = (String)listShowParameter.getCustomParam("exportlist");
            String exportlistbyselectfields = (String)listShowParameter.getCustomParam("exportlistbyselectfields");
            if (StringUtils.isNotBlank((CharSequence)exportlist)) {
                this.getView().invokeOperation("exportlist");
            }
            if (StringUtils.isNotBlank((CharSequence)exportlistbyselectfields)) {
                this.getView().invokeOperation("exportlistbyselectfields");
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (hasPermOrgResult.getHasPermOrgs().size() > 0) {
            List orgIds = hasPermOrgResult.getHasPermOrgs();
            e.getQFilters().add(new QFilter("taxorg", "in", (Object)orgIds));
        }
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            List list = ObjectUtils.isEmpty((Object)e.getQFilters()) ? new ArrayList() : e.getQFilters();
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id", (QFilter[])list.toArray(new QFilter[list.size()]));
            List idList = collection.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            this.getPageCache().put(pagekey_addId, JSONObject.toJSONString(idList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        } else {
            e.getQFilters().add(new QFilter("taxationsys", "=", (Object)OrgConstant.TAX_CHINA));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opt = (FormOperate)args.getSource();
        String optKey = opt.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)optKey, (CharSequence)"exportlist")) {
            ListSelectedRowCollection rows = this.getSelectRowColl();
            if (ObjectUtils.isEmpty((Object)rows)) {
                if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(pagekey_addId)) && SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
                    JSONArray jsonArray = JSONObject.parseArray((String)this.getPageCache().get(pagekey_addId));
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id,taxationsys.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)jsonArray)});
                    List list = collection.stream().map(row -> row.getLong("taxationsys.id")).distinct().collect(Collectors.toList());
                    if (list.size() == 1 && list.contains(OrgConstant.TAX_CHINA)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7a0e\u52a1\u4fe1\u606f-\u4e3b\u4fe1\u606f\u548c\u7a0e\u79cd\u4fe1\u606f\u201d\u6a21\u677f\u8fdb\u884c\u5bfc\u51fa\u6570\u636e\u3002", (String)"TaxInfoListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    }
                    if (list.size() > 1 && list.contains(OrgConstant.TAX_CHINA)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2d\u56fd\u5927\u9646\u7a0e\u5236\u548c\u6d77\u5916\u7a0e\u5236\u4e0d\u80fd\u540c\u65f6\u5f15\u51fa\u3002", (String)"TaxInfoListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (!list.contains(OrgConstant.TAX_CHINA)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7a0e\u52a1\u4fe1\u606f-\u4e3b\u4fe1\u606f\u548c\u7a0e\u79cd\u4fe1\u606f\uff08\u6d77\u5916\u7a0e\u5236\uff09\u201d\u6a21\u677f\u8fdb\u884c\u5bfc\u51fa\u6570\u636e\u3002", (String)"TaxInfoListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    }
                }
            } else {
                Object[] pkids = rows.getPrimaryKeyValues();
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id,taxationsys.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)});
                List list = collection.stream().map(row -> row.getLong("taxationsys.id")).distinct().collect(Collectors.toList());
                if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
                    if (list.size() > 1 && list.contains(OrgConstant.TAX_CHINA)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e2d\u56fd\u5927\u9646\u7a0e\u5236\u548c\u6d77\u5916\u7a0e\u5236\u4e0d\u80fd\u540c\u65f6\u5f15\u51fa\u3002", (String)"TaxInfoListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (list.size() == 1 && list.contains(OrgConstant.TAX_CHINA)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7a0e\u52a1\u4fe1\u606f-\u4e3b\u4fe1\u606f\u548c\u7a0e\u79cd\u4fe1\u606f\u201d\u6a21\u677f\u8fdb\u884c\u5bfc\u51fa\u6570\u636e\u3002", (String)"TaxInfoListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    } else if (!list.contains(OrgConstant.TAX_CHINA)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7a0e\u52a1\u4fe1\u606f-\u4e3b\u4fe1\u606f\u548c\u7a0e\u79cd\u4fe1\u606f\uff08\u6d77\u5916\u7a0e\u5236\uff09\u201d\u6a21\u677f\u8fdb\u884c\u5bfc\u51fa\u6570\u636e\u3002", (String)"TaxInfoListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7a0e\u52a1\u4fe1\u606f-\u4e3b\u4fe1\u606f\u548c\u7a0e\u79cd\u4fe1\u606f\u201d\u6a21\u677f\u8fdb\u884c\u5bfc\u51fa\u6570\u636e\u3002", (String)"TaxInfoListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("tctb_tax_info_home".equals(evt.getActionId())) {
            this.refresh();
        }
    }

    private ListSelectedRowCollection getSelectRowColl() {
        ListView listview = (ListView)this.getView();
        return listview.getSelectedRows();
    }

    private void refresh() {
        ListView listview = (ListView)this.getView();
        listview.refresh();
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            ArrayList visibleList = Lists.newArrayList((Object[])TaxInfoConstant.TAXORG_FILEDS);
            filterContainerInitEvent.getSchemeFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
            filterContainerInitEvent.getCommonFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
        } else {
            ArrayList visibleList = Lists.newArrayList((Object[])TaxInfoConstant.TAXORGENTRY_FILEDS);
            filterContainerInitEvent.getSchemeFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
            filterContainerInitEvent.getCommonFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        List listColumns = beforeCreateListColumnsArgs.getListColumns();
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            ArrayList visibleList = Lists.newArrayList((Object[])TaxInfoConstant.TAXORG_FILEDS);
            listColumns.removeIf(column -> visibleList.contains(column.getListFieldKey()));
        } else {
            ArrayList visibleList = Lists.newArrayList((Object[])TaxInfoConstant.TAXORGENTRY_FILEDS);
            listColumns.removeIf(column -> visibleList.contains(column.getListFieldKey()));
        }
    }
}

