/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.common.constant.TaxConstant;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.taxorg.validator.QuoteOrgEntityEnum;
import kd.taxc.taxorg.validator.TaxorgQuoteValidator;
import kd.taxc.tctb.business.taxcmain.TaxInfoHomeBusiness;
import kd.taxc.tctb.business.taxcmain.TaxcMainService;
import kd.taxc.tctb.business.util.TaxInfoUtil;
import kd.taxc.tctb.common.constant.OrgConstant;
import kd.taxc.tctb.formplugin.util.TaxPayerTypeUtil;

public class TaxInfoMain
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String APITUDE_EDIT = "apicardentryflex1";
    private static final String CATEGORY_EDIT = "category_edit";
    private static final String TAX_VER = "taxver";
    private static final String IS_ENTITY = "isEntity";
    private static final String LIST_FLAG = "listFlag";
    private static final String TRUE = "true";
    private static final Long TAX_CHINA = 1L;
    private static final String IS_TAXPAYER_DETAIL = "1";
    private static final String NO_TAXPAYER_DETAIL = "";
    private static final String STATUS_ENABLE = "1";
    private static final String TAXTYPE = "taxtype";
    private static final String BASTAX_TAXORG_FIELD = "id,org,taxpayer,istaxpayer,unifiedsocialcode,cmborgtype,status,isvirtual,taxpayerdetail,licensestatus,org_id,cmborgtype_id,entryentity,entryentity.entry_taxpayerdetail,entryentity.entry_taxationsys,entryentity.entry_unifiedsocialcode,entryentity.entry_status,entryentity.entry_istaxpayer,entryentity.entry_taxpayer";
    private static final Map<String, String> IMAGE_MAP = new HashMap<String, String>();
    private static final String USA_CIT = "USA-CIT-Fed-0";
    public static final Map<String, String> noTaxPayerFields = new HashMap<String, String>();
    private List<String> apitudeFields = Arrays.asList("apitudetype", "companytype", "profitmyear", "profittype", "yxsy", "apitudestartdate", "apitudeenddate", "shanghai", "issuedate", "certificateno");
    private static Map<String, String> ICONS;
    private static final List<Map<String, String>> CATEGORY_LIST;

    public void initialize() {
        this.addClickListeners(new String[]{"newcreate", APITUDE_EDIT, CATEGORY_EDIT, TAX_VER});
        CardEntry incomecardList = (CardEntry)this.getView().getControl("categoryentryentity");
        incomecardList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String billstatus = (String)this.getModel().getValue("billstatus");
        if ("newcreate".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            HashMap customParams = new HashMap(8);
            showParameter.setCustomParams(customParams);
            showParameter.setFormId("tctb_apitude_dialog");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tctb_apitude_dialog");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else if (APITUDE_EDIT.equals(key)) {
            this.editEntry("apitudeentryentity", "tctb_apitude_dialog", APITUDE_EDIT, billstatus);
        } else if (CATEGORY_EDIT.equals(key)) {
            this.editEntry("categoryentryentity", "tctb_category_dialog", CATEGORY_EDIT, billstatus);
        } else if (TAX_VER.equals(key)) {
            this.openTaxVerDialog();
        }
    }

    private void openTaxVerDialog() {
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("orgid", ((DynamicObject)this.getModel().getValue("orgid")).get("id"));
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("tctb_tax_ver_changlist");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        List newRows = evt.getNewRows();
        if (!CollectionUtils.isEmpty((Collection)newRows) && newRows.contains(-1)) {
            return;
        }
        String taxType = (String)this.getModel().getValue(TAXTYPE);
        String billstatus = (String)this.getModel().getValue("billstatus");
        if ("categoryentryentity".equals(cardEntry.getKey())) {
            if ("fjsf".equals(taxType)) {
                this.editEntry("categoryentryentity", "tctb_addtional_tax_dialog", CATEGORY_EDIT, billstatus);
            } else if ("yhs".equals(taxType)) {
                this.editEntry("categoryentryentity", "tctb_yhs_dialog", CATEGORY_EDIT, billstatus);
            } else if ("xfs".equals(taxType)) {
                this.editEntry("categoryentryentity", "tctb_xfs_dialog", CATEGORY_EDIT, billstatus);
            } else if ("fcscztdsys".equals(taxType)) {
                this.editEntry("categoryentryentity", "tctb_fcscztdsys_dialog", CATEGORY_EDIT, billstatus);
            } else if ("hjbhs".equals(taxType)) {
                this.editEntry("categoryentryentity", "tctb_hjbhs_dialog", CATEGORY_EDIT, billstatus);
            } else if ("qtsf".equals(taxType)) {
                this.editEntry("categoryentryentity", "tctb_qtsf_dialog", CATEGORY_EDIT, billstatus);
            } else if ("szys".equals(taxType)) {
                this.editEntry("categoryentryentity", "tctb_szys_dialog", CATEGORY_EDIT, billstatus);
            } else if ("cwbb".equals(taxType) || "qhjt".equals(taxType) || "zdsy".equals(taxType)) {
                this.editEntry("categoryentryentity", "tctb_sbx_dialog", CATEGORY_EDIT, billstatus);
            } else {
                this.editEntry("categoryentryentity", "tctb_category_dialog", CATEGORY_EDIT, billstatus);
            }
        } else if ("apitudeentryentity".equals(cardEntry.getKey())) {
            this.editEntry("apitudeentryentity", "tctb_apitude_dialog", APITUDE_EDIT, billstatus);
        }
    }

    private void editEntry(String entry, String formId, String actionid, String billstatus) {
        int index = this.getModel().getEntryCurrentRowIndex(entry);
        FormShowParameter showParameter = new FormShowParameter();
        if (!"A".equals(billstatus)) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        }
        showParameter.setFormId(formId);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("index", (Object)index);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionid);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("apitudeentryentity");
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        Map returnMap = (Map)closedCallBackEvent.getReturnData();
        if (returnMap != null && "tctb_apitude_dialog".equals(closedCallBackEvent.getActionId())) {
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            for (Map.Entry entry : returnMap.entrySet()) {
                dynamicObject.set((String)entry.getKey(), entry.getValue());
            }
            entryEntity.add((Object)dynamicObject);
            this.sortEntry(entryEntity);
            this.setChildVisible();
            this.setApitudeImg();
        } else {
            String entry = null;
            if (CATEGORY_EDIT.equals(closedCallBackEvent.getActionId())) {
                entry = "categoryentryentity";
            } else if (APITUDE_EDIT.equals(closedCallBackEvent.getActionId())) {
                entry = "apitudeentryentity";
            }
            if (entry != null) {
                int index = this.getModel().getEntryCurrentRowIndex(entry);
                ArrayList<Integer> newList = new ArrayList<Integer>();
                newList.add(-1);
                ArrayList<Integer> oldList = new ArrayList<Integer>();
                oldList.add(index);
                CardEntry incomecardList = (CardEntry)this.getView().getControl(entry);
                incomecardList.selectRowsChanged(newList, oldList);
                incomecardList.selectCard(Integer.valueOf(-1));
            }
            this.setBackground();
            this.setChildVisible();
        }
    }

    private void sortEntry(DynamicObjectCollection entryEntity) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.addAll((Collection)entryEntity);
        collection.sort((o1, o2) -> {
            DynamicObject companyTypeDyo1 = o1.getDynamicObject("companytype");
            DynamicObject companyTypeDyo2 = o2.getDynamicObject("companytype");
            if (null == companyTypeDyo1 || null == companyTypeDyo2) {
                return 0;
            }
            String companyType1 = o1.getDynamicObject("companytype").getString("number");
            String companyType2 = o2.getDynamicObject("companytype").getString("number");
            boolean yxsy1 = o1.getBoolean("yxsy");
            boolean yxsy2 = o2.getBoolean("yxsy");
            if ("FTA001".equals(companyType1) && !"FTA001".equals(companyType2) || yxsy1 && !yxsy2 && !"FTA001".equals(companyType1) && !"FTA001".equals(companyType2)) {
                return -1;
            }
            return 0;
        });
        this.getModel().deleteEntryData("apitudeentryentity");
        if (collection.size() > 0) {
            int[] rows = this.getModel().batchCreateNewEntryRow("apitudeentryentity", collection.size());
            for (int i = 0; i < rows.length; ++i) {
                DynamicObject object = (DynamicObject)collection.get(i);
                for (String key : this.apitudeFields) {
                    this.getModel().setValue(key, object.get(key), i);
                }
            }
        }
    }

    public OperationResult doOperate(String operateKey) {
        String errorMsg;
        DynamicObject main;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        Long orgid = org.getLong("id");
        String errors = this.validateOperate(operateKey, orgid, dataEntity.getLong("taxationsys.id"));
        OperationResult operationResult = new OperationResult();
        if (StringUtils.isNotBlank((CharSequence)errors)) {
            operationResult.setSuccess(false);
            operationResult.setMessage(errors);
            return operationResult;
        }
        boolean flag = false;
        String billStatus = "A";
        if (dataEntity.getLong("id") != 0L && Objects.nonNull(main = TaxInfoHomeBusiness.queryTaxMainInfoById((Long)dataEntity.getLong("id"), (String)"billstatus"))) {
            flag = true;
            billStatus = main.getString("billstatus");
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.setIsEntityDefaultValue();
        }
        OperateOption option = OperateOption.create();
        if (flag && StringUtils.isNotBlank((CharSequence)(errorMsg = TaxInfoUtil.validateBillstatus((String)operateKey, (String)billStatus)))) {
            operationResult.setSuccess(false);
            operationResult.setMessage(errorMsg);
            return operationResult;
        }
        option.setVariableValue("taxtypechange", this.getPageCache().get("taxtypechange"));
        option.setVariableValue("isStrict", "false");
        operationResult = OperationServiceHelper.executeOperate((String)operateKey, (String)"tctb_tax_main", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)option);
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && !operationResult.isSuccess() && !flag) {
            this.getModel().setValue("isinitial", (Object)Boolean.FALSE);
        } else if (("save".equals(operateKey) || "submit".equals(operateKey)) && operationResult.isSuccess()) {
            this.updateTaxOrgTaxpayerdetail(dataEntity, orgid, "1");
            this.getPageCache().remove("zzs,period," + operationResult.getSuccessPkIds().get(0).toString());
        } else if ("audit".equals(operateKey) && operationResult.isSuccess()) {
            this.getPageCache().remove("taxtypechange");
        } else if ("delete".equals(operateKey) && operationResult.isSuccess()) {
            this.updateTaxOrgTaxpayerdetail(dataEntity, orgid, NO_TAXPAYER_DETAIL);
        }
        if (operationResult.isSuccess()) {
            this.getView().updateView("company_info");
        }
        return operationResult;
    }

    private void updateTaxOrgTaxpayerdetail(DynamicObject dataEntity, Long orgid, String newValue) {
        DynamicObject[] load;
        long ationId = dataEntity.getLong("taxationsys.id");
        for (DynamicObject dyo : load = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)BASTAX_TAXORG_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgid), new QFilter("entryentity.entry_taxationsys", "=", (Object)ationId)})) {
            if (ationId == TAX_CHINA) {
                dyo.set("taxpayerdetail", (Object)newValue);
            }
            DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
            entryentity.forEach(entry -> {
                if (ationId == entry.getLong("entry_taxationsys.id")) {
                    entry.set("entry_taxpayerdetail", (Object)newValue);
                }
            });
        }
        SaveServiceHelper.update((DynamicObject[])load);
    }

    private String validateOperate(String operateKey, Long orgid, Long taxAtionid) {
        boolean isPass;
        String errorMsg = NO_TAXPAYER_DETAIL;
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
        if (null == taxorg) {
            errorMsg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u672a\u751f\u6210\uff0c\u8bf7\u5148\u540c\u6b65\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"TaxInfoMain_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            return errorMsg;
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            Long taxationsys = Objects.isNull(this.getModel().getValue("taxationsys")) ? null : Long.valueOf(this.getModel().getDataEntity(true).getLong("taxationsys.id"));
            Long id = this.getModel().getDataEntity(true).getLong("id");
            DynamicObject[] dbMainInfos = TaxPayerTypeUtil.getTaxMainInfoByOrgid(orgid);
            if (EmptyCheckUtils.isNotEmpty((Object)dbMainInfos)) {
                for (DynamicObject mainInfo : dbMainInfos) {
                    Long pkid = mainInfo.getLong("id");
                    if (!Objects.equals(taxationsys, mainInfo.getLong("taxationsys.id")) || Objects.equals(pkid, id)) continue;
                    errorMsg = ResManager.loadKDString((String)"\u4e00\u4e2a\u7a0e\u6536\u5236\u5ea6\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxInfoMain_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                    return errorMsg;
                }
            }
        }
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && EmptyCheckUtils.isNotEmpty((Object)(errorMsg = (Boolean)this.getModel().getValue("istaxpayer") != false ? TaxcMainService.checkTaxPayerMustInput((DynamicObject)this.getModel().getDataEntity(true)) : this.checkFieldsNoTaxPayer(this.getModel().getDataEntity(true))))) {
            return errorMsg;
        }
        if ("delete".equals(operateKey) && taxAtionid == 1L) {
            ArrayList<Long> orgIds = new ArrayList<Long>(8);
            orgIds.add(orgid);
            QuoteOrgEntityEnum quoteOrgEntityEnum = TaxorgQuoteValidator.validatorTaxOrgQuote(orgIds);
            if (null != quoteOrgEntityEnum) {
                return quoteOrgEntityEnum.getMessage();
            }
        }
        if (!(isPass = this.validateHwsEntry())) {
            errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5dde\u516c\u53f8\u6240\u5f97\u7a0e\u542f\u7528\u60c5\u51b5\u4e0b\uff0c\u8054\u90a6\u516c\u53f8\u6240\u5f97\u7a0e\u4e0d\u53ef\u7981\u7528\u3002", (String)"TaxInfoMain_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    private String checkFieldsNoTaxPayer(DynamicObject info) {
        StringBuilder errors = new StringBuilder();
        String start = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a", (String)"TaxInfoMain_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        for (Map.Entry<String, String> entry : noTaxPayerFields.entrySet()) {
            if (!ObjectUtils.isEmpty((Object)info.get(entry.getKey()))) continue;
            if (!errors.toString().contains(start)) {
                errors.append(start);
            }
            errors.append(entry.getValue()).append('\uff0c');
        }
        if (StringUtils.isBlank((CharSequence)errors.toString())) {
            return null;
        }
        errors.deleteCharAt(errors.length() - 1);
        errors.append("\u3002");
        return errors.toString();
    }

    private void setIsEntityDefaultValue() {
        if (!((Boolean)this.getModel().getValue("isinitial")).booleanValue()) {
            this.getModel().setValue("isinitial", (Object)Boolean.TRUE);
        }
    }

    private boolean validateHwsEntry() {
        List keys;
        DynamicObject obj;
        DynamicObjectCollection hwsEntry;
        long taxationsysId;
        DynamicObject taxationsysObj = this.getModel().getDataEntity().getDynamicObject("taxationsys");
        boolean isPass = true;
        if (taxationsysObj != null && (taxationsysId = this.getModel().getDataEntity().getDynamicObject("taxationsys").getLong("id")) != 1L && !CollectionUtils.isEmpty((Collection)(hwsEntry = (obj = this.getModel().getDataEntity(true)).getDynamicObjectCollection("hwsentryentity"))) && !CollectionUtils.isEmpty(keys = hwsEntry.stream().filter(f -> f.getDynamicObject("hwstaxtype") != null && f.getDynamicObject("hwstaxarea") != null).map(o -> o.getDynamicObject("hwstaxtype").getString("number") + "-" + o.getDynamicObject("hwstaxarea").getString("number") + "-" + o.getString("hwsenable")).collect(Collectors.toList())) && keys.contains(USA_CIT)) {
            for (DynamicObject entryObj : hwsEntry) {
                String taxAreaNumber;
                String taxTypeNumber = entryObj.getDynamicObject("hwstaxtype").getString("number");
                if (!"USA-CIT".equals(taxTypeNumber) || "Fed".equals(taxAreaNumber = entryObj.getDynamicObject("hwstaxarea").getString("number")) || !entryObj.getBoolean("hwsenable")) continue;
                isPass = false;
                break;
            }
        }
        return isPass;
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = "0";
        if (Objects.isNull(customParams.get(LIST_FLAG))) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
            orgid = Objects.isNull(org) ? (customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0") : String.valueOf(org.get("id"));
        } else if (((Boolean)customParams.get(LIST_FLAG)).booleanValue()) {
            orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
        }
        Boolean isEntity = (Boolean)customParams.get(IS_ENTITY);
        DynamicObject[] taxorgs = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)BASTAX_TAXORG_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orgid))});
        long ationId = this.getModel().getDataEntity(true).getLong("taxationsys.id");
        String taxpayer2 = NO_TAXPAYER_DETAIL;
        if (taxorgs != null && taxorgs.length > 0) {
            DynamicObject taxorg = taxorgs[0];
            this.getModel().setValue("taxorg", (Object)taxorg);
            isEntity = taxorg.getBoolean("istaxpayer");
            StringBuilder builder = new StringBuilder();
            if (ationId != 0L) {
                if (ationId == TAX_CHINA) {
                    taxpayer2 = taxorg.getString("taxpayer");
                    this.getModel().setValue("unifiedsocialcode2", taxorg.get("unifiedsocialcode"));
                } else {
                    DynamicObjectCollection entryentity = taxorg.getDynamicObjectCollection("entryentity");
                    Boolean istaxpayer = Boolean.FALSE;
                    for (DynamicObject entry : entryentity) {
                        if (ationId != entry.getLong("entry_taxationsys.id")) continue;
                        builder.append(entry.getString("entry_unifiedsocialcode")).append(",");
                        if (entry.getBoolean("entry_istaxpayer")) {
                            istaxpayer = Boolean.TRUE;
                        }
                        taxpayer2 = StringUtils.isNotBlank((CharSequence)taxpayer2) ? taxpayer2 : entry.getString("entry_taxpayer");
                    }
                    isEntity = istaxpayer;
                    if (builder.toString().endsWith(",")) {
                        this.getModel().setValue("unifiedsocialcode2", (Object)builder.toString().substring(0, builder.length() - 1));
                    }
                }
            } else {
                this.getModel().setValue("unifiedsocialcode2", taxorg.get("unifiedsocialcode"));
            }
            this.getModel().setValue("taxpayer2", (Object)taxpayer2);
            this.getModel().setValue("istaxpayer", (Object)isEntity);
            this.getView().updateView("unifiedsocialcode2");
            this.getView().updateView("taxpayer2");
        }
        this.getModel().setValue("orgid", (Object)orgid);
        Long pkid = Objects.isNull(this.getModel().getValue("id")) ? null : (Long)this.getModel().getValue("id");
        this.init(pkid, orgid, isEntity);
        int bankRowCount = this.getModel().getEntryRowCount("entryentity");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("tripleaggrement");
        if (bankRowCount > 0) {
            for (int i = 0; i < bankRowCount; ++i) {
                if (((Boolean)this.getModel().getValue("taxacct", i)).booleanValue()) {
                    this.setMustInput(Boolean.TRUE, fields);
                    continue;
                }
                this.setMustInput(Boolean.FALSE, fields);
            }
        } else {
            this.setMustInput(Boolean.FALSE, fields);
        }
        this.setApitudeImg();
        this.getModel().setDataChanged(false);
    }

    private void setApitudeImg() {
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        int index = 0;
        for (DynamicObject object : dynamicObject.getDynamicObjectCollection("apitudeentryentity")) {
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>();
            propertiesMap.put("src", ICONS.get(object.getString("apitudetype")));
            pmap.put("imageap1", propertiesMap);
            client.invokeControlMethod("apitudeentryentity", "setCustomProperties", new Object[]{index++, pmap});
        }
    }

    private void init(Long pkid, String orgid, Boolean isEntity) {
        Long orgId = Long.parseLong(orgid);
        DynamicObject[] dobj = null;
        if (EmptyCheckUtils.isNotEmpty((Object)pkid) && pkid != 0L) {
            dobj = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,taxationsys", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        } else {
            long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
            dobj = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,taxationsys", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)orgId), new QFilter("taxationsys", "=", (Object)taxationsysId)}, (String)"taxationsys.id asc");
        }
        IDataModel model = this.getModel();
        Map map = TaxInfoUtil.getInfoByOrgIdFromErp((String)orgid, (String[])new String[]{"id", "number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank", "taxpayertype"});
        if (EmptyCheckUtils.isEmpty((Object)dobj)) {
            model.setValue("orgid", map.get("id"));
            model.setValue("orgnumber", map.get("number"));
            model.setValue("orgname", map.get("name"));
            model.setValue("number", map.get("number"));
            model.setValue("maincompany", map.get("name"));
            model.setValue("registeredcapital", map.get("registeredcapital"));
            model.setValue("billno", map.get("number"));
            if (map.get("establishmentdate") != null && !NO_TAXPAYER_DETAIL.equals(map.get("establishmentdate"))) {
                model.setValue("registertime", (Object)DateUtils.stringToDate((String)((String)map.get("establishmentdate"))));
            }
            model.setValue("legalpeople", map.get("frepresentative"));
            model.setValue("others", (Object)Boolean.TRUE);
            this.loadCardEntry(model);
            this.setBackground();
            String taxPayerType = (String)map.get("taxpayertype");
            DynamicObjectCollection collection = this.getModel().getEntryEntity("categoryentryentity");
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject object = (DynamicObject)collection.get(i);
                if (!"zzs".equals(object.getString(TAXTYPE))) continue;
                if (StringUtils.isNotBlank((CharSequence)taxPayerType) && Objects.equals("1", taxPayerType)) {
                    this.getModel().setValue("taxpayertype", (Object)"ybnsr", i);
                    this.getModel().setValue("deadline", (Object)"aysb", i);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)taxPayerType) || !Objects.equals("2", taxPayerType)) continue;
                this.getModel().setValue("taxpayertype", (Object)"xgmnsr", i);
                this.getModel().setValue("deadline", (Object)"ajsb", i);
            }
        } else {
            long taxationsys = dobj[0].getLong("taxationsys.id");
            if (taxationsys == 1L || taxationsys == 0L) {
                this.loadCardEntry(model);
                this.setBackground();
                this.setChildVisible();
            }
            model.setValue("orgname", map.get("name"));
            model.setValue("orgnumber", map.get("number"));
            model.setValue("billno", map.get("number"));
            if (taxationsys != 1L) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TAX_VER});
            }
        }
        if (null != isEntity) {
            this.getModel().setValue("istaxpayer", (Object)isEntity);
        }
        this.dealHwsRelationFields(this.getModel().getDataEntity().getLong("taxationsys.id"));
    }

    private void dealHwsRelationFields(Long taxationsysId) {
        Map hwsEntityFields = new TaxcMainConstant().getHwsEntityFields();
        if (((Boolean)this.getModel().getValue("istaxpayer")).booleanValue()) {
            this.setMustInput(Boolean.TRUE, TaxcMainConstant.allEntityRelateFields);
            if (EmptyCheckUtils.isNotEmpty((Object)taxationsysId) && taxationsysId != 1L) {
                FieldEdit taxoffice = (FieldEdit)this.getControl("taxoffice");
                taxoffice.setMustInput(false);
                ArrayList<String> hwsEntityRelateFields = new ArrayList<String>(hwsEntityFields.size());
                hwsEntityRelateFields.addAll(hwsEntityFields.keySet());
                this.setMustInput(Boolean.TRUE, hwsEntityRelateFields);
            }
        } else {
            this.setmustInputFalse();
            ArrayList<String> hwsEntityRelateFields = new ArrayList<String>(hwsEntityFields.size());
            hwsEntityRelateFields.addAll(hwsEntityFields.keySet());
            this.setMustInput(Boolean.FALSE, hwsEntityRelateFields);
        }
    }

    private void setmustInputFalse() {
        ArrayList<String> noMustInputList = new ArrayList<String>(TaxcMainConstant.allEntityRelateFields.size());
        for (String field : TaxcMainConstant.allEntityRelateFields) {
            if (Objects.equals("taxationsys", field)) continue;
            noMustInputList.add(field);
        }
        this.setMustInput(Boolean.FALSE, noMustInputList);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit labelMulBaseEdit = (MulBasedataEdit)this.getView().getControl("orgattr");
        BasedataEdit taxationsysEdit = (BasedataEdit)this.getView().getControl("taxationsys");
        BasedataEdit registertypeEdit = (BasedataEdit)this.getView().getControl("registertype");
        BasedataEdit hwstaxtypeEdit = (BasedataEdit)this.getView().getControl("hwstaxtype");
        BasedataEdit hwstaxarea = (BasedataEdit)this.getView().getControl("hwstaxarea");
        BasedataEdit standardsEdit = (BasedataEdit)this.getView().getControl("accountingstandards");
        if (null != labelMulBaseEdit) {
            labelMulBaseEdit.addBeforeF7SelectListener(this::beforeF7SelectListener);
            taxationsysEdit.addBeforeF7SelectListener(this::beforeF7SelectListener);
            registertypeEdit.addBeforeF7SelectListener(this::beforeF7SelectListener);
            hwstaxtypeEdit.addBeforeF7SelectListener(this::beforeF7SelectListener);
            standardsEdit.addBeforeF7SelectListener(this::beforeF7SelectListener);
            hwstaxarea.addBeforeF7SelectListener(this::beforeF7SelectListener);
        }
    }

    private void beforeF7SelectListener(BeforeF7SelectEvent event) {
        if (Objects.equals("orgattr", event.getProperty().getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7\u6807\u7b7e", (String)"TaxInfoMain_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("longnumber", "like", (Object)"org-attribute001%"));
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
        } else if (Objects.equals("taxationsys", event.getProperty().getName())) {
            boolean isopenFlag = TaxInfoUtil.validateHwsIsopen();
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            if (isopenFlag) {
                long orgid = this.getModel().getDataEntity(true).getLong("orgid.id");
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"id,org,taxpayer,istaxpayer,unifiedsocialcode,cmborgtype,status,isvirtual,taxpayerdetail,licensestatus,org_id,cmborgtype_id,entryentity,entryentity.entry_taxpayerdetail,entryentity.entry_taxationsys", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgid)});
                if (EmptyCheckUtils.isNotEmpty((Object)load)) {
                    DynamicObjectCollection entryentity = load[0].getDynamicObjectCollection("entryentity");
                    List idList = entryentity.stream().map(entry -> entry.getLong("entry_taxationsys.id")).collect(Collectors.toList());
                    ArrayList<QFilter> list = new ArrayList<QFilter>();
                    list.add(new QFilter("id", "in", idList));
                    formShowParameter.setListFilterParameter(new ListFilterParameter(list, (String)null));
                }
            } else {
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                list.add(new QFilter("id", "=", (Object)1L));
                formShowParameter.setListFilterParameter(new ListFilterParameter(list, (String)null));
            }
        } else if (Objects.equals("registertype", event.getProperty().getName())) {
            if (this.chooseTaxationsys()) {
                event.setCancel(true);
            }
            DynamicObject[] registerTypes = BusinessDataServiceHelper.load((String)"tax_info_registertype", (String)"id,number,name,enable,taxationsys", (QFilter[])new QFilter[]{new QFilter("taxationsys.id", "=", (Object)this.getModel().getDataEntity(true).getLong("taxationsys.id"))});
            List<Long> idList = Arrays.stream(registerTypes).map(type -> type.getLong("id")).collect(Collectors.toList());
            this.setFromFilter(event, idList);
        } else if (Objects.equals("hwstaxtype", event.getProperty().getName())) {
            QFilter qfilter = new QFilter("taxationsysid.id", "=", (Object)this.getModel().getDataEntity(true).getLong("taxationsys.id"));
            QFilter dateQFilter = new QFilter("expdate", "is null", null).and(new QFilter("activedate", "<=", (Object)new Date()));
            QFilter dateQFilter1 = new QFilter("expdate", "is not null", null).and(new QFilter("activedate", "<=", (Object)new Date())).and(new QFilter("expdate", ">=", (Object)new Date()));
            qfilter.and(dateQFilter.or(dateQFilter1));
            DynamicObject[] taxTypeList = BusinessDataServiceHelper.load((String)"bd_taxcategory", (String)"id,number,name,taxationsysid", (QFilter[])new QFilter[]{qfilter});
            List<Long> idList = Arrays.stream(taxTypeList).map(type -> type.getLong("id")).collect(Collectors.toList());
            this.setFromFilter(event, idList);
        } else if (Objects.equals("accountingstandards", event.getProperty().getName())) {
            if (this.chooseTaxationsys()) {
                event.setCancel(true);
            }
            DynamicObject[] bizdefList = BusinessDataServiceHelper.load((String)"tpo_tccit_bizdef", (String)"id,number,name,entry_detail.taxationsys", (QFilter[])new QFilter[]{new QFilter("entry_detail.taxationsys.id", "=", (Object)this.getModel().getDataEntity(true).getLong("taxationsys.id"))});
            List bizidList = Arrays.stream(bizdefList).map(type -> type.getLong("id")).collect(Collectors.toList());
            DynamicObject[] kjzzList = BusinessDataServiceHelper.load((String)"tpo_tccit_bizdef_kjzz", (String)"id,number,bizdef", (QFilter[])new QFilter[]{new QFilter("bizdef.id", "in", bizidList)});
            List<Long> idList = Arrays.stream(kjzzList).map(type -> type.getLong("id")).collect(Collectors.toList());
            this.setFromFilter(event, idList);
        } else if (Objects.equals("hwstaxarea", event.getProperty().getName())) {
            DynamicObject hwstaxtype = (DynamicObject)this.getModel().getValue("hwstaxtype");
            if (hwstaxtype == null) {
                event.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u79cd\u3002", (String)"TaxInfoMain_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObjectCollection taxareas;
                List areaGroupIds = null;
                if (hwstaxtype != null && (taxareas = hwstaxtype.getDynamicObjectCollection("taxarea")) != null && taxareas.size() > 0) {
                    areaGroupIds = taxareas.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty(areaGroupIds)) {
                    this.setFromFilter(event, areaGroupIds);
                } else {
                    this.setFromFilter(event, Collections.singletonList(-1L));
                }
            }
        }
    }

    private boolean chooseTaxationsys() {
        Object taxationsys = this.getModel().getDataEntity(true).get("taxationsys");
        if (Objects.isNull(taxationsys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxInfoMain_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setFromFilter(BeforeF7SelectEvent event, List<Long> idList) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("id", "in", idList));
        formShowParameter.setListFilterParameter(new ListFilterParameter(list, (String)null));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("categoryentryentity");
        if (entryEntity.size() > 0) {
            entryEntity = this.sortCardEntry(entryEntity);
            int size = entryEntity.size();
            for (int i = 0; i < size; ++i) {
                ((DynamicObject)entryEntity.get(i)).set("seq", (Object)(i + 1));
            }
            model.getEntryEntity("categoryentryentity").clear();
            model.getEntryEntity("categoryentryentity").addAll((Collection)entryEntity);
        }
    }

    private void setEntityEnable() {
        IFormView view = this.getView();
        view.getModel().setValue("status", (Object)"3");
        view.setEnable(Boolean.FALSE, new String[]{"number", "maincompany", "taxpayer", "unifiedsocialcode", "registertype", "registeredcapital", "registertime", "codeandname", "registeraddress", "registeraddrdetail", "actualaddress", "actualaddrdetail", "legalpeople", "contactinformation", "legalpeople_title", "retiredsoldiers", "keygroup", "armyrelatives", "militarycadres", "others", "radiogroupfield", "radiofield", "radiofield1", "radiofield2", "radiofield3", "radiofield4"});
        view.setVisible(Boolean.FALSE, new String[]{"vectorap1", "newcreate", "button_add1", "button_del1", "button_add11", "button_del11", "button_add", "button_del", "advconbaritemap", "advconbaritemap1"});
    }

    private void loadCardEntry(IDataModel model) {
        DynamicObjectCollection entryEntity = model.getEntryEntity("categoryentryentity");
        Map<String, DynamicObject> uniqueMap = entryEntity.parallelStream().collect(Collectors.groupingBy(v -> v.getString(TAXTYPE), Collectors.collectingAndThen(Collectors.reducing((a, b) -> a.getInt("seq") > b.getInt("seq") ? a : b), Optional::get)));
        if (entryEntity.size() > uniqueMap.size()) {
            DynamicObjectCollection newEntryEntity = new DynamicObjectCollection();
            uniqueMap.forEach((k, v) -> newEntryEntity.add(v));
            entryEntity = newEntryEntity;
            model.getEntryEntity("categoryentryentity").clear();
            model.getEntryEntity("categoryentryentity").addAll((Collection)newEntryEntity);
            this.getView().updateView("categoryentryentity");
        }
        boolean createNewEntry = false;
        for (Map<String, String> categoryMap : CATEGORY_LIST) {
            String taxtype = categoryMap.get(TAXTYPE);
            boolean exist = false;
            for (DynamicObject object : entryEntity) {
                if (!taxtype.equals(object.get(TAXTYPE))) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            createNewEntry = true;
            int index = model.createNewEntryRow("categoryentryentity");
            for (Map.Entry<String, String> entry : categoryMap.entrySet()) {
                model.setValue(entry.getKey(), (Object)entry.getValue(), index);
            }
        }
        DynamicObjectCollection entries = model.getEntryEntity("categoryentryentity");
        if (EmptyCheckUtils.isNotEmpty((Object)entries) && (createNewEntry || !Objects.equals(((DynamicObject)entries.get(0)).get(TAXTYPE), "zzs"))) {
            entries = this.sortCardEntry(entries);
            model.getEntryEntity("categoryentryentity").clear();
            model.getEntryEntity("categoryentryentity").addAll((Collection)entries);
            this.getView().updateView("categoryentryentity");
        }
    }

    private DynamicObjectCollection sortCardEntry(DynamicObjectCollection entryEntity) {
        List taxtypeList = CATEGORY_LIST.stream().map(x -> (String)x.get(TAXTYPE)).collect(Collectors.toList());
        entryEntity = entryEntity.stream().sorted((o1, o2) -> {
            if (taxtypeList.contains(o1.getString(TAXTYPE)) && taxtypeList.contains(o2.getString(TAXTYPE))) {
                if (taxtypeList.indexOf(o1.getString(TAXTYPE)) > taxtypeList.indexOf(o2.getString(TAXTYPE))) {
                    return 1;
                }
                if (taxtypeList.indexOf(o1.getString(TAXTYPE)) == taxtypeList.indexOf(o2.getString(TAXTYPE))) {
                    return 0;
                }
                if (taxtypeList.indexOf(o1.getString(TAXTYPE)) < taxtypeList.indexOf(o2.getString(TAXTYPE))) {
                    return -1;
                }
            } else {
                if (taxtypeList.contains(o1.getString(TAXTYPE)) && !taxtypeList.contains(o2.getString(TAXTYPE))) {
                    return -1;
                }
                if (!taxtypeList.contains(o1.getString(TAXTYPE)) && taxtypeList.contains(o2.getString(TAXTYPE))) {
                    return 1;
                }
            }
            return 0;
        }).collect(Collectors.toCollection(DynamicObjectCollection::new));
        return entryEntity;
    }

    private void setBackground() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("categoryentryentity");
        int index = 0;
        for (DynamicObject object : entryEntity) {
            HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
            HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
            propertiesMap.put("bgik", IMAGE_MAP.get(object.getString(TAXTYPE)));
            pmap.put("categorybody", propertiesMap);
            ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
            client.invokeControlMethod("categoryentryentity", "setCustomProperties", new Object[]{index++, pmap});
        }
    }

    private void setChildVisible() {
        DynamicObjectCollection aptitudeCollection = this.getModel().getEntryEntity("apitudeentryentity");
        int aptitudeIndex = 0;
        CardEntry aptitudeEntry = (CardEntry)this.getControl("apitudeentryentity");
        for (DynamicObject object : aptitudeCollection) {
            boolean yxsy = object.getBoolean("yxsy");
            aptitudeEntry.setChildVisible(yxsy, aptitudeIndex, new String[]{"prioritytion"});
            ++aptitudeIndex;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataEntityProperty property = e.getProperty();
        if (EmptyCheckUtils.isNotEmpty((Object)property) && EmptyCheckUtils.isNotEmpty((Object)(changeSet = e.getChangeSet()))) {
            if (StringUtils.equals((CharSequence)"registeraddress", (CharSequence)property.getName())) {
                this.getModel().setValue("baseregisteraddress", changeSet[0].getNewValue());
            } else if ("istaxpayer".equals(property.getName())) {
                if (((Boolean)this.getModel().getValue("istaxpayer")).booleanValue()) {
                    this.setMustInput(Boolean.TRUE, TaxcMainConstant.allEntityRelateFields);
                } else {
                    this.setmustInputFalse();
                }
            } else if ("investrate".equals(property.getName())) {
                DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity1");
                BigDecimal investrateSum = entryentity1.stream().map(s -> s.getBigDecimal("investrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (investrateSum.compareTo(new BigDecimal("100")) > 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6295\u8d44\u6bd4\u4f8b\u5408\u8ba1\u4e0d\u5f97\u5927\u4e8e100%\u3002", (String)"TaxInfoMain_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    this.rollbackPropertyChange(e);
                    return;
                }
            } else if ("taxacct".equals(property.getName()) && ((Boolean)changeSet[0].getNewValue()).booleanValue()) {
                int rowIndex = changeSet[0].getRowIndex();
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryentity.size(); ++i) {
                    if (i == rowIndex) {
                        this.getModel().setValue("taxacct", (Object)Boolean.TRUE, i);
                        continue;
                    }
                    this.getModel().setValue("taxacct", (Object)Boolean.FALSE, i);
                }
            } else if ("taxationsys".equals(property.getName())) {
                FieldEdit control;
                DynamicObject[] load;
                DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
                if (Objects.isNull(newValue)) {
                    return;
                }
                this.getModel().deleteEntryData("hwsentryentity");
                long taxAtionid = newValue.getLong("id");
                long orgid = this.getModel().getDataEntity(true).getLong("orgid.id");
                boolean entryIstaxpayer = false;
                for (DynamicObject dyo : load = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)BASTAX_TAXORG_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgid), new QFilter("entryentity.entry_taxationsys", "=", (Object)taxAtionid), new QFilter("entryentity.entry_status", "=", (Object)"1")})) {
                    DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entryentity) {
                        if (taxAtionid != entry.getLong("entry_taxationsys.id")) continue;
                        this.getModel().setValue("unifiedsocialcode2", (Object)entry.getString("entry_unifiedsocialcode"));
                        if (entryIstaxpayer) continue;
                        entryIstaxpayer = entry.getBoolean("entry_istaxpayer");
                    }
                }
                this.getModel().setValue("istaxpayer", (Object)entryIstaxpayer);
                if (taxAtionid == OrgConstant.TAX_CHINA) {
                    this.loadCardEntry(this.getModel());
                    this.setBackground();
                    this.setChildVisible();
                    if (((Boolean)this.getModel().getValue("istaxpayer")).booleanValue()) {
                        control = (FieldEdit)this.getControl("taxoffice");
                        control.setMustInput(true);
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{"taxoffice"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"cardentryviewap1,categoryentryentity,cardentryrowap1,apitudeflex,advconap2"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap4,hwsentryentity,advconchildpanelap3"});
                } else {
                    control = (FieldEdit)this.getControl("taxoffice");
                    control.setMustInput(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"taxoffice"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap4,hwsentryentity,advconchildpanelap3"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"cardentryviewap1,categoryentryentity,cardentryrowap1,apitudeflex,advconap2"});
                    this.dealHwsRelationFields(taxAtionid);
                }
                this.setMustAndVisibleByTaxaTionSys(taxAtionid);
                this.getModel().setValue("registertype", null);
                this.getModel().setValue("accountingstandards", null);
            } else if ("accountingstandards".equals(property.getName()) && Objects.isNull(this.getModel().getValue("taxationsys"))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxInfoMain_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("accountingstandards", null);
                this.getView().updateView("accountingstandards");
                this.rollbackPropertyChange(e);
            } else if ("hwstaxtype".equals(property.getName())) {
                int rowIndex = changeSet[0].getRowIndex();
                DynamicObject hwstaxtype = (DynamicObject)this.getModel().getValue("hwstaxtype", rowIndex);
                if (hwstaxtype == null) {
                    this.getModel().setValue("hwstaxarea", null, rowIndex);
                } else {
                    DynamicObjectCollection taxareas = hwstaxtype.getDynamicObjectCollection("taxarea");
                    if (taxareas != null && taxareas.size() > 0) {
                        this.getModel().setValue("hwstaxarea", (Object)((DynamicObject)taxareas.get(0)).getLong("fbasedataid.id"), rowIndex);
                    }
                }
            }
        }
    }

    private void setMustAndVisibleByTaxaTionSys(long taxAtionid) {
        boolean istaxpayer = (Boolean)this.getModel().getValue("istaxpayer");
        if (istaxpayer) {
            if (taxAtionid == OrgConstant.TAX_CHINA) {
                FieldEdit control1 = (FieldEdit)this.getControl("accountingstandards");
                FieldEdit control2 = (FieldEdit)this.getControl("registertype");
                FieldEdit control3 = (FieldEdit)this.getControl("codeandname");
                control1.setMustInput(true);
                control2.setMustInput(true);
                control3.setMustInput(true);
                control1.setVisible("accountingstandards", true);
                control2.setVisible("registertype", true);
                control3.setVisible("codeandname", true);
            } else {
                FieldEdit control1 = (FieldEdit)this.getControl("accountingstandards");
                FieldEdit control2 = (FieldEdit)this.getControl("registertype");
                FieldEdit control3 = (FieldEdit)this.getControl("codeandname");
                control1.setMustInput(false);
                control2.setMustInput(false);
                control3.setMustInput(false);
                control1.setVisible("accountingstandards", false);
                control2.setVisible("registertype", false);
                control3.setVisible("codeandname", false);
            }
        } else {
            FieldEdit control1 = (FieldEdit)this.getControl("accountingstandards");
            FieldEdit control2 = (FieldEdit)this.getControl("registertype");
            FieldEdit control3 = (FieldEdit)this.getControl("codeandname");
            control1.setMustInput(false);
            control2.setMustInput(false);
            control3.setMustInput(false);
            control1.setVisible("accountingstandards", false);
            control2.setVisible("registertype", false);
            control3.setVisible("codeandname", false);
        }
    }

    private void setMustInput(Boolean mustInput, List<String> fields) {
        for (String field : fields) {
            FieldEdit control = (FieldEdit)this.getControl(field);
            if (null == control) continue;
            control.setMustInput(mustInput.booleanValue());
        }
    }

    protected void initUIContext() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taxAtionsys = (String)formShowParameter.getCustomParam("taxAtionsys");
        if (formShowParameter.getStatus() == OperationStatus.ADDNEW && StringUtil.isNotEmpty((CharSequence)taxAtionsys)) {
            this.getModel().setValue("taxationsys", (Object)Long.valueOf(taxAtionsys));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initUIContext();
        int bankRowCount = this.getModel().getEntryRowCount("entryentity");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("tripleaggrement");
        if (bankRowCount > 0) {
            int count = 0;
            for (int i = 0; i < bankRowCount; ++i) {
                Boolean taxacctFlag = (Boolean)this.getModel().getValue("taxacct", i);
                if (taxacctFlag.booleanValue()) {
                    ++count;
                    this.setMustInput(Boolean.TRUE, fields);
                } else {
                    this.setMustInput(Boolean.FALSE, fields);
                }
                if (count <= 1) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u4e2a\u7eb3\u7a0e\u4e3b\u4f53\u53ea\u80fd\u6709\u4e00\u4e2a\u94f6\u884c\u4fe1\u606f\u7684\u201c\u7f34\u7a0e\u8d26\u6237\u201d\u586b\u5199\u4e3a\u201c\u662f\u201d\u3002", (String)"TaxInfoMain_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.setMustInput(Boolean.FALSE, fields);
        }
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    static {
        noTaxPayerFields.put("taxationsys", ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6", (String)"TaxInfoMain_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        IMAGE_MAP.put("zzs", "url(\"kingdee/taxc/images/pc/cardbackground/card_zzs.png?v=1.0\")");
        IMAGE_MAP.put("qysds", "url(\"kingdee/taxc/images/pc/cardbackground/card_qysds.png?v=1.0\")");
        IMAGE_MAP.put("yhs", "url(\"images/pc/cardbackground/card_yinhuashui.png?v=1.0\")");
        IMAGE_MAP.put("xfs", "url(\"images/pc/cardbackground/swy_xfs_240_132.png?v=1.0\")");
        IMAGE_MAP.put("fjsf", "url(\"kingdee/taxc/images/pc/cardbackground/card_fjs.png?v=1.0\")");
        IMAGE_MAP.put("fcscztdsys", "url(\"images/pc/cardbackground/swy_fcshtds_240_132.png?v=1.0\")");
        IMAGE_MAP.put("hjbhs", "url(\"images/pc/cardbackground/swy_hbs_240_132.png?v=1.0\")");
        IMAGE_MAP.put("szys", "url(\"images/pc/cardbackground/swy_szys_240_132.png?v=1.0\")");
        IMAGE_MAP.put("qtsf", "url(\"images/pc/cardbackground/swy_qtsf_240_132.png?v=1.0\")");
        IMAGE_MAP.put("tdzzs", "url(\"images/pc/cardbackground/swy_tdzzs_240_132.png?v=1.0\")");
        IMAGE_MAP.put("cwbb", "url(\"kingdee/taxc/images/pc/cardbackground/card_cwbb.png?v=1.0\")");
        IMAGE_MAP.put("qhjt", "url(\"kingdee/taxc/images/pc/cardbackground/card_qhjt.png?v=1.0\")");
        IMAGE_MAP.put("zdsy", "url(\"kingdee/taxc/images/pc/cardbackground/card_zdsy.png?v=1.0\")");
        IMAGE_MAP.put("zys", "url(\"kingdee/taxc/images/pc/cardbackground/card_zys.png?v=1.0\")");
        ICONS = new HashMap<String, String>();
        ICONS.put("1", "/icons/pc/other/cwy_kjl_36_36.png");
        ICONS.put("2", "/icons/pc/other/swy_ckl_36_36.png");
        ICONS.put("3", "/icons/pc/other/swy_shbzl_36_36.png");
        ICONS.put("4", "/icons/pc/other/swy_qtl_36_36.png");
        ICONS.put("5", "/icons/pc/other/swy_nsxydj_36_36.png");
        CATEGORY_LIST = new ArrayList<Map<String, String>>(){
            private static final long serialVersionUID = 1L;
            {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(TaxInfoMain.TAXTYPE, "zzs");
                map.put("levytype", "czzs");
                map.put("deadline", "aysb");
                map.put("taxpayertype", "ybnsr");
                map.put("enable", "1");
                map.put("farmdeducttype", "none");
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put(TaxInfoMain.TAXTYPE, "qysds");
                map1.put("levytype", "czzs");
                map1.put("deadline", "ajsb");
                map1.put("residenttype", "jmqy");
                map1.put("enable", "1");
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put(TaxInfoMain.TAXTYPE, "yhs");
                map2.put("levytype", TaxInfoMain.NO_TAXPAYER_DETAIL);
                map2.put("deadline", TaxInfoMain.NO_TAXPAYER_DETAIL);
                map2.put("enable", "1");
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put(TaxInfoMain.TAXTYPE, "fjsf");
                map3.put("addcswhjss", TaxConstant.getCswhjssName());
                map3.put("addjyffj", TaxConstant.getDfjyffjName());
                map3.put("adddfjyffj", TaxConstant.getJyffjName());
                map3.put("cswhjssenable", "1");
                map3.put("orgplace", "cityarea");
                map3.put("jyffjenable", "2");
                map3.put("dfjyffjenable", "3");
                map3.put("enable", "1");
                HashMap<String, String> map4 = new HashMap<String, String>();
                map4.put(TaxInfoMain.TAXTYPE, "fcscztdsys");
                map4.put("fcs", TaxConstant.getFcsName());
                map4.put("cztdsys", TaxConstant.getCztdsysName());
                map4.put("fcsenable", "5");
                map4.put("cztdsysenable", "6");
                map4.put("enable", "0");
                HashMap<String, String> map5 = new HashMap<String, String>();
                map5.put(TaxInfoMain.TAXTYPE, "xfs");
                map5.put("levytype", TaxInfoMain.NO_TAXPAYER_DETAIL);
                map5.put("deadline", "aysb");
                map5.put("enable", "0");
                HashMap<String, String> map6 = new HashMap<String, String>();
                map6.put(TaxInfoMain.TAXTYPE, "hjbhs");
                map6.put("levytype", TaxInfoMain.NO_TAXPAYER_DETAIL);
                map6.put("deadline", TaxInfoMain.NO_TAXPAYER_DETAIL);
                map6.put("enable", "0");
                HashMap<String, String> map7 = new HashMap<String, String>();
                map7.put(TaxInfoMain.TAXTYPE, "szys");
                map7.put("levytype", TaxInfoMain.NO_TAXPAYER_DETAIL);
                map7.put("deadline", "aysb");
                map7.put("enable", "0");
                HashMap<String, String> map8 = new HashMap<String, String>();
                map8.put(TaxInfoMain.TAXTYPE, "qtsf");
                map8.put("levytype", TaxInfoMain.NO_TAXPAYER_DETAIL);
                map8.put("deadline", TaxInfoMain.NO_TAXPAYER_DETAIL);
                map8.put("enable", "0");
                HashMap<String, String> map9 = new HashMap<String, String>();
                map9.put(TaxInfoMain.TAXTYPE, "tdzzs");
                map9.put("enable", "0");
                HashMap<String, String> map10 = new HashMap<String, String>();
                map10.put(TaxInfoMain.TAXTYPE, "cwbb");
                map10.put("declareperiod", "ajsb");
                map10.put("enable", "1");
                HashMap<String, String> map11 = new HashMap<String, String>();
                map11.put(TaxInfoMain.TAXTYPE, "qhjt");
                map11.put("enable", "0");
                HashMap<String, String> map12 = new HashMap<String, String>();
                map12.put(TaxInfoMain.TAXTYPE, "zdsy");
                map12.put("enable", "0");
                HashMap<String, String> map13 = new HashMap<String, String>();
                map13.put(TaxInfoMain.TAXTYPE, "zys");
                map13.put("enable", "0");
                this.add(map);
                this.add(map1);
                this.add(map10);
                this.add(map2);
                this.add(map3);
                this.add(map4);
                this.add(map5);
                this.add(map6);
                this.add(map7);
                this.add(map13);
                this.add(map8);
                this.add(map9);
                this.add(map11);
                this.add(map12);
            }
        };
    }
}

