/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.taxcmain.TaxInfoHomeBusiness;
import kd.taxc.tctb.business.util.TaxInfoUtil;
import kd.taxc.tctb.formplugin.util.TaxPayerTypeUtil;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TaxInfoMainOp
extends AbstractOperationServicePlugIn {
    private static final String BASTAX_TAXORG_FIELD = "id,org,taxpayer,istaxpayer,unifiedsocialcode,cmborgtype,status,isvirtual,taxpayerdetail,licensestatus,org_id,cmborgtype_id,entryentity,entryentity.entry_taxpayerdetail,entryentity.entry_taxationsys,entryentity.entry_unifiedsocialcode,entryentity.entry_status,entryentity.entry_istaxpayer,entryentity.entry_taxpayer";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                List objs = Stream.of(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
                Map cacheData = TaxInfoUtil.batchFetchValidateData(objs);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String importType;
                    DynamicObject org = (DynamicObject)dataEntity.getValue("orgid");
                    if (!QueryServiceHelper.exists((String)"bastax_taxorg", (Object)org.get("id"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u672a\u751f\u6210\uff0c\u8bf7\u5148\u540c\u6b65\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"TaxInfoMainOp_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (this.getOption().containsVariable("importtype") && StringUtil.isNotBlank((CharSequence)(importType = this.getOption().getVariableValue("importtype"))) && org != null) {
                        boolean addNew = "new".equals(importType);
                        Optional permissionResult = TaxInfoHomeBusiness.checkSavePermission((Long)org.getLong("id"), (String)(addNew ? "47156aff000000ac" : "4715a0df000000ac"));
                        if (permissionResult.isPresent()) {
                            this.addFatalErrorMessage(dataEntity, (String)permissionResult.get());
                            continue;
                        }
                    }
                    Long taxAtionId = dataEntity.getDataEntity().getLong("taxationsys.id");
                    DynamicObject[] taxMainInfo = TaxPayerTypeUtil.getTaxMainInfoByOrgidAndTaxAtion(org.getLong("id"), taxAtionId);
                    if (Objects.isNull(taxMainInfo)) {
                        dataEntity.setValue("billstatus", (Object)"A");
                    } else if (!"A".equals(taxMainInfo[0].getString("billstatus"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\uff1a%1$s \u7ec4\u7ec7\u975e\u6682\u5b58\u72b6\u6001\uff0c\u65e0\u6cd5\u66f4\u65b0\u5f15\u5165\u3002", (String)"TaxInfoMainOp_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), org.get("number")));
                        return;
                    }
                    DynamicObject tctbDyo = dataEntity.getDataEntity();
                    DynamicObjectCollection yhsentityList = tctbDyo.getDynamicObjectCollection("yhsentity");
                    for (DynamicObject yhsentity : yhsentityList) {
                        Date expiryDate = yhsentity.getDate("expirydate");
                        ImmutablePair datePeriod = TaxInfoMainOp.this.getDatePeriod(yhsentity.getDynamicObject("taxrate").getLong("id"));
                        Date enddate = datePeriod.right == null ? null : DateUtils.getDayFirst((Date)((Date)datePeriod.right));
                        boolean betweenOfTime = enddate == null || enddate.compareTo(DateUtils.getDayFirst((Date)expiryDate)) >= 0;
                        if (betweenOfTime) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u54c1\u76ee%1$s\u6709\u6548\u671f\u8303\u56f4\u4e0d\u5728\u7a0e\u76ee\u8868\u751f\u6548\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u4fee\u6539\u6709\u6548\u8d77\u6b62\u65f6\u95f4\u3002", (String)"TaxInfoMainOp_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), yhsentity.getDynamicObject("taxrate").getString("name")));
                        return;
                    }
                    Optional result = TaxInfoUtil.checkTaxOrgVolid((DynamicObject)dataEntity.getDataEntity());
                    if (result.isPresent()) {
                        this.addErrorMessage(dataEntity, (String)result.get());
                        continue;
                    }
                    Optional validateFinancetaxperiodResult = TaxInfoUtil.validateFinancetaxperiodMustInput((DynamicObject)dataEntity.getDataEntity());
                    if (result.isPresent()) {
                        this.addFatalErrorMessage(dataEntity, (String)validateFinancetaxperiodResult.get());
                        continue;
                    }
                    Optional validateResult = TaxInfoUtil.validateRegisterAdressForzzs((DynamicObject)dataEntity.getDataEntity());
                    if (validateResult.isPresent()) {
                        this.addFatalErrorMessage(dataEntity, (String)validateResult.get());
                        continue;
                    }
                    Optional validateRegisterPlaceUniqueResult = TaxInfoUtil.validateRegisterPlaceUnique((DynamicObject)dataEntity.getDataEntity(), (Map)cacheData);
                    if (validateRegisterPlaceUniqueResult.isPresent()) {
                        this.addFatalErrorMessage(dataEntity, (String)validateRegisterPlaceUniqueResult.get());
                        continue;
                    }
                    Optional validateTaxJurisdictionUniqueResult = TaxInfoUtil.validateTaxJurisdictionUnique((DynamicObject)dataEntity.getDataEntity(), (Map)cacheData);
                    if (validateTaxJurisdictionUniqueResult.isPresent()) {
                        this.addFatalErrorMessage(dataEntity, (String)validateTaxJurisdictionUniqueResult.get());
                        continue;
                    }
                    Optional validateRegisterAddressCountryResult = TaxInfoUtil.validateRegisterAddressCountry((DynamicObject)dataEntity.getDataEntity(), (Map)cacheData);
                    if (validateRegisterAddressCountryResult.isPresent()) {
                        this.addFatalErrorMessage(dataEntity, (String)validateRegisterAddressCountryResult.get());
                        continue;
                    }
                    Optional validateRegisteredCurrencyMustInputResult = TaxInfoUtil.validateRegisteredCurrencyMustInput((DynamicObject)dataEntity.getDataEntity());
                    if (validateRegisteredCurrencyMustInputResult.isPresent()) {
                        this.addFatalErrorMessage(dataEntity, (String)validateRegisteredCurrencyMustInputResult.get());
                        continue;
                    }
                    Optional volidateBankInfoTaxAcctUniqueResult = TaxInfoUtil.volidateBankInfoTaxAcctUnique((DynamicObject)dataEntity.getDataEntity(), (Map)cacheData);
                    if (!volidateBankInfoTaxAcctUniqueResult.isPresent()) continue;
                    this.addFatalErrorMessage(dataEntity, (String)volidateBankInfoTaxAcctUniqueResult.get());
                }
            }
        });
    }

    private ImmutablePair<Date, Date> getDatePeriod(Long id) {
        DynamicObject[] tcsdTaxrates;
        for (DynamicObject tcsdTaxrate : tcsdTaxrates = BusinessDataServiceHelper.load((String)"tpo_tcsd_taxrate", (String)"id,entryentity,startdate,enddate", (QFilter[])new QFilter[0])) {
            DynamicObjectCollection entryentity = tcsdTaxrate.getDynamicObjectCollection("entryentity");
            List ids = entryentity.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
            if (!ids.contains(id)) continue;
            Date startdate = tcsdTaxrate.getDate("startdate");
            Date enddate = tcsdTaxrate.getDate("enddate");
            return ImmutablePair.of((Object)startdate, (Object)enddate);
        }
        return ImmutablePair.of(null, null);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objects = e.getDataEntities();
        Arrays.stream(objects).forEach(o -> o.set("taxorg", o.get("orgid")));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objects = e.getDataEntities();
        TaxInfoUtil.updateTaxMainTaxOrgEntryFields((DynamicObject[])objects);
        TaxInfoUtil.updateResidenttypeFields((DynamicObject[])objects);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] load;
        ArrayList orgIds = new ArrayList();
        DynamicObject[] objects = e.getDataEntities();
        Arrays.stream(objects).forEach(o -> orgIds.add(o.get("orgid.id")));
        ArrayList ationIds = new ArrayList();
        Arrays.stream(objects).forEach(o -> ationIds.add(o.get("taxationsys.id")));
        for (DynamicObject dyo : load = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)BASTAX_TAXORG_FIELD, (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds), new QFilter("entryentity.entry_taxationsys.id", "in", ationIds)})) {
            for (DynamicObject object : objects) {
                long ationId = object.getLong("taxationsys.id");
                if (ationId == 1L) {
                    dyo.set("taxpayerdetail", (Object)"1");
                }
                DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
                entryentity.forEach(entry -> {
                    if (ationId == entry.getLong("entry_taxationsys.id")) {
                        entry.set("entry_taxpayerdetail", (Object)"1");
                    }
                });
            }
        }
        SaveServiceHelper.update((DynamicObject[])load);
    }
}

