/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationSysEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.common.metadata.MetadataUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.taxorg.validator.QuoteOrgEntityEnum;
import kd.taxc.taxorg.validator.TaxorgQuoteValidator;
import kd.taxc.tctb.business.taxcmain.TaxInfoHomeBusiness;
import kd.taxc.tctb.business.taxcmain.TaxcMainBusiness;
import kd.taxc.tctb.business.taxmain.util.TaxVersionUtil;
import kd.taxc.tctb.business.util.TaxInfoUtil;
import kd.taxc.tctb.business.util.UpgradeUtil;
import kd.taxc.tctb.common.constant.OrgConstant;
import kd.taxc.tctb.formplugin.util.TaxPayerTypeUtil;

public class TaxInfoMainOperateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String allSubFieldString = MetadataUtil.getAllSubFieldString((String)TaxcMainConstant.ENTITYNAME);
        if (StringUtil.isNotEmpty((CharSequence)allSubFieldString)) {
            List<String> fieldList = Arrays.asList(allSubFieldString.split(","));
            for (String field : fieldList) {
                if (e.getFieldKeys().contains(field)) continue;
                e.getFieldKeys().add(field);
            }
        }
        e.getFieldKeys().add("categoryentryentity.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                block9: {
                    String operateKey;
                    block8: {
                        operateKey = this.getOperateKey();
                        if (!"submit".equalsIgnoreCase(operateKey)) break block8;
                        List objs = Stream.of(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
                        Map cacheData = TaxInfoUtil.batchFetchValidateData(objs);
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            Optional result = TaxInfoUtil.checkTaxOrgVolid((DynamicObject)dataEntity.getDataEntity());
                            if (result.isPresent()) {
                                this.addErrorMessage(dataEntity, (String)result.get());
                                continue;
                            }
                            Optional validateFinancetaxperiodResult = TaxInfoUtil.validateFinancetaxperiodMustInput((DynamicObject)dataEntity.getDataEntity());
                            if (result.isPresent()) {
                                this.addFatalErrorMessage(dataEntity, (String)validateFinancetaxperiodResult.get());
                                continue;
                            }
                            Optional validateResult = TaxInfoUtil.validateRegisterAdressForzzs((DynamicObject)dataEntity.getDataEntity());
                            if (validateResult.isPresent()) {
                                this.addFatalErrorMessage(dataEntity, (String)validateResult.get());
                                continue;
                            }
                            Optional validateRegisterPlaceUniqueResult = TaxInfoUtil.validateRegisterPlaceUnique((DynamicObject)dataEntity.getDataEntity(), (Map)cacheData);
                            if (validateRegisterPlaceUniqueResult.isPresent()) {
                                this.addFatalErrorMessage(dataEntity, (String)validateRegisterPlaceUniqueResult.get());
                                continue;
                            }
                            Optional validateTaxJurisdictionUniqueResult = TaxInfoUtil.validateTaxJurisdictionUnique((DynamicObject)dataEntity.getDataEntity(), (Map)cacheData);
                            if (validateTaxJurisdictionUniqueResult.isPresent()) {
                                this.addFatalErrorMessage(dataEntity, (String)validateTaxJurisdictionUniqueResult.get());
                                continue;
                            }
                            Optional validateRegisterAddressCountryResult = TaxInfoUtil.validateRegisterAddressCountry((DynamicObject)dataEntity.getDataEntity(), (Map)cacheData);
                            if (validateRegisterAddressCountryResult.isPresent()) {
                                this.addFatalErrorMessage(dataEntity, (String)validateRegisterAddressCountryResult.get());
                                continue;
                            }
                            Optional validateRegisteredCurrencyMustInputResult = TaxInfoUtil.validateRegisteredCurrencyMustInput((DynamicObject)dataEntity.getDataEntity());
                            if (!validateRegisteredCurrencyMustInputResult.isPresent()) continue;
                            this.addFatalErrorMessage(dataEntity, (String)validateRegisteredCurrencyMustInputResult.get());
                        }
                        break block9;
                    }
                    if (!"delete".equalsIgnoreCase(operateKey)) break block9;
                    DynamicObject mainInfo = null;
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        List<Long> orgIds;
                        QuoteOrgEntityEnum quoteOrgEntityEnum;
                        mainInfo = dataEntity.getDataEntity();
                        if (mainInfo == null || mainInfo.getLong("taxationsys.id") != TaxationSysEnum.CHAIN_MAINLAND.getId().longValue() || null == (quoteOrgEntityEnum = TaxorgQuoteValidator.validatorTaxOrgQuote(orgIds = Collections.singletonList(mainInfo.getLong("orgid.id"))))) continue;
                        this.addErrorMessage(dataEntity, quoteOrgEntityEnum.getMessage());
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("submit".equals(operationKey)) {
            DynamicObject[] objects = e.getDataEntities();
            TaxInfoUtil.updateTaxMainTaxOrgEntryFields((DynamicObject[])objects);
            TaxInfoUtil.updateResidenttypeFields((DynamicObject[])objects);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("submit".equals(operationKey)) {
            ArrayList orgIds = new ArrayList();
            DynamicObject[] dataEntities = e.getDataEntities();
            boolean flag = false;
            try {
                dataEntities[0].getDynamicObjectCollection("categoryentryentity");
            }
            catch (Exception ex) {
                flag = true;
            }
            List pkids = Arrays.stream(dataEntities).map(item -> item.getLong("id")).collect(Collectors.toList());
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,orgid,categoryentryentity,taxationsys", (QFilter[])new QFilter[]{new QFilter("id", "in", pkids)});
            if (EmptyCheckUtils.isNotEmpty((Object)objects)) {
                Arrays.stream(objects).forEach(o -> orgIds.add(o.get("orgid.id")));
            } else {
                Arrays.stream(dataEntities).forEach(o -> orgIds.add(o.get("orgid.id")));
            }
            if (!flag) {
                if (dataEntities[0].getLong("taxationsys.id") == 1L) {
                    DynamicObjectCollection categories = dataEntities[0].getDynamicObjectCollection("categoryentryentity");
                    UpgradeUtil.executeInitSyncTask((DynamicObjectCollection)categories);
                }
            } else {
                for (Long pkid : pkids) {
                    DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"tctb_tax_main");
                    if (object.getLong("taxationsys.id") != 1L) continue;
                    DynamicObjectCollection categories = object.getDynamicObjectCollection("categoryentryentity");
                    UpgradeUtil.executeInitSyncTask((DynamicObjectCollection)categories);
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("audit".equalsIgnoreCase(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            List ids = Arrays.stream(dataEntities).map(v -> v.getLong("id")).collect(Collectors.toList());
            DynamicObject[] taxMains = TaxcMainBusiness.getTaxMainInfoByIds(ids);
            List<DynamicObject> chinaTaxMains = Arrays.stream(taxMains).filter(main -> main.getLong("taxationsys.id") == OrgConstant.TAX_CHINA.longValue()).collect(Collectors.toList());
            Map effectiveDateMap = TaxVersionUtil.saveTaxLastVersion(chinaTaxMains);
            TaxPayerTypeUtil.uodateNsrType(chinaTaxMains, effectiveDateMap);
            TaxInfoHomeBusiness.doAuditJob(ids);
        } else if ("delete".equalsIgnoreCase(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                long orgid = dataEntity.getLong("orgid.id");
                long taxAtionId = dataEntity.getLong("taxationsys.id");
                List<Long> orgIds = Collections.singletonList(orgid);
                TaxResult result = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, (Long)taxAtionId, (boolean)true);
                if (result == null || !result.isSuccess()) continue;
                List basorgs = (List)result.getData();
                for (DynamicObject dyo : basorgs) {
                    if (taxAtionId == OrgConstant.TAX_CHINA) {
                        dyo.set("taxpayerdetail", (Object)"");
                    }
                    DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
                    entryentity.forEach(entry -> {
                        if (taxAtionId == entry.getLong("entry_taxationsys.id")) {
                            entry.set("entry_taxpayerdetail", (Object)"");
                        }
                    });
                }
                SaveServiceHelper.update((DynamicObject[])basorgs.toArray(new DynamicObject[basorgs.size()]));
            }
        }
    }
}

