/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tctb.business.org.TaxcOrgSaveBusiness;
import org.apache.commons.collections4.CollectionUtils;

public class TaxcOrgSaveEventPlugin
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(TaxcOrgSaveEventPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("TaxcOrgSaveEventPlugin,event id:{},number:{}", (Object)evt.getEventNumber(), (Object)evt.getEventId());
        try {
            List taxcOrglist = (List)SerializationUtils.fromJsonString((String)evt.getSource(), List.class);
            if (!CollectionUtils.isEmpty((Collection)taxcOrglist)) {
                List<Long> ids = taxcOrglist.stream().map(o -> {
                    String s = ((LinkedHashMap)o.get("org")).get("id").toString();
                    return Long.valueOf(s);
                }).collect(Collectors.toList());
                this.doBusiness(ids);
            }
        }
        catch (Exception e) {
            logger.error("TaxcOrgSaveEventPlugin error." + e.getMessage(), (Throwable)e);
            throw e;
        }
        return "success";
    }

    protected void doBusiness(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            TaxcOrgSaveBusiness.syncTaxLicenseWithLock(ids);
        }
    }
}

