/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.orgmap.OrgMapRelationBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class OrgMapRelationEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map taxCategoryMap = OrgMapRelationBusiness.getTaxCategoryMap((String)"id", (boolean)true);
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject entry = null;
        String taxcategory = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entry = (DynamicObject)entryCol.get(i);
            taxcategory = entry.getString("taxcategory");
            if (!StringUtil.isNotBlank((CharSequence)taxcategory)) continue;
            String[] ids = taxcategory.split(",");
            List idList = Arrays.stream(ids).filter(id -> !ObjectUtils.isEmpty(taxCategoryMap.get(id))).map(id -> ((DynamicObject)taxCategoryMap.get(id)).getString("name")).collect(Collectors.toList());
            this.getModel().setValue("applytaxtype", (Object)StringUtil.join(idList, (String)","), i);
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("businessnumber".equalsIgnoreCase(propName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Object propValue = e.getChangeSet()[0].getNewValue();
            if (ObjectUtils.isEmpty((Object)propValue)) {
                this.getModel().setValue("businessname", null, rowIndex);
                this.getModel().setValue("businessid", null, rowIndex);
            }
        } else if ("applytaxtype".equalsIgnoreCase(propName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Object propValue = e.getChangeSet()[0].getNewValue();
            if (ObjectUtils.isEmpty((Object)propValue)) {
                this.getModel().setValue("taxcategory", null, rowIndex);
                this.getModel().setValue("taxcategoryname", null, rowIndex);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit businessNumberTextEdit = (TextEdit)this.getControl("businessnumber");
        businessNumberTextEdit.addClickListener((ClickListener)this);
        TextEdit applyTaxtypeTextEdit = (TextEdit)this.getControl("applytaxtype");
        applyTaxtypeTextEdit.addClickListener((ClickListener)this);
        BasedataEdit mapobjectBasedataEdit = (BasedataEdit)this.getControl("useorg");
        mapobjectBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("useorg".equals(key)) {
            DynamicObject group = (DynamicObject)this.getModel().getValue("group");
            if (ObjectUtils.isEmpty((Object)group)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6620\u5c04\u65b9\u6848\u3002", (String)"OrgMapRelationEditPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            List<Long> enableTaxOrgList = this.getPermOrgs();
            DynamicObject[] coll = OrgMapRelationBusiness.queryOrgMapRelationByGroupId((Long)group.getLong("id"));
            List existsIds = Stream.of(coll).map(v -> v.getDynamicObject("useorg").getLong("id")).collect(Collectors.toList());
            List conformList = enableTaxOrgList.stream().filter(id -> !existsIds.contains(id)).collect(Collectors.toList());
            QFilter orgQ = new QFilter("id", "in", conformList);
            listShowParameter.getListFilterParameter().setFilter(orgQ);
        }
    }

    protected List<Long> getPermOrgs() {
        long userId;
        TaxResult result;
        List<Long> orgIds = new ArrayList<Long>(10);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        String entityid = this.getView().getEntityId();
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        if ((result = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)(userId = RequestContext.get().getCurrUserId()), (String)appid, (String)entityid, (String)"47150e89000000ac")) != null && result.isSuccess()) {
            orgIds = (List)result.getData();
        }
        return orgIds;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"businessnumber")) {
            DynamicObject group = (DynamicObject)this.getView().getModel().getValue("group");
            if (ObjectUtils.isEmpty((Object)group)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6620\u5c04\u65b9\u6848\u3002", (String)"OrgMapRelationEditPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject mapObject = group.getDynamicObject("mapobject");
            String entity = mapObject.getString("number");
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId(entity);
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entity);
            if (ObjectUtils.isEmpty((Object)formConfig)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6253\u5f00\u5f02\u5e38\u3002", (String)"OrgMapRelationEditPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (ObjectUtils.isEmpty((Object)entityType.getAlias())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u6620\u5c04\u5bf9\u8c61\u7684\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgMapRelationEditPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            listShowParameter.setFormId(formConfig.getF7ListFormId());
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            listShowParameter.getOpenStyle().setInlineStyleCss(css);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.setShowTitle(false);
            listShowParameter.setMultiSelect(true);
            listShowParameter.setLookUp(true);
            listShowParameter.setCustomParam("selectaction", (Object)"doOpenParent");
            listShowParameter.setCustomParam("modeltype", (Object)"BaseFormModel");
            listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            DynamicObject focusRow = this.getModel().getEntryRowEntity("entryentity", entryGrid.getEntryState().getFocusRow());
            if (entityType.getPrimaryKey() instanceof VarcharProp) {
                listShowParameter.setSelectedRow((Object)focusRow.getString("businessid"));
            } else {
                listShowParameter.setSelectedRow((Object)focusRow.getLong("businessid"));
            }
            IDataEntityProperty dataEntityProperty = entityType.findProperty("enable");
            if (ObjectUtils.isNotEmpty((Object)dataEntityProperty) && StringUtil.isNotBlank((CharSequence)dataEntityProperty.getAlias())) {
                QFilter statusQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
                listShowParameter.getListFilterParameter().setFilter(statusQ);
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "businessnumber");
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"applytaxtype")) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("bd_taxcategory");
            listShowParameter.setFormId("bos_listf7");
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            listShowParameter.getOpenStyle().setInlineStyleCss(css);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.setShowTitle(false);
            listShowParameter.setMultiSelect(true);
            listShowParameter.setLookUp(true);
            listShowParameter.setCustomParam("selectaction", (Object)"doOpenParent");
            listShowParameter.setCustomParam("modeltype", (Object)"BaseFormModel");
            listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            DynamicObject focusRow = this.getModel().getEntryRowEntity("entryentity", entryGrid.getEntryState().getFocusRow());
            String idString = focusRow.getString("taxcategory");
            String[] ids = idString.split(",");
            if (ObjectUtils.isNotEmpty((Object)ids)) {
                List selList = Arrays.stream(ids).filter(o -> StringUtil.isNotBlank((CharSequence)o)).map(o -> Long.valueOf(o)).collect(Collectors.toList());
                listShowParameter.setSelectedRows(selList.toArray());
            }
            QFilter startDateQ = new QFilter("activedate", "<=", (Object)new Date());
            QFilter endDateQ = new QFilter("expdate", "is null", null).or(new QFilter("expdate", ">=", (Object)new Date()));
            QFilter statusQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
            listShowParameter.getListFilterParameter().setFilter(startDateQ);
            listShowParameter.getListFilterParameter().setFilter(endDateQ);
            listShowParameter.getListFilterParameter().setFilter(statusQ);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "applytaxtype");
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof DeleteEntry) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            DynamicObject currentObject = this.getModel().getEntryRowEntity("entryentity", entryGrid.getEntryState().getFocusRow());
            if (ObjectUtils.isNotEmpty((Object)currentObject.getString("businessnumber"))) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delentry", (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u4e1a\u52a1\u5bf9\u8c61\u540e\uff0c\u53d6\u6570\u65f6\u5c06\u4e0d\u518d\u53d6\u5230\u8be5\u5bf9\u8c61\u7684\u6570\u636e\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"OrgMapRelationEditPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"delentry") && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            this.getModel().deleteEntryRows("entryentity", entryGrid.getEntryState().getSelectedRows());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listDatas;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"businessnumber")) {
            ListSelectedRowCollection listDatas2 = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (!ObjectUtils.isEmpty((Object)listDatas2) && listDatas2.size() > 0) {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
                boolean isFirst = true;
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int focusRow = entryGrid.getEntryState().getFocusRow();
                for (ListSelectedRow row2 : listDatas2) {
                    if (isFirst) {
                        this.getModel().setValue("businessid", row2.getPrimaryKeyValue(), focusRow);
                        this.getModel().setValue("businessnumber", (Object)row2.getNumber(), focusRow);
                        this.getModel().setValue("businessname", (Object)row2.getName(), focusRow);
                        isFirst = false;
                        continue;
                    }
                    DynamicObject dynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
                    int index = this.getModel().createNewEntryRow("entryentity", dynamicObject);
                    this.getModel().setValue("businessid", row2.getPrimaryKeyValue(), index);
                    this.getModel().setValue("businessnumber", (Object)row2.getNumber(), index);
                    this.getModel().setValue("businessname", (Object)row2.getName(), index);
                }
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"applytaxtype") && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) && listDatas.size() > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int focusRow = entryGrid.getEntryState().getFocusRow();
            String applyTaxtypeName = StringUtil.join((Iterable)listDatas.stream().map(row -> row.getName()).collect(Collectors.toList()), (String)",");
            String applyTaxtypeId = StringUtil.join((Iterable)listDatas.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList()), (String)",");
            this.getModel().setValue("applytaxtype", (Object)applyTaxtypeName, focusRow);
            this.getModel().setValue("taxcategory", (Object)applyTaxtypeId, focusRow);
        }
    }
}

