/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.orgmap.OrgMapRelationBusiness;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OrgMapRelationListPlugin
extends AbstractTreeListPlugin {
    private static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.getTreeModel().setTextFormat("{code}({name})");
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        this.getTreeModel().setTextFormat("{code}({name})");
        TreeListModel treeListModel = (TreeListModel)this.getTreeModel();
        treeListModel.getQueryParas().put("order", "number");
    }

    private void refreshTreeView() {
        String nodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node != null) {
            this.getTreeListView().getTreeView().updateNode(node);
            this.getTreeListView().getTreeView().focusNode(node);
            if (((AbstractTreeListView)this.getTreeListView()).getRoot() != null) {
                this.getTreeListView().refreshTreeNode(node.getId());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("new".equals(key) && this.isRoot()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u6620\u5c04\u65b9\u6848\u3002", (String)"OrgMapRelationListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private boolean isRoot() {
        boolean isRoot = false;
        if (this.getTreeModel().getRoot() != null && this.getTreeModel().getCurrentNodeId() != null && this.getTreeModel().getCurrentNodeId().equals(this.getTreeModel().getRoot().getId())) {
            isRoot = true;
        }
        return isRoot;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("refresh".equals(key)) {
            this.getTreeListView().focusRootNode();
            this.refreshTreeView();
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] rows = e.getQueryValues();
        if (ObjectUtils.isNotEmpty((Object)rows)) {
            Map taxcategoryMap = OrgMapRelationBusiness.getTaxCategoryMap((String)"id", (boolean)true);
            Arrays.stream(rows).forEach(object -> {
                DynamicObjectCollection busObjectSubCol = object.getDynamicObjectCollection("entryentity");
                busObjectSubCol.stream().forEach(busObject -> {
                    String idString = busObject.getString("taxcategory");
                    if (StringUtil.isNotBlank((CharSequence)idString)) {
                        String[] ids = idString.split(",");
                        ArrayList numberList = new ArrayList(10);
                        ArrayList nameList = new ArrayList(10);
                        Arrays.stream(ids).filter(id -> !ObjectUtils.isEmpty(taxcategoryMap.get(id))).forEach(id -> {
                            numberList.add(((DynamicObject)taxcategoryMap.get(id)).getString("number"));
                            nameList.add(((DynamicObject)taxcategoryMap.get(id)).getString("name"));
                        });
                        busObject.set("taxcategory", (Object)StringUtil.join(numberList, (String)","));
                        busObject.set("taxcategoryname", (Object)StringUtil.join(nameList, (String)","));
                    }
                });
            });
        }
    }
}

