/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org.ver;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.taxcmain.TaxcMainBusiness;
import kd.taxc.tctb.business.taxmain.util.TaxVersionUtil;
import kd.taxc.tctb.common.constant.OrgConstant;
import kd.taxc.tctb.formplugin.util.TaxPayerTypeUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OrgTaxVerImportPlugin
extends BatchImportPlugin {
    private static final String BASTAX_TAXORG_FIELD = "id,org,taxpayer,istaxpayer,unifiedsocialcode,cmborgtype,status,isvirtual,taxpayerdetail,licensestatus,org_id,cmborgtype_id,entryentity,entryentity.entry_taxpayerdetail,entryentity.entry_taxationsys,entryentity.entry_unifiedsocialcode,entryentity.entry_status,entryentity.entry_istaxpayer,entryentity.entry_taxpayer";

    public String getDefaultKeyFields() {
        return "orgid,taxationsys";
    }

    public String getBillFormId() {
        return super.getBillFormId();
    }

    public String getDefaultImportType() {
        return super.getDefaultImportType();
    }

    protected boolean isForceBatch() {
        return true;
    }

    private boolean isNewType() {
        Map option = this.ctx.getOption();
        if (MapUtils.isEmpty((Map)option)) {
            return false;
        }
        Object importtype = option.get("importtype");
        return StringUtils.isNotBlank(importtype) && StringUtils.equals((CharSequence)"new", (CharSequence)importtype.toString());
    }

    private void remove(List<ImportBillData> data, Iterator<ImportBillData> partList) {
        if (ObjectUtils.isNotEmpty(data)) {
            partList.remove();
        }
    }

    private void queryGather(List<ImportBillData> billdatas, Map<String, Object> cacheMap) {
        QFilter taxNumberQ;
        DynamicObjectCollection collection;
        List taxationSysExpdateList = (List)cacheMap.get("taxationSysExpdateList");
        List taxationSysNoExistList = (List)cacheMap.get("taxationSysNoExistList");
        List taxationSysDisableList = (List)cacheMap.get("taxationSysDisableList");
        List taxTypeExpdateList = (List)cacheMap.get("taxTypeExpdateList");
        List taxTypeDisableList = (List)cacheMap.get("taxTypeDisableList");
        List taxTypeNoExistList = (List)cacheMap.get("taxTypeNoExistList");
        List orgNumberNoExistList = (List)cacheMap.get("orgNumberNoExistList");
        Map taxTypeTaxationmap = (Map)cacheMap.get("taxTypeTaxationmap");
        Map orgTaxationMap = (Map)cacheMap.get("orgTaxationMap");
        Map orgMainExistTaxationMap = (Map)cacheMap.get("orgMainExistTaxationMap");
        List supplierDisableList = (List)cacheMap.get("supplierDisableList");
        List supplierNoExistList = (List)cacheMap.get("supplierNoExistList");
        List customerDisableList = (List)cacheMap.get("customerDisableList");
        List customerNoExistList = (List)cacheMap.get("customerNoExistList");
        HashSet<String> orgNumberSet = new HashSet<String>();
        HashSet<String> taxationsysNumerSet = new HashSet<String>();
        HashSet<String> taxcategoriesNumberSet = new HashSet<String>();
        HashSet<String> supplierNumberSet = new HashSet<String>();
        HashSet<String> customerNumberSet = new HashSet<String>();
        for (ImportBillData importBillData : billdatas) {
            Map<String, Integer> map;
            JSONArray hwsEnrtys;
            JSONObject data = importBillData.getData();
            orgNumberSet.add(ObjectUtils.isNotEmpty((Object)data.getJSONObject("orgid")) ? data.getJSONObject("orgid").getString("number") : "");
            taxationsysNumerSet.add(ObjectUtils.isNotEmpty((Object)data.getJSONObject("taxationsys")) ? data.getJSONObject("taxationsys").getString("number") : "");
            supplierNumberSet.add(ObjectUtils.isNotEmpty((Object)data.getJSONObject("acctsupplier")) ? data.getJSONObject("acctsupplier").getString("number") : "");
            customerNumberSet.add(ObjectUtils.isNotEmpty((Object)data.getJSONObject("acctcustomer")) ? data.getJSONObject("acctcustomer").getString("number") : "");
            if (data.containsKey((Object)"hwsentryentity") && ObjectUtils.isNotEmpty((Object)(hwsEnrtys = data.getJSONArray("hwsentryentity")))) {
                for (int i = 0; i < hwsEnrtys.size(); ++i) {
                    JSONObject hwsEntry = hwsEnrtys.getJSONObject(i);
                    JSONObject hwstaxtype = hwsEntry.getJSONObject("hwstaxtype");
                    taxcategoriesNumberSet.add(ObjectUtils.isNotEmpty((Object)hwstaxtype) ? hwstaxtype.getString("number") : "");
                }
            }
            if (!ObjectUtils.isNotEmpty((Object)data.getJSONObject("orgid")) || !ObjectUtils.isNotEmpty((Object)data.getJSONObject("taxationsys"))) continue;
            String orgNumber = data.getJSONObject("orgid").getString("number");
            String taxationsysNumber = data.getJSONObject("taxationsys").getString("number");
            if (orgMainExistTaxationMap.containsKey(orgNumber)) {
                map = (Map)orgMainExistTaxationMap.get(orgNumber);
                if (map.containsKey(taxationsysNumber)) {
                    map.put(taxationsysNumber, (Integer)map.get(taxationsysNumber) + 1);
                    continue;
                }
                map.put(taxationsysNumber, 1);
                continue;
            }
            map = new HashMap();
            map.put(taxationsysNumber, 1);
            orgMainExistTaxationMap.put(orgNumber, map);
        }
        if (ObjectUtils.isNotEmpty(orgNumberSet)) {
            QFilter numberQ = new QFilter("number", "in", orgNumberSet);
            collection = QueryServiceHelper.query((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{numberQ});
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                orgNumberNoExistList = collection.stream().filter(row -> !orgNumberSet.contains(row.getString("number"))).map(o -> o.getString("number")).collect(Collectors.toList());
            } else {
                orgNumberNoExistList.addAll(orgNumberSet);
            }
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.number,entryentity,entryentity.entry_taxationsys.number", (QFilter[])new QFilter[]{new QFilter("org.number", "in", orgNumberSet)});
            for (DynamicObject row2 : coll) {
                String orgNumber = row2.getString("org.number");
                if (orgTaxationMap.containsKey(orgNumber)) {
                    ((List)orgTaxationMap.get(orgNumber)).add(row2.getString("entryentity.entry_taxationsys.number"));
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(row2.getString("entryentity.entry_taxationsys.number"));
                orgTaxationMap.put(orgNumber, list);
            }
            if (this.isNewType()) {
                DynamicObjectCollection orgMainCol = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.number,taxationsys.number", (QFilter[])new QFilter[]{new QFilter("orgid.number", "in", orgNumberSet)});
                for (DynamicObject row3 : orgMainCol) {
                    Map<String, Integer> map;
                    String orgNumber = row3.getString("orgid.number");
                    String taxationsysNumber = row3.getString("taxationsys.number");
                    if (orgMainExistTaxationMap.containsKey(orgNumber)) {
                        map = (Map)orgMainExistTaxationMap.get(orgNumber);
                        if (map.containsKey(taxationsysNumber)) {
                            map.put(taxationsysNumber, (Integer)map.get(taxationsysNumber) + 1);
                            continue;
                        }
                        map.put(taxationsysNumber, 1);
                        continue;
                    }
                    map = new HashMap();
                    map.put(taxationsysNumber, 1);
                    orgMainExistTaxationMap.put(orgNumber, map);
                }
            }
        }
        if (ObjectUtils.isNotEmpty(taxationsysNumerSet)) {
            taxNumberQ = new QFilter("number", "in", taxationsysNumerSet);
            collection = QueryServiceHelper.query((String)"bd_taxationsys", (String)"number,expdate,activedate,enable", (QFilter[])new QFilter[]{taxNumberQ});
            for (DynamicObject row4 : collection) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)row4.getString("enable"), (CharSequence)"1")) {
                    taxationSysDisableList.add(row4.getString("number"));
                    continue;
                }
                if (DateUtils.isEffectiveDate((Date)new Date(), (Date)row4.getDate("activedate"), (Date)row4.getDate("expdate"))) continue;
                taxationSysExpdateList.add(row4.getString("number"));
            }
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                taxationSysNoExistList = collection.stream().filter(row -> !taxationsysNumerSet.contains(row.getString("number"))).map(o -> o.getString("number")).collect(Collectors.toList());
            } else {
                taxationSysNoExistList.addAll(taxationsysNumerSet);
            }
        }
        if (ObjectUtils.isNotEmpty(supplierNumberSet)) {
            QFilter supplierNumberQ = new QFilter("number", "in", supplierNumberSet);
            collection = QueryServiceHelper.query((String)"bd_supplier", (String)"number,enable", (QFilter[])new QFilter[]{supplierNumberQ});
            for (DynamicObject row4 : collection) {
                if (StringUtil.equalsIgnoreCase((CharSequence)row4.getString("enable"), (CharSequence)"1")) continue;
                supplierDisableList.add(row4.getString("number"));
            }
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                supplierNoExistList = collection.stream().filter(row -> !supplierNumberSet.contains(row.getString("number"))).map(o -> o.getString("number")).collect(Collectors.toList());
            } else {
                supplierNoExistList.addAll(supplierNumberSet);
            }
        }
        if (ObjectUtils.isNotEmpty(customerNumberSet)) {
            QFilter customerNumberQ = new QFilter("number", "in", customerNumberSet);
            collection = QueryServiceHelper.query((String)"bd_customer", (String)"number,enable", (QFilter[])new QFilter[]{customerNumberQ});
            for (DynamicObject row4 : collection) {
                if (StringUtil.equalsIgnoreCase((CharSequence)row4.getString("enable"), (CharSequence)"1")) continue;
                customerDisableList.add(row4.getString("number"));
            }
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                customerNoExistList = collection.stream().filter(row -> !customerNumberSet.contains(row.getString("number"))).map(o -> o.getString("number")).collect(Collectors.toList());
            } else {
                customerNoExistList.addAll(customerNumberSet);
            }
        }
        if (!ObjectUtils.isEmpty(taxcategoriesNumberSet)) {
            taxNumberQ = new QFilter("number", "in", taxcategoriesNumberSet);
            collection = QueryServiceHelper.query((String)"bd_taxcategory", (String)"number,taxationsysid.number,activedate,expdate,enable", (QFilter[])new QFilter[]{taxNumberQ});
            for (DynamicObject row4 : collection) {
                String number = row4.getString("number");
                if (!StringUtil.equalsIgnoreCase((CharSequence)row4.getString("enable"), (CharSequence)"1")) {
                    taxTypeDisableList.add(number);
                    continue;
                }
                if (!DateUtils.isEffectiveDate((Date)new Date(), (Date)row4.getDate("activedate"), (Date)row4.getDate("expdate"))) {
                    taxTypeExpdateList.add(number);
                    continue;
                }
                taxTypeTaxationmap.put(row4.getString("number"), row4.getString("taxationsysid.number"));
            }
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                taxTypeNoExistList = collection.stream().filter(row -> !taxcategoriesNumberSet.contains(row.getString("number"))).map(o -> o.getString("number")).collect(Collectors.toList());
            } else {
                taxTypeNoExistList.addAll(taxcategoriesNumberSet);
            }
        }
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        if (ObjectUtils.isNotEmpty(billdatas)) {
            ArrayList orgNumberNoExistList = new ArrayList();
            ArrayList taxationSysExpdateList = new ArrayList();
            ArrayList taxationSysNoExistList = new ArrayList();
            ArrayList taxationSysDisableList = new ArrayList();
            ArrayList taxTypeExpdateList = new ArrayList();
            ArrayList taxTypeDisableList = new ArrayList();
            ArrayList taxTypeNoExistList = new ArrayList();
            ArrayList supplierDisableList = new ArrayList();
            ArrayList supplierNoExistList = new ArrayList();
            ArrayList customerDisableList = new ArrayList();
            ArrayList customerNoExistList = new ArrayList();
            HashMap taxTypeTaxationmap = new HashMap();
            HashMap orgTaxationMap = new HashMap();
            HashMap orgMainExistTaxationMap = new HashMap();
            HashMap<String, Object> cacheMap = new HashMap<String, Object>(10);
            cacheMap.put("orgNumberNoExistList", orgNumberNoExistList);
            cacheMap.put("taxationSysExpdateList", taxationSysExpdateList);
            cacheMap.put("taxationSysNoExistList", taxationSysNoExistList);
            cacheMap.put("taxationSysDisableList", taxationSysDisableList);
            cacheMap.put("taxTypeExpdateList", taxTypeExpdateList);
            cacheMap.put("taxTypeDisableList", taxTypeDisableList);
            cacheMap.put("taxTypeNoExistList", taxTypeNoExistList);
            cacheMap.put("supplierDisableList", supplierDisableList);
            cacheMap.put("supplierNoExistList", supplierNoExistList);
            cacheMap.put("customerDisableList", customerDisableList);
            cacheMap.put("customerNoExistList", customerNoExistList);
            cacheMap.put("taxTypeTaxationmap", taxTypeTaxationmap);
            cacheMap.put("orgTaxationMap", orgTaxationMap);
            cacheMap.put("orgMainExistTaxationMap", orgMainExistTaxationMap);
            this.queryGather(billdatas, cacheMap);
            Iterator<ImportBillData> it = billdatas.iterator();
            while (it.hasNext()) {
                Optional<String> checkResult;
                ImportBillData importBillData = it.next();
                int index = importBillData.getStartIndex();
                JSONObject data = importBillData.getData();
                boolean isMainInfo = false;
                if (data.containsKey((Object)"hwsentryentity")) {
                    isMainInfo = true;
                } else if (data.containsKey((Object)"categoryentryentity")) {
                    isMainInfo = true;
                }
                JSONObject orgJson = data.getJSONObject("orgid");
                if (ObjectUtils.isEmpty((Object)orgJson)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTaxVerImportPlugin_22", (String)"taxc-tctb-formplugin", (Object[])new Object[0])).fail();
                    this.remove(billdatas, it);
                    continue;
                }
                if (orgNumberNoExistList.contains(orgJson.getString("number"))) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801%1$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_23", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), orgJson.getString("number"))).fail();
                    this.remove(billdatas, it);
                    continue;
                }
                String orgNumber = orgJson.getString("number");
                if (!orgTaxationMap.containsKey(orgNumber)) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801%1$s\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u672a\u751f\u6210\uff0c\u8bf7\u5148\u540c\u6b65\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgTaxVerImportPlugin_24", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), orgNumber)).fail();
                    this.remove(billdatas, it);
                    continue;
                }
                if (isMainInfo) {
                    Integer count;
                    boolean chinaAtionFlag;
                    JSONObject acctcustomer;
                    JSONObject taxationSysJson = data.getJSONObject("taxationsys");
                    if (ObjectUtils.isEmpty((Object)taxationSysJson)) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTaxVerImportPlugin_25", (String)"taxc-tctb-formplugin", (Object[])new Object[0])).fail();
                        this.remove(billdatas, it);
                        continue;
                    }
                    String taxationNumber = taxationSysJson.getString("number");
                    if (taxationSysNoExistList.contains(taxationNumber)) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u7f16\u7801%1$s\u4e0d\u5b58\u5728,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_26", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), taxationNumber)).fail();
                        this.remove(billdatas, it);
                        continue;
                    }
                    if (taxationSysExpdateList.contains(taxationNumber)) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u7f16\u7801%1$s\u5df2\u5931\u6548,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_27", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), taxationNumber)).fail();
                        this.remove(billdatas, it);
                        continue;
                    }
                    if (taxationSysDisableList.contains(taxationNumber)) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u7f16\u7801%1$s\u672a\u542f\u7528,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_28", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), taxationNumber)).fail();
                        this.remove(billdatas, it);
                        continue;
                    }
                    if (!((List)orgTaxationMap.get(orgJson.getString("number"))).contains(taxationNumber)) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801%1$s\u672a\u7ef4\u62a4\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6%2$s\u3002", (String)"OrgTaxVerImportPlugin_29", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), orgJson.getString("number"), taxationNumber)).fail();
                        this.remove(billdatas, it);
                        continue;
                    }
                    JSONObject acctsupplier = data.getJSONObject("acctsupplier");
                    if (ObjectUtils.isNotEmpty((Object)acctsupplier)) {
                        String supplierNumber = acctsupplier.getString("number");
                        if (supplierNoExistList.contains(supplierNumber)) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801%1$s\u4e0d\u5b58\u5728,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_43", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), supplierNumber)).fail();
                            this.remove(billdatas, it);
                            continue;
                        }
                        if (supplierDisableList.contains(supplierNumber)) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801%1$s\u672a\u542f\u7528,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_44", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), supplierNumber)).fail();
                            this.remove(billdatas, it);
                            continue;
                        }
                    }
                    if (ObjectUtils.isNotEmpty((Object)(acctcustomer = data.getJSONObject("acctcustomer")))) {
                        String customerNumber = acctcustomer.getString("number");
                        if (customerNoExistList.contains(customerNumber)) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u7f16\u7801%1$s\u4e0d\u5b58\u5728,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_45", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), customerNumber)).fail();
                            this.remove(billdatas, it);
                            continue;
                        }
                        if (customerDisableList.contains(customerNumber)) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u7f16\u7801%1$s\u672a\u542f\u7528,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_46", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), customerNumber)).fail();
                            this.remove(billdatas, it);
                            continue;
                        }
                    }
                    if (chinaAtionFlag = this.isChinaAtionFlag(taxationNumber)) {
                        if (data.containsKey((Object)"hwsentryentity")) {
                            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u4fe1\u606f\u548c\u7a0e\u79cd\u4fe1\u606f\u6a21\u677f\u8fdb\u884c\u5f15\u5165\u6570\u636e\u3002", (String)"OrgTaxVerImportPlugin_30", (String)"taxc-tctb-formplugin", (Object[])new Object[0])).fail();
                            this.remove(billdatas, it);
                            continue;
                        }
                    } else {
                        if (data.containsKey((Object)"categoryentryentity")) {
                            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u4fe1\u606f\u548c\u7a0e\u79cd\u4fe1\u606f\uff08\u6d77\u5916\u7a0e\uff09\u6a21\u677f\u8fdb\u884c\u5f15\u5165\u6570\u636e\u3002", (String)"OrgTaxVerImportPlugin_31", (String)"taxc-tctb-formplugin", (Object[])new Object[0])).fail();
                            this.remove(billdatas, it);
                            continue;
                        }
                        ArrayList<ImportLogger.ImportLog> importLogList = new ArrayList<ImportLogger.ImportLog>();
                        JSONArray hwsEnrtys = data.getJSONArray("hwsentryentity");
                        Map hwsEntityFields = new TaxcMainConstant().getHwsEntityFields();
                        if (ObjectUtils.isNotEmpty((Object)hwsEnrtys)) {
                            boolean isContinue = false;
                            for (int i = 0; i < hwsEnrtys.size(); ++i) {
                                JSONObject hwsEntry = hwsEnrtys.getJSONObject(i);
                                for (Map.Entry entry : hwsEntityFields.entrySet()) {
                                    if (null != hwsEntry.get(entry.getKey())) continue;
                                    ImportLogger.ImportLog importLog = new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a\"%s\"\u3002", (String)"OrgTaxVerImportPlugin_32", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), entry.getValue()));
                                    importLogList.add(importLog);
                                }
                                if (ObjectUtils.isNotEmpty(importLogList)) {
                                    logger.logAll(Integer.valueOf(index), importLogList).fail();
                                    this.remove(billdatas, it);
                                    isContinue = true;
                                    break;
                                }
                                JSONObject hwstaxTypeJson = hwsEntry.getJSONObject("hwstaxtype");
                                String hwsTaxTypeNumber = hwstaxTypeJson.getString("number");
                                if (taxTypeNoExistList.contains(hwsTaxTypeNumber)) {
                                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u7f16\u7801%1$s\u4e0d\u5b58\u5728,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_33", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), hwsTaxTypeNumber)).fail();
                                    this.remove(billdatas, it);
                                    isContinue = true;
                                    break;
                                }
                                if (taxTypeExpdateList.contains(hwsTaxTypeNumber)) {
                                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u7f16\u7801%1$s\u5df2\u5931\u6548,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_34", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), hwsTaxTypeNumber)).fail();
                                    this.remove(billdatas, it);
                                    isContinue = true;
                                    break;
                                }
                                if (taxTypeDisableList.contains(hwsTaxTypeNumber)) {
                                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u7f16\u7801%1$s\u672a\u542f\u7528,\u8bf7\u4fee\u6539\u3002", (String)"OrgTaxVerImportPlugin_35", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), hwsTaxTypeNumber)).fail();
                                    this.remove(billdatas, it);
                                    isContinue = true;
                                    break;
                                }
                                if (!taxTypeTaxationmap.containsKey(hwsTaxTypeNumber) || ((String)taxTypeTaxationmap.get(hwsTaxTypeNumber)).contains(taxationNumber)) continue;
                                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u7f16\u7801%1$s\u672a\u7ef4\u62a4\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6%2$s\u3002", (String)"OrgTaxVerImportPlugin_36", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), hwsTaxTypeNumber, taxationNumber)).fail();
                                this.remove(billdatas, it);
                                isContinue = true;
                                break;
                            }
                            if (isContinue) continue;
                        }
                    }
                    if (orgMainExistTaxationMap.containsKey(orgNumber) && ObjectUtils.isNotEmpty(orgMainExistTaxationMap.get(orgNumber)) && ObjectUtils.isNotEmpty(((Map)orgMainExistTaxationMap.get(orgNumber)).get(taxationNumber)) && (count = (Integer)((Map)orgMainExistTaxationMap.get(orgNumber)).get(taxationNumber)) > 1) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u7f16\u7801%1$s\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgTaxVerImportPlugin_37", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), taxationNumber)).fail();
                        this.remove(billdatas, it);
                        continue;
                    }
                }
                if (!(checkResult = this.checkFieldsBeforeSave(data, isMainInfo)).isPresent()) continue;
                logger.log(Integer.valueOf(index), checkResult.get()).fail();
                this.remove(billdatas, it);
            }
        }
    }

    private Optional<String> checkFieldsBeforeSave(JSONObject data, boolean isMainInfo) {
        StringBuilder errors = new StringBuilder();
        if (isMainInfo) {
            JSONArray categories;
            boolean chinaAtionFlag;
            String orgNumber = data.getJSONObject("orgid").getString("number");
            String taxationsys = data.getString("taxationsys");
            String taxationNumber = data.getJSONObject("taxationsys").getString("number");
            DynamicObject[] orgObj = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
            if (EmptyCheckUtils.isNotEmpty((Object)orgObj)) {
                Long orgid = orgObj[0].getLong("id");
                DynamicObject[] taxorgs = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)BASTAX_TAXORG_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgid)});
                if (EmptyCheckUtils.isEmpty((Object)taxorgs)) {
                    errors.append(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u672a\u751f\u6210\uff0c\u8bf7\u5148\u540c\u6b65\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgTaxVerImportPlugin_38", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                } else {
                    Optional<DynamicObject> entry = taxorgs[0].getDynamicObjectCollection("entryentity").stream().filter(v -> taxationNumber.equals(v.getString("entry_taxationsys.number"))).findFirst();
                    if (entry.isPresent()) {
                        this.checkFields(data, entry.get().getBoolean("entry_istaxpayer"), errors);
                    }
                }
            } else {
                this.checkFields(data, false, errors);
            }
            if (StringUtil.isNotBlank((CharSequence)taxationsys) && (chinaAtionFlag = this.isChinaAtionFlag(taxationNumber)) && null != (categories = data.getJSONArray("categoryentryentity")) && categories.size() > 0 && this.exist(orgNumber)) {
                this.checkInnerIdExist(errors, categories, orgNumber);
            }
        } else {
            this.checkFields(data, false, errors);
        }
        return errors.length() > 0 ? Optional.of(errors.toString()) : Optional.empty();
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (EmptyCheckUtils.isNotEmpty(rowdatas)) {
            for (ImportBillData importBillData : rowdatas) {
                JSONObject data = importBillData.getData();
                data.put("isinitial", (Object)Boolean.TRUE);
            }
            ApiResult result = super.save(rowdatas, logger);
            if (result.getSuccess()) {
                List ids = ((List)result.getData()).stream().map(v -> (Long)v.get("id")).collect(Collectors.toList());
                DynamicObject[] taxMains = TaxcMainBusiness.getTaxMainInfoByIds(ids);
                List<DynamicObject> chinaTaxMains = Arrays.stream(taxMains).filter(main -> main.getLong("taxationsys.id") == OrgConstant.TAX_CHINA.longValue()).collect(Collectors.toList());
                Map effectiveDateMap = TaxVersionUtil.saveTaxLastVersion(chinaTaxMains);
                TaxPayerTypeUtil.uodateNsrType(chinaTaxMains, effectiveDateMap);
            }
            return result;
        }
        return super.save(rowdatas, logger);
    }

    private boolean isChinaAtionFlag(String taxationNumber) {
        return Objects.equals("001", taxationNumber);
    }

    private void checkInnerIdExist(StringBuilder errors, JSONArray categories, String orgNumber) {
        for (int i = 0; i < categories.size(); ++i) {
            JSONObject info = categories.getJSONObject(i);
            if (!StringUtil.isEmpty((CharSequence)info.getString("id"))) continue;
            String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\uff1a%s\u5df2\u5b58\u5728\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u76f8\u5173\u8054\u7684\u7a0e\u79cd\u5185\u7801", (String)"OrgTaxVerImportPlugin_39", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), orgNumber);
            errors.append(message).append("\n");
            return;
        }
    }

    private StringBuilder checkFields(JSONObject data, boolean isMainInfo, StringBuilder errors) {
        block14: {
            block13: {
                if (!isMainInfo) break block13;
                Map isEntityRelateFields = new TaxcMainConstant().getIsEntityRelateFields();
                String taxationNumber = data.getJSONObject("taxationsys").getString("number");
                String taxationName = data.getJSONObject("taxationsys").getString("name");
                for (Map.Entry entry : isEntityRelateFields.entrySet()) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)taxationNumber, (CharSequence)"001")) {
                        ArrayList list = Lists.newArrayList((Object[])new String[]{"taxoffice", "accountingstandards", "registertype", "codeandname"});
                        if (!data.getBoolean("registerplace").booleanValue()) {
                            list.add("registertime");
                            list.add("registeraddress");
                            list.add("actualaddress");
                        }
                        if (list.contains(entry.getKey()) || null != data.get(entry.getKey())) continue;
                        String message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a\"%s\"\u3002", (String)"OrgTaxVerImportPlugin_32", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), entry.getValue());
                        errors.append(message).append("\n");
                        continue;
                    }
                    if (null != data.get(entry.getKey())) continue;
                    String message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a\"%s\"\u3002", (String)"OrgTaxVerImportPlugin_32", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), entry.getValue());
                    errors.append(message).append("\n");
                }
                if (!ObjectUtils.isNotEmpty((Object)data.getJSONObject("registertype"))) break block14;
                String registertypeNumber = data.getJSONObject("registertype").getString("number");
                String registertypeName = data.getJSONObject("registertype").getString("name");
                DynamicObject[] registerTypes = BusinessDataServiceHelper.load((String)"tax_info_registertype", (String)"id,number,name,enable,taxationsys", (QFilter[])new QFilter[]{new QFilter("taxationsys.number", "=", (Object)taxationNumber)});
                List registNumberList = Arrays.stream(registerTypes).map(type -> type.getString("number")).collect(Collectors.toList());
                if (registNumberList.contains(registertypeNumber)) break block14;
                String message = String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6%1$s\uff0c\u4e0d\u5b58\u5728\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b%2$s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"OrgTaxVerImportPlugin_40", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), taxationName, registertypeName);
                errors.append(message).append("\n");
                break block14;
            }
            JSONArray bankInfos = data.getJSONArray("entryentity");
            if (null != bankInfos) {
                int count = 0;
                Map bankInfoFields = new TaxcMainConstant().getBankInfoFields();
                for (int i = 0; i < bankInfos.size(); ++i) {
                    Boolean taxacctFlag;
                    JSONObject info = bankInfos.getJSONObject(i);
                    if (Objects.isNull(info.get((Object)"taxacct"))) {
                        info.put("taxacct", (Object)false);
                    }
                    if ((taxacctFlag = (Boolean)info.get((Object)"taxacct")).booleanValue()) {
                        ++count;
                    }
                    for (Map.Entry entry : bankInfoFields.entrySet()) {
                        String message;
                        if (!taxacctFlag.booleanValue()) {
                            if ("tripleaggrement".equals(entry.getKey()) || null != info.get(entry.getKey())) continue;
                            message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a\"%s\"\u3002", (String)"OrgTaxVerImportPlugin_32", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), entry.getValue());
                            errors.append(message).append("\n");
                            continue;
                        }
                        if (null != info.get(entry.getKey())) continue;
                        message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a\"%s\"\u3002", (String)"OrgTaxVerImportPlugin_32", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), entry.getValue());
                        errors.append(message).append("\n");
                    }
                }
                if (count > 1) {
                    String message = String.format(ResManager.loadKDString((String)"\u6bcf\u4e2a\u7eb3\u7a0e\u4e3b\u4f53\u53ea\u80fd\u6709\u4e00\u4e2a\u94f6\u884c\u4fe1\u606f\u7684\u201c\u7f34\u7a0e\u8d26\u6237\u201d\u586b\u5199\u4e3a\u201c\u662f\u201d\u3002", (String)"OrgTaxVerImportPlugin_41", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), new Object[0]);
                    errors.append(message).append("\n");
                }
            }
            JSONArray shareHolders = data.getJSONArray("entryentity1");
            Map shareHolderFields = new TaxcMainConstant().getShareHolderFields();
            if (null != shareHolders) {
                for (int i = 0; i < shareHolders.size(); ++i) {
                    for (Map.Entry entry : shareHolderFields.entrySet()) {
                        JSONObject holder = shareHolders.getJSONObject(i);
                        if (null != holder.get(entry.getKey())) continue;
                        String message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a\"%s\"\u3002", (String)"OrgTaxVerImportPlugin_32", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), entry.getValue());
                        errors.append(message).append("\n");
                    }
                }
            }
        }
        return errors;
    }

    private boolean exist(String orgNumber) {
        return null != QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
    }
}

