/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org.ver;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.enums.TaxTypeComboEnum;

public class TaxVerChangPlugin
extends AbstractListPlugin
implements ListboxClickListener {
    private static final String LISTBOX = "listboxap";
    private static final String ORG = "orgid";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CACHE_TAX_TYPE_CODE = "cache_taxtypecode";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("normalentity");
        billList.addSetFilterListener(this::setFilter);
        BillList xfsbillList = (BillList)this.getControl("xfsentity");
        xfsbillList.addSetFilterListener(this::setFilter);
        BillList yhsbillList = (BillList)this.getControl("yhsentity");
        yhsbillList.addSetFilterListener(this::setFilter);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String taxtype = this.getPageCache().get(CACHE_TAX_TYPE_CODE);
        if (EmptyCheckUtils.isEmpty((Object)taxtype)) {
            taxtype = TaxTypeComboEnum.ZZS.getCode();
        }
        TaxTypeComboEnum taxTypeComboEnum = TaxTypeComboEnum.getEnumByCode((String)taxtype);
        List list = args.getListColumns();
    }

    public void setFilter(SetFilterEvent e) {
        String orgIdStr = String.valueOf(this.getModel().getValue(ORG));
        QFilter qFilter = new QFilter("org.id", "=", (Object)Long.parseLong(orgIdStr));
        String taxtype = this.getPageCache().get(CACHE_TAX_TYPE_CODE);
        QFilter qFilter2 = new QFilter("taxtype", "=", (Object)taxtype);
        qFilter.and(qFilter2);
        List qFilters = e.getQFilters();
        qFilters.add(qFilter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initOrg();
        this.initLeftMenu();
        this.select(TaxTypeComboEnum.ZZS.getCode());
    }

    private void initOrg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isNotEmpty((Object)customParams) && EmptyCheckUtils.isNotEmpty(customParams.get(ORG))) {
            this.getModel().setValue(ORG, customParams.get(ORG));
        }
    }

    private void select(String index) {
        Listbox listbox = (Listbox)this.getControl(LISTBOX);
        listbox.listboxClick(index);
    }

    public void registerListener(EventObject e) {
        Listbox listbox = (Listbox)this.getControl(LISTBOX);
        listbox.addListboxClickListener((ListboxClickListener)this);
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String key = listboxEvent.getItemId();
        String sourceKey = ((Listbox)listboxEvent.getSource()).getKey();
        if (sourceKey.equalsIgnoreCase(LISTBOX)) {
            this.displayTaxVerInfo(key);
        }
    }

    private void displayTaxVerInfo(String key) {
        TaxTypeComboEnum taxTypeComboEnum = TaxTypeComboEnum.getEnumByCode((String)key);
        this.getView().setVisible(Boolean.TRUE, new String[]{taxTypeComboEnum.getDisplayControl()});
        this.getView().setVisible(Boolean.FALSE, taxTypeComboEnum.getHideControl().split(","));
        this.getPageCache().put(CACHE_TAX_TYPE_CODE, key);
        String orgIdStr = String.valueOf(this.getModel().getValue(ORG));
        QFilter qFilter = new QFilter("org.id", "=", (Object)Long.parseLong(orgIdStr));
        QFilter qFilter2 = new QFilter("taxtype", "=", (Object)key);
        qFilter.and(qFilter2);
        BillList billList = (BillList)this.getView().getControl(taxTypeComboEnum.getDisplayControl());
        billList.setFilter(qFilter);
        billList.refresh();
    }

    private void initLeftMenu() {
        Listbox listbox = (Listbox)this.getControl(LISTBOX);
        List listboxItemList = TaxTypeComboEnum.generalListboxItems();
        listbox.addItems(listboxItemList);
        listbox.addListboxClickListener((ListboxClickListener)this);
    }
}

