/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.param;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.common.json.JsonUtil;
import kd.taxc.common.param.ParamUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.enums.ParamEnum;
import kd.taxc.tctb.business.param.ParamBusiness;

public class TaxParamListPlugin
extends TemplateTreePlugin {
    private static final String TAXC_TAXPARAM = "tctb_taxparam";
    private static final String GROUP = "group";
    private static final String PARAMKEY = "paramkey";
    private static Log logger = LogFactory.getLog(TaxParamListPlugin.class);

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnedit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndel"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeListModel tree = (TreeListModel)e.getSource();
        tree.getTreeFilter().add(new QFilter("id", "in", this.getTaxcParamAppIDs().get("taxcParamAppIDs")));
    }

    public void setFilter(SetFilterEvent e) {
        if (EmptyCheckUtils.isEmpty((Object)e.getMainOrgQFilter())) {
            return;
        }
        ArrayList orgid = (ArrayList)e.getMainOrgQFilter().getValue();
        List<Long> idInApply = TaxParamListPlugin.getIdIApply((Long)orgid.get(0));
        if (EmptyCheckUtils.isEmpty(idInApply)) {
            return;
        }
        QFilter notInApply = new QFilter("id", "not in", idInApply);
        ArrayList<QFilter> custom = new ArrayList<QFilter>();
        custom.add(notInApply);
        e.setCustomQFilters(custom);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        long userDefaultOrgID = RequestContext.get().getOrgId();
        Object tamBaseInitOrg = this.getView().getFormShowParameter().getCustomParam("tamBaseInitOrg");
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)tamBaseInitOrg)) {
            userDefaultOrgID = Long.parseLong(String.valueOf(tamBaseInitOrg));
        }
        ((FilterColumn)args.getCommonFilterColumns().get(0)).setDefaultValue(String.valueOf(userDefaultOrgID));
        ArrayList<Long> orgids = new ArrayList<Long>(12);
        orgids.add(userDefaultOrgID);
        this.lockDrainData(orgids);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getView().getFormShowParameter().getParentFormId(), (CharSequence)"tctb_taxparam_plan")) {
            return;
        }
        Object orgid = args.getSearchClickEvent().getFilterValue("org.id");
        List<Object> orgids = new ArrayList(12);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)orgid)) {
            if (orgid instanceof List) {
                orgids = (ArrayList)orgid;
            } else {
                orgids.add(ObjectUtils.toLong((Object)orgid));
            }
            logger.info("TaxParamListPlugin.filterContainerSearchClick,orgid:{}", orgid);
        }
        if (EmptyCheckUtils.isEmpty(orgids)) {
            List schemelist;
            ArrayList<QFilter> orgFilters = new ArrayList<QFilter>();
            Map filterValues = args.getFilterValues();
            if (filterValues != null && (schemelist = (List)filterValues.get("schemefilter")) != null && schemelist.size() > 0) {
                for (Map map : schemelist) {
                    if (map.get("FieldName") == null || !"org.name".equals(((List)map.get("FieldName")).get(0))) continue;
                    String compare = (String)((List)map.get("Compare")).get(0);
                    String value = (String)((List)map.get("Value")).get(0);
                    String cp = this.getQCP(compare);
                    if (compare.equals("37")) {
                        orgFilters.add(new QFilter("name", "=", (Object)""));
                        continue;
                    }
                    if (compare.equals("106") || compare.equals("109") || compare.equals("112") || compare.equals("113")) {
                        orgFilters.add(new QFilter("name", "in", args.getQFilter("org.name").getValue()));
                        continue;
                    }
                    if (!EmptyCheckUtils.isNotEmpty((Object)value)) continue;
                    if (compare.equals("59")) {
                        value = "%" + value + "%";
                    } else if (compare.equals("58")) {
                        value = "%" + value + "%";
                    } else if (compare.equals("60")) {
                        value = value + "%";
                    } else if (compare.equals("211")) {
                        value = "%" + value;
                    }
                    orgFilters.add(new QFilter("name", cp, (Object)value));
                }
            }
            if (orgFilters.size() == 0) {
                orgFilters.add(new QFilter("id", "=", (Object)RequestContext.get().getOrgId()));
            }
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])orgFilters.toArray(new QFilter[0]));
            orgids = Stream.of(orgs).map(org -> org.getLong("id")).collect(Collectors.toList());
        }
        this.lockDrainData(orgids);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List filter;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Refresh && EmptyCheckUtils.isNotEmpty((Object)(filter = this.getControlFilters().getFilter("org.id")))) {
            ArrayList<Long> orgids = new ArrayList<Long>(12);
            for (Object id : filter) {
                orgids.add(Long.valueOf((String)id));
            }
            this.lockDrainData(orgids);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtil.equalsIgnoreCase((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"createapply")) {
            List orgids = this.getControlFilters().getFilter("org.id");
            long orgId = Long.parseLong(orgids.get(0).toString());
            ListSelectedRowCollection rows = this.getSelectedRows();
            List selIds = Stream.of(rows.getPrimaryKeyValues()).map(id -> (Long)id).collect(Collectors.toList());
            DynamicObject[] params = ParamBusiness.queryParamById(selIds, (String)"org.id,paramkey,pagekey");
            if (OrgUnitServiceHelper.getRootOrgId() != orgId) {
                for (DynamicObject param : params) {
                    if (!ParamUtil.isGroupControl((String)param.getString("pagekey"), (String)param.getString(PARAMKEY)).booleanValue()) continue;
                    String erro = ResManager.loadKDString((String)"\u975e\u6839\u7ec4\u7ec7\u65e0\u6cd5\u4fee\u6539%s\u3002", (String)"TaxParamListPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(String.format(erro, param.getString("paramname")));
                    return;
                }
            }
            List<Long> idInApply = TaxParamListPlugin.getIdIApply(Long.valueOf((String)orgids.get(0)));
            for (Long selId : selIds) {
                if (!idInApply.contains(selId)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53c2\u6570\u5305\u542b\u5df2\u5728\u7533\u8bf7\u6d41\u7a0b\u4e2d\u7684\u53c2\u6570\uff0c\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u3002", (String)"TaxParamListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("tctb_param_apply");
            parameter.setStatus(OperationStatus.ADDNEW);
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            parameter.setOpenStyle(openStyle);
            HashMap cusParam = new HashMap();
            cusParam.put("ids", selIds);
            parameter.setCustomParams(cusParam);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"viewapply")) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setFormId("bos_list");
            parameter.setBillFormId("tctb_param_apply");
            parameter.setStatus(OperationStatus.VIEW);
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            parameter.setOpenStyle(openStyle);
            HashMap cusParam = new HashMap();
            parameter.setCustomParams(cusParam);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("group.name".equals(args.getFieldName())) {
            args.getCustomQFilters();
            args.addCustomQFilter(new QFilter("id", "in", this.getTaxcParamAppIDs().get("taxcParamAppIDs")));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String flag = (String)this.getView().getFormShowParameter().getCustomParam("hide");
        if (StringUtil.equalsIgnoreCase((CharSequence)flag, (CharSequence)"1")) {
            List listColumns = args.getListColumns();
            Iterator iterator = listColumns.iterator();
            while (iterator.hasNext()) {
                AbstractListColumn column = (AbstractListColumn)iterator.next();
                String name = column.getListFieldKey();
                if (!StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"org.number") && !StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"org.name") && !StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"paramvalue")) continue;
                iterator.remove();
            }
        }
    }

    public void lockDrainData(List<Long> orgids) {
        CopyOnWriteArrayList locks = new CopyOnWriteArrayList();
        try {
            orgids = orgids.stream().filter(id -> TaxParamListPlugin.tryLock("taxc_tdm_enterParamList", locks, id)).collect(Collectors.toList());
            this.drainData(orgids);
        }
        finally {
            locks.forEach(lock -> {
                if (lock != null) {
                    lock.unlock();
                }
            });
        }
    }

    public void drainData(List<Long> orgids) {
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>();
        Map<String, Object> map = this.getTaxcParamAppIDs();
        Map<String, DataEntityPropertyCollection> appID_PropertiesMap = this.getAppID_PropertiesMap(map);
        Map<String, String> appID_formMap = this.getAppID_FormMap(map);
        Map taxAppMap = (Map)map.get("taxAppMap");
        AppParam param = new AppParam();
        for (Long orgid : orgids) {
            for (Map.Entry<String, DataEntityPropertyCollection> appEntry : appID_PropertiesMap.entrySet()) {
                String appID = appEntry.getKey();
                DataEntityPropertyCollection properties = appEntry.getValue();
                param.setOrgId(orgid);
                param.setAppId(appID);
                if (this.ignoreApp(appID, taxAppMap)) continue;
                Map params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param);
                HashMap<String, String> avalibleVal = new HashMap<String, String>();
                for (IDataEntityProperty property : properties) {
                    String name = property.getName();
                    if (params.containsKey(name)) continue;
                    params.put(name, null);
                }
                for (Map.Entry paramEntry : params.entrySet()) {
                    String json;
                    DynamicObject taxParam = BusinessDataServiceHelper.newDynamicObject((String)TAXC_TAXPARAM);
                    IDataEntityProperty component = (IDataEntityProperty)properties.get((Object)((String)paramEntry.getKey()));
                    if (component instanceof BasedataProp || component instanceof LongProp || this.ignoreKey(appID, (String)paramEntry.getKey(), taxAppMap)) continue;
                    taxParam.set("org", (Object)orgid);
                    taxParam.set(GROUP, (Object)appID);
                    taxParam.set(PARAMKEY, paramEntry.getKey());
                    String paramName = ParamEnum.getParamName((String)((String)taxAppMap.get(appID)), (String)paramEntry.getKey().toString());
                    if (EmptyCheckUtils.isEmpty((Object)paramName)) {
                        paramName = component.getDisplayName().getLocaleValue();
                    }
                    taxParam.set("paramname", (Object)paramName);
                    taxParam.set("pagekey", (Object)appID_formMap.get(appID));
                    if (component instanceof ComboProp) {
                        if (component instanceof MulComboProp) {
                            taxParam.set("ismultiple", (Object)"1");
                        } else {
                            taxParam.set("ismultiple", (Object)"0");
                        }
                        for (ValueMapItem comboItem : ((ComboProp)component).getComboItems()) {
                            if (!comboItem.isItemVisible()) continue;
                            avalibleVal.put(comboItem.getValue(), comboItem.getName().getLocaleValue());
                        }
                        json = JsonUtil.toJson(avalibleVal);
                        taxParam.set("avalibleval", (Object)json);
                    } else if (component instanceof BooleanProp) {
                        avalibleVal.put("true", ResManager.loadKDString((String)"\u662f", (String)"TaxParamListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        avalibleVal.put("false", ResManager.loadKDString((String)"\u5426", (String)"TaxParamListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        JsonUtil.toJson(avalibleVal);
                        json = JsonUtil.toJson(avalibleVal);
                        taxParam.set("avalibleval", (Object)json);
                        taxParam.set("ismultiple", (Object)"0");
                    }
                    String[] splitedVal = String.valueOf(paramEntry.getValue()).split(",", -1);
                    if (StringUtil.equalsIgnoreCase((CharSequence)taxParam.getString("ismultiple"), (CharSequence)"1")) {
                        String vals = this.convert(splitedVal, avalibleVal);
                        taxParam.set("paramvalue", (Object)vals);
                    } else {
                        taxParam.set("paramvalue", avalibleVal.get(String.valueOf(paramEntry.getValue())));
                    }
                    avalibleVal.clear();
                    taxParam.set("enable", (Object)"1");
                    taxParam.set("status", (Object)"C");
                    QFilter f1 = new QFilter("org", "=", (Object)orgid);
                    QFilter f2 = new QFilter(GROUP, "=", (Object)appID);
                    QFilter f3 = new QFilter(PARAMKEY, "=", paramEntry.getKey());
                    if (QueryServiceHelper.exists((String)TAXC_TAXPARAM, (QFilter[])new QFilter[]{f1, f2, f3})) {
                        DynamicObject oldData = BusinessDataServiceHelper.loadSingle((String)TAXC_TAXPARAM, (String)"id", (QFilter[])new QFilter[]{f1, f2, f3});
                        taxParam.set("id", (Object)oldData.getLong("id"));
                        updates.add(taxParam);
                        continue;
                    }
                    saves.add(taxParam);
                }
            }
        }
        if (EmptyCheckUtils.isNotEmpty(updates)) {
            SaveServiceHelper.update((DynamicObject[])updates.toArray(new DynamicObject[0]));
        }
        if (EmptyCheckUtils.isNotEmpty(saves)) {
            SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        }
    }

    protected boolean ignoreApp(String appId, Map<String, String> taxAppMap) {
        return this.getIgnoreApps() != null && taxAppMap != null && this.getIgnoreApps().contains(taxAppMap.get(appId));
    }

    protected boolean ignoreKey(String appId, String key, Map<String, String> taxAppMap) {
        return this.getIgnorekeys() != null && taxAppMap != null && this.getIgnorekeys().contains(taxAppMap.get(appId) + "." + key);
    }

    protected List getIgnoreApps() {
        return null;
    }

    protected List getIgnorekeys() {
        ArrayList<String> ignoreAppIdParamkeys = new ArrayList<String>();
        ignoreAppIdParamkeys.add("tctb.unpackaudit");
        ignoreAppIdParamkeys.add("tctb.packaudit");
        ignoreAppIdParamkeys.add("tctb.bdaudittype");
        return ignoreAppIdParamkeys;
    }

    public Map<String, DataEntityPropertyCollection> getAppID_PropertiesMap(Map<String, Object> map) {
        List taxcParamAppIDs = (List)map.get("taxcParamAppIDs");
        List taxcParamFormIDs = (List)map.get("taxcParamFormIDs");
        HashMap<String, DataEntityPropertyCollection> appID_PropertiesMap = new HashMap<String, DataEntityPropertyCollection>(16);
        for (int i = 0; i < taxcParamFormIDs.size(); ++i) {
            String formID = (String)taxcParamFormIDs.get(i);
            String appID = (String)taxcParamAppIDs.get(i);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formID);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            appID_PropertiesMap.put(appID, properties);
        }
        return appID_PropertiesMap;
    }

    public Map<String, String> getAppID_FormMap(Map<String, Object> map) {
        List taxcParamAppIDs = (List)map.get("taxcParamAppIDs");
        List taxcParamFormIDs = (List)map.get("taxcParamFormIDs");
        HashMap<String, String> appID_FormMap = new HashMap<String, String>(16);
        for (int i = 0; i < taxcParamFormIDs.size(); ++i) {
            String formID = (String)taxcParamFormIDs.get(i);
            String appID = (String)taxcParamAppIDs.get(i);
            appID_FormMap.put(appID, formID);
        }
        return appID_FormMap;
    }

    public Map<String, Object> getTaxcParamAppIDs() {
        QFilter taxcFilter = new QFilter("bizcloud.number", "=", (Object)"TAXC");
        DynamicObject[] taxcApps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])taxcFilter.toArray());
        List appIDs = Stream.of(taxcApps).map(item -> item.getString("id")).collect(Collectors.toList());
        Map<String, String> taxAppMap = Stream.of(taxcApps).collect(Collectors.toMap(k -> k.getString("id"), v -> v.getString("number")));
        StringBuffer taxcParamFilter = new StringBuffer();
        taxcParamFilter.append('(');
        for (int i = 0; i < appIDs.size(); ++i) {
            taxcParamFilter.append('\'');
            taxcParamFilter.append((String)appIDs.get(i));
            taxcParamFilter.append('\'');
            if (i == appIDs.size() - 1) continue;
            taxcParamFilter.append(',');
        }
        taxcParamFilter.append(')');
        String sql = "select FID,FAPPID,FFORMID from t_bas_sysparaconsole where FENABLED ='1' and FAPPID in " + taxcParamFilter;
        DynamicObjectCollection taxcParamApps = SingleORM.query(null, (String)sql, null);
        ArrayList<String> taxcParamAppIDs = new ArrayList<String>();
        ArrayList<String> taxcParamFormIDs = new ArrayList<String>();
        ArrayList<String> taxcParamIDs = new ArrayList<String>();
        for (DynamicObject i : taxcParamApps) {
            String fappid = i.getString("FAPPID");
            String fformid = i.getString("FFORMID");
            String fid = i.getString("FID");
            taxcParamAppIDs.add(fappid);
            taxcParamFormIDs.add(fformid);
            taxcParamIDs.add(fid);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taxcParamAppIDs", taxcParamAppIDs);
        map.put("taxcParamFormIDs", taxcParamFormIDs);
        map.put("taxcParamIDs", taxcParamIDs);
        map.put("taxAppMap", taxAppMap);
        return map;
    }

    public String getQCP(String compareType) {
        switch (compareType) {
            case "59": {
                return "like";
            }
            case "58": {
                return "not like";
            }
            case "60": {
                return "like";
            }
            case "211": {
                return "like";
            }
            case "110": {
                return "=";
            }
            case "111": {
                return "in";
            }
            case "114": {
                return "!=";
            }
            case "115": {
                return "not in";
            }
        }
        return null;
    }

    public String convert(String[] splitedVal, Map<String, String> avalibleVal) {
        StringBuilder vals = new StringBuilder();
        for (String val : splitedVal) {
            if (!EmptyCheckUtils.isNotEmpty((Object)val)) continue;
            if (StringUtil.equalsIgnoreCase((CharSequence)val, (CharSequence)"null")) {
                vals.append(" ");
            } else {
                vals.append(avalibleVal.get(val));
            }
            vals.append('\uff1b');
        }
        return vals.toString();
    }

    public static List<Long> getIdIApply(Long orgid) {
        ArrayList<Long> orgids = new ArrayList<Long>();
        orgids.add(orgid);
        DynamicObject[] applys = ParamBusiness.queryNotAuditApplyByOrgId(orgids, (String)"entryentity.app, entryentity.paramname");
        if (EmptyCheckUtils.isEmpty((Object)applys)) {
            return Collections.emptyList();
        }
        ArrayList<Long> idInApply = new ArrayList<Long>();
        for (DynamicObject apply : applys) {
            for (DynamicObject param : apply.getDynamicObjectCollection("entryentity")) {
                DynamicObject paramId = ParamBusiness.queryFid((long)orgid, (String)param.getString("app.id"), (String)param.getString("paramname"));
                if (EmptyCheckUtils.isEmpty((Object)paramId)) {
                    logger.info("\u7a0e\u52a1\u53c2\u6570\u5217\u8868\uff1a\u7ec4\u7ec7\uff1a" + orgid + " \u6240\u5c5e\u5e94\u7528id&\u540d\u79f0\uff1a" + param.getString("app.id") + " " + param.getString("app.name") + " \u53c2\u6570\u540d\u79f0\uff1a" + param.getString("paramname"));
                    continue;
                }
                idInApply.add(paramId.getLong("id"));
            }
        }
        return idInApply;
    }

    private static boolean tryLock(String methodName, List<DLock> locks, Long id) {
        DLock lock = DLock.create((String)methodName.concat(String.valueOf(id)));
        if (lock.tryLock(30000L)) {
            locks.add(lock);
            return true;
        }
        return false;
    }
}

