/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.param;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.formula.utils.JsonUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.formplugin.param.TaxParamListPlugin;

public class TaxParamPlanPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String PARAM_NAME = "paramname";
    private static final String PARAM_VALUE = "paramvalue";
    private static final String ORG = "org";
    private static final String PARAM_ENTRY = "paramentry";
    private static final String ORG_ENTRY = "orgentry";
    private static final String TCTB_TAXPARAM_PLAN = "tctb_taxparam_plan";
    private static final String SAVECOPY = "savecopy";
    private static final String SAVECOPYID = "savecopyid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit paramEdit = (BasedataEdit)this.getControl(PARAM_NAME);
        paramEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        paramEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit paramValEdit = (BasedataEdit)this.getControl(PARAM_VALUE);
        paramValEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        paramValEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl(ORG);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Toolbar toolbarMain = (Toolbar)this.getControl("tbmain");
        toolbarMain.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String id = this.getPageCache().get(SAVECOPYID);
        if (StringUtil.isNotBlank((CharSequence)id)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(id), (DynamicObjectType)this.getModel().getDataEntityType());
            DynamicObjectCollection params = dynamicObject.getDynamicObjectCollection(PARAM_ENTRY);
            this.getModel().deleteEntryData(PARAM_ENTRY);
            params.stream().forEach(o -> {
                int rowIndex = this.getModel().createNewEntryRow(PARAM_ENTRY);
                this.getModel().setValue(PARAM_NAME, o.get(PARAM_NAME), rowIndex);
                this.getModel().setValue(PARAM_VALUE, o.get(PARAM_VALUE), rowIndex);
            });
            DynamicObjectCollection orgs = dynamicObject.getDynamicObjectCollection(ORG_ENTRY);
            this.getModel().deleteEntryData(ORG_ENTRY);
            orgs.stream().forEach(o -> {
                int rowIndex = this.getModel().createNewEntryRow(ORG_ENTRY);
                this.getModel().setValue(ORG, o.get(ORG), rowIndex);
            });
            this.getPageCache().remove(SAVECOPYID);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)PARAM_NAME)) {
            Long userDefaultOrgID = RequestContext.get().getOrgId();
            TaxParamListPlugin plugin = new TaxParamListPlugin();
            ArrayList<Long> id = new ArrayList<Long>();
            id.add(userDefaultOrgID);
            plugin.lockDrainData(id);
            QFilter paramFilter = new QFilter("org.id", "=", (Object)userDefaultOrgID);
            beforeF7SelectEvent.getCustomQFilters().add(paramFilter);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("hide", (Object)"1");
        } else if (StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)PARAM_VALUE)) {
            int curIndex = beforeF7SelectEvent.getRow();
            DynamicObject param = (DynamicObject)this.getModel().getValue(PARAM_NAME, curIndex);
            if (null != param) {
                Map avalible = JsonUtils.strToMap((String)param.getString("avalibleval"));
                QFilter paramFilter = new QFilter("key", "in", avalible.keySet());
                beforeF7SelectEvent.getCustomQFilters().add(paramFilter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53c2\u6570\u540d\u79f0", (String)"TaxParamPlanPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String op = evt.getItemKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)op, (CharSequence)"bar_save")) {
            if (this.duplicate().booleanValue()) {
                evt.setCancel(true);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)op, (CharSequence)SAVECOPY)) {
            if (this.duplicate().booleanValue()) {
                evt.setCancel(true);
            } else {
                this.getPageCache().put(SAVECOPY, "1");
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        int index = this.getModel().getEntryCurrentRowIndex(PARAM_ENTRY);
        String paramKey = this.getModel().getEntryRowEntity(PARAM_ENTRY, index).getString("paramname.paramkey");
        if (afterF7SelectEvent.getSource() instanceof MulBasedataEdit) {
            int selectNum = afterF7SelectEvent.getListSelectedRowCollection().size();
            if (StringUtil.equalsIgnoreCase((CharSequence)PARAM_VALUE, (CharSequence)((MulBasedataEdit)afterF7SelectEvent.getSource()).getKey()) && selectNum > 1) {
                String isMul = this.getModel().getEntryRowEntity(PARAM_ENTRY, index).getDynamicObject(PARAM_NAME).getString("ismultiple");
                if (StringUtil.equalsIgnoreCase((CharSequence)isMul, (CharSequence)"0")) {
                    this.getModel().setValue(PARAM_VALUE, null, index);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u53c2\u6570\u4e0d\u652f\u6301\u591a\u9009\u3002", (String)"TaxParamPlanPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)paramKey, (CharSequence)"hjtzrznd") || StringUtil.equalsIgnoreCase((CharSequence)paramKey, (CharSequence)"sjtzrznd")) {
                    ListSelectedRowCollection selectedRows = afterF7SelectEvent.getListSelectedRowCollection();
                    ArrayList<String> keys = new ArrayList<String>();
                    for (ListSelectedRow selectedRow : selectedRows) {
                        keys.add(selectedRow.getNumber());
                    }
                    if (keys.contains("jtzt_bn") && keys.contains("jtzt_sn") || keys.contains("bdzt_bn") && keys.contains("bdzt_sn")) {
                        this.getModel().setValue(PARAM_VALUE, null, index);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u8d26\u7c3f\u7684\u672c\u5e74\u9009\u9879\u4e0e\u4e0a\u5e74\u9009\u9879\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxParamPlanPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtil.equalsIgnoreCase((CharSequence)e.getProperty().getName(), (CharSequence)PARAM_NAME)) {
            int index = this.getModel().getEntryCurrentRowIndex(PARAM_ENTRY);
            this.getModel().setValue(PARAM_VALUE, null, index);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (result.isSuccess() && StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get(SAVECOPY), (CharSequence)"1")) {
                List ids = result.getSuccessPkIds();
                this.getPageCache().put(SAVECOPYID, ids.get(0).toString());
                this.getPageCache().put("isSuccess", "1");
            }
            this.getPageCache().remove(SAVECOPY);
        }
    }

    public Boolean duplicate() {
        DynamicObjectCollection orgEntrys = this.getModel().getEntryEntity(ORG_ENTRY);
        DynamicObjectCollection paramEntrys = this.getModel().getEntryEntity(PARAM_ENTRY);
        for (DynamicObject orgEntry : orgEntrys) {
            Long orgid = orgEntry.getLong("org.id");
            for (DynamicObject paramEntry : paramEntrys) {
                String paramKey = paramEntry.getString("paramname.paramkey");
                String groupid = paramEntry.getString("paramname.group.id");
                QFilter f1 = new QFilter("orgentry.org.id", "=", (Object)orgid);
                QFilter f2 = new QFilter("paramentry.paramname.paramkey", "=", (Object)paramKey);
                QFilter f3 = new QFilter("id", "!=", this.getModel().getValue("id"));
                QFilter f4 = new QFilter("paramentry.paramname.group.id", "=", (Object)groupid);
                DynamicObject exist = BusinessDataServiceHelper.loadSingle((String)TCTB_TAXPARAM_PLAN, (String)"name,paramentry.paramname", (QFilter[])new QFilter[]{f1, f2, f3, f4});
                if (null == exist) continue;
                StringBuilder buffer = new StringBuilder();
                buffer.append(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u7684%2$s\u5e94\u7528%3$s\u53c2\u6570\u5df2\u5728%4$s\u65b9\u6848\u4e2d\u8bbe\u7f6e\uff0c\u8bf7\u5728%5$s\u65b9\u6848\u4e2d\u4fee\u6539\u3002", (String)"TaxParamPlanPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), orgEntry.getString("org.name"), paramEntry.getString("paramname.group.name"), paramEntry.getString("paramname.paramname"), exist.getString("name"), exist.getString("name")));
                String msg = buffer.toString();
                this.getView().showErrorNotification(msg);
                return true;
            }
        }
        return false;
    }
}

