/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.param;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;

public class TaxParamPlugin
extends AbstractFormPlugin {
    private static String PARAM_VALUE = "paramvalue";
    private static String AVALIBLE_VAL = "avalibleval";
    private static String PARAM_KEY = "paramkey";
    private static String MUL_VALUE = "mulvalue";
    private static String IS_MULTIPLE = "ismultiple";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ComboEdit combo = (ComboEdit)this.getControl(PARAM_VALUE);
        ComboEdit combo2 = (ComboEdit)this.getControl(MUL_VALUE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(12);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String avalibleVal = dataEntity.getString(AVALIBLE_VAL);
        String paramValue = dataEntity.getString(PARAM_VALUE);
        JSONObject avalibleValJSON = (JSONObject)JSONObject.parse((String)avalibleVal);
        for (Map.Entry entry : avalibleValJSON.entrySet()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(String.valueOf(entry.getValue())));
            item.setValue(String.valueOf(entry.getKey()));
            items.add(item);
        }
        combo.setComboItems(items);
        combo2.setComboItems(items);
        if (StringUtil.equalsIgnoreCase((CharSequence)dataEntity.getString(IS_MULTIPLE), (CharSequence)"1")) {
            String[] split = paramValue.split("\uff1b", -1);
            List splitedVal = Stream.of(split).filter(val -> EmptyCheckUtils.isNotEmpty((Object)val)).collect(Collectors.toList());
            StringBuffer mulVal = new StringBuffer();
            mulVal.append(',');
            for (Map.Entry entry : avalibleValJSON.entrySet()) {
                if (!splitedVal.contains(entry.getValue())) continue;
                mulVal.append(entry.getKey());
                mulVal.append(',');
            }
            this.getModel().setValue(MUL_VALUE, (Object)mulVal);
        } else {
            for (Map.Entry entry : avalibleValJSON.entrySet()) {
                if (!entry.getValue().equals(paramValue)) continue;
                this.getModel().setValue(PARAM_VALUE, entry.getKey());
                break;
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && this.haveConflict().booleanValue()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u8d26\u7c3f\u7684\u672c\u5e74\u9009\u9879\u4e0e\u4e0a\u5e74\u9009\u9879\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxParamPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
    }

    public Boolean haveConflict() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String paramKey = dataEntity.getString(PARAM_KEY);
        String mulVal = dataEntity.getString(MUL_VALUE);
        String[] splitedVAl = mulVal.split(",", -1);
        List list = Stream.of(splitedVAl).collect(Collectors.toList());
        if ((StringUtil.equalsIgnoreCase((CharSequence)paramKey, (CharSequence)"hjtzrznd") || StringUtil.equalsIgnoreCase((CharSequence)paramKey, (CharSequence)"sjtzrznd")) && (list.contains("jtzt_bn") && list.contains("jtzt_sn") || list.contains("bdzt_bn") && list.contains("bdzt_sn"))) {
            return true;
        }
        return false;
    }
}

