/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.provision;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.formplugin.accessconfig.AbstractAccessConfigPlugin;

public class ProvisionRuleConfigPlugin
extends AbstractAccessConfigPlugin
implements BeforeF7SelectListener,
CellClickListener {
    private static final String Key_filtergridap = "filtergridap";
    public static final String KEY_DATASOURCE = "datasource";
    private static final String EQUEAL = "67";
    private static final String CONTAIN = "59";
    private static final String NOT_CONTAIN = "58";
    public static final String ENTRYENTITY = "entryentity";
    public static final String DATASOURCE = "datasource";
    public static final String DATASOURCETEXT = "datasourcetext";

    public void initialize() {
        super.initialize();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            boolean composite = (Boolean)this.getModel().getValue("composite", focusRow);
            if ("setting".equals(key)) {
                if (composite) {
                    this.openDataSourceConfigPage(focusRow, null, false);
                } else {
                    super.beforeDoOperation(args);
                }
            } else if ("setadvancedconf".equals(key)) {
                Optional<DynamicObject> first;
                DynamicObject tableValue = (DynamicObject)this.getModel().getValue("table", focusRow);
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield", focusRow);
                if (amountfield == null) {
                    return;
                }
                long entryId = amountfield.getLong("id");
                if (EntityV3Constant.ENTITY_V3.containsKey(tableValue.getString("entityname"))) {
                    first = tableValue.getDynamicObjectCollection(ENTRYENTITY).stream().filter(o -> "column".equals(o.getString("fieldname"))).findFirst();
                    if (first.isPresent()) {
                        amountfield = first.get();
                    }
                } else {
                    first = tableValue.getDynamicObjectCollection(ENTRYENTITY).stream().filter(o -> entryId == o.getLong("id")).findFirst();
                    if (first.isPresent()) {
                        amountfield = first.get();
                    }
                }
                String advancedconfjson = (String)this.getModel().getValue("advancedconfjson", focusRow);
                String datatype = (String)this.getModel().getValue("datatype", focusRow);
                BigDecimal vatrate = BigDecimal.ZERO;
                BigDecimal jsbl = BigDecimal.ONE;
                BigDecimal yzvatrate = BigDecimal.ZERO;
                if ("jsflqs".equals(datatype) || "cysldsqs".equals(datatype) || "sehshsj".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                } else if ("gjqs".equals(datatype)) {
                    jsbl = (BigDecimal)this.getModel().getValue("jsbl", focusRow);
                } else if ("yjjsflqs".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                    yzvatrate = (BigDecimal)this.getModel().getValue("yzvatrate", focusRow);
                } else if ("hsjhsse".equals(datatype) || "bhsjhsse".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                }
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate, jsbl, yzvatrate);
                if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson")) {
                    String exratejson = (String)this.getModel().getValue("exratejson", focusRow);
                    advanceConfDto.setConvertExrateJson(exratejson);
                }
                RuleTemplateService.operationConfigClick((AdvanceConfDto)advanceConfDto, (BeforeDoOperationEventArgs)args, (EntryGrid)entryentity, (DynamicObject)amountfield, (Long)tableValue.getLong("id"), (IFormView)this.getView(), (int)focusRow, (String)ENTRYENTITY, (IFormPlugin)this);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.loadEntryData();
    }

    public void afterBindData(EventObject e) {
        DynamicObject obj = this.getModel().getDataEntity().getDynamicObject("datasource");
        if (obj != null) {
            this.initFilterCondition(obj.getLong("id"), obj.getString("entityname"));
        } else {
            this.initFilterCondition(null, null);
        }
        String filterjson = this.getModel().getDataEntity().getString("filterjson_tag");
        if (StringUtils.isNotBlank((CharSequence)filterjson)) {
            this.setDataFilter(filterjson);
        }
        this.loadEntryData();
        if (this.isSystem()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"operationcolumnap", "operationfadvancedconf"});
        }
        this.getModel().setDataChanged(false);
    }

    private void loadEntryData() {
        int count = this.getModel().getEntryRowCount(ENTRYENTITY);
        this.getModel().beginInit();
        for (int i = 0; i < count; ++i) {
            Object value = this.getModel().getValue("composite", i);
            if (value == null) continue;
            Boolean composite = Boolean.parseBoolean(String.valueOf(value));
            List<String> fields = Arrays.asList("amountfield", "datatype", "datadirection");
            if (composite.booleanValue()) {
                String compositejson = (String)this.getModel().getValue("compositejson", i);
                if (StringUtils.isNotEmpty((CharSequence)compositejson)) {
                    this.getModel().setValue(DATASOURCETEXT, (Object)compositejson, i);
                }
                this.setMustInput(false, fields);
                continue;
            }
            DynamicObject table = (DynamicObject)this.getModel().getValue("table", i);
            if (table != null) {
                this.getModel().setValue(DATASOURCETEXT, (Object)table.getString("bizname"), i);
            }
            this.setMustInput(true, fields);
        }
        this.getModel().endInit();
        if (count > 0) {
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void setMustInputByComposite(int rowIndex) {
        Object value = this.getModel().getValue("composite", rowIndex);
        if (value != null) {
            Boolean composite = Boolean.parseBoolean(String.valueOf(value));
            List<String> fields = Arrays.asList("amountfield", "datatype", "datadirection");
            if (composite.booleanValue()) {
                this.setMustInput(false, fields);
            } else {
                this.setMustInput(true, fields);
            }
        }
    }

    private void setMustInput(Boolean mustInput, List<String> fields) {
        for (String field : fields) {
            FieldEdit control = (FieldEdit)this.getControl(field);
            if (null == control) continue;
            control.setMustInput(mustInput.booleanValue());
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("enable", (Object)"1");
        this.getModel().setValue("issystem", (Object)"0");
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("datasource".equals(propertyName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                this.initFilterCondition(newValue.getLong("id"), newValue.getString("entityname"));
            } else {
                this.initFilterCondition(null, null);
            }
            this.getModel().deleteEntryData(ENTRYENTITY);
        } else if ("composite".equals(propertyName)) {
            int rowIndex = changeData.getRowIndex();
            this.setMustInputByComposite(rowIndex);
            this.getModel().setValue("amountfield", null, rowIndex);
            this.getModel().setValue("advancedconf", null, rowIndex);
        } else {
            super.propertyChanged(e);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObject datasource;
        if (e.getEntryProp().getName().equals(ENTRYENTITY) && (datasource = this.getModel().getDataEntity().getDynamicObject("datasource")) != null) {
            int row = this.getModel().getEntryRowCount(ENTRYENTITY) - 1;
            this.getModel().setValue("table", (Object)datasource.getLong("id"), row);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (DATASOURCETEXT.equalsIgnoreCase(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int row = entryGrid.getEntryState().getFocusRow();
            Object value = this.getModel().getValue("composite", row);
            if (value != null && Boolean.parseBoolean(String.valueOf(value))) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DATASOURCETEXT);
                this.openDataSourceConfigPage(row, closeCallBack, true);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit dataSourceTextEdit = (TextEdit)this.getControl(DATASOURCETEXT);
        dataSourceTextEdit.addClickListener((ClickListener)this);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (DATASOURCETEXT.equals(actionId) && (returnData = evt.getReturnData()) != null) {
            Map returnMap = (Map)returnData;
            int rowIndex = Integer.parseInt((String)returnMap.get("row"));
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
            entryRowEntity.set("compositejson", returnMap.get("description"));
            entryRowEntity.set("compositejson_tag", returnMap.get("compositejson"));
            entryRowEntity.set(DATASOURCETEXT, returnMap.get("description"));
            this.getView().updateView(DATASOURCETEXT, rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    private String buildFilterJson() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        if (CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
            return "";
        }
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        return filterJson;
    }

    private void initFilterCondition(Long entityid, String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        if (entityid != null && StringUtils.isNotBlank((CharSequence)entityNumber)) {
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if ("gl_balance".equals(entityNumber)) {
                ((DynamicProperty)entityType.getFields().get("org")).setAlias("forgid");
                ((DynamicProperty)entityType.getFields().get("booktype")).setAlias("fbooktypeid");
                ((DynamicProperty)entityType.getFields().get("period")).setAlias("FPERIODID");
                ((DynamicProperty)entityType.getFields().get("endperiod")).setAlias("FENDPERIODID");
                ((DynamicProperty)entityType.getFields().get("accounttable")).setAlias("faccounttableid");
                ((DynamicProperty)entityType.getFields().get("account")).setAlias("FACCOUNTID");
                ((DynamicProperty)entityType.getFields().get("assgrp")).setAlias("fassgrpid");
                ((DynamicProperty)entityType.getFields().get("currency")).setAlias("FCURRENCYID");
                ((DynamicProperty)entityType.getFields().get("measureunit")).setAlias("FMEASUREUNITID");
            }
            if (EntityV3Constant.ENTITY_V3.containsKey(entityNumber) && entityType.getFields().containsKey("fetchitemtype") && entityType.getFields().containsKey("fetchitem")) {
                ((DynamicProperty)entityType.getFields().get("fetchitemtype")).setAlias("fetchitemtype");
                ((DynamicProperty)entityType.getFields().get("fetchitem")).setAlias("fetchitem");
            }
            List list = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
            QFilter tableIdQfilter = new QFilter("tableid", "=", (Object)entityid);
            QFilter wherestateQfilter = new QFilter("wherestate", "=", (Object)"1");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_datasource_entry", (String)"fieldname,bizsubname,fieldsubname", (QFilter[])new QFilter[]{tableIdQfilter, wherestateQfilter});
            HashMap replaceMap = new HashMap();
            ArrayList filterColumns = new ArrayList();
            list.stream().forEach(filterColumn -> {
                String type = (String)filterColumn.get("type");
                String fieldName = (String)filterColumn.get("fieldName");
                dynamicObjects.parallelStream().forEach(dynamicObject -> {
                    String bizsubname = dynamicObject.getString("bizsubname");
                    this.buildFilterColumn(entityNumber, replaceMap, filterColumns, (Map<String, Object>)filterColumn, type, fieldName, (DynamicObject)dynamicObject, bizsubname);
                });
            });
            filterGrid.setFilterColumns(filterColumns);
            filterGrid.setEntityNumber(entityNumber);
        } else {
            filterGrid.setFilterColumns(new ArrayList());
            filterGrid.setEntityNumber(null);
        }
        this.getView().updateView(Key_filtergridap);
    }

    private void buildFilterColumn(String entityNumber, Map<String, String> replaceMap, List<Map<String, Object>> filterColumns, Map<String, Object> filterColumn, String type, String fieldName, DynamicObject dynamicObject, String bizsubname) {
        if ("basedata".equals(type) || "enum".equals(type)) {
            if (fieldName.equals(dynamicObject.getString("fieldname")) || fieldName.split("\\.").length == 2 && fieldName.split("\\.")[0].equals(dynamicObject.getString("fieldname"))) {
                String oldCaption = (String)filterColumn.get("fieldCaption");
                if (entityNumber.equals("tccit_invest_dispose")) {
                    String newCaption = fieldName.startsWith("transtype.") || fieldName.startsWith("assetlosstype.") ? oldCaption.split("\\.")[1] : oldCaption.split("\\.")[0];
                    boolean anyMatch = filterColumns.stream().anyMatch(s -> s.get("fieldCaption").equals(newCaption));
                    if (!anyMatch) {
                        filterColumn.put("fieldCaption", newCaption);
                        filterColumns.add(filterColumn);
                    }
                } else if (fieldName.startsWith("row.")) {
                    boolean anyMatch;
                    boolean bl = anyMatch = fieldName.endsWith(".longnumber") || fieldName.endsWith(".fullname");
                    if (!anyMatch) {
                        ((List)filterColumn.get("compareTypes")).removeIf(dto -> !dto.getId().equals(EQUEAL));
                        filterColumns.add(filterColumn);
                    }
                } else {
                    if ("assetdata.assetclass".equals(filterColumn.get("fieldName")) || "assetdata.assetcode".equals(filterColumn.get("fieldName"))) {
                        return;
                    }
                    String newCaption = oldCaption;
                    if (newCaption.startsWith(ResManager.loadKDString((String)"\u5206\u5f55\u4f53", (String)"ProvisionRuleConfigPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0])) || newCaption.startsWith(ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"ProvisionRuleConfigPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]))) {
                        newCaption = newCaption.substring(4);
                    }
                    if ((entityNumber.equals("sim_vatinvoice") || entityNumber.equals("sim_vatinvoice_vehicles")) && "taxrate".equals(dynamicObject.getString("fieldname"))) {
                        if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("NO_TAXRATE"), "true")) {
                            return;
                        }
                        newCaption = ResManager.loadKDString((String)"\u7a0e\u7387", (String)"ProvisionRuleConfigPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                    }
                    filterColumn.put("fieldCaption", newCaption);
                    replaceMap.put(oldCaption, newCaption);
                    filterColumns.add(filterColumn);
                }
            }
        } else if (fieldName.startsWith(dynamicObject.getString("fieldname"))) {
            replaceMap.put((String)filterColumn.get("fieldCaption"), bizsubname);
            filterColumn.put("fieldCaption", bizsubname);
            if (fieldName.equals("assgrp") && ("gl_voucher".equals(entityNumber) || "gl_balance".equals(entityNumber))) {
                ((List)filterColumn.get("compareTypes")).removeIf(dto -> !dto.getId().equals(CONTAIN) && !dto.getId().equals(NOT_CONTAIN));
            }
            if (fieldName.equals("swczsyss") && "tccit_invest_dispose".equals(entityNumber)) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (customParams.get("ruleCode").equals("RULE-CIT-HJ-SRTZ-TZZCCZSY")) {
                    ((List)filterColumn.get("items")).removeIf(s -> !s.getValue().equals("1"));
                } else if (customParams.get("ruleCode").equals("RULE-CIT-HJ-ZCTZ-ZCSS-01")) {
                    ((List)filterColumn.get("items")).removeIf(s -> !s.getValue().equals("2"));
                }
            }
            filterColumns.add(filterColumn);
        }
    }

    private void setDataFilter(String dataFilter) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.SetValue(filterCondition);
    }

    private void openDataSourceConfigPage(int row, CloseCallBack closeCallBack, boolean isEdit) {
        if (this.isSystem()) {
            return;
        }
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tctb_jtgz_datasource_form");
        formshowParameter.setCustomParam("row", (Object)row);
        formshowParameter.setStatus(isEdit ? OperationStatus.EDIT : OperationStatus.VIEW);
        formshowParameter.setCustomParam("compositejson", this.getModel().getValue("compositejson_tag", row));
        formshowParameter.setCloseCallBack(closeCallBack);
        DynamicObject datasource = this.getModel().getDataEntity().getDynamicObject("datasource");
        if (datasource != null) {
            formshowParameter.setCustomParam("table", (Object)datasource.getLong("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId) {
        if (this.isSystem()) {
            return;
        }
        super.openSettingPage(rowIndex, entityId, entityNumber, entityfield, conditionjson, actionId);
    }

    private boolean isSystem() {
        Object value = this.getModel().getValue("issystem");
        return value != null && "1".equalsIgnoreCase(value.toString());
    }

    private void buildEntryData() {
        String json = this.buildFilterJson();
        if (EmptyCheckUtils.isEmpty((Object)json)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u89c4\u5219\u542f\u7528\u6761\u4ef6", (String)"ProvisionRuleConfigPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("filterjson_tag", (Object)json);
    }
}

