/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.provision;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.formplugin.accessconfig.AbstractAccessConfigPlugin;

public class ProvisionRuleDataSourceConfigPlugin
extends AbstractAccessConfigPlugin
implements BeforeF7SelectListener,
CellClickListener {
    public static final String ENTRYENTITY = "entryentity";
    public static final String DATASOURCE = "datasource";

    public void initialize() {
        super.initialize();
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (null != entry) {
            entry.addCellClickListener((CellClickListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            if ("setting".equals(key)) {
                super.beforeDoOperation(args);
            } else if ("setadvancedconf".equals(key)) {
                Optional<DynamicObject> first;
                DynamicObject tableValue = (DynamicObject)this.getModel().getValue("table", focusRow);
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield", focusRow);
                if (amountfield == null) {
                    return;
                }
                long entryId = amountfield.getLong("id");
                if (EntityV3Constant.ENTITY_V3.containsKey(tableValue.getString("entityname"))) {
                    first = tableValue.getDynamicObjectCollection(ENTRYENTITY).stream().filter(o -> "column".equals(o.getString("fieldname"))).findFirst();
                    if (first.isPresent()) {
                        amountfield = first.get();
                    }
                } else {
                    first = tableValue.getDynamicObjectCollection(ENTRYENTITY).stream().filter(o -> entryId == o.getLong("id")).findFirst();
                    if (first.isPresent()) {
                        amountfield = first.get();
                    }
                }
                String advancedconfjson = (String)this.getModel().getValue("advancedconfjson", focusRow);
                String datatype = (String)this.getModel().getValue("datatype", focusRow);
                BigDecimal vatrate = BigDecimal.ZERO;
                BigDecimal jsbl = BigDecimal.ONE;
                BigDecimal yzvatrate = BigDecimal.ZERO;
                if ("jsflqs".equals(datatype) || "cysldsqs".equals(datatype) || "sehshsj".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                } else if ("gjqs".equals(datatype)) {
                    jsbl = (BigDecimal)this.getModel().getValue("jsbl", focusRow);
                } else if ("yjjsflqs".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                    yzvatrate = (BigDecimal)this.getModel().getValue("yzvatrate", focusRow);
                } else if ("hsjhsse".equals(datatype) || "bhsjhsse".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                }
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate, jsbl, yzvatrate);
                if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson")) {
                    String exratejson = (String)this.getModel().getValue("exratejson", focusRow);
                    advanceConfDto.setConvertExrateJson(exratejson);
                }
                RuleTemplateService.operationConfigClick((AdvanceConfDto)advanceConfDto, (BeforeDoOperationEventArgs)args, (EntryGrid)entryentity, (DynamicObject)amountfield, (Long)tableValue.getLong("id"), (IFormView)this.getView(), (int)focusRow, (String)ENTRYENTITY, (IFormPlugin)this);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

