/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.provision;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.FilterBuilderUtils;

public class ProvistonRuleDataSourceEditPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String OK = "btnok";
    private static final String CANCEL = "btncancel";
    private static final String TAX_TYPE = "taxtype";
    private static final String CLEAR = "clr";
    private static final String BACKSPACE = "backspace";
    private static final String ADD = "btnadd";
    private static final String SUBTRACTION = "btnsubtraction";
    private static final String MULTIPLICATION = "btnmultiplication";
    private static final String DIVISON = "btndivison";
    private static final String EQUAL = "btnequal";
    private static final String NOT_EQUAL = "btnnotequal";
    private static final String LESS_THAN = "btnlessthen";
    private static final String MORE_THAN = "btnmorethen";
    private static final String LESS_EQUAL = "btnlessequal";
    private static final String MORE_EQUAL = "btnmoreequal";
    private static final String AND = "btnand";
    private static final String OR = "btnor";
    private static final String LEFT = "btnleft";
    private static final String RIGHT = "btnright";
    protected static final String KEY_BASEDATATYPE = "basedatatype";
    public static final String ENTRYENTITY = "entryentity";
    public static final String DESCRIPTION = "description";
    public static final String EXPRESSION = "expression";
    public static final String TABLE = "table";
    public static final String BTNFUNCTION = "btnfunction";
    public static final String ROW = "row";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{OK, CANCEL});
        this.addClickListeners(new String[]{BTNFUNCTION, CLEAR, BACKSPACE});
        this.addClickListeners(new String[]{ADD, SUBTRACTION, MULTIPLICATION, DIVISON, EQUAL, NOT_EQUAL, LESS_THAN, MORE_THAN, LESS_EQUAL, MORE_EQUAL, AND, OR, LEFT, RIGHT});
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (null != entry) {
            entry.addCellClickListener((CellClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)BTNFUNCTION)) {
            this.showFuncSetting();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)CLEAR)) {
            this.getModel().setValue(EXPRESSION, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)EXPRESSION, (int)0);
            this.getModel().setValue(DESCRIPTION, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)DESCRIPTION, (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)BACKSPACE)) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)BACKSPACE, (String)EXPRESSION);
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)BACKSPACE, (String)DESCRIPTION);
        } else if (OK.equalsIgnoreCase(ctlSource.getKey())) {
            this.getModel().setDataChanged(false);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
            binder.setOnlyDbProperty(false);
            binder.setSerializeDefaultValue(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            String jsonString = jser.serializeToString((Object)dataEntity, null);
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put(ROW, String.valueOf(customParams.get(ROW)));
            returnMap.put("compositejson", jsonString);
            String description = this.getModel().getDataEntity().getString(DESCRIPTION);
            if (StringUtil.isNotEmpty((CharSequence)description)) {
                if (description.length() > 255) {
                    description = description.substring(0, 255);
                }
                returnMap.put(DESCRIPTION, description);
            }
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if (CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object table = customParams.get(TABLE);
        Object entryData = customParams.get("compositejson");
        if (EmptyCheckUtils.isNotEmpty(entryData)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tctb_jtgz_datasource_form");
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
            binder.setOnlyDbProperty(false);
            binder.setSerializeDefaultValue(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            DynamicObject object = (DynamicObject)jser.deserializeFromString((String)entryData, null);
            this.getModel().setValue(DESCRIPTION, (Object)object.getString(DESCRIPTION));
            this.getModel().setValue(EXPRESSION, (Object)object.getString(EXPRESSION));
            DynamicObjectCollection entries = object.getDynamicObjectCollection(ENTRYENTITY);
            this.getModel().deleteEntryData(ENTRYENTITY);
            for (DynamicObject entry : entries) {
                int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue(TABLE, entry.get(TABLE), rowIndex);
                DynamicObject tableObj = (DynamicObject)this.getModel().getValue(TABLE);
                if (EntityV3Constant.ENTITY_V3.containsKey(tableObj.getString("entityname"))) {
                    this.getModel().setValue(KEY_BASEDATATYPE, (Object)"tpo_col_member", rowIndex);
                } else {
                    this.getModel().setValue(KEY_BASEDATATYPE, (Object)"tctb_datasource_entry", rowIndex);
                }
                this.getModel().setValue("amountfield", entry.get("amountfield"), rowIndex);
                this.getModel().setValue("absolute", entry.get("absolute"), rowIndex);
                this.getModel().setValue("datatype", entry.get("datatype"), rowIndex);
                this.getModel().setValue("datadirection", entry.get("datadirection"), rowIndex);
                this.getModel().setValue("filtercondition", entry.get("filtercondition"), rowIndex);
                this.getModel().setValue("conditionjson", entry.get("conditionjson"), rowIndex);
                this.getModel().setValue("advancedconf", entry.get("advancedconf"), rowIndex);
                this.getModel().setValue("advancedconfjson", entry.get("advancedconfjson"), rowIndex);
            }
        } else if (table != null) {
            this.getModel().setValue(TABLE, table);
            DynamicObject tableObj = (DynamicObject)this.getModel().getValue(TABLE);
            if (EntityV3Constant.ENTITY_V3.containsKey(tableObj.getString("entityname"))) {
                this.getModel().setValue(KEY_BASEDATATYPE, (Object)"tpo_col_member");
            } else {
                this.getModel().setValue(KEY_BASEDATATYPE, (Object)"tctb_datasource_entry");
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object table = customParams.get(TABLE);
        int row = this.getModel().getEntryRowCount(ENTRYENTITY) - 1;
        if (table != null) {
            this.getModel().setValue(TABLE, table, row);
            DynamicObject tableObj = (DynamicObject)this.getModel().getValue(TABLE, row);
            if (EntityV3Constant.ENTITY_V3.containsKey(tableObj.getString("entityname"))) {
                this.getModel().setValue(KEY_BASEDATATYPE, (Object)"tpo_col_member", row);
            } else {
                this.getModel().setValue(KEY_BASEDATATYPE, (Object)"tctb_datasource_entry", row);
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        DynamicObject table;
        String fieldkey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        if ("add_formula".equals(fieldkey) && (table = (DynamicObject)this.getModel().getValue(TABLE, row)) != null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)table.getString("entityname"));
            if (!EntityV3Constant.ENTITY_V3.containsKey(table.getString("entityname"))) {
                DynamicObject obj = (DynamicObject)this.getModel().getValue("amountfield", row);
                if (obj != null) {
                    EntityType entityType;
                    long entryId = obj.getLong("id");
                    Optional<DynamicObject> first = table.getDynamicObjectCollection(ENTRYENTITY).stream().filter(o -> entryId == o.getLong("id")).findFirst();
                    if (first.isPresent() && (entityType = ProvistonRuleDataSourceEditPlugin.queryEntityType(table.getString("entityname"), first.get().getString("fieldname"))) != null) {
                        String fieldNumber = entityType.getProperty(first.get().getString("fieldname")).getName();
                        this.getView().getModel().setValue(EXPRESSION, (Object)(this.getModel().getValue(EXPRESSION) + "" + mainEntityType.getName() + "." + fieldNumber + "|" + FilterBuilderUtils.buildFilterDesc((String)String.valueOf(this.getModel().getValue("conditionjson", row)), (String)table.getString("entityname"))));
                        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)EXPRESSION, (int)this.getModel().getValue(EXPRESSION).toString().length());
                        String fieldName = entityType.getProperty(first.get().getString("fieldname")).getDisplayName().getLocaleValue();
                        this.getView().getModel().setValue(DESCRIPTION, (Object)(this.getModel().getValue(DESCRIPTION) + "\u3010" + mainEntityType.getDisplayName() + "." + fieldName + "|" + this.getModel().getValue("filtercondition", row) + "\u3011"));
                        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)DESCRIPTION, (int)this.getModel().getValue(DESCRIPTION).toString().length());
                    }
                }
            } else {
                EntityType entityType;
                Optional<DynamicObject> first = table.getDynamicObjectCollection(ENTRYENTITY).stream().filter(o -> "column".equals(o.getString("fieldname"))).findFirst();
                if (first.isPresent() && (entityType = ProvistonRuleDataSourceEditPlugin.queryEntityType(table.getString("entityname"), first.get().getString("fieldname"))) != null) {
                    String fieldNumber = entityType.getProperty(first.get().getString("fieldname")).getName();
                    Object conditionjson = this.getModel().getValue("conditionjson", row);
                    if (EmptyCheckUtils.isNotEmpty((Object)conditionjson)) {
                        this.getView().getModel().setValue(EXPRESSION, (Object)(this.getModel().getValue(EXPRESSION) + "" + mainEntityType.getName() + "." + fieldNumber + "|" + FilterBuilderUtils.buildFilterDesc((String)String.valueOf(this.getModel().getValue("conditionjson", row)), (String)table.getString("entityname"))));
                        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)EXPRESSION, (int)this.getModel().getValue(EXPRESSION).toString().length());
                        String fieldName = entityType.getProperty(first.get().getString("fieldname")).getDisplayName().getLocaleValue();
                        this.getView().getModel().setValue(DESCRIPTION, (Object)(this.getModel().getValue(DESCRIPTION) + "\u3010" + mainEntityType.getDisplayName() + "." + fieldName + "|" + this.getModel().getValue("filtercondition", row) + "\u3011"));
                        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)DESCRIPTION, (int)this.getModel().getValue(DESCRIPTION).toString().length());
                    } else {
                        this.getView().getModel().setValue(EXPRESSION, (Object)(this.getModel().getValue(EXPRESSION) + "" + mainEntityType.getName() + "." + fieldNumber));
                        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)EXPRESSION, (int)this.getModel().getValue(EXPRESSION).toString().length());
                        String fieldName = entityType.getProperty(first.get().getString("fieldname")).getDisplayName().getLocaleValue();
                        this.getView().getModel().setValue(DESCRIPTION, (Object)(this.getModel().getValue(DESCRIPTION) + "\u3010" + mainEntityType.getDisplayName() + "." + fieldName + "\u3011"));
                        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)DESCRIPTION, (int)this.getModel().getValue(DESCRIPTION).toString().length());
                    }
                }
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)BTNFUNCTION)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.receiveFuncSetting((String)closedCallBackEvent.getReturnData());
        }
    }

    private void showFuncSetting() {
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML) && StringUtils.isBlank((CharSequence)(funcsXML = this.getPageCache().get("functiontypes")))) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        String jsonNode = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTNFUNCTION);
        FuncSettingHelper.show((String)funcsXML, (String)entityNumber, (String)jsonNode, (Map)null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        int var4 = -1;
        switch (compareKey.hashCode()) {
            case -1378808635: {
                if (!compareKey.equals(ADD)) break;
                var4 = 0;
                break;
            }
            case -1378808325: {
                if (!compareKey.equals(AND)) break;
                var4 = 10;
                break;
            }
            case -1179832642: {
                if (!compareKey.equals(DIVISON)) break;
                var4 = 3;
                break;
            }
            case -997791075: {
                if (!compareKey.equals(NOT_EQUAL)) break;
                var4 = 5;
                break;
            }
            case -845487581: {
                if (!compareKey.equals(MORE_EQUAL)) break;
                var4 = 9;
                break;
            }
            case -616237854: {
                if (!compareKey.equals(MULTIPLICATION)) break;
                var4 = 2;
                break;
            }
            case -489169518: {
                if (!compareKey.equals(LESS_THAN)) break;
                var4 = 6;
                break;
            }
            case 94070079: {
                if (!compareKey.equals(OR)) break;
                var4 = 11;
                break;
            }
            case 206934115: {
                if (!compareKey.equals(LEFT)) break;
                var4 = 12;
                break;
            }
            case 1497184590: {
                if (!compareKey.equals(MORE_THAN)) break;
                var4 = 7;
                break;
            }
            case 1859708056: {
                if (!compareKey.equals(SUBTRACTION)) break;
                var4 = 1;
                break;
            }
            case 2002044511: {
                if (!compareKey.equals(LESS_EQUAL)) break;
                var4 = 8;
                break;
            }
            case 2113897048: {
                if (!compareKey.equals(EQUAL)) break;
                var4 = 4;
                break;
            }
            case 2125651264: {
                if (!compareKey.equals(RIGHT)) break;
                var4 = 13;
            }
        }
        switch (var4) {
            case 0: {
                compareValue = "+";
                break;
            }
            case 1: {
                compareValue = "-";
                break;
            }
            case 2: {
                compareValue = "*";
                break;
            }
            case 3: {
                compareValue = "/";
                break;
            }
            case 4: {
                compareValue = "=";
                break;
            }
            case 5: {
                compareValue = "<>";
                break;
            }
            case 6: {
                compareValue = "<";
                break;
            }
            case 7: {
                compareValue = ">";
                break;
            }
            case 8: {
                compareValue = "<=";
                break;
            }
            case 9: {
                compareValue = ">=";
                break;
            }
            case 10: {
                compareValue = "and";
                break;
            }
            case 11: {
                compareValue = "or";
                break;
            }
            case 12: {
                compareValue = "(";
                break;
            }
            case 13: {
                compareValue = ")";
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)EXPRESSION, (String)compareValue);
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)DESCRIPTION, (String)compareValue);
        }
    }

    private void receiveFuncSetting(String funcSetting) {
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)BTNFUNCTION, (String)EXPRESSION, (String)funcSetting);
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)BTNFUNCTION, (String)DESCRIPTION, (String)funcSetting);
    }

    private static EntityType queryEntityType(String entityNumber, String fieldNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entityMap = mainEntityType.getAllEntities();
        if (entityMap != null) {
            EntityType mainEntity = (EntityType)entityMap.get(entityNumber);
            Optional<Map.Entry> entityType = entityMap.entrySet().stream().filter(o -> ((EntityType)o.getValue()).getProperty(fieldNumber) != null).findFirst();
            if (entityType.isPresent()) {
                return (EntityType)entityType.get().getValue();
            }
            return null;
        }
        return null;
    }
}

