/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.provision;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.bdtaxr.common.enums.MenuFilterEnum;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.provision.ProvisionRuleBusiness;
import org.apache.commons.lang3.StringUtils;

public class ProvistonRuleListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        MenuFilterEnum menuFilterEnum;
        String filterKey = (String)this.getView().getFormShowParameter().getCustomParam("filterKey");
        if (StringUtils.isNotEmpty((CharSequence)filterKey) && (menuFilterEnum = MenuFilterEnum.getEnumByKey((String)"tctb_jtgz_rules", (String)filterKey)) != null) {
            e.setCustomQFilters(Collections.singletonList(menuFilterEnum.getFilter()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opt = (FormOperate)args.getSource();
        String operateKey = opt.getOperateKey();
        if ("specified_sharing".equalsIgnoreCase(operateKey)) {
            DynamicObject[] plans;
            List ids = Stream.of(args.getListSelectedData().getPrimaryKeyValues()).map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            for (DynamicObject plan : plans = ProvisionRuleBusiness.queryProvisionRuleByIds(ids)) {
                if (StringUtil.equalsIgnoreCase((CharSequence)plan.getString("enable"), (CharSequence)"1")) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u7528\u7684\u6570\u636e\u624d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ProvistonPlanListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if ("specified_sharing".equalsIgnoreCase(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tctb_jtgz_shareplan", (boolean)true);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "specified_sharing"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"specified_sharing") && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            List ids;
            ListSelectedRowCollection returnDataRows = (ListSelectedRowCollection)returnData;
            List sharePlanIds = returnDataRows.stream().map(v -> Long.valueOf(v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            OperationResult operationResult = ProvisionRuleBusiness.specifiedSharing(sharePlanIds, ids = this.getSelectedRows().stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList()));
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u6210\u529f\u3002", (String)"ProvistonPlanListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            } else {
                String operName = ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848", (String)"ProvistonPlanListPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                this.getView().showOperationResult(operationResult, operName);
            }
        }
    }
}

