/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.provision;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.enums.MenuFilterEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.ProvisionHyperlinkParamsEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tctb.business.provision.ProvisionItemBusiness;
import kd.taxc.tctb.business.provision.TaxProvisionBusiness;
import kd.taxc.tctb.business.provision.TaxprovisionTaxesBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class TaxprovisionListPlugin
extends AbstractListPlugin {
    private static final String DELETE_CONFIRM = "deleteConfirm";
    private List filterList = Arrays.asList("taxsystem.number", "taxtype.number", "provistonitem.number", "sourcedrafttype");
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";
    private static final String SJJT = "SJJT";
    private static final String PARAMKEY_ENABLEPROVISTONITEMCOMBO = "enableListProvistonItemcomboByFilter";
    private static final String PARAMKEY_PROVISTONITEMNUMBER = "provistonitem.number";
    private static final String PARAMKEY_MODEL = "modle";
    private static final Map<String, String> provistionItemByModle = new HashMap<String, String>(8);

    public void initialize() {
        super.initialize();
        List<String> item = this.getProvistonitemNumberFromPageParams();
        String numberStr = String.join((CharSequence)",", item);
        this.getView().getFormShowParameter().setCustomParam(PARAMKEY_PROVISTONITEMNUMBER, (Object)numberStr);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("taxorg.id".equalsIgnoreCase(args.getFieldName())) {
            HasPermOrgResult orgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"itp", (String)"itp_proviston_taxes", (String)"47150e89000000ac", (Long)RequestContext.get().getCurrUserId());
            QFilter filter = null;
            if (orgsByUserId != null && !orgsByUserId.hasAllOrgPerm()) {
                filter = new QFilter("id", "in", (Object)orgsByUserId.getHasPermOrgs());
            }
            args.getQfilters().add(filter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isFromDraft = (String)customParams.get("isFromDraft");
        for (FilterColumn column : filterColumnList) {
            if (ObjectUtils.isNotEmpty((Object)isFromDraft) && StringUtil.isEmpty((CharSequence)this.getPageCache().get("source"))) {
                if (StringUtil.equalsIgnoreCase((CharSequence)column.getFieldName(), (CharSequence)"taxorg.name")) {
                    CommonBaseDataFilterColumn orgColumn = (CommonBaseDataFilterColumn)column;
                    orgColumn.setDefaultValue((String)customParams.get("orgId"));
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)column.getFieldName(), (CharSequence)"taxsystem.name")) {
                    CommonBaseDataFilterColumn column1 = (CommonBaseDataFilterColumn)column;
                    column1.setDefaultValue((String)customParams.get("taxsystem"));
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)column.getFieldName(), (CharSequence)"entrydate")) {
                    CommonFilterColumn dateFilterColumn = (CommonFilterColumn)column;
                    dateFilterColumn.setDefaultValue(null);
                }
            }
            if (!StringUtil.equalsIgnoreCase((CharSequence)column.getFieldName(), (CharSequence)"provistonitem.name")) continue;
            this.initProvistonItemCombal((CommonFilterColumn)column);
        }
    }

    private void initProvistonItemCombal(CommonFilterColumn provistonitemClumn) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String needSet = (String)customParams.get(PARAMKEY_ENABLEPROVISTONITEMCOMBO);
        if (!"true".equals(needSet)) {
            return;
        }
        List<String> numbers = this.getProvistonitemNumberFromPageParams();
        DynamicObject[] dyns = ProvisionItemBusiness.getByNumbers(numbers);
        List<ComboItem> comboItems = this.getProvisionItemComboItems(dyns);
        provistonitemClumn.setComboItems(comboItems);
    }

    private List<String> getProvistonitemNumberFromPageParams() {
        HashSet<String> numbers = new HashSet<String>(8);
        numbers.addAll(this.getProvistonitemNumberByParams());
        numbers.addAll(this.getProvistonitemNumberByModle());
        ArrayList<String> list = new ArrayList<String>(10);
        for (String item : numbers) {
            if (!StringUtil.isNotEmpty((CharSequence)item)) continue;
            list.add(item);
        }
        return list;
    }

    private List<String> getProvistonitemNumberByParams() {
        ArrayList<String> list = new ArrayList<String>(10);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String numbersStrFromParams = (String)customParams.get(PARAMKEY_PROVISTONITEMNUMBER);
        if (StringUtil.isEmpty((CharSequence)numbersStrFromParams)) {
            return list;
        }
        String[] numbers = numbersStrFromParams.split(",");
        return Arrays.asList(numbers);
    }

    private List<String> getProvistonitemNumberByModle() {
        ArrayList<String> list = new ArrayList<String>(10);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String modle = (String)customParams.get(PARAMKEY_MODEL);
        if (StringUtil.isNotEmpty((CharSequence)modle)) {
            String baseNumberStr = provistionItemByModle.get(modle);
            if (StringUtil.isEmpty((CharSequence)baseNumberStr)) {
                return list;
            }
            list.addAll(Arrays.asList(baseNumberStr.split(",")));
        }
        return list;
    }

    private List<ComboItem> getProvisionItemComboItems(DynamicObject[] provisionItemDyns) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(provisionItemDyns.length);
        for (DynamicObject dyn : provisionItemDyns) {
            String name = dyn.getString("name");
            ComboItem item = new ComboItem();
            item.setValue(dyn.getLong("id") + "");
            item.setCaption(new LocaleString(name));
            combos.add(item);
        }
        return combos;
    }

    public void setFilter(SetFilterEvent e) {
        MenuFilterEnum menuFilterEnum;
        String filterKey;
        String isFromDraft;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String appid = (String)customParams.get("appid");
        this.filterList.stream().forEach(filter -> {
            if (ObjectUtils.isNotEmpty(customParams.get(filter))) {
                e.getQFilters().add(new QFilter(filter.toString(), "in", (Object)Lists.newArrayList((Object[])customParams.get(filter).toString().split(","))));
            }
        });
        List filterproperty = e.getQFilters().stream().map(o -> o.getProperty()).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(filterproperty) || !filterproperty.contains("taxtype.number")) {
            if ("tccit".equals(appid)) {
                e.getQFilters().add(new QFilter("taxtype.number", "=", (Object)"003"));
            } else if ("tcvat".equals(appid)) {
                e.getQFilters().add(new QFilter("taxtype.number", "in", (Object)Lists.newArrayList((Object[])new String[]{"001", "006", "019", "020"})));
            } else if ("tcret".equals(appid)) {
                e.getQFilters().add(new QFilter("taxtype.number", "in", (Object)Lists.newArrayList((Object[])new String[]{"007", "008", "009", "011", "018", "022"})));
            }
        }
        if (ObjectUtils.isNotEmpty((Object)(isFromDraft = (String)customParams.get("isFromDraft"))) && StringUtil.isEmpty((CharSequence)this.getPageCache().get("source"))) {
            e.setMainOrgQFilter(new QFilter("1", "=", (Object)1));
            e.getQFilters().add(new QFilter("entitynumber", "=", customParams.get("entitynumber")));
            if (!QueryServiceHelper.exists((String)"itp_proviston_taxes", (QFilter[])new QFilter[]{new QFilter("entitynumber", "=", customParams.get("entitynumber"))})) {
                this.getPageCache().put("source", "1");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(filterKey = (String)this.getView().getFormShowParameter().getCustomParam("filterKey"))) && (menuFilterEnum = MenuFilterEnum.getEnumByKey((String)"itp_proviston_taxes", (String)filterKey)) != null) {
            e.setCustomQFilters(Collections.singletonList(menuFilterEnum.getFilter()));
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("startdate".equals(columnDesc.getKey())) {
            String dateFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
            String start = DateUtils.format((Date)data.getDate("startdate"), (String)dateFormat);
            String end = DateUtils.format((Date)data.getDate("enddate"), (String)dateFormat);
            e.setFormatValue((Object)(start + "~" + end));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("entitynumber".equals(fieldName)) {
            boolean flag;
            args.setCancel(true);
            HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            boolean bl = flag = allPermOrgs.hasAllOrgPerm() || !allPermOrgs.hasAllOrgPerm() && PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"2KBDG21ABT42");
            if (flag) {
                long userId = RequestContext.get().getCurrUserId();
                BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
                ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"itp_proviston_taxes", (String)"taxorg,accountorg", (QFilter[])new QFilter[]{new QFilter("id", "=", currentSelectedRowInfo.getPrimaryKeyValue())});
                long accountorgId = dynamicObject.getLong("taxorg");
                if (!allPermOrgs.hasAllOrgPerm()) {
                    ProvisionHyperlinkParamsEnum hyperlinkParamsEnum;
                    String draftPage;
                    MainEntityType mainEntityType;
                    String appid;
                    HasPermOrgResult orgs;
                    boolean viewflag;
                    DynamicObject object;
                    MultiTableEnum[] multiTableEnums;
                    DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"itp_proviston_taxes");
                    QFilter qFilter = new QFilter("billno", "=", (Object)dyn.getString("entitynumber"));
                    String table = "tpo_declare_main_tsd";
                    String number = dyn.getString("entitytype.number");
                    for (MultiTableEnum tableEnum : multiTableEnums = MultiTableEnum.values()) {
                        if (!tableEnum.getDeclareMainTable().equalsIgnoreCase(number)) continue;
                        table = number;
                        break;
                    }
                    if ((object = BusinessDataServiceHelper.loadSingle((String)table, (String)MetadataUtil.getAllSubFieldString((String)table), (QFilter[])new QFilter[]{qFilter})) == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u8ba1\u63d0\u5e95\u7a3f\u4efb\u52a1\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"TaxprovisionListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String templatetype = object.getString("templatetype.number");
                    if (EmptyCheckUtils.isEmpty((Object)templatetype)) {
                        DynamicObject queryObject = TaxProvisionBusiness.queryOneEntityData((String)table, (String)"templatetype", (Long)object.getLong("id"));
                        templatetype = queryObject.getString("templatetype");
                    }
                    if (!(viewflag = (orgs = PermissionUtils.getAllPermOrgsByUserId((String)(appid = (mainEntityType = EntityMetadataCache.getDataEntityType((String)(draftPage = (hyperlinkParamsEnum = ProvisionHyperlinkParamsEnum.getEnumByTemplateType((String)templatetype)).getDraftNumber()))).getAppId()), (String)draftPage, (String)"47150e89000000ac", (Long)userId)).getHasPermOrgs().contains(accountorgId))) {
                        String description = hyperlinkParamsEnum.getDraftName().loadKDString();
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"TaxprovisionListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), description));
                        return;
                    }
                }
                this.openDraftPageOrDeclarePage(list, true);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7a0e\u91d1\u8ba1\u63d0\u5355\u201d\u7684\u201c\u67e5\u770b\u5e95\u7a3f\u201d\u6743\u9650\u3002", (String)"TaxprovisionListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        } else if ("voucherno".equalsIgnoreCase(fieldName)) {
            boolean flag;
            args.setCancel(true);
            HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            boolean bl = flag = allPermOrgs.hasAllOrgPerm() || !allPermOrgs.hasAllOrgPerm() && PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"2LZ9GWKAIUXE");
            if (flag) {
                Object primaryKeyValue = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"itp_proviston_taxes", (String)"voucherno", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
                DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"gl_voucher", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)dynamicObject.getString("voucherno"))});
                this.showTargetForm(dyn.getLong("id"), "gl_voucher", null);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7a0e\u91d1\u8ba1\u63d0\u5355\u201d\u7684\u201c\u9884\u89c8\u51ed\u8bc1\u201d\u6743\u9650\u3002", (String)"TaxprovisionListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openDraftPageOrDeclarePage(BillList list, boolean openDraftPage) {
        DynamicObject object;
        MultiTableEnum[] multiTableEnums;
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"itp_proviston_taxes");
        QFilter qFilter = new QFilter("billno", "=", (Object)dynamicObject.getString("entitynumber"));
        String table = "tpo_declare_main_tsd";
        String number = dynamicObject.getString("entitytype.number");
        for (MultiTableEnum tableEnum : multiTableEnums = MultiTableEnum.values()) {
            if (!tableEnum.getDeclareMainTable().equalsIgnoreCase(number)) continue;
            table = number;
            break;
        }
        if ((object = BusinessDataServiceHelper.loadSingle((String)table, (String)MetadataUtil.getAllSubFieldString((String)table), (QFilter[])new QFilter[]{qFilter})) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u8ba1\u63d0\u5e95\u7a3f\u4efb\u52a1\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"TaxprovisionListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return;
        }
        String templatetype = object.getString("templatetype.number");
        if (EmptyCheckUtils.isEmpty((Object)templatetype)) {
            DynamicObject queryObject = TaxProvisionBusiness.queryOneEntityData((String)table, (String)"templatetype", (Long)object.getLong("id"));
            templatetype = queryObject.getString("templatetype");
        }
        ProvisionHyperlinkParamsEnum hyperlinkParamsEnum = ProvisionHyperlinkParamsEnum.getEnumByTemplateType((String)templatetype);
        FormShowParameter param = hyperlinkParamsEnum.createFormShowParameter(object);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String itemKey = args.getOperateKey();
        BillList billlist = (BillList)this.getControl("billlistap");
        Object[] selectedIds = billlist.getSelectedRows().getPrimaryKeyValues();
        if ("seepapers".equals(itemKey)) {
            if (selectedIds.length > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u770b\u5e95\u7a3f\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"TaxprovisionListPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            } else {
                this.openDraftPageOrDeclarePage(billlist, true);
            }
        }
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && (AUDIT.equalsIgnoreCase(args.getOperateKey()) || UNAUDIT.equalsIgnoreCase(args.getOperateKey()))) {
            TaxprovisionTaxesBusiness.sendMessage((Object[])selectedIds, (String)args.getOperateKey());
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get("isDelSucc"), (CharSequence)"true")) {
            this.getPageCache().remove("isDelSucc");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaxprovisionListPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        }
    }

    private void showTargetForm(Long pkId, String formId, String caption) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(formId);
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "commonclose");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    static {
        provistionItemByModle.put("qtsf", "JTSX-0061,JTSX-0062,JTSX-0063,JTSX-0064,JTSX-0065,JTSX-0066,JTSX-0067");
    }
}

