/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.provision;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.ProvisionHyperlinkParamsEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tctb.business.provision.TaxProvisionBusiness;
import kd.taxc.tctb.business.provision.TaxprovisionTaxesBusiness;
import org.apache.commons.collections4.CollectionUtils;

public class TaxprovisionPlugin
extends AbstractBillPlugIn {
    private static final String DELETE_CONFIRM = "deleteConfirm";
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"itp_proviston_taxes", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        if (dynamicObject == null) {
            long orgId;
            long accorgId = orgId = RequestContext.get().getOrgId();
            HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"47150e89000000ac");
            boolean flag = allPermOrgs.hasAllOrgPerm();
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("fisaccounting", "=", (Object)"1")});
            List orgIds = Arrays.stream(orgs).map(o -> o.getLong("id")).collect(Collectors.toList());
            if (!flag) {
                List hasPermOrgs = allPermOrgs.getHasPermOrgs();
                if (!hasPermOrgs.contains(orgId) && hasPermOrgs.size() > 0) {
                    orgId = (Long)hasPermOrgs.get(0);
                }
                if (orgIds != null && orgIds.size() > 0) {
                    orgIds.retainAll(hasPermOrgs);
                    if (!orgIds.contains(accorgId)) {
                        accorgId = (Long)orgIds.get(0);
                    }
                }
            } else if (!orgIds.contains(accorgId)) {
                accorgId = (Long)orgIds.get(0);
            }
            this.getModel().setValue("taxorg", (Object)orgId);
            this.getModel().setValue("accountorg", (Object)orgId);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection taxesentryentity = this.getModel().getDataEntity().getDynamicObjectCollection("taxesentryentity");
        if (CollectionUtils.isEmpty((Collection)taxesentryentity)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"jtmx"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("seepapers".equalsIgnoreCase(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.openDraftPageOrDeclarePage((Long)this.getModel().getDataEntity().getPkValue(), true);
        }
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && (AUDIT.equalsIgnoreCase(args.getOperateKey()) || UNAUDIT.equalsIgnoreCase(args.getOperateKey()))) {
            TaxprovisionTaxesBusiness.sendMessage((Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (String)args.getOperateKey());
        }
    }

    private void openDraftPageOrDeclarePage(long pkId, boolean openDraftPage) {
        DynamicObject object;
        MultiTableEnum[] multiTableEnums;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"itp_proviston_taxes");
        QFilter qFilter = new QFilter("billno", "=", (Object)dynamicObject.getString("entitynumber"));
        String table = "tpo_declare_main_tsd";
        String number = dynamicObject.getString("entitytype.number");
        for (MultiTableEnum tableEnum : multiTableEnums = MultiTableEnum.values()) {
            if (!tableEnum.getDeclareMainTable().equalsIgnoreCase(number)) continue;
            table = number;
            break;
        }
        if ((object = BusinessDataServiceHelper.loadSingle((String)table, (String)MetadataUtil.getAllSubFieldString((String)table), (QFilter[])new QFilter[]{qFilter})) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u8ba1\u63d0\u5e95\u7a3f\u4efb\u52a1\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"TaxprovisionPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return;
        }
        String templatetype = object.getString("templatetype.number");
        if (EmptyCheckUtils.isEmpty((Object)templatetype)) {
            DynamicObject queryObject = TaxProvisionBusiness.queryOneEntityData((String)table, (String)"templatetype", (Long)object.getLong("id"));
            templatetype = queryObject.getString("templatetype");
        }
        ProvisionHyperlinkParamsEnum hyperlinkParamsEnum = ProvisionHyperlinkParamsEnum.getEnumByTemplateType((String)templatetype);
        FormShowParameter param = hyperlinkParamsEnum.createFormShowParameter(object);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

