/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.shareplan;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.formplugin.shareplan.AbstractSharePlanFormPlugin;
import kd.taxc.tctb.business.shareplan.ProvisionSharePlanBusiness;

public class ProvisionSharePlanFormPlugin
extends AbstractSharePlanFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.settingEditable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String k = e.getProperty().getName();
        if ("number".equals(k)) {
            this.settingEditable();
        }
    }

    private void settingEditable() {
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L) {
            if (!this.hasUpdatePerm()) {
                this.setEditEnable(false);
            } else {
                this.setEditEnable(true);
            }
        } else if (!this.hasNewPerm()) {
            this.setEditEnable(false);
        } else {
            this.setEditEnable(true);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    protected void setOrgFilter(BeforeF7SelectEvent event) {
        List permOrgs = this.getPermOrgs();
        List orgs = ProvisionSharePlanBusiness.queryTaxcOrgByOrgIdAndIsTaxpayer((List)permOrgs);
        List orgIds = orgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity("planentity");
        DynamicObject row = (DynamicObject)planEntity.get(this.getSelectRows());
        List entityOrgIds = row.getDynamicObjectCollection("orgentity").stream().filter(o -> o.getPkValue() != null && o.getDynamicObject("org") != null).map(v -> v.getLong("org.id")).collect(Collectors.toList());
        QFilter inOrgFilter = new QFilter("id", "in", orgIds);
        QFilter notInOrgFilter = new QFilter("id", "not in", entityOrgIds);
        event.getCustomQFilters().add(inOrgFilter);
        event.getCustomQFilters().add(notInOrgFilter);
    }

    protected void setRuleFilter(BeforeF7SelectEvent event) {
        DynamicObjectCollection rules = this.getModel().getEntryEntity("ruleentity");
        List ruleIds = rules.stream().filter(o -> o.getPkValue() != null && o.getDynamicObject("rule") != null).map(v -> v.getLong("rule.id")).collect(Collectors.toList());
        QFilter ruleIdsFilter = new QFilter("id", "not in", ruleIds);
        event.getCustomQFilters().add(ruleIdsFilter);
    }

    protected DynamicObject[] loadPlanDatas() {
        return ProvisionSharePlanBusiness.querySharePlanByIds(null);
    }

    protected DynamicObject loadPlanData(Long id) {
        return ProvisionSharePlanBusiness.querySharePlanById((Long)id);
    }

    protected String getSharePlanEntityName() {
        return "tctb_jtfa_shareplan";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    protected boolean beforeSavePlan() {
        return this.checkPermBeforeSave();
    }

    private boolean checkPermBeforeSave() {
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L) {
            if (!this.hasUpdatePerm()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5171\u4eab\u8ba1\u7a0e\u65b9\u6848\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProvisionSharePlanFormPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (!this.hasNewPerm()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5171\u4eab\u8ba1\u7a0e\u65b9\u6848\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProvisionSharePlanFormPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean hasNewPerm() {
        return this.hasPerm("47156aff000000ac");
    }

    private boolean hasUpdatePerm() {
        return this.hasPerm("4715a0df000000ac");
    }

    private boolean hasPerm(String permId) {
        boolean perm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"tctb", (String)"tctb_jtfa_shareplan_form", (String)permId);
        return perm;
    }
}

