/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.shareplan;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.enums.TaxJswdEnum;
import kd.taxc.tctb.business.taxplan.TaxcPlanBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class TaxSharePlanListPlugin
extends AbstractListPlugin {
    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] rows = e.getQueryValues();
        if (ObjectUtils.isNotEmpty((Object)rows)) {
            List ids = Stream.of(rows).flatMap(v -> v.getDynamicObjectCollection("ruleentity").stream()).filter(v -> v.getDynamicObject("rule") != null).map(v -> v.getLong("rule.id")).collect(Collectors.toList());
            DynamicObject[] rules = TaxcPlanBusiness.loadByIds(ids);
            Map<Long, DynamicObject> ruleMap = Stream.of(rules).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
            Stream.of(rows).forEach(object -> {
                DynamicObjectCollection ruleEntity = object.getDynamicObjectCollection("ruleentity");
                ruleEntity.stream().filter(v -> v.getDynamicObject("rule") != null).forEach(entry -> {
                    Long ruleId = entry.getLong("rule.id");
                    DynamicObject rule = (DynamicObject)ruleMap.get(ruleId);
                    if (ObjectUtils.isNotEmpty((Object)rule)) {
                        entry.set("imptaxtype", Optional.ofNullable(rule.getDynamicObject("taxtype")).map(v -> v.get("name")).orElse(null));
                        entry.set("imptaxdimension", Optional.ofNullable(TaxJswdEnum.getEnumByType((String)rule.getString("taxdimension"))).orElse(null));
                        entry.set("impbusinessdimesion", Optional.ofNullable(rule.getDynamicObject("businessdimesion")).map(v -> v.get("name")).orElse(null));
                        entry.set("impstartdate", (Object)rule.getDate("startdate"));
                        entry.set("impenddate", (Object)rule.getDate("enddate"));
                    }
                });
            });
        }
    }
}

