/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.supplier;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tctb.business.supplier.TaxSupplierBusiness;

public class TaxSupplierEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static String[] f7Controls = new String[]{"supplier", "treatyname", "treatyagreement"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7SelectListener(f7Controls);
    }

    protected void addBeforeF7SelectListener(String ... args) {
        for (String arg : args) {
            BasedataEdit control = (BasedataEdit)this.getView().getControl(arg);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
        if ("supplier".equals(key)) {
            List supplierIds = TaxSupplierBusiness.getSupplierIdsByIds(null);
            if (supplierIds.size() > 0) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
                filters.add(new QFilter("id", "not in", (Object)supplierIds));
                f7List.getListFilterParameter().setQFilters(filters);
            }
        } else if ("treatyname".equalsIgnoreCase(key)) {
            f7List.setCaption(ResManager.loadKDString((String)"\u9002\u7528\u7a0e\u6536\u534f\u8bae\u540d\u79f0", (String)"TaxSupplierEditPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        } else if ("treatyagreement".equalsIgnoreCase(key)) {
            f7List.setCaption(ResManager.loadKDString((String)"\u9002\u7528\u7a0e\u6536\u534f\u5b9a\u6761\u6b3e", (String)"TaxSupplierEditPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
    }
}

