/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.tag;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.SearchUtil;
import kd.taxc.common.util.TreeUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxLabelWindowPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
ListRowClickListener {
    private static final String LABEL_TREE = "treeviewap";
    private static final String LABEL_TYPE = "tctb_label_type";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String BILL_LIST = "billlistap";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.addListRowClickListener((ListRowClickListener)this);
        TreeView tree = (TreeView)this.getView().getControl(LABEL_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"concel", "save"});
    }

    public void registerListener(EventObject e) {
        Search search = (Search)this.getControl("entitysearchap");
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        TreeView treeView = (TreeView)this.getControl(LABEL_TREE);
        search.addEnterListener(event -> {
            if (StringUtils.isNotEmpty((CharSequence)event.getText())) {
                SearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)LABEL_TREE);
            } else {
                this.getPageCache().put("_resultlist", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"TaxLabelWindowPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.loadTree();
    }

    public void loadTree() {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection dType = QueryServiceHelper.query((String)LABEL_TYPE, (String)"id,name,parent", null);
        if (dType != null && !dType.isEmpty()) {
            for (DynamicObject entry : dType) {
                TreeNode node = new TreeNode();
                String id = entry.getString("id");
                String name = entry.getString("name");
                String parent = entry.getString("parent");
                node.setId(id);
                node.setText(name);
                node.setParentid(parent);
                nodeList.add(node);
            }
        }
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaxLabelWindowPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        nodeList.add(root);
        TreeView treeView = (TreeView)this.getView().getControl(LABEL_TREE);
        treeView.deleteAllNodes();
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)this.getPageCache(), (boolean)true);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        pageCache.put(CURRENT_NODE, nodeId);
        TreeView treeView = (TreeView)this.getControl(LABEL_TREE);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        if (treeNode == null) {
            return;
        }
        BillList billList = (BillList)this.getControl(BILL_LIST);
        String labelId = treeNode.getId();
        List childNodesList = TreeUtils.getNodeList((TreeNode)treeNode);
        ArrayList<String> idList = new ArrayList<String>(childNodesList.size());
        for (TreeNode node : childNodesList) {
            idList.add(node.getId());
        }
        if (!"0".equals(labelId)) {
            QFilter qFilter = new QFilter("group.id", "in", idList.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()));
            billList.setFilter(qFilter);
        }
        billList.refreshData();
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection selectedRowCollection = evt.getListSelectedRowCollection();
        ArrayList<ValueTextItem> f7ItemList = new ArrayList<ValueTextItem>();
        for (ListSelectedRow selectedRow : selectedRowCollection) {
            f7ItemList.add(new ValueTextItem(selectedRow.toString(), selectedRow.getName()));
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl("f7selectedlistap");
        f7SelectedList.addItems(f7ItemList);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ("concel".equals(sourceKey)) {
            this.getView().close();
        } else if ("save".equals(sourceKey)) {
            BillList billList = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            this.getView().returnDataToParent((Object)listSelectedRows);
            this.getView().close();
        }
    }
}

