/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.task;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.util.DateUtils;

public class ContractVoucherValidateTask
implements Callable<Boolean> {
    private static Log logger = LogFactory.getLog(ContractVoucherValidateTask.class);
    private RequestContext ctx;
    private JSONObject dynamicObject;
    private Date startDate;
    private Date endDate;
    private Long orgId;

    public ContractVoucherValidateTask(RequestContext ctx, JSONObject dynamicObject, Date startDate, Date endDate, Long orgId) {
        this.ctx = ctx;
        this.dynamicObject = dynamicObject;
        this.startDate = startDate;
        this.endDate = endDate;
        this.orgId = orgId;
    }

    @Override
    public Boolean call() {
        String period = this.dynamicObject.getString("period");
        Long taxRateId = this.dynamicObject.getJSONObject("taxrate").getLong("id");
        String taxation = this.dynamicObject.getBoolean("isverify") != false ? "hdzs" : "aqhz";
        BigDecimal hdRate = this.dynamicObject.getBigDecimal("hdrate").setScale(2, 4);
        QFilter skssqqFilter = new QFilter("skssqq", ">", (Object)this.startDate).and(new QFilter("skssqq", "<", (Object)this.endDate));
        QFilter skssqzFilter = new QFilter("skssqz", ">", (Object)this.startDate).and(new QFilter("skssqz", "<", (Object)this.endDate));
        QFilter qFilter = skssqqFilter.or(skssqzFilter).and(new QFilter("type", "=", (Object)"yhs")).and(new QFilter("declarestatus", "=", (Object)"declared")).and(new QFilter("org", "=", (Object)this.orgId));
        DynamicObject[] declareObjects = BusinessDataServiceHelper.load((String)"tcsd_yhs_declare_list", (String)"org,skssqq,skssqz", (QFilter[])new QFilter[]{qFilter});
        AtomicBoolean isQuoted = new AtomicBoolean(false);
        if (declareObjects != null && declareObjects.length > 0) {
            for (DynamicObject dynamicObject : declareObjects) {
                Date skssqz;
                Date skssqq = dynamicObject.getDate("skssqq");
                QFilter contractFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)(skssqz = dynamicObject.getDate("skssqz")))).and(new QFilter("orgid", "=", (Object)this.orgId));
                DynamicObject[] objects = BusinessDataServiceHelper.load((String)"tcsd_contract_summary", (String)"taxitem,taxation,skssqq,skssqz,verifyrate,verifybasis", (QFilter[])new QFilter[]{contractFilter});
                if (objects != null && objects.length > 0) {
                    for (DynamicObject dobj : objects) {
                        Long taxItemId = dobj.getDynamicObject("taxitem").getLong("id");
                        String taxationType = dobj.getString("taxation");
                        BigDecimal verifyRate = dobj.getBigDecimal("verifyrate").setScale(2, 4);
                        String taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
                        if (taxRateId.longValue() != taxItemId.longValue() || !taxation.equals(taxationType) || hdRate.compareTo(verifyRate) != 0 || !period.equals(taxLimit)) continue;
                        isQuoted.set(true);
                        break;
                    }
                }
                if (isQuoted.get()) break;
            }
        }
        return isQuoted.get();
    }
}

