/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.task;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.org.OrgService;

public class MessageRemindTaskEditPlugin
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    public static OrgService orgService = new OrgService();

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"exceplandesc", "taxctag"});
        BasedataEdit subscribe = (BasedataEdit)this.getControl("subscribe");
        subscribe.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        subscribe.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        org.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setItemValueByNumber("subscribe", "taxc_event_remind_sendmsg.sendMsg");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("remindtype");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tctb_remind_assist", (String)"number,name", (QFilter[])new QFilter[0]);
        if (query != null && query.size() > 0) {
            List names = query.stream().map(s -> new ComboItem(new LocaleString(s.getString("name")), s.getString("number"))).collect(Collectors.toList());
            comboEdit.setComboItems(names);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        if ("roletype".equals(name)) {
            String roletype = (String)changeData.getNewValue();
            if ("common".equals(roletype)) {
                this.getModel().setValue("bizsysrole", null);
                this.getModel().setValue("position", null);
                this.setMustInput("commsysrole", true);
                this.setMustInput("bizsysrole", false);
                this.setMustInput("position", true);
            }
            if ("biz".equals(roletype)) {
                this.getModel().setValue("commsysrole", null);
                this.getModel().setValue("position", null);
                this.setMustInput("commsysrole", false);
                this.setMustInput("bizsysrole", true);
                this.setMustInput("position", true);
            }
            if ("position".equals(roletype)) {
                this.getModel().setValue("commsysrole", null);
                this.getModel().setValue("bizsysrole", null);
                this.setMustInput("commsysrole", false);
                this.setMustInput("bizsysrole", false);
                this.setMustInput("position", true);
            }
        } else if ("remindtype".equals(name)) {
            String remindtype = (String)changeData.getNewValue();
            if ("FXLTX".equals(remindtype)) {
                this.getModel().setItemValueByNumber("subscribe", "taxc_event_riskreminder_sendmsg.sendMsg");
            } else if ("DGLTX".equals(remindtype) || "SBLTX".equals(remindtype)) {
                this.getModel().setItemValueByNumber("subscribe", "taxc_event_remind_sendmsg.sendMsg");
            } else if ("TJLTX".equals(remindtype)) {
                this.getModel().setItemValueByNumber("subscribe", "taxc_event_fixed_filling_sendmsg.sendMsg");
            }
        }
    }

    private void setMustInput(String key, boolean mustInput) {
        FieldEdit control = (FieldEdit)this.getControl(key);
        control.setMustInput(mustInput);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection ruleentryentity;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if ("save".equals(key) && (ruleentryentity = this.getModel().getEntryEntity("ruleentryentity")) != null && ruleentryentity.size() > 0) {
            Map<String, List<DynamicObject>> tables = ruleentryentity.stream().filter(s -> s.getDynamicObject("table") != null).collect(Collectors.groupingBy(s -> s.getString("table")));
            boolean anyMatch = tables.entrySet().stream().anyMatch(s -> ((List)s.getValue()).size() > 1);
            if (anyMatch) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u9192\u89c4\u5219\u6570\u636e\u6e90\u4e0d\u80fd\u91cd\u590d\u3002", (String)"MessageRemindTaskEditPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean emptyJson = ruleentryentity.stream().anyMatch(s -> StringUtil.isBlank((CharSequence)s.getString("conditionjson")));
            if (emptyJson) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessageRemindTaskEditPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("exceplandesc".equalsIgnoreCase(key)) {
            IBillModel billmodel = (IBillModel)this.getModel();
            String number = (String)billmodel.getValue("number");
            long id = (Long)billmodel.getValue("id");
            if (StringUtils.isBlank((Object)id) || id == 0L) {
                String tableName = billmodel.getDataEntityType().getAlias();
                long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
                id = ids[0];
                billmodel.getDataEntity().set("id", (Object)id);
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("sch_schedule");
            parameter.addCustPlugin("kd.taxc.tctb.formplugin.task.SchScheduleLayoutPlugin");
            String scheduleId = (String)this.getView().getModel().getValue("sheduleplanid");
            if (scheduleId != null && scheduleId.trim().length() != 0) {
                parameter.setPkId((Object)scheduleId);
                parameter.setStatus(OperationStatus.EDIT);
            } else {
                parameter.setStatus(OperationStatus.ADDNEW);
                String paramjsonstr = "{\"taxcSchemaidList\":[{\"Id\":" + id + "}]}";
                parameter.setCustomParam("paramjsonstr", (Object)paramjsonstr);
                parameter.setCustomParam("taskclassname", (Object)"kd.taxc.tctb.mservice.message.RemindTask");
                parameter.setCustomParam("taskdefineid", (Object)this.getExecClassName(parameter, "tctb"));
                parameter.setCustomParam("taskname", (Object)ResManager.loadKDString((String)"\u7a0e\u52a1\u6d88\u606f\u63d0\u9192\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u8ba1\u5212", (String)"MessageRemindTaskEditPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                parameter.setCustomParam("tasknumber", (Object)("taxc_auto_create_" + number));
            }
            parameter.setCustomParam("taskappnumber", (Object)"tctb");
            parameter.setCustomParam("taskdefineid", (Object)this.getExecClassName(parameter, "tctb"));
            parameter.setHasRight(true);
            parameter.setCustomParam("frombiz", (Object)"true");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newshedule"));
            StyleCss css1 = new StyleCss();
            css1.setWidth("800");
            css1.setHeight("700");
            parameter.getOpenStyle().setInlineStyleCss(css1);
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("taxctag".equalsIgnoreCase(key)) {
            ListShowParameter listForm = new ListShowParameter();
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("580px");
            styleCss.setWidth("960px");
            listForm.setFormId("bos_treelistf7");
            listForm.setBillFormId("tctb_label_group");
            listForm.setMultiSelect(true);
            listForm.getOpenStyle().setInlineStyleCss(styleCss);
            listForm.getOpenStyle().setShowType(ShowType.Modal);
            listForm.setShowTitle(false);
            listForm.setLookUp(true);
            listForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taxcTagCallBack"));
            this.getView().showForm((FormShowParameter)listForm);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() != null) {
            ListSelectedRowCollection rtn;
            List selectIds;
            List orgIds;
            if ("newshedule".equals(e.getActionId())) {
                DynamicObject scheduleInfo;
                Object rtn2 = e.getReturnData();
                if (rtn2 != null && (scheduleInfo = (DynamicObject)rtn2) != null) {
                    Date endtime = scheduleInfo.getDate("endtime");
                    String planid = (String)scheduleInfo.get("id");
                    this.getModel().setValue("sheduleplanid", (Object)planid);
                    String txtdesc = (String)scheduleInfo.get("txtdesc");
                    if (StringUtils.isNotEmpty((CharSequence)txtdesc) && txtdesc.length() > 153) {
                        txtdesc = txtdesc.substring(0, 150) + "...";
                    }
                    this.getModel().setValue("exceplandesc", (Object)txtdesc);
                    this.getModel().setValue("endtime", (Object)endtime);
                }
            } else if ("taxcTagCallBack".equals(e.getActionId()) && !(orgIds = orgService.longOrgIdByTagId(selectIds = Arrays.stream((rtn = (ListSelectedRowCollection)e.getReturnData()).getPrimaryKeyValues()).map(s -> Long.parseLong(s.toString())).collect(Collectors.toList()))).isEmpty()) {
                IDataModel model = this.getModel();
                model.deleteEntryData("orgrangeentryentity");
                model.beginInit();
                model.batchCreateNewEntryRow("orgrangeentryentity", orgIds.size());
                int index = 0;
                for (Long id : orgIds) {
                    model.setValue("org", (Object)id, index);
                    ++index;
                }
                model.endInit();
                this.getView().updateView("orgrangeentryentity");
            }
        }
    }

    private String getExecClassName(BillShowParameter parameter, String appid) {
        String taskdefineid;
        QFilter filter = new QFilter("classname", "=", (Object)"kd.taxc.tctb.mservice.message.RemindTask");
        filter.and("appid", "=", (Object)appid);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"sch_taskdefine", (String)"id", (QFilter[])filter.toArray(), null);
        if (null != load && load.length > 0) {
            taskdefineid = load[0].getString("id");
        } else {
            DynamicObject taskDyn = BusinessDataServiceHelper.newDynamicObject((String)"sch_taskdefine");
            taskDyn.set("name", (Object)("RemindExceTask-" + appid));
            taskDyn.set("number", (Object)("RemindExceTask-" + appid));
            taskDyn.set("classname", (Object)"kd.taxc.tctb.mservice.message.RemindTask");
            taskDyn.set("appid", (Object)appid);
            DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskDyn});
            taskdefineid = save[0].getString("id");
        }
        return taskdefineid;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection entity;
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        if (beforeF7SelectEvent.getProperty().getName().equals("org") && (entity = this.getModel().getEntryEntity("orgrangeentryentity")) != null && entity.size() > 0) {
            List selectIds = entity.stream().filter(s -> s.getDynamicObject("org") != null).map(s -> s.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
            listFilterParameter.setFilter(new QFilter("id", "not in", selectIds));
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }
}

