/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.message.RemindAssistService;
import kd.taxc.tctb.business.message.RemindTaskCacheUtil;

public class MessageRemindTaskListPlugin
extends AbstractListPlugin {
    private Map<String, String> remindTypes = RemindAssistService.getRemindTypes();

    public void filterContainerSearchClick(FilterContainerSearchClickArgs searchClickEvent) {
        super.filterContainerSearchClick(searchClickEvent);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List schemeColumnList = contInitEvent.getSchemeFilterColumns();
        for (FilterColumn column : schemeColumnList) {
            if (!"remindtype".equals(column.getFieldName())) continue;
            SchemeFilterColumn typeColumn = (SchemeFilterColumn)column;
            typeColumn.setComboItems(this.remindTypes.entrySet().stream().map(s -> new ComboItem(new LocaleString((String)s.getValue()), (String)s.getKey())).collect(Collectors.toList()));
            break;
        }
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc = (ColumnDesc)e.getSource();
        String key = columnDesc.getKey();
        if (key.equals("remindtype")) {
            DynamicObject d = e.getRowData();
            String remindtype = d.getString("remindtype");
            String name = this.remindTypes.get(remindtype);
            e.setFormatValue((Object)name);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        QFilter resetQfilter = filters.stream().filter(s -> s.getProperty().equals("iscurrentuser")).map(s -> {
            if ("1".equals(s.getValue())) {
                return new QFilter("creator", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
            }
            if ("0".equals(s.getValue())) {
                return new QFilter("creator", "!=", (Object)Long.parseLong(RequestContext.get().getUserId()));
            }
            return null;
        }).findFirst().orElseGet(() -> null);
        filters.removeIf(s -> s.getProperty().equals("iscurrentuser"));
        filters.add(resetQfilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if ("delete".equals(key) && !CollectionUtils.isEmpty((Collection)(selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows()))) {
            List sheduleplanids = selectedRows.stream().map(s -> BusinessDataServiceHelper.loadSingle((Object)s.getPrimaryKeyValue(), (String)"tctb_remind_task")).map(s -> s.getString("sheduleplanid")).collect(Collectors.toList());
            this.getPageCache().put("sheduleplanids", SerializationUtils.toJsonString(sheduleplanids));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("delete".equals(key) && (operationResult = args.getOperationResult()).isSuccess()) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    List sheduleplanids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("sheduleplanids"), List.class);
                    for (String sheduleplanid : sheduleplanids) {
                        DynamicObject schSchedule = BusinessDataServiceHelper.loadSingle((Object)sheduleplanid, (String)"sch_schedule");
                        DynamicObjectCollection jobs = schSchedule.getDynamicObjectCollection("entryentity");
                        DeleteServiceHelper.delete((String)"sch_schedule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sheduleplanid)});
                        if (jobs == null || jobs.isEmpty()) continue;
                        List jobids = jobs.stream().map(s -> s.getDynamicObject("jobnumber").getString("id")).collect(Collectors.toList());
                        DeleteServiceHelper.delete((String)"sch_job", (QFilter[])new QFilter[]{new QFilter("id", "in", jobids)});
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw new RuntimeException(t);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("exectask".equals(key)) {
            HasPermOrgResult res = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tctb", (String)"tctb_remind_task", (String)"0URSIR=DBGPV");
            if (!res.hasAllOrgPerm() && res.getHasPermOrgs().isEmpty()) {
                return;
            }
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() < 1) {
                return;
            }
            List dynamicObjects = selectedRows.stream().map(s -> BusinessDataServiceHelper.loadSingle((Object)s.getPrimaryKeyValue(), (String)"tctb_remind_task")).collect(Collectors.toList());
            String disables = dynamicObjects.stream().filter(s -> s.getString("enable").equals("0")).map(s -> s.getString("name")).collect(Collectors.joining("\u3001"));
            if (StringUtil.isNotBlank((CharSequence)disables)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4efb\u52a1\u5931\u8d25: %s \u4e3a\u7981\u7528\u72b6\u6001", (String)"MessageRemindTaskListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), disables));
                return;
            }
            dynamicObjects.stream().filter(s -> s.getString("enable").equals("1")).forEach(s -> this.excutePlanAsyn((DynamicObject)s));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u4efb\u52a1\u5df2\u7ecf\u5f00\u59cb\u6267\u884c", (String)"MessageRemindTaskListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        } else if ("stopexec".equals(key)) {
            HashMap<String, Object> processMap;
            HasPermOrgResult res = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tctb", (String)"tctb_remind_task", (String)"24B5CZ7NK0F=");
            if (!res.hasAllOrgPerm() && res.getHasPermOrgs().isEmpty()) {
                return;
            }
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() < 1) {
                return;
            }
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u4efb\u52a1\u4e2d\u6b62\u3002", (String)"MessageRemindTaskListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            long schemaId = (Long)selectedRows.get(0).getPrimaryKeyValue();
            if (this.isExecute(schemaId, processMap = new HashMap<String, Object>())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u4e2d\u6b62\u64cd\u4f5c\uff0c\u5728\u672c\u6279\u6b21\u6267\u884c\u5b8c\u540e\uff0c\u5c06\u4e2d\u6b62\u63d0\u9192\u4efb\u52a1\u6267\u884c\u3002", (String)"MessageRemindTaskListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                RemindTaskCacheUtil.setStopFlag((long)schemaId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u6267\u884c\u5b8c\u6210\u3002", (String)"MessageRemindTaskListPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isExecute(long schemaId, Map<String, Object> processMap) {
        return "running".equals(RemindTaskCacheUtil.getTaskStatus((long)schemaId));
    }

    private void excutePlanAsyn(DynamicObject dyn) {
        RequestContext rc = RequestContext.get();
        ArrayList<Long> schemaIdListNew = new ArrayList<Long>();
        schemaIdListNew.add(dyn.getLong("id"));
        JobInfo job = new JobInfo();
        job.setRunByLang(rc.getLang());
        job.setJobType(JobType.REALTIME);
        job.setName(rc.getUserName() + " execute job");
        job.setId(Uuid16.create().toString());
        job.setRunByUserId(rc.getCurrUserId());
        job.setTaskClassname("kd.taxc.tctb.mservice.message.RemindTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taxcSchemaidList", this.createJobParam(schemaIdListNew));
        params.put("type", "1");
        job.setParams(params);
        job.setAppId("tctb");
        job.setRunConcurrently(false);
        JobClient.dispatch((JobInfo)job);
    }

    private List<Object> createJobParam(List<Long> schemaIdList) {
        ArrayList<Object> list = new ArrayList<Object>(schemaIdList.size());
        for (Long id : schemaIdList) {
            HashMap<String, Long> map = new HashMap<String, Long>(16);
            map.put("Id", id);
            list.add(map);
        }
        return list;
    }
}

