/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.task;

import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.common.service.RuleTemplateService;
import kd.taxc.common.util.StringUtil;

public class TaskRuleTemplateNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "ruleentryentity";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";

    public void initialize() {
        BasedataEdit tablefield = (BasedataEdit)this.getControl("table");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            if (!"setting".equals(key)) {
                return;
            }
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table", focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"TaskRuleTemplateNewPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long tableEntityId = tabletype.getLong("id");
            if ("setting".equals(key)) {
                String ischild = tabletype.getString("ischild");
                String entityNumber = tabletype.getString("name");
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY, KEY_CONDITIONJSON, "setting");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        super.closedCallBack(evt);
        if ("setting".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(KEY_FILTERCONDITION, filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, filterData.get("filtervalue"), currentRowIndex);
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId) {
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filterconditions");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        RuleTemplateService.setRuleConfig((BeforeF7SelectEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (eventName.equals("table")) {
            long tables;
            DynamicObjectCollection entity;
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            String tableName = Optional.ofNullable((DynamicObject)changeData.getNewValue()).map(s -> s.getString("name")).orElseGet(() -> "");
            if (StringUtil.isNotBlank((CharSequence)tableName) && (entity = this.getModel().getEntryEntity(ENTRY_ENTITY)) != null && entity.size() > 0 && (tables = entity.stream().filter(s -> s.getDynamicObject("table") != null).filter(s -> s.getDynamicObject("table").getString("name").equals(tableName)).count()) > 1L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u9192\u89c4\u5219\u6570\u636e\u6e90\u4e0d\u80fd\u91cd\u590d\u3002", (String)"TaskRuleTemplateNewPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("table", null, rowIndex);
                return;
            }
            this.getModel().setValue(KEY_FILTERCONDITION, null, rowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, null, rowIndex);
        }
    }
}

