/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.taskmonistor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.OrgUtils;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.tctb.common.util.DevprotalBizAppUtil;

public class TaskMonitorDetailListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(TaskMonitorDetailListPlugin.class);
    private static final String DRAFT_TASKDEFINE_ID = "2NQ73WR=MKQU";
    private static final String DECLARE_TASKDEFINE_ID = "2O/+75P9AO8U";
    private static final String WITH_DRAW_DRAFT_TASKDEFINE_ID = "3+CVFCPJ8HAJ";
    private static final String RETRY = "retry";
    private static final String APPID = "appid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TASK_MONITOR_DETAIL = "tctb_task_monitor_detail";
    private static final String SCH_TASK = "sch_task";

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (Objects.equals(SKSSQQ, columnDesc.getKey())) {
            try {
                String dateFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
                String skssqq = DateUtils.format((Date)data.getDate(SKSSQQ), (String)dateFormat);
                String skssqz = DateUtils.format((Date)data.getDate(SKSSQZ), (String)dateFormat);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)skssqq) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)skssqz)) {
                    e.setFormatValue((Object)(skssqq + "~" + skssqz));
                }
            }
            catch (Exception ex) {
                logger.error("TaskMonitorDetailListPlugin packageData cause exption", (Object)e);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List timeFilterList;
        List<QFilter> qFilters = e.getQFilters() == null ? new ArrayList() : e.getQFilters();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!Objects.isNull(customParams.get("parentid"))) {
            qFilters.add(new QFilter("parentid", "=", customParams.get("parentid")));
        }
        for (QFilter qFilter : qFilters) {
            if (!SKSSQQ.equals(qFilter.getProperty())) continue;
            List qFilterNests = qFilter.getNests(false);
            if (CollectionUtils.isEmpty((Collection)qFilterNests)) break;
            ((QFilter.QFilterNest)qFilterNests.get(0)).getFilter().__setProperty(SKSSQZ);
            break;
        }
        if ((timeFilterList = qFilters.stream().filter(m -> SKSSQQ.equalsIgnoreCase(m.getProperty())).collect(Collectors.toList())).size() > 1) {
            QFilter qFilter;
            qFilter = (QFilter)timeFilterList.get(0);
            for (int i = 1; i < timeFilterList.size(); ++i) {
                qFilter.and((QFilter)timeFilterList.get(i));
            }
            qFilters.removeAll(timeFilterList);
            qFilters.add(qFilter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("taskdefine.id".equals(args.getFieldName())) {
            QFilter q = new QFilter("id", "in", (Object)new String[]{DECLARE_TASKDEFINE_ID, DRAFT_TASKDEFINE_ID, WITH_DRAW_DRAFT_TASKDEFINE_ID});
            args.getQfilters().add(q);
        } else if ("taxorg.id".equals(args.getFieldName())) {
            List<Long> orgIds = this.getIsTaxpayerOrg();
            QFilter q = new QFilter("id", "in", orgIds);
            args.getQfilters().add(q);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        IFormView view = this.getView();
        List commonFilterColumns = args.getCommonFilterColumns();
        List appArray = DevprotalBizAppUtil.getTaxcAppIds();
        List<Long> orgIds = this.getIsTaxpayerOrg();
        ArrayList<ComboItem> orgComboItems = new ArrayList<ComboItem>(orgIds.size());
        Map customParams = view.getFormShowParameter().getCustomParams();
        String isHyperLinkClick = "";
        if (!CollectionUtils.isEmpty((Map)customParams)) {
            isHyperLinkClick = Objects.isNull(customParams.get("isHyperLinkClick")) ? "" : (String)customParams.get("isHyperLinkClick");
        }
        for (FilterColumn filterColumn : commonFilterColumns) {
            DynamicObject[] orgList;
            String fieldName = filterColumn.getFieldName();
            CommonFilterColumn filter = (CommonFilterColumn)filterColumn;
            if (Objects.equals("taxorg.name", fieldName) && Objects.equals("Y", isHyperLinkClick)) {
                filter.setDefaultValues(new ArrayList());
                continue;
            }
            if (!Objects.equals("taxorg.name", fieldName) || Objects.equals("Y", isHyperLinkClick)) continue;
            String defaultOrg = TaskMonitorDetailListPlugin.getDefaultOrg(view);
            filter.setDefaultValues(StringUtils.isNotBlank((CharSequence)defaultOrg) ? Collections.singletonList(defaultOrg) : new ArrayList());
            QFilter qFilter = new QFilter("org.id", "in", orgIds);
            for (DynamicObject obj : orgList = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"org.id ,org.number,org.name", (QFilter[])new QFilter[]{qFilter})) {
                this.getComboItems(orgComboItems, obj.getString("org.id"), obj.getString("org.name"));
                filter.setComboItems(orgComboItems);
            }
        }
    }

    private List<ComboItem> getComboItems(List<ComboItem> comboItems, String id, String name) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(id);
        comboItem.setCaption(new LocaleString(name));
        comboItems.add(comboItem);
        return comboItems;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (RETRY.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaskMonitorDetailListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Object> ids = Arrays.asList(list.getPrimaryKeyValues());
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection detailList = QueryServiceHelper.query((String)TASK_MONITOR_DETAIL, (String)"taskid,taskappid,taskdefine,parentid,status,appid,taskname,taskclassname,businessparams,taxorg,skssqq,skssqz,progress,operater,dispatchflag,batchnumber", (QFilter[])new QFilter[]{qFilter});
            ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(detailList.size());
            long[] serialnoList = DB.genLongIds((String)"t_tctb_task_detail", (int)detailList.size());
            for (int i = 0; i < detailList.size(); ++i) {
                DynamicObject detail = (DynamicObject)detailList.get(i);
                String status = detail.getString("status");
                if ("COMPLETED".equals(status) || "SCHEDULED".equals(status) || "BEGIN".equals(status) || "RUNNING".equals(status)) {
                    return;
                }
                DynamicObject subTask = this.saveSubTask(detail, serialnoList[i]);
                addList.add(subTask);
            }
            if (EmptyCheckUtils.isNotEmpty(addList)) {
                SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
            }
            billlist.refresh();
        }
    }

    public DynamicObject saveSubTask(DynamicObject task, long taskSerialNumber) {
        DynamicObject subTask = BusinessDataServiceHelper.newDynamicObject((String)TASK_MONITOR_DETAIL);
        subTask.set("id", (Object)taskSerialNumber);
        subTask.set("taskdefine", (Object)task.getString("taskdefine"));
        subTask.set("parentid", (Object)task.getString("parentid"));
        subTask.set("status", (Object)"SCHEDULED");
        subTask.set("taxorg", (Object)task.getLong("taxorg"));
        subTask.set(SKSSQQ, (Object)task.getDate(SKSSQQ));
        subTask.set(SKSSQZ, (Object)task.getDate(SKSSQZ));
        subTask.set("dispatchflag", (Object)"NO");
        subTask.set("operater", task.get("operater") == null ? Long.valueOf(0L) : task.get("operater"));
        subTask.set("taskappid", task.get("taskappid"));
        subTask.set(APPID, task.get(APPID));
        subTask.set("taskname", (Object)task.getString("taskname"));
        subTask.set("taskclassname", (Object)task.getString("taskclassname"));
        subTask.set("businessparams", (Object)task.getString("businessparams"));
        return subTask;
    }

    public static String getDefaultOrg(IFormView view) {
        String defaultOrg = "";
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgResult, (boolean)true);
        if (null != col) {
            long orgId = RequestContext.get().getOrgId();
            boolean useDefault = false;
            for (DynamicObject obj : col) {
                if (obj.getLong("id") != orgId) continue;
                defaultOrg = String.valueOf(orgId);
                useDefault = true;
                break;
            }
            if (!useDefault && col.size() > 0) {
                defaultOrg = ((DynamicObject)col.get(0)).getString("id");
            }
        }
        return defaultOrg;
    }

    public static List<ComboItem> getComboItems(IFormView view) {
        ArrayList orgItems = new ArrayList();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgResult, (boolean)true);
        if (null != col) {
            col.stream().forEach(v -> {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", v.getString("id"));
                item.put("number", v.getString("number"));
                item.put("name", v.getString("name"));
                item.put("parentid", v.getString("parentid"));
                item.put("status", v.getString("status"));
                item.put("longnumber", v.getString("longnumber"));
                orgItems.add(item);
            });
        }
        return OrgUtils.getComboItems(orgItems);
    }

    protected List<Long> getIsTaxpayerOrg() {
        DynamicObjectCollection taxOrgs;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        QFilter istaxpayerQuery = new QFilter("istaxpayer", "=", (Object)Boolean.TRUE);
        QFilter status = new QFilter("status", "=", (Object)"1");
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs())) {
            QFilter authFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{istaxpayerQuery, status, authFilter});
        } else {
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{istaxpayerQuery, status});
        }
        if (CollectionUtils.isEmpty((Collection)taxOrgs)) {
            return new ArrayList<Long>();
        }
        List ids = taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("orgid", "in", ids);
        QFilter orgFilters = this.getOrgFilters(qFilter);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid as id", (QFilter[])new QFilter[]{orgFilters});
        return CollectionUtils.isEmpty((Collection)results) ? new ArrayList<Long>() : results.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    protected QFilter getOrgFilters(QFilter filters) {
        return filters;
    }
}

