/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.taskmonistor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctb.common.util.DevprotalBizAppUtil;

public class TaskMonitorListPlugin
extends AbstractListPlugin {
    private static final String DRAFT_TASKDEFINE_ID = "2NQ73WR=MKQU";
    private static final String DECLARE_TASKDEFINE_ID = "2O/+75P9AO8U";
    private static final String WITH_DRAW_DRAFT_TASKDEFINE_ID = "3+CVFCPJ8HAJ";
    private static final String TASK_MONITOR = "tctb_task_monitor";
    private static final String TASK_MONITOR_DETAIL = "tctb_task_monitor_detail";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("taskdefine.id".equals(args.getFieldName())) {
            QFilter q = new QFilter("id", "in", (Object)new String[]{DECLARE_TASKDEFINE_ID, DRAFT_TASKDEFINE_ID, WITH_DRAW_DRAFT_TASKDEFINE_ID});
            args.getQfilters().add(q);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        List appArray = DevprotalBizAppUtil.getTaxcAppIds();
        QFilter appFilter = new QFilter("appid", "in", (Object)appArray);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sch_taskdefine", (String)"id,number,appid,name,classname", (QFilter[])new QFilter[]{appFilter});
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dynamicObjects.length);
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            CommonFilterColumn filter = (CommonFilterColumn)filterColumn;
            if (!Objects.equals("taskdefine.name", fieldName)) continue;
            for (DynamicObject obj : dynamicObjects) {
                String id = obj.getString("id");
                if (!id.equals(DECLARE_TASKDEFINE_ID) && !id.equals(DRAFT_TASKDEFINE_ID) && !id.equals(WITH_DRAW_DRAFT_TASKDEFINE_ID)) continue;
                this.getComboItems(comboItems, id, obj.getString("name"));
                filter.setComboItems(comboItems);
            }
        }
    }

    private void getComboItems(List<ComboItem> comboItems, String id, String name) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(id);
        comboItem.setCaption(new LocaleString(name));
        comboItems.add(comboItem);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow rowInfo = billList.getCurrentSelectedRowInfo();
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)rowInfo.getPrimaryKeyValue(), (String)TASK_MONITOR);
        String taskid = task.getString("taskid");
        args.setCancel(true);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(TASK_MONITOR_DETAIL);
        listShowParameter.setFormId("bos_list");
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        customParams.put("isHyperLinkClick", "Y");
        customParams.put("taskdefine", task.getString("taskdefine.id"));
        customParams.put("parentid", taskid);
        listShowParameter.setCustomParams(customParams);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

