/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.taxcalendarlist;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.common.util.DateUtils;

public class TaxCalendarGeneratePagePlugin
extends AbstractFormPlugin {
    private static final String F7_TAXYEAR = "taxyear";
    private static final String DATE_YEARSTART = "yearstart";
    private static final String DATE_YEAREND = "yearend";
    private static final String BTN_OK = "btnok";
    private static final int MAXYEARCOUNT = 10;

    public void afterCreateNewData(EventObject e) {
        this.setDefaultValue();
        this.filterYearstart();
        this.filterEndstart();
    }

    protected void setDefaultValue() {
        this.getModel().setValue(DATE_YEARSTART, (Object)new Date());
        this.getModel().setValue(DATE_YEAREND, (Object)new Date());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (DATE_YEARSTART.equals(name)) {
            this.filterEndstart();
        } else if (DATE_YEAREND.equals(name)) {
            this.filterYearstart();
        }
    }

    protected void filterYearstart() {
        DateEdit startdate = (DateEdit)this.getControl(DATE_YEARSTART);
        Date enddate = (Date)this.getModel().getValue(DATE_YEAREND);
        if (enddate != null) {
            startdate.setMaxDate(enddate);
        } else {
            startdate.setMaxDate(new Date(Long.MAX_VALUE));
        }
    }

    protected void filterEndstart() {
        DateEdit enddate = (DateEdit)this.getControl(DATE_YEAREND);
        Date startdate = (Date)this.getModel().getValue(DATE_YEARSTART);
        if (startdate != null) {
            enddate.setMinDate(startdate);
        } else {
            enddate.setMinDate(new Date(0L));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            DynamicObjectCollection taxyearCollection = (DynamicObjectCollection)this.getModel().getValue(F7_TAXYEAR);
            Date yearstart = (Date)this.getModel().getValue(DATE_YEARSTART);
            Date yearend = (Date)this.getModel().getValue(DATE_YEAREND);
            if (DateUtils.getYearOfDate((Date)yearend) - DateUtils.getYearOfDate((Date)yearstart) + 1 > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e74\u4efd\u8de8\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s\u5e74\u3002", (String)"TaxCalendarGeneratePagePlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[]{10}));
                return;
            }
            HashMap<String, Object> callBackResultMap = new HashMap<String, Object>(4);
            callBackResultMap.put(F7_TAXYEAR, taxyearCollection);
            callBackResultMap.put(DATE_YEARSTART, yearstart);
            callBackResultMap.put(DATE_YEAREND, yearend);
            this.getView().returnDataToParent(callBackResultMap);
            this.getView().close();
        }
    }
}

