/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.taxcalendarlist;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.taxc.common.util.DateUtils;
import kd.taxc.tctb.business.taxcalendarlist.TaxCalendarListBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class TaxCalendarListPlugin
extends AbstractListPlugin {
    private static final String OPERATE_GENERATE = "generate";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List<String> hideList = Arrays.asList("createtime", "billstatus", "creator.number", "modifier.number", "auditor.number", "auditor.name", "auditdate");
        args.getSchemeFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getCommonFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
        args.getFastFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (OPERATE_GENERATE.equals(operateKey)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPERATE_GENERATE);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tctb_taxcalendar_generate");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        IDataModel model = this.getModel();
        String actionId = event.getActionId();
        if (OPERATE_GENERATE.equals(actionId)) {
            int endyearInt;
            Map returnData = (Map)event.getReturnData();
            if (returnData == null) {
                return;
            }
            List taxyears = (List)returnData.get("taxyear");
            taxyears = taxyears.stream().map(dynamicObject -> (DynamicObject)dynamicObject.get(1)).collect(Collectors.toList());
            Date yearstart = (Date)returnData.get("yearstart");
            Date yearend = (Date)returnData.get("yearend");
            int startyearInt = DateUtils.getYearOfDate((Date)yearstart);
            DynamicObject[] systemCalendarListDatas = TaxCalendarListBusiness.queryTaxCalendarListByYearAndTaxYear(taxyears, (int)startyearInt, (int)(endyearInt = DateUtils.getYearOfDate((Date)yearend)));
            if (systemCalendarListDatas != null && systemCalendarListDatas.length > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u751f\u6210\u76f8\u540c\u7eb3\u7a0e\u671f\u95f4\u548c\u5e74\u4efd\u7684\u7a0e\u52a1\u65e5\u5386\u6e05\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"TaxCalendarListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            Map generateResultMap = TaxCalendarListBusiness.generateTaxcalendarlistData(taxyears, (int)startyearInt, (int)endyearInt);
            boolean isSuccess = (Boolean)generateResultMap.get("isSuccess");
            String message = (String)generateResultMap.get("message");
            if (isSuccess) {
                this.getView().showSuccessNotification(message);
                ListView listview = (ListView)this.getView();
                listview.refresh();
            } else {
                this.getView().showErrorNotification(message);
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] rows = e.getQueryValues();
        if (ObjectUtils.isNotEmpty((Object)rows)) {
            List ids = Arrays.stream(rows).map(row -> row.getLong("id")).collect(Collectors.toList());
            DynamicObject[] systemTaxCalendars = TaxCalendarListBusiness.queryTaxCalendarListByIds(ids);
            Map<Long, DynamicObject> systemTaxCalendarMap = Arrays.stream(systemTaxCalendars).collect(Collectors.toMap(taxCalendar -> taxCalendar.getLong("id"), taxCalendar -> taxCalendar, (a, b) -> a));
            Stream.of(rows).forEach(row -> {
                DynamicObject systemData = (DynamicObject)systemTaxCalendarMap.get(row.getLong("id"));
                if (systemData != null) {
                    DynamicObject taxyear = systemData.getDynamicObject("taxyear");
                    row.set("taxyear_export", (Object)taxyear);
                    DynamicObject taxationsys = systemData.getDynamicObject("taxationsys");
                    row.set("taxationsys_export", (Object)taxationsys);
                    DynamicObject taxareagroup = systemData.getDynamicObject("taxareagroup");
                    row.set("taxareagroup_export", (Object)taxareagroup);
                    DynamicObject taxcategory = systemData.getDynamicObject("taxcategory");
                    row.set("taxcategory_export", (Object)taxcategory);
                    String taxcycle = systemData.getString("taxcycle");
                    row.set("taxcycle_export", (Object)taxcycle);
                    Date skssqq = systemData.getDate("skssqq");
                    row.set("skssqq_export", (Object)skssqq);
                    Date skssqz = systemData.getDate("skssqz");
                    row.set("skssqz_export", (Object)skssqz);
                }
            });
        }
    }
}

