/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.taxcalendarlist;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;

public class TaxCalendarRuleEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String F7_GROUP = "group";
    private static final String F7_TAXAREAGROUP = "taxareagroup";
    private static final String F7_TAXCATEGORY = "taxcategory";
    private static final String ENUM_TAXCYCLE = "taxcycle";
    private static final String MULTILANG_NAME = "name";

    public void afterCreateNewData(EventObject e) {
        this.carryDefaultTaxAreaGroup();
    }

    public void registerListener(EventObject e) {
        BasedataEdit taxareagroup = (BasedataEdit)this.getView().getControl(F7_TAXAREAGROUP);
        taxareagroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxcategory = (BasedataEdit)this.getView().getControl(F7_TAXCATEGORY);
        taxcategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals(F7_TAXAREAGROUP)) {
            this.beforeSelectF7TaxAreaGroup(evt);
        } else if (evt.getProperty().getName().equals(F7_TAXCATEGORY)) {
            this.beforeSelectF7TaxCategory(evt);
        }
    }

    protected void beforeSelectF7TaxAreaGroup(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        List areaGroupIds = null;
        TaxResult<List<DynamicObject>> listTaxResult = this.queryTaxAreaResult();
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            areaGroupIds = ((List)listTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(areaGroupIds)) {
            QFilter idQFilter = new QFilter("id", "in", areaGroupIds);
            listShowParameter.getListFilterParameter().setFilter(idQFilter);
        } else {
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)-1));
        }
    }

    protected TaxResult<List<DynamicObject>> queryTaxAreaResult() {
        Long countryId;
        DynamicObject taxationsysObj = this.getModel().getDataEntity().getDynamicObject(F7_GROUP);
        if (taxationsysObj != null && taxationsysObj.getDynamicObject("countryid") != null && (countryId = Long.valueOf(taxationsysObj.getDynamicObject("countryid").getLong("id"))) != null && countryId != 0L) {
            return TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId((Long)countryId);
        }
        return null;
    }

    protected void carryDefaultTaxAreaGroup() {
        TaxResult<List<DynamicObject>> listTaxResult = this.queryTaxAreaResult();
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            DynamicObject taxareagroup = ((DynamicObject)((List)listTaxResult.getData()).get(0)).getDynamicObject(F7_GROUP);
            this.getModel().setValue(F7_TAXAREAGROUP, (Object)taxareagroup);
        }
    }

    protected void beforeSelectF7TaxCategory(BeforeF7SelectEvent evt) {
        DynamicObject taxareagroup = (DynamicObject)this.getModel().getValue(F7_TAXAREAGROUP);
        DynamicObject taxationsys = (DynamicObject)this.getModel().getValue(F7_GROUP);
        if (taxareagroup == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u6536\u8f96\u533a\u201d\u3002", (String)"TaxCalendarRuleEditPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter taxareaFilter = new QFilter("taxarea.fbasedataid.id", "=", (Object)taxareagroup.getLong("id"));
        QFilter taxationsysFilter = new QFilter("taxationsysid.id", "=", (Object)taxationsys.getLong("id"));
        listShowParameter.getListFilterParameter().setFilter(taxareaFilter);
        listShowParameter.getListFilterParameter().setFilter(taxationsysFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (F7_TAXAREAGROUP.equals(name)) {
            this.getModel().setValue(F7_TAXCATEGORY, null);
        }
    }
}

