/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.taxcalendarlist;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.New;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.taxc.enums.TaxCalendarEndDayEnum;

public class TaxCalendarRuleListPlugin
extends AbstractTreeListPlugin {
    private static final String SBJZR = "sbjzr";
    private static final String JKJZR = "jkjzr";
    private static final String SBJZRNSSDLX = "sbjzrnssdlx";
    private static final String SBJZRY = "sbjzry";
    private static final String SBJZRT = "sbjzrt";
    private static final String JKJZRNSSDLX = "jkjzrnssdlx";
    private static final String JKJZRY = "jkjzry";
    private static final String JKJZRT = "jkjzrt";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List<String> hideList = Collections.singletonList("name");
        args.getFastFilterColumns().removeIf(column -> hideList.contains(column.getFieldName()));
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (SBJZR.equals(columnDesc.getKey())) {
            e.setFormatValue((Object)this.getEndDayString(rowData.getString(SBJZRNSSDLX), rowData.getInt(SBJZRY), rowData.getInt(SBJZRT)));
        }
        if (JKJZR.equals(columnDesc.getKey())) {
            e.setFormatValue((Object)this.getEndDayString(rowData.getString(JKJZRNSSDLX), rowData.getInt(JKJZRY), rowData.getInt(JKJZRT)));
        }
    }

    private String getEndDayString(String enddaytype, int month, int day) {
        if (TaxCalendarEndDayEnum.ENDDAY.getCode().equals(enddaytype)) {
            return TaxCalendarEndDayEnum.ENDDAY.getShowTip().loadKDString();
        }
        if (TaxCalendarEndDayEnum.BEFOREENDDAY.getCode().equals(enddaytype) || TaxCalendarEndDayEnum.AFTERENDDAY.getCode().equals(enddaytype)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TaxCalendarEndDayEnum.getEnumByCode((String)enddaytype).getShowTip().loadKDString());
            if (month > 0) {
                sb.append(month);
                sb.append(ResManager.loadKDString((String)"\u6708", (String)"TaxCalendarRuleListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
            if (day > 0) {
                sb.append(day);
                sb.append(ResManager.loadKDString((String)"\u5929", (String)"TaxCalendarRuleListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
            return sb.toString();
        }
        return "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof New) {
            List selectedNodes = this.getTreeListView().getTreeView().getTreeState().getSelectedNodes();
            if (selectedNodes == null || selectedNodes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7a0e\u6536\u5236\u5ea6\uff0c\u6839\u8282\u70b9\u4e0d\u652f\u6301\u65b0\u589e\u89c4\u5219\u3002", (String)"TaxCalendarRuleListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap node = (HashMap)selectedNodes.get(0);
            if (StringUtils.isEmpty((CharSequence)((String)node.get("parentid")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7a0e\u6536\u5236\u5ea6\uff0c\u6839\u8282\u70b9\u4e0d\u652f\u6301\u65b0\u589e\u89c4\u5219\u3002", (String)"TaxCalendarRuleListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter billShowParameter = e.getParameter();
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        billShowParameter.setOpenStyle(style);
    }
}

