/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.taxyear;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.TemplateGroupBaseDataPlugin;
import kd.bos.list.ITreeListView;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.bos.param.SystemParamDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;

public class TaxYearListPlugin
extends TemplateGroupBaseDataPlugin {
    public void setTreeListView(ITreeListView treeListView) {
        if (!this.enableoverseastax()) {
            return;
        }
        super.setTreeListView(treeListView);
        if (this.treeListView == null || this.treeListView.getTreeModel() == null || this.treeListView.getTreeModel().getRoot() == null || this.treeListView.getTreeModel().getRoot().getChildren() == null) {
            return;
        }
        Date currentDate = new Date();
        QFilter nullQ = QFilter.isNull((String)"expdate").and("activedate", "<=", (Object)currentDate);
        QFilter dateQ = new QFilter("expdate", ">=", (Object)currentDate).and(new QFilter("activedate", "<=", (Object)currentDate));
        QFilter notNullQ = QFilter.isNotNull((String)"expdate").and(dateQ);
        QFilter notChineseTaxQ = new QFilter("id", "!=", (Object)TaxationsysMappingEnum.CHN.getId());
        QFilter lastDateQ = notChineseTaxQ.and(nullQ.or(notNullQ));
        this.getTreeListView().getTreeModel().getTreeFilter().add(lastDateQ);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if ("kd.bos.form.operate.New".equals(args.getSource().getClass().getName())) {
            TreeNode root;
            if (!this.enableoverseastax()) {
                args.setCancel(true);
                return;
            }
            ITreeModel treeModel = this.getTreeModel();
            String currentNodeId = (String)treeModel.getCurrentNodeId();
            if (currentNodeId.equals((root = treeModel.getRoot()).getId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u65b0\u589e\u6570\u636e\u3002", (String)"TaxYearListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (!this.enableoverseastax()) {
            return;
        }
    }

    private boolean enableoverseastax() {
        TaxResult enable;
        Long rootOrgId = (Long)ViewDataServiceHelper.getRootOrgId().getData();
        if (!ObjectUtils.isEmpty((Object)rootOrgId) && !((Boolean)(enable = SystemParamDataServiceHelper.getAppParameter((String)"tctb", (String)"enableoverseastax", (Long)rootOrgId)).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u6d77\u5916\u7a0e\u53c2\u6570\u3002", (String)"TaxYearListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Boolean isenableoverseastax() {
        Long rootOrgId = (Long)ViewDataServiceHelper.getRootOrgId().getData();
        Boolean isenable = false;
        if (!ObjectUtils.isEmpty((Object)rootOrgId)) {
            TaxResult enable = SystemParamDataServiceHelper.getAppParameter((String)"tctb", (String)"enableoverseastax", (Long)rootOrgId);
            isenable = (Boolean)enable.getData();
        }
        return isenable;
    }

    public void setFilter(SetFilterEvent e) {
        if (!this.isenableoverseastax().equals(Boolean.TRUE)) {
            QFilter qFilter = new QFilter("id", "=", (Object)-1L);
            e.getQFilters().add(qFilter);
        }
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }
}

