/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.taxyear;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxYearPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String STARTDATE = "startdate";
    private static final String APPLICATIONSCOPE = "applicationscope";
    private static final String ENTRYENTITY = "entryentity";
    private static final String STARTYEAR = "startyear";
    private static final String STARTMONTHANDDAY = "startmonthandday";
    private static final String STARTTOEND = "starttoend";
    private static final String ENDYEAR = "endyear";
    private static final String ENDMONTHANDDAY = "endmonthandday";
    private static final String MONTHLY = "monthly";
    private static final String QUARTER = "quarter";
    private static final String HALFYEAR = "halfyear";
    private static final String ORGENTRYENTITY = "orgentryentity";
    private static final String ORG = "org";
    private static final String ORGNAME = "orgname";
    private static final String TAXATIONSYS = "group";
    private static final String TAXCATEGORY = "taxcategory";

    public void initialize() {
        super.initialize();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("heightLimit", false);
        this.getView().updateControlMetadata(ENTRYENTITY, map);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxrate = (BasedataEdit)this.getView().getControl(ORG);
        taxrate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxcateory = (BasedataEdit)this.getView().getControl(TAXCATEGORY);
        taxcateory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getModel().getValue(STARTDATE) == null) {
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)new Date());
            this.getModel().setValue(STARTDATE, (Object)firstDateOfYear);
            this.clearEntryEntityRow(ENTRYENTITY);
            this.setEntryEntityDate(firstDateOfYear);
            if ("2".equalsIgnoreCase((String)this.getModel().getValue(APPLICATIONSCOPE))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap2"});
                ((BasedataEdit)this.getControl(ORG)).setMustInput(true);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
                ((BasedataEdit)this.getControl(ORG)).setMustInput(false);
            }
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < collection.size(); ++i) {
            this.getModel().setValue(STARTTOEND, (Object)ResManager.loadKDString((String)"\u81f3", (String)"TaxYearPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), i);
        }
        this.getModel().setDataChanged(false);
        if ("2".equalsIgnoreCase((String)this.getModel().getValue(APPLICATIONSCOPE))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap2"});
            ((BasedataEdit)this.getControl(ORG)).setMustInput(true);
        } else {
            this.clearEntryEntityRow(ORGENTRYENTITY);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
            ((BasedataEdit)this.getControl(ORG)).setMustInput(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date startDate;
        if (STARTDATE.equalsIgnoreCase(e.getProperty().getName())) {
            startDate = (Date)this.getModel().getValue(STARTDATE);
            if (ObjectUtils.isEmpty((Object)startDate)) {
                this.clearEntryEntityRow(ENTRYENTITY);
            } else {
                int dayOfDate = DateUtils.getDayOfDate((Date)startDate);
                if (dayOfDate > 28) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6bcf\u670828\u65e5\u4ee5\u540e\u7684\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8d77\u59cb\u65e5\u3002", (String)"TaxYearPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                } else {
                    this.clearEntryEntityRow(ENTRYENTITY);
                    this.setEntryEntityDate(startDate);
                }
            }
        }
        if (APPLICATIONSCOPE.equalsIgnoreCase(e.getProperty().getName())) {
            startDate = (Date)this.getModel().getValue(STARTDATE);
            if (ObjectUtils.isEmpty((Object)startDate)) {
                this.clearEntryEntityRow(ENTRYENTITY);
            } else {
                this.clearEntryEntityRow(ENTRYENTITY);
                this.setEntryEntityDate(startDate);
            }
            if ("2".equalsIgnoreCase((String)this.getModel().getValue(APPLICATIONSCOPE))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap2"});
                ((BasedataEdit)this.getControl(ORG)).setMustInput(true);
            } else {
                this.clearEntryEntityRow(ORGENTRYENTITY);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
                ((BasedataEdit)this.getControl(ORG)).setMustInput(false);
            }
        }
    }

    private void setEntryEntityDate(Date date) {
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 12);
        BaseModel dataModel = (BaseModel)this.getModel();
        dataModel.beginInit();
        int currRowCnt = dataModel.getEntryRowCount(ENTRYENTITY);
        Date currentDate = new Date();
        String startToEnd = ResManager.loadKDString((String)"\u81f3", (String)"TaxYearPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < currRowCnt; ++i) {
            Date startMonthAndDay = DateUtils.addMonth((Date)date, (int)i);
            Date endMonthAndDay = DateUtils.addMonth((Date)startMonthAndDay, (int)1);
            endMonthAndDay = DateUtils.addDay((Date)endMonthAndDay, (int)-1);
            String startYear = DateUtils.getYearOfDate((Date)startMonthAndDay) > DateUtils.getYearOfDate((Date)currentDate) ? "1" : "0";
            String endYear = DateUtils.getYearOfDate((Date)endMonthAndDay) > DateUtils.getYearOfDate((Date)currentDate) ? "1" : "0";
            String quarter = i < 3 ? "1" : (i < 6 ? "2" : (i < 9 ? "3" : "4"));
            String halfYear = i < 6 ? "0" : "1";
            dataModel.setValue(STARTYEAR, (Object)startYear, i);
            dataModel.setValue(STARTMONTHANDDAY, (Object)startMonthAndDay, i);
            dataModel.setValue(STARTTOEND, (Object)startToEnd, i);
            dataModel.setValue(ENDYEAR, (Object)endYear, i);
            dataModel.setValue(ENDMONTHANDDAY, (Object)endMonthAndDay, i);
            dataModel.setValue(MONTHLY, (Object)(i + 1), i);
            dataModel.setValue(QUARTER, (Object)quarter, i);
            dataModel.setValue(HALFYEAR, (Object)halfYear, i);
        }
        dataModel.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void clearEntryEntityRow(String entity) {
        IDataModel model = this.getModel();
        model.deleteEntryData(entity);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String result = beforeF7SelectEvent.getProperty().getName();
        long currUserId = RequestContext.get().getCurrUserId();
        long taxationsysId = ((DynamicObject)this.getModel().getValue(TAXATIONSYS)).getLong("id");
        if (ORG.equalsIgnoreCase(result)) {
            TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdByIsTaxpayerWithPerm((Long)currUserId, (Long)taxationsysId);
            ArrayList<Long> orgIds = new ArrayList<Long>();
            List datas = (List)listTaxResult.getData();
            DynamicObjectCollection orgentryentityCollection = this.getModel().getEntryEntity(ORGENTRYENTITY);
            if (!ObjectUtils.isEmpty((Object)orgentryentityCollection)) {
                for (DynamicObject orgObject : orgentryentityCollection) {
                    long orgId = orgObject.getLong("org.id");
                    if (orgId == 0L) continue;
                    orgIds.add(orgId);
                }
            }
            QFilter f1 = new QFilter("id", "not in", orgIds);
            QFilter f2 = new QFilter("id", "in", (Object)datas);
            QFilter filter = f1.and(f2);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(filter);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getTreeFilterParameter().setQFilters(qFilters);
            listShowParameter.getListFilterParameter().setFilter(filter);
        } else if (TAXCATEGORY.equals(result)) {
            QFilter filter = new QFilter("taxationsysid.id", "=", (Object)taxationsysId);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(filter);
        }
    }
}

