/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.util;

import java.util.EventObject;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.formplugin.util.enums.JobInfoEnum;
import kd.taxc.tctb.formplugin.util.enums.MicroServiceEntityEnum;

public class MicroServicePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (MicroServiceEntityEnum entityEnum : MicroServiceEntityEnum.values()) {
            DynamicObject dynamicObject = collection.addNew();
            dynamicObject.set("cloud", (Object)entityEnum.getCloudId());
            dynamicObject.set("app", (Object)entityEnum.getAppId());
            dynamicObject.set("servicename", (Object)entityEnum.getServiceName());
            dynamicObject.set("methodsname", (Object)entityEnum.getMethodsName());
            dynamicObject.set("desc", (Object)entityEnum.getDesc());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtil.equalsIgnoreCase((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"start")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            DynamicObject object = (DynamicObject)collection.get(entryGrid.getEntryState().getFocusRow());
            String cloudId = object.getString("cloud");
            String appId = object.getString("app");
            String serviceName = object.getString("servicename");
            String methodName = object.getString("methodsname");
            try {
                if (StringUtil.equals((CharSequence)"RecordingVoucherMergeUpgradeService", (CharSequence)serviceName)) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("update_voucherdata", (IFormPlugin)this);
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5373\u5c06\u5347\u7ea7\u51ed\u8bc1\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5347\u7ea7\uff1f", (String)"MicroServicePlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                } else if (StringUtil.equals((CharSequence)"AccountBalanceMergeUpgradeService", (CharSequence)serviceName)) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("update_accountbalance", (IFormPlugin)this);
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5373\u5c06\u5347\u7ea7\u79d1\u76ee\u4f59\u989d\u8868\uff0c\u786e\u5b9a\u662f\u5426\u5347\u7ea7\uff1f", (String)"MicroServicePlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                } else if (StringUtil.equals((CharSequence)"RecordingUpgradeService", (CharSequence)serviceName)) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("update_voucherwriteoff", (IFormPlugin)this);
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5373\u5c06\u5347\u7ea7\u51ed\u8bc1\u6570\u636e\u6838\u9500\u5b57\u6bb5\uff0c\u786e\u5b9a\u662f\u5426\u5347\u7ea7\uff1f", (String)"MicroServicePlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                } else {
                    DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{null, null, null, null});
                    this.getView().showSuccessNotification("success!");
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        super.confirmCallBack(messageBoxClosedEvent);
        if ((StringUtils.equalsIgnoreCase((CharSequence)"update_voucherdata", (CharSequence)fieldKey) || StringUtils.equalsIgnoreCase((CharSequence)"update_accountbalance", (CharSequence)fieldKey) || StringUtils.equalsIgnoreCase((CharSequence)"update_voucherwriteoff", (CharSequence)fieldKey)) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.dispatch(fieldKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void dispatch(String key) {
        JobInfoEnum jobEnum = JobInfoEnum.getEnumByKey(key);
        if (jobEnum == null) {
            return;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(jobEnum.getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(jobEnum.getJobName());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(jobEnum.getTaskClassName());
        HashMap params = new HashMap();
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, jobEnum.getCallBackId());
        JobForm.dispatch((JobInfo)jobInfo, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }
}

