/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.enums.TaxTypeComboEnum;
import kd.taxc.tctb.business.bosorg.BosOrgService;

public class TaxPayerTypeUtil {
    private static final Log LOGGER = LogFactory.getLog(TaxPayerTypeUtil.class);
    private static String NORMAL_SELECT_FIELD = "modifydate,entryentity.modifycontexttitle,entryentity.modifycontexttitleysjbs,entryentity.modifycontexbefore,entryentity.modifycontexbeforecode,entryentity.modifycontexafter,entryentity.modifycontexaftercode,modifier";

    public static String getTaxPayerType(DynamicObject bosOrg) {
        if (bosOrg == null) {
            return null;
        }
        String taxPayerType = bosOrg.getString("taxpayertype");
        if (StringUtils.isNotBlank((CharSequence)taxPayerType) && "1".equals(taxPayerType)) {
            return "ybnsr";
        }
        if (StringUtils.isNotBlank((CharSequence)taxPayerType) && "2".equals(taxPayerType)) {
            return "xgmnsr";
        }
        return null;
    }

    public static String getTaxPayerType(Long orgid) {
        if (orgid == null || orgid == 0L) {
            return null;
        }
        DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
        String taxPayerType = bosOrg.getString("taxpayertype");
        if (StringUtils.isNotBlank((CharSequence)taxPayerType) && "1".equals(taxPayerType)) {
            return "ybnsr";
        }
        if (StringUtils.isNotBlank((CharSequence)taxPayerType) && "2".equals(taxPayerType)) {
            return "xgmnsr";
        }
        return null;
    }

    public static DynamicObject getBosOrg(Long orgid) {
        if (orgid == null || orgid == 0L) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
    }

    public static DynamicObject[] getBosOrgList(List<Long> orgids) {
        return BusinessDataServiceHelper.load((Object[])orgids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
    }

    public static DynamicObject[] getTaxMainInfoByOrgid(Long orgid) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,orgid,number,billstatus,taxationsys", (QFilter[])new QFilter[]{orgFilter});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return null;
        }
        return dynamicObjects;
    }

    public static DynamicObject getTaxMainInfoById(Long pkid) {
        try {
            return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"tctb_tax_main");
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return null;
        }
    }

    public static DynamicObject[] getTaxMainInfoByOrgidAndTaxAtion(Long orgid, Long taxAtionId) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter taxationFilter = new QFilter("taxationsys", "=", (Object)taxAtionId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,orgid,number,billstatus,taxationsys", (QFilter[])new QFilter[]{orgFilter, taxationFilter});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return null;
        }
        return dynamicObjects;
    }

    public static void updateSysTaxPayerType(DynamicObjectCollection collection, Long orgid) {
        if (EmptyCheckUtils.isEmpty((Object)collection)) {
            return;
        }
        DynamicObject bosOrg = TaxPayerTypeUtil.getBosOrg(orgid);
        for (DynamicObject taxMainInfo : collection) {
            String businessType;
            String taxPayertype;
            String taxtype = taxMainInfo.getString("taxtype");
            if (!TaxTypeComboEnum.ZZS.getCode().equalsIgnoreCase(taxtype) || Objects.equals(taxPayertype = taxMainInfo.getString("taxpayertype"), businessType = TaxPayerTypeUtil.getTaxPayerType(bosOrg)) || !Objects.equals(taxMainInfo.getString("enable"), "1")) continue;
            new BosOrgService().addOrUpdate(orgid, taxPayertype, "2018-01-01");
        }
    }

    public static void uodateNsrType(Long orgid, DynamicObjectCollection categories, String effectiveDate) {
        DynamicObject bosOrg = TaxPayerTypeUtil.getBosOrg(orgid);
        DynamicObject[] versionList = TaxPayerTypeUtil.getVersionList(orgid);
        for (DynamicObject info : categories) {
            if (!Objects.equals(info.getString("taxtype"), "zzs")) continue;
            String currentTaxType = info.getString("taxpayertype");
            String enable = info.getString("enable");
            String taxPayerType = TaxPayerTypeUtil.getTaxPayerType(bosOrg);
            if (Objects.equals(currentTaxType, taxPayerType) || !enable.equals("1")) break;
            TaxPayerTypeUtil.updateTaxpayerTypeToSys(orgid, currentTaxType, effectiveDate, versionList);
            break;
        }
    }

    public static void uodateNsrType(List<DynamicObject> taxMains, Map<Long, String> effectiveDateMap) {
        if (EmptyCheckUtils.isEmpty(taxMains)) {
            return;
        }
        List<Long> orgids = taxMains.stream().map(v -> v.getLong("orgid.id")).collect(Collectors.toList());
        DynamicObject[] bosOrgs = TaxPayerTypeUtil.getBosOrgList(orgids);
        Map<Long, DynamicObject> bosOrgMap = Arrays.stream(bosOrgs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, Optional<DynamicObject>> maxVerMap = TaxPayerTypeUtil.getMaxVerMap(orgids);
        ArrayList<OrgParam> updateList = new ArrayList<OrgParam>(8);
        for (DynamicObject taxMain : taxMains) {
            List fitTaxTypes;
            Long pkid = taxMain.getLong("id");
            Long orgid = taxMain.getLong("orgid.id");
            DynamicObjectCollection taxTypes = taxMain.getDynamicObjectCollection("categoryentryentity");
            DynamicObject lastVer = null;
            if (maxVerMap.get(orgid) != null && maxVerMap.get(orgid).isPresent()) {
                lastVer = maxVerMap.get(orgid).get();
            }
            if (!EmptyCheckUtils.isNotEmpty(fitTaxTypes = taxTypes.stream().filter(v -> "zzs".equalsIgnoreCase(v.getString("taxtype"))).collect(Collectors.toList()))) continue;
            DynamicObject fitTaxType = (DynamicObject)fitTaxTypes.get(0);
            DynamicObject bosOrg = bosOrgMap.get(orgid);
            String effectiveDate = effectiveDateMap.get(pkid);
            String currentTaxType = fitTaxType.getString("taxpayertype");
            String enable = fitTaxType.getString("enable");
            String taxPayerType = TaxPayerTypeUtil.getTaxPayerType(bosOrg);
            if (Objects.equals(currentTaxType, taxPayerType) || !enable.equals("1")) continue;
            TaxPayerTypeUtil.updateTaxpayerTypeToSys(orgid, currentTaxType, effectiveDate, lastVer, updateList);
        }
        if (updateList.size() > 0) {
            try {
                IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
                orgService.addOrUpdate(updateList);
            }
            catch (Exception e) {
                LOGGER.error("BosOrgService addOrUpdate cause exception", (Throwable)e);
            }
        }
    }

    public static void updateTaxpayerTypeToSys(Long orgid, String currentPayertype, String effectiveDate, DynamicObject[] versionList) {
        if (EmptyCheckUtils.isEmpty((Object)versionList)) {
            new BosOrgService().addOrUpdate(orgid, currentPayertype, "2018-01-01");
            return;
        }
        DynamicObject dynamicObject = versionList[0];
        List entityList = (List)dynamicObject.get("entryentity");
        for (DynamicObject entity : entityList) {
            int compare;
            if (!Objects.equals("taxenddate", entity.getString("modifycontexttitleysjbs"))) continue;
            if (StringUtils.isBlank((CharSequence)effectiveDate) && StringUtils.isBlank((CharSequence)entity.getString("modifycontexafter"))) {
                effectiveDate = "2018-01-01";
            }
            if ((compare = DateUtils.stringToDate((String)effectiveDate).compareTo(new Date())) > 0) continue;
            new BosOrgService().addOrUpdate(orgid, currentPayertype, effectiveDate);
        }
    }

    public static void updateTaxpayerTypeToSys(Long orgid, String currentPayertype, String effectiveDate, DynamicObject lastVer, List<OrgParam> updateList) {
        if (lastVer == null || EmptyCheckUtils.isEmpty((Object)lastVer)) {
            updateList.add(TaxPayerTypeUtil.getOrgParam(orgid, currentPayertype, effectiveDate));
            return;
        }
        List entityList = (List)lastVer.get("entryentity");
        for (DynamicObject entity : entityList) {
            int compare;
            if (!Objects.equals("taxenddate", entity.getString("modifycontexttitleysjbs"))) continue;
            if (StringUtils.isBlank((CharSequence)effectiveDate) && StringUtils.isBlank((CharSequence)entity.getString("modifycontexafter"))) {
                effectiveDate = "2018-01-01";
            }
            if ((compare = DateUtils.stringToDate((String)effectiveDate).compareTo(new Date())) > 0) continue;
            updateList.add(TaxPayerTypeUtil.getOrgParam(orgid, currentPayertype, effectiveDate));
        }
    }

    private static OrgParam getOrgParam(Long orgid, String currentPayertype, String effectiveDate) {
        OrgParam orgParam = new OrgParam();
        orgParam.setId(orgid.longValue());
        HashMap<String, String> propertyMap = new HashMap<String, String>(8);
        if (Objects.equals("ybnsr", currentPayertype)) {
            propertyMap.put("taxpayertype", "1");
        } else if (Objects.equals("xgmnsr", currentPayertype)) {
            propertyMap.put("taxpayertype", "2");
        }
        orgParam.setPropertyMap(propertyMap);
        return orgParam;
    }

    public static DynamicObject[] getVersionList(Long orgid) {
        QFilter q1 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q2 = new QFilter("org", "=", (Object)orgid);
        DynamicObject[] versionList = BusinessDataServiceHelper.load((String)"tctb_tax_ver_normal", (String)NORMAL_SELECT_FIELD, (QFilter[])new QFilter[]{q1, q2}, (String)"ver desc", (int)1);
        return versionList;
    }

    public static Map<Long, Optional<DynamicObject>> getMaxVerMap(List<Long> orgids) {
        QFilter orgQfilter = new QFilter("org.id", "in", orgids);
        QFilter taxTypeQfilter = new QFilter("taxtype", "=", (Object)"zzs");
        DynamicObject[] verList = BusinessDataServiceHelper.load((String)"tctb_tax_ver_normal", (String)(NORMAL_SELECT_FIELD + ",ver,org.id"), (QFilter[])new QFilter[]{orgQfilter, taxTypeQfilter}, null);
        Map<Long, Optional<DynamicObject>> maxVerMap = Arrays.stream(verList).collect(Collectors.groupingBy(k -> k.getLong("org.id"), Collectors.maxBy(Comparator.comparingLong(v -> v.getLong("ver")))));
        return maxVerMap;
    }

    public static void updateTaxpayerTypeToSys(Long orgid, String currentPayertype, String effectiveDate) {
        QFilter q1 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q2 = new QFilter("org", "=", (Object)orgid);
        DynamicObject[] versionList = BusinessDataServiceHelper.load((String)"tctb_tax_ver_normal", (String)NORMAL_SELECT_FIELD, (QFilter[])new QFilter[]{q1, q2}, (String)"ver desc", (int)1);
        if (EmptyCheckUtils.isEmpty((Object)versionList)) {
            new BosOrgService().addOrUpdate(orgid, currentPayertype, "2018-01-01");
            return;
        }
        DynamicObject dynamicObject = versionList[0];
        List entityList = (List)dynamicObject.get("entryentity");
        for (DynamicObject entity : entityList) {
            int compare;
            if (!Objects.equals("taxenddate", entity.getString("modifycontexttitleysjbs"))) continue;
            if (StringUtils.isBlank((CharSequence)effectiveDate) && StringUtils.isBlank((CharSequence)entity.getString("modifycontexafter"))) {
                effectiveDate = "2018-01-01";
            }
            if ((compare = DateUtils.stringToDate((String)effectiveDate).compareTo(new Date())) > 0) continue;
            new BosOrgService().addOrUpdate(orgid, currentPayertype, effectiveDate);
        }
    }
}

