/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.ygx;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ShaSignUtils;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.open.res.model.ThirdAppApplyInfoDto;
import kd.bos.open.res.plugin.service.impl.ThirdAppApplyClientServiceImpl;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.util.FileEncryptorUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.common.dto.AllAttachResp;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class CloudUpdateListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(CloudUpdateListPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("ygx".equals(operateKey)) {
            ThirdAppApplyInfoDto dto = new ThirdAppApplyInfoDto();
            ThirdAppApplyClientServiceImpl service = new ThirdAppApplyClientServiceImpl();
            ApiCommonResult result = null;
            try {
                result = service.findThirdAppApplyInfo(dto);
                LOGGER.info("findThirdAppApplyInfo result:{}", (Object)SerializationUtils.toJsonString((Object)result));
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"tctb_cloud_update");
            String number = DeclareServiceHelper.generateSBBNo((String)"tctb_cloud_update", (DynamicObject)object, (String)String.valueOf(RequestContext.get().getOrgId()));
            object.set("billno", (Object)number);
            object.set("ygxtime", (Object)new Date());
            object.set("operatype", (Object)"0");
            String operaresult = "0";
            String URL2 = null;
            if ("0".equals(result.getErrorCode())) {
                URL2 = this.getUrlAndParams((ThirdAppApplyDto)result.getData());
            } else {
                ApiCommonResult result2 = null;
                try {
                    result2 = service.findThirdAppApplyInfo(dto);
                    LOGGER.info("findThirdAppApplyInfo2 result:{}", (Object)SerializationUtils.toJsonString((Object)result2));
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
                if ("0".equals(result2.getErrorCode())) {
                    URL2 = this.getUrlAndParams((ThirdAppApplyDto)result2.getData());
                }
            }
            try {
                if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{URL2})) {
                    List<AllAttachResp> allAttachResps = this.getAttaFiles(HttpClientUtils.get((String)URL2));
                    if (CollectionUtils.isEmpty(allAttachResps)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u4ee5\u201c\u66f4\u65b0\u201d\u7684\u6570\u636e\u3002", (String)"CloudUpdateListPlugin1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        this.getView().invokeOperation("refresh");
                        return;
                    }
                    Boolean dealSqlData = this.dealSqlData(allAttachResps);
                    if (Objects.isNull(dealSqlData)) {
                        return;
                    }
                    operaresult = dealSqlData != false ? "1" : "0";
                }
            }
            catch (Exception e) {
                LOGGER.error("HttpClient exec ERROR !!!", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            object.set("operaresult", (Object)operaresult);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            this.getView().invokeOperation("refresh");
            if ("1".equals(operaresult)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"CloudUpdateListPlugin2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean dealSqlData(List<AllAttachResp> param) throws Exception {
        for (AllAttachResp o : param) {
            String kdec_name = o.getKdec_name();
            String kdec_billno = o.getKdec_billno();
            String kdec_startdate = o.getKdec_startdate();
            String kdec_enddate = o.getKdec_enddate();
            List attachDtos = o.getAttachDtos();
            LOGGER.info("dealSqlData kdec_name:{},kdec_billno:{},kdec_startdate:{},kdec_enddate:{},size:{}", new Object[]{kdec_name, kdec_billno, kdec_startdate, kdec_enddate, attachDtos.size()});
            for (AllAttachResp.AttachDto v : attachDtos) {
                Boolean bl;
                String url = v.getUrl();
                String name = v.getName();
                InputStream inputStream = null;
                ZipInputStream zipInputStream = null;
                BufferedReader reader = null;
                try {
                    ZipEntry entry;
                    URL urlCon = new URL(url);
                    inputStream = new BufferedInputStream(FileEncryptorUtil.decryptDecryptFile((InputStream)urlCon.openStream()));
                    zipInputStream = new ZipInputStream(inputStream);
                    ArrayList<String> xmldata = new ArrayList<String>();
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        String line;
                        LOGGER.info("Reading file:{},form:{}", (Object)entry.getName(), (Object)name);
                        if (!entry.getName().endsWith(".sql") && !entry.getName().endsWith(".xml")) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u4e91\u66f4\u65b0\u201d\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloudUpdateListPlugin0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        }
                        reader = new BufferedReader(new InputStreamReader(zipInputStream));
                        while ((line = reader.readLine()) != null) {
                            if (entry.getName().endsWith(".sql")) {
                                this.lineExecuteSql("taxc", line);
                                continue;
                            }
                            if (!entry.getName().endsWith(".xml")) continue;
                            xmldata.add(line);
                        }
                        zipInputStream.closeEntry();
                    }
                    for (String str : xmldata) {
                        this.lineExecuteXml(str);
                    }
                }
                catch (ConnectException e) {
                    LOGGER.error("ConnectException dealSqlData ERROR,", (Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u4e91\u66f4\u65b0\u201d\u7f51\u7edc\u94fe\u63a5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloudUpdateListPlugin3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    bl = null;
                    return bl;
                }
                catch (Exception e) {
                    LOGGER.error("dealSqlData ERROR,", (Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u4e91\u66f4\u65b0\u201d\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloudUpdateListPlugin0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        return true;
    }

    private void lineExecuteSql(String routeKey, String sqlContent) {
        if (!StringUtils.isEmpty((CharSequence)sqlContent)) {
            LOGGER.info("\u6267\u884cSQL\uff1a{}", (Object)sqlContent);
            DB.execute((DBRoute)new DBRoute(routeKey), (String)sqlContent);
        }
    }

    private void lineExecuteXml(String sqlContent) {
        if (!StringUtils.isEmpty((CharSequence)sqlContent)) {
            LOGGER.info("\u6267\u884cSQL\uff1a{}", (Object)sqlContent);
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(new InputSource(new StringReader(sqlContent)));
                Element rootElement = document.getRootElement();
                Element longtextdata = rootElement.element("longtextdata");
                Element pkcol = longtextdata.element("pkcols").element("pkcol");
                if (longtextdata != null && pkcol != null && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{longtextdata.elementText("data")})) {
                    String dbkey = longtextdata.attributeValue("dbkey");
                    String tablename = longtextdata.attributeValue("tablename");
                    String colname = longtextdata.attributeValue("colname");
                    String name = pkcol.attributeValue("name");
                    String type = pkcol.attributeValue("type");
                    if (!"11".equals(type) || !"FID".equals(name)) {
                        throw new KDBizException("XML File TYPE ERROR !!!");
                    }
                    String idvalue = pkcol.attributeValue("value");
                    String textContent = longtextdata.elementText("data");
                    String sqlStr = "update " + tablename + " set " + colname + " = ? where " + name + " = ? ";
                    ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
                    Object[] object = new Object[]{textContent, Long.parseLong(idvalue)};
                    updateParams.add(object);
                    DBUtils.executeBatch((String)dbkey, (String)sqlStr, updateParams);
                }
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private List<AllAttachResp> getAttaFiles(String result) {
        JSONObject json = JSONObject.parseObject((String)result);
        if (json.getBoolean("status").booleanValue() && "00".equals(json.getString("errorCode"))) {
            try {
                String data = json.getString("data");
                return (List)JSONUtils.cast((String)data, List.class, (Class[])new Class[]{AllAttachResp.class});
            }
            catch (IOException e) {
                LOGGER.error("getAttaFiles exec ERROR !!!", (Throwable)e);
            }
        }
        return null;
    }

    private String getUrlAndParams(ThirdAppApplyDto dto) {
        String encodedDate;
        String signkey;
        String URL2 = dto.getTargeturl() + "kapi/v2/kdec/kdec_taxc/nrgl/attachs";
        String publickey = dto.getPublickey();
        String uuidAsString = UUID.randomUUID().toString().replace("-", "");
        Date date = new Date();
        String longDateStr = DateUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        try {
            signkey = ShaSignUtils.HMACSHA256StrByKey((String)("pageSize=1000&pageNo=1" + longDateStr + uuidAsString), (String)publickey);
            encodedDate = URLEncoder.encode(longDateStr, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            LOGGER.error("CloudUpdateListPlugin getUrlAndParams ERROR!", (Throwable)e);
            throw new KDBizException("ShaSignUtils.HMACSHA256StrByKey ERROR !!!" + e);
        }
        return URL2 + "?pageSize=1000&pageNo=1&appId=" + dto.getThirdcode() + "&timestamp=" + encodedDate + "&signatureNonce=" + uuidAsString + "&signature=" + signkey + "&parameters=pageSize,pageNo&user=" + dto.getEmail() + "&accountId=" + dto.getTargetaccountid() + "&usertype=Email";
    }
}

