/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.taxc.common.util.DBUtils;
import kd.taxc.tctb.upgradeservice.YhsEntityUpgradePlugin;

public class TcvatIncomeRuleDataSourceUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(YhsEntityUpgradePlugin.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        try {
            if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_datasource_pkrules") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_datasource")) {
                this.updateDataSource();
            }
        }
        catch (Throwable t) {
            LOGGER.error("DATA UPGRADE FAILURE!!!!", t);
        }
        result.setLog(LOGGER.toString());
        result.setSuccess(success);
        result.setEl("");
        return result;
    }

    private void updateDataSource() {
        String existsQuery = "select fpkid from t_tctb_datasource_pkrules where fbasedataid = 1916782912498648064;";
        try (DataSet existDataSet = DB.queryDataSet((String)"TcvatIncomeRuleDataSourceUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)existsQuery);){
            if (!existDataSet.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        String queryUpdateData = "select fpkid, fid, fbasedataid from t_tctb_datasource_pkrules where fid in (select fid from t_tctb_datasource where fid not in (1163062995127970816,1835580761286481920,1543335746595744768,1916656681010699264) and fgroupid = 978216567512983552) and fbasedataid = 1043426415279747072;";
        try (DataSet datasourcePkrulesDataSet = DB.queryDataSet((String)"TcvatIncomeRuleDataSourceUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)queryUpdateData);){
            if (datasourcePkrulesDataSet.isEmpty()) {
                return;
            }
            int dataCount = datasourcePkrulesDataSet.copy().count("FPKID", false);
            long[] pkidArray = DB.genLongIds((String)"t_tctb_datasource_pkrules", (int)dataCount);
            ArrayList<Object[]> insertParam = new ArrayList<Object[]>(dataCount);
            ArrayList<Object[]> updateParam = new ArrayList<Object[]>(dataCount);
            int i = 0;
            while (datasourcePkrulesDataSet.hasNext()) {
                Row row = datasourcePkrulesDataSet.next();
                updateParam.add(new Object[]{1916782639197675520L, row.getLong("FPKID")});
                insertParam.add(new Object[]{pkidArray[i++], row.getLong("FID"), 1916782912498648064L});
            }
            String updateSql = "update t_tctb_datasource_pkrules set fbasedataid = ? where fpkid = ?;";
            DBUtils.executeBatch((String)updateSql, updateParam);
            String insertSql = "insert into t_tctb_datasource_pkrules (fpkid, fid, fbasedataid) values (?,?,?);";
            DBUtils.executeBatch((String)insertSql, insertParam);
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }
}

