/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.upgradeservice;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.taxc.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.tctb.business.org.YhsEntityUpgradeBusisess;

public class YhsEntityUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YhsEntityUpgradePlugin.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        try (TXHandle h = TX.requiresNew();){
            try {
                YhsEntityUpgradeBusisess.sqlUpdate();
                this.addLog(INFO, "taxc-YhsEntityUpgradePlugin succ");
            }
            catch (Exception e) {
                String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                this.addLog(ERROR, String.format("taxc-YhsEntityUpgradePlugin upgrade fail:\uff1a%S", exceptionStackTraceMessage));
                h.markRollback();
            }
        }
    }
}

