/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.DateUtils;

public class DeductionRatePluginSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObjectCollection entryentity;
                    QFilter idFilter;
                    DynamicObject obj = dataEntity.getDataEntity();
                    Object billPkId = dataEntity.getBillPkId();
                    DynamicObject org = obj.getDynamicObject("org");
                    long orgid = org.getLong("id");
                    QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
                    boolean exists = QueryServiceHelper.exists((String)"tctb_deduction_rate", (QFilter[])new QFilter[]{orgFilter, idFilter = new QFilter("id", "!=", billPkId)});
                    if (exists) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DeductionRatePluginSaveOp_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    }
                    if (null == (entryentity = obj.getDynamicObjectCollection("entryentity"))) continue;
                    ArrayList<String> dateList = new ArrayList<String>();
                    for (DynamicObject dynamicObject : entryentity) {
                        LocalDate endLocalDate;
                        LocalDate startLocalDate;
                        Date startdate = dynamicObject.getDate("datestart");
                        if (null != startdate && !DateUtils.isFirstOrLastDay((String)"start", (LocalDate)(startLocalDate = DateUtils.date2LocalDate((Date)startdate)))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u53ea\u80fd\u9009\u62e9\u6708\u521d1\u53f7\u3002", (String)"DeductionRatePluginSaveOp_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        Date enddate = dynamicObject.getDate("dateend");
                        if (null != enddate && !DateUtils.isFirstOrLastDay((String)"end", (LocalDate)(endLocalDate = DateUtils.date2LocalDate((Date)enddate)))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u53ea\u80fd\u9009\u62e9\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"DeductionRatePluginSaveOp_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (null == startdate || null == enddate) continue;
                        if (enddate.before(startdate)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u4e0d\u80fd\u5c0f\u4e8e\u6709\u6548\u671f\u8d77\u3002", (String)"DeductionRatePluginSaveOp_3", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        dateList.add(DateUtils.format((Date)startdate).concat(" ").concat(DateUtils.format((Date)enddate)));
                        boolean overlapping = DateUtils.overlapping(dateList);
                        if (!overlapping) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7814\u53d1\u52a0\u8ba1\u6263\u9664\u7387\u7ef4\u62a4\u6709\u6548\u671f\u5b58\u5728\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DeductionRatePluginSaveOp_4", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
        });
    }
}

