/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeTypeEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.taxcmain.TaxcMainBusiness;

public class OrgGroupSaveValidator
extends AbstractValidator {
    private static final String ENTRYGRID_NAME = "orgrow";
    private static final String STATUS_PARENT = "2";
    private static final String STATUS_CHILD = "3";
    public static final String TAX_CIT = "qysds";
    public static final String TAX_SLJSJJ = "sljsjj";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_EFFECTDATE = "effectdate";
    private static final String FIELD_INVALIDDATE = "invaliddate";
    public static final String FIELD_TAXTYPE = "taxtype";
    private static final String FIELD_ORGCODE = "orgid.number";
    private static final String FIELD_DECLARATION = "declaration";
    private static final String FIELD_ORGID = "orgid";
    private static final String FIELD_LEVEL = "level";
    private static final String ID = "id";
    private static final String KDQJYQYLX = "kdqjyqylx";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.doSaveValidators(dataEntity);
            this.saveClick(dataEntity);
        }
    }

    private void doSaveValidators(ExtendedDataEntity dataEntity) {
        BigDecimal fixedratio;
        String taxtype = (String)dataEntity.getValue(FIELD_TAXTYPE);
        String summaryorgtype = (String)dataEntity.getValue("summaryorgtype");
        String summaryway = (String)dataEntity.getValue("summaryway");
        String prelevyrate = (String)dataEntity.getValue("prelevyrate");
        if ("zzs".equals(taxtype) && "1".equals(summaryway) && "1".equals(prelevyrate) && ((fixedratio = (BigDecimal)dataEntity.getValue("fixedratio")).compareTo(BigDecimal.ONE) > 0 || fixedratio.compareTo(BigDecimal.ZERO) <= 0)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\"\u56fa\u5b9a\u6bd4\u4f8b\u503c\",\u8d85\u51fa\u6570\u503c\u8303\u56f4(0,1]", (String)"OrgGroupSaveValidator_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return;
        }
        if ("zzs".equals(taxtype) && "5".equals(summaryorgtype) && STATUS_PARENT.equals(summaryway)) {
            String fpxssrfw = (String)dataEntity.getValue("fpxssrfw");
            String ybtsehffs = (String)dataEntity.getValue("ybtsehffs");
            String zfjgsefpfs = (String)dataEntity.getValue("zfjgsefpfs");
            if (StringUtils.isBlank((CharSequence)fpxssrfw) || StringUtils.isBlank((CharSequence)ybtsehffs) || StringUtils.isBlank((CharSequence)zfjgsefpfs)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u914d\u9500\u552e\u6536\u5165\u8303\u56f4\u3001\u5e94\u8865\u9000\u7a0e\u989d\u5212\u5206\u65b9\u5f0f\u3001\u603b\u5206\u673a\u6784\u7a0e\u989d\u5206\u914d\u65b9\u5f0f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgGroupSaveValidator_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryentity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            if (STATUS_PARENT.equals(zfjgsefpfs) && entryentity.size() > 0) {
                BigDecimal ybxmhwbl = BigDecimal.ZERO;
                BigDecimal jzjthwbl = BigDecimal.ZERO;
                BigDecimal ybxmysbl = BigDecimal.ZERO;
                BigDecimal jzjtysbl = BigDecimal.ZERO;
                for (DynamicObject row : entryentity) {
                    if (this.isChangeBill() && BizChangeTypeEnum.DELETE.getValue().equalsIgnoreCase(row.getString("entrychangetype1"))) continue;
                    ybxmhwbl = ybxmhwbl.add(row.getBigDecimal("ybxmhwbl"));
                    jzjthwbl = jzjthwbl.add(row.getBigDecimal("jzjthwbl"));
                    ybxmysbl = ybxmysbl.add(row.getBigDecimal("ybxmysbl"));
                    jzjtysbl = jzjtysbl.add(row.getBigDecimal("jzjtysbl"));
                }
                if (ybxmhwbl.compareTo(BigDecimal.ZERO) != 0 && ybxmhwbl.compareTo(BigDecimal.ONE) != 0) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e00\u822c\u9879\u76ee\u8d27\u7269\u53ca\u52b3\u52a1\u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u9700\u7b49\u4e8e1\u3002", (String)"OrgGroupSaveValidator_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (jzjthwbl.compareTo(BigDecimal.ZERO) != 0 && jzjthwbl.compareTo(BigDecimal.ONE) != 0) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8d27\u7269\u53ca\u52b3\u52a1\u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u9700\u7b49\u4e8e1\u3002", (String)"OrgGroupSaveValidator_3", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (ybxmysbl.compareTo(BigDecimal.ZERO) != 0 && ybxmysbl.compareTo(BigDecimal.ONE) != 0) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e00\u822c\u9879\u76ee\u5e94\u7a0e\u670d\u52a1\u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u9700\u7b49\u4e8e1\u3002", (String)"OrgGroupSaveValidator_4", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (jzjtysbl.compareTo(BigDecimal.ZERO) != 0 && jzjtysbl.compareTo(BigDecimal.ONE) != 0) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u5e94\u7a0e\u670d\u52a1\u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u9700\u7b49\u4e8e1\u3002", (String)"OrgGroupSaveValidator_5", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        } else if (TAX_CIT.equals(taxtype)) {
            DynamicObjectCollection orgrow = dataEntity.getDataEntity().getDynamicObjectCollection(ENTRYGRID_NAME);
            boolean allMatch = orgrow.stream().filter(s -> s.getString(FIELD_DECLARATION).equals(STATUS_CHILD)).allMatch(s -> s.getString(KDQJYQYLX).equals("312"));
            Optional<DynamicObject> first = orgrow.stream().filter(s -> s.getString(FIELD_DECLARATION).equals(STATUS_PARENT)).findFirst();
            if (first.isPresent()) {
                if (allMatch && first.get().getString(KDQJYQYLX).equals("210")) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u88ab\u6c47\u603b\u7ec4\u7ec7\u5747\u4e3a\u4e0d\u5c31\u5730\u9884\u7f34\u5206\u652f\u673a\u6784\u65f6\uff0c\u6c47\u603b\u7ec4\u7ec7\u4e0d\u5f97\u8bbe\u7f6e\u4e3a\u9002\u7528\u8de8\u5730\u533a\u7ecf\u8425\u7ba1\u7406\u529e\u6cd5\u7684\u603b\u673a\u6784\u3002", (String)"OrgGroupSaveValidator_6", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("org.number", "=", first.get().get(FIELD_ORGCODE)), new QFilter("istaxpayer", "=", (Object)"0")})) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6c47\u603b\u7ec4\u7ec7\u4e0d\u662f\u7eb3\u7a0e\u4e3b\u4f53\u3002", (String)"OrgGroupSaveValidator_7", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private void saveClick(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryid;
        DynamicObject[] objects;
        List jmqyhdzsOrgList;
        this.verify(dataEntity);
        ArrayList<String> zzsOrgNums = new ArrayList<String>();
        DynamicObjectCollection entryList = dataEntity.getDataEntity().getDynamicObjectCollection(ENTRYGRID_NAME);
        String taxType = (String)dataEntity.getValue(FIELD_TAXTYPE);
        String summaryway = (String)dataEntity.getValue("summaryway");
        if (entryList != null) {
            List orgIds = entryList.stream().filter(v -> v.getDynamicObject(FIELD_ORGID) != null).map(v -> v.getDynamicObject(FIELD_ORGID).getLong(ID)).collect(Collectors.toList());
            Map<Object, Object> orgMap = new HashMap(10);
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgIds);
            if (result != null && result.isSuccess()) {
                orgMap = ((List)result.getData()).stream().filter(v -> v.getDynamicObject(FIELD_ORGID) != null).collect(Collectors.toMap(k -> k.getDynamicObject(FIELD_ORGID).getLong(ID), v -> v));
            }
            for (DynamicObject obj2 : entryList) {
                Integer level = (Integer)obj2.get(FIELD_LEVEL);
                if (TAX_CIT.equals(taxType)) {
                    if (level > 3) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u6c47\u603b\u5173\u7cfb\u6700\u591a\u5141\u8bb8\u5efa\u7acb\u4e09\u7ea7\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"OrgGroupSaveValidator_8", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject org = obj2.getDynamicObject(FIELD_ORGID);
                    DynamicObject taxMain = (DynamicObject)orgMap.get(org.getLong(ID));
                    if (STATUS_PARENT.equals(obj2.getString(FIELD_DECLARATION)) && Lists.newArrayList((Object[])new String[]{"311", "312"}).contains(obj2.getString(KDQJYQYLX))) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c47\u603b\u7533\u62a5\u7ec4\u7ec7\u7684\u201c\u8de8\u5730\u533a\u7ecf\u8425\u4f01\u4e1a\u7c7b\u578b\u201d\u4e0d\u5f97\u914d\u7f6e\u4e3a\u5206\u652f\u673a\u6784\uff0c\u8bf7\u5148\u8c03\u6574\u5206\u652f\u673a\u6784\u7684\u201c\u5206\u644a\u6807\u8bc6\u201d\uff0c\u518d\u4fee\u6539\u6c47\u603b\u7533\u62a5\u7ec4\u7ec7\u7684\u201c\u8de8\u5730\u533a\u7ecf\u8425\u4f01\u4e1a\u7c7b\u578b\u201d\u4e3a\u603b\u673a\u6784\u3002", (String)"OrgGroupSaveValidator_10", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        return;
                    }
                } else if ("zzs".equals(taxType)) {
                    if (level > 3) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u6c47\u603b\u5173\u7cfb\u6700\u591a\u5141\u8bb8\u5efa\u7acb\u4e09\u7ea7\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"OrgGroupSaveValidator_11", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        return;
                    }
                } else if (TAX_SLJSJJ.equals(taxType) && level > 3) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u6c47\u603b\u5173\u7cfb\u6700\u591a\u5141\u8bb8\u5efa\u7acb\u4e09\u7ea7\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"OrgGroupSaveValidator_12", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
                zzsOrgNums.add(obj2.getString(FIELD_ORGCODE));
            }
        }
        if ("zzs".equalsIgnoreCase(taxType)) {
            QFilter orgsQFilter = new QFilter(FIELD_ORGCODE, "in", zzsOrgNums);
            QFilter taxtypeQfilter = new QFilter("categoryentryentity.taxtype", "=", (Object)"zzs");
            QFilter taxpayertypeQfilter = new QFilter("categoryentryentity.taxpayertype", "=", (Object)"ybnsr");
            QFilter[] zzsFilter = new QFilter[]{orgsQFilter, taxtypeQfilter, taxpayertypeQfilter};
            DynamicObjectCollection zzsOrgs = QueryServiceHelper.query((String)"tctb_tax_main", (String)FIELD_ORGCODE, (QFilter[])zzsFilter);
            if (entryList != null && zzsOrgs != null && entryList.size() > zzsOrgs.size()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6c47\u603b\u7ec4\u7ec7\u201d\u603b\u673a\u6784\u53ca\u5176\u5206\u652f\u673a\u6784\u9700\u4e3a\u201c\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OrgGroupSaveValidator_13", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                return;
            }
        } else if (TAX_CIT.equals(taxType) && (jmqyhdzsOrgList = Stream.of(objects = TaxcMainBusiness.loadTaxcMainQysdsByOrgNums(zzsOrgNums, (Long)TaxationsysMappingEnum.CHN.getId())).filter(obj -> {
            DynamicObjectCollection taxTypes = obj.getDynamicObjectCollection("categoryentryentity");
            if (taxTypes.size() > 0) {
                DynamicObject taxTypeObj = (DynamicObject)taxTypes.get(0);
                return "jmqy".equals(taxTypeObj.getString("residenttype")) && "hdzs".equals(taxTypeObj.getString("levytype"));
            }
            return false;
        }).map(v -> v.getString("taxorg.org.name")).collect(Collectors.toList())).size() > 0) {
            String message = StringUtils.join((Object[])jmqyhdzsOrgList.toArray(), (char)'\u3001').concat(ResManager.loadKDString((String)"\u4e3a\u5c45\u6c11\u4f01\u4e1a\u6838\u5b9a\u5f81\u6536\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u6c47\u603b\u65b9\u6848\u3002", (String)"OrgGroupSaveValidator_14", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            this.addFatalErrorMessage(dataEntity, message);
            return;
        }
        if ((entryid = dataEntity.getDataEntity().getDynamicObjectCollection(ENTRYGRID_NAME)) == null || entryid.isEmpty()) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u6c47\u603b\u7ec4\u7ec7\u3002", (String)"OrgGroupSaveValidator_15", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void verify(ExtendedDataEntity dataEntity) {
        int day;
        OrmLocaleValue name = (OrmLocaleValue)dataEntity.getValue(FIELD_NAME);
        String number = (String)dataEntity.getValue(FIELD_NUMBER);
        Date startdate = (Date)dataEntity.getValue(FIELD_EFFECTDATE);
        Date enddate = (Date)dataEntity.getValue(FIELD_INVALIDDATE);
        String taxtype = (String)dataEntity.getValue(FIELD_TAXTYPE);
        String orgtype = (String)dataEntity.getValue("summaryorgtype");
        String summaryway = (String)dataEntity.getValue("summaryway");
        String prelevyrate = (String)dataEntity.getValue("prelevyrate");
        BigDecimal fixedratio = (BigDecimal)dataEntity.getValue("fixedratio");
        String fpxssrfw = (String)dataEntity.getValue("fpxssrfw");
        String ybtsehffs = (String)dataEntity.getValue("ybtsehffs");
        String zfjgsefpfs = (String)dataEntity.getValue("zfjgsefpfs");
        BigDecimal zjggdbl = (BigDecimal)dataEntity.getValue("zjggdbl");
        if ("".equals(StringUtils.trimToEmpty((String)number))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u7f16\u7801\u3002", (String)"OrgGroupSaveValidator_16", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return;
        }
        if (name == null || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"OrgGroupSaveValidator_17", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isChangeBill() && StringUtils.isEmpty((CharSequence)((String)dataEntity.getValue("changereason")))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d8\u66f4\u539f\u56e0", (String)"OrgGroupSaveValidator_31", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((Object)startdate)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6709\u6548\u671f\u8d77\u3002", (String)"OrgGroupSaveValidator_18", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)taxtype, (CharSequence)"zzs")) {
            if (StringUtils.isBlank((CharSequence)orgtype)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6c47\u603b\u4f01\u4e1a\u7c7b\u578b\u3002", (String)"OrgGroupSaveValidator_19", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)summaryway)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6c47\u603b\u65b9\u5f0f\u3002", (String)"OrgGroupSaveValidator_20", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)summaryway, (CharSequence)"1")) {
                if (StringUtil.isBlank((CharSequence)prelevyrate)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9884\u5f81\u7387\u8ba1\u7b97", (String)"OrgGroupSaveValidator_21", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)prelevyrate, (CharSequence)"1") && EmptyCheckUtils.isEmpty((Object)fixedratio)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u56fa\u5b9a\u6bd4\u4f8b\u503c\u3002", (String)"OrgGroupSaveValidator_22", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
        if ((day = DateUtils.getDayOfDate((Date)startdate)) != 1) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u65f6\u95f4\u8d77\u53ea\u80fd\u4e3a\u6708\u521d1\u53f7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OrgGroupSaveValidator_23", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return;
        }
        if (enddate != null) {
            int day2;
            Date LastDate = DateUtils.getLastDateOfMonth((Date)enddate);
            int day1 = DateUtils.getDayOfDate((Date)enddate);
            if (day1 != (day2 = DateUtils.getDayOfDate((Date)LastDate))) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u65f6\u95f4\u6b62\u53ea\u80fd\u4e3a\u6708\u672b\u6700\u540e\u4e00\u5929\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OrgGroupSaveValidator_24", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (enddate != null && startdate.compareTo(enddate) > 0) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u665a\u4e8e\u6709\u6548\u671f\u6b62\u3002", (String)"OrgGroupSaveValidator_25", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private boolean isChangeBill() {
        return "tctb_xorg_group".equalsIgnoreCase(this.getEntityKey());
    }
}

