/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.business.changemodel.service.impl.BillTransferService;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.DynamicObjectUtils;
import kd.taxc.tctb.business.orggroup.TaxcOrgGroupBusiness;

public class OrgGroupUniqueValidator
extends AbstractValidator {
    public void validate() {
        List<DynamicObject> allObjs = null;
        Map<Long, DynamicObject> sourceBillMap = null;
        List<DynamicObject> objects = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
        if (this.isChangeBill()) {
            BillTransferService billTransferService = new BillTransferService();
            Object[] srcBills = billTransferService.reserveSrcBill(objects.toArray(new DynamicObject[objects.size()]));
            allObjs = this.loadAllObjs(Lists.newArrayList((Object[])srcBills));
            sourceBillMap = Arrays.stream(srcBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        } else {
            allObjs = this.loadAllObjs(objects);
        }
        this.checkNumberDuplicate(allObjs, sourceBillMap);
        this.checkNameDuplicate(allObjs, sourceBillMap);
        this.checkTaxTypeOrgDuplicate(allObjs, sourceBillMap);
    }

    private List<DynamicObject> loadAllObjs(List<DynamicObject> toDoObjs) {
        DynamicObject[] objects = TaxcOrgGroupBusiness.loadAllOrgGroup();
        ArrayList<DynamicObject> allObjs = new ArrayList<DynamicObject>(100);
        allObjs.addAll(toDoObjs);
        List toDoObjIds = toDoObjs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        List dbObjs = Arrays.stream(objects).filter(v -> !toDoObjIds.contains(v.getLong("id"))).collect(Collectors.toList());
        allObjs.addAll(dbObjs);
        return allObjs;
    }

    protected void checkNumberDuplicate(List<DynamicObject> allObjs, Map<Long, DynamicObject> sourceBillMap) {
        for (ExtendedDataEntity entry : this.dataEntities) {
            DynamicObject currentObj = entry.getDataEntity();
            if (this.isChangeBill() && sourceBillMap != null) {
                currentObj = sourceBillMap.get(currentObj.getLong("sourcebillid"));
            }
            for (DynamicObject obj : allObjs) {
                if (currentObj.getLong("id") == obj.getLong("id") || this.getFalseDataEntities().contains(entry) || !this.hasNumberDuplicate(currentObj, obj)) continue;
                String uniqueErrorMsg = this.buildNumberUniqueErrorMsg(currentObj, obj);
                this.addFatalErrorMessage(entry, uniqueErrorMsg);
            }
        }
    }

    private boolean hasNumberDuplicate(DynamicObject currentObj, DynamicObject obj) {
        Object o1 = currentObj.get("number");
        Object o2 = obj.get("number");
        return DynamicObjectUtils.isEquals((Object)o1, (Object)o2);
    }

    private String buildNumberUniqueErrorMsg(DynamicObject currentObj, DynamicObject obj) {
        return ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"OrgGroupSaveValidator_26", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
    }

    protected void checkNameDuplicate(List<DynamicObject> allObjs, Map<Long, DynamicObject> sourceBillMap) {
        for (ExtendedDataEntity entry : this.dataEntities) {
            DynamicObject currentObj = entry.getDataEntity();
            if (this.isChangeBill() && sourceBillMap != null) {
                currentObj = sourceBillMap.get(currentObj.getLong("sourcebillid"));
            }
            for (DynamicObject obj : allObjs) {
                if (currentObj.getLong("id") == obj.getLong("id") || this.getFalseDataEntities().contains(entry) || !this.hasNameDuplicate(currentObj, obj)) continue;
                String uniqueErrorMsg = this.buildNameUniqueErrorMsg(entry, currentObj, obj);
                this.addFatalErrorMessage(entry, uniqueErrorMsg);
            }
        }
    }

    private boolean hasNameDuplicate(DynamicObject currentObj, DynamicObject obj) {
        Object o1 = currentObj.get("name");
        Object o2 = obj.get("name");
        return DynamicObjectUtils.isEquals((Object)o1, (Object)o2);
    }

    private String buildNameUniqueErrorMsg(ExtendedDataEntity entry, DynamicObject currentObj, DynamicObject obj) {
        return ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"OrgGroupSaveValidator_27", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
    }

    protected void checkTaxTypeOrgDuplicate(List<DynamicObject> allObjs, Map<Long, DynamicObject> sourceBillMap) {
        for (ExtendedDataEntity entry : this.dataEntities) {
            DynamicObject currentObj = entry.getDataEntity();
            if (this.isChangeBill() && sourceBillMap != null) {
                currentObj = sourceBillMap.get(currentObj.getLong("sourcebillid"));
            }
            for (DynamicObject obj : allObjs) {
                if (currentObj.getLong("id") == obj.getLong("id") || this.getFalseDataEntities().contains(entry) || !this.hasTaxTypeOrgDuplicate(currentObj, obj)) continue;
                String uniqueErrorMsg = this.buildTaxTypeOrgErrorMsg(currentObj, obj);
                this.addFatalErrorMessage(entry, uniqueErrorMsg);
            }
        }
    }

    private boolean hasTaxTypeOrgDuplicate(DynamicObject currentObj, DynamicObject obj) {
        Date endDate;
        Date startDate;
        Date endTime;
        Object o2;
        Object o1 = currentObj.get("taxtype");
        if (!DynamicObjectUtils.isEquals((Object)o1, (Object)(o2 = obj.get("taxtype")))) {
            return false;
        }
        Date beginTime = currentObj.getDate("effectdate");
        if (!this.hasDateDuplicate(beginTime, endTime = currentObj.getDate("invaliddate"), startDate = obj.getDate("effectdate"), endDate = obj.getDate("invaliddate"))) {
            return false;
        }
        DynamicObjectCollection currentEntries = currentObj.getDynamicObjectCollection("orgrow");
        Set currentOrgIds = currentEntries.stream().map(v -> v.getLong("orgid.id")).collect(Collectors.toSet());
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("orgrow");
        Set orgIds = entries.stream().map(v -> v.getLong("orgid.id")).collect(Collectors.toSet());
        currentOrgIds.retainAll(orgIds);
        return currentOrgIds.size() != 0;
    }

    protected boolean hasDateDuplicate(Date beginTime, Date endTime, Date startDate, Date endDate) {
        Date[] date;
        if (beginTime != null) {
            beginTime = DateUtils.getDayFirst((Date)beginTime);
        }
        if (endTime != null) {
            endTime = DateUtils.getDayFirst((Date)endTime);
        }
        if (startDate != null) {
            startDate = DateUtils.getDayFirst((Date)startDate);
        }
        if (endDate != null) {
            endDate = DateUtils.getDayFirst((Date)endDate);
        }
        return (date = DateUtils.getIntersectionDate((Date)beginTime, (Date)endTime, (Date)startDate, (Date)endDate)) != null && date.length > 0;
    }

    private String buildTaxTypeOrgErrorMsg(DynamicObject currentObj, DynamicObject obj) {
        Date startdate = currentObj.getDate("effectdate");
        Date enddate = currentObj.getDate("invaliddate");
        String number = obj.getString("number");
        HashMap orgMap = new HashMap(10);
        DynamicObjectCollection currentEntries = currentObj.getDynamicObjectCollection("orgrow");
        Set currentOrgIds = currentEntries.stream().map(v -> v.getLong("orgid.id")).collect(Collectors.toSet());
        currentEntries.stream().forEach(e -> orgMap.put(e.getLong("orgid.id"), e.getString("orgname")));
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("orgrow");
        Set orgIds = entries.stream().map(v -> v.getLong("orgid.id")).collect(Collectors.toSet());
        entries.stream().forEach(e -> orgMap.put(e.getLong("orgid.id"), e.getString("orgname")));
        currentOrgIds.retainAll(orgIds);
        if (currentOrgIds.size() > 0) {
            StringBuilder orgName = new StringBuilder();
            ArrayList duplicateOrgIds = new ArrayList(currentOrgIds);
            int size = duplicateOrgIds.size();
            for (int i = 0; i < size; ++i) {
                if (i <= 2) {
                    if (!"".equals(orgName.toString())) {
                        orgName.append(',');
                    }
                } else {
                    orgName.append(String.format(ResManager.loadKDString((String)"......\u7b49%1$s\u4e2a", (String)"OrgGroupSaveValidator_32", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), duplicateOrgIds.size()));
                    break;
                }
                orgName.append((String)orgMap.get(duplicateOrgIds.get(i)));
            }
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6c47\u603b\u65b9\u6848\u6709\u6548\u671f%1$s\u81f3%2$s\u5185\uff0c\u7ec4\u7ec7\uff08%3$s\uff09\u5728\u65b9\u6848\uff08%4$s\uff09\u4e2d\u5df2\u88ab\u914d\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e", (String)"OrgGroupSaveValidator_30", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), DateUtils.format((Date)startdate), DateUtils.format((Date)enddate), orgName.toString(), number);
        }
        return null;
    }

    private boolean isChangeBill() {
        return "tctb_xorg_group".equalsIgnoreCase(this.getEntityKey());
    }
}

